/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.automation.router.whiskerRouter;

import com.sigrity.acl.ALog;
import com.sigrity.acl.APair;
import com.sigrity.acl.geom.AGeom;
import com.sigrity.acl.geom.ALine;
import com.sigrity.acl.geom.APath;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.orbit.ui.core.DesignView2D;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Stream;

public class WhiskerMgmt {
    LinkedList<Whisker> whiskers = new LinkedList();
    LinkedList<Path> paths = new LinkedList();
    HashMap<Whisker, Object> whiskerToObject = new HashMap();
    HashMap<Object, Path> objectToPath = new HashMap();
    HashMap<Path, LinkedList<NewPts>> replacePts = new HashMap();
    HashMap<Path, HashMap<ALine, LinkedList<NewPts>>> splitPts = new HashMap();
    Function<Object, Long> getClearanceFn;

    public WhiskerMgmt(DesignView2D view) {
    }

    public void addWhisker(ALine l, APoint2D start, Object o) {
        this.whiskers.add(new Whisker(l, start, o));
    }

    public void addPath(APath p, Object o) {
        this.paths.add(new Path(p.cleanPath(), o));
    }

    public void apply(Function<Object, Long> getClearance, Function<APair<Object, APath>, Boolean> update) {
        this.getClearanceFn = getClearance;
        this.paths.stream().forEach(p -> this.insertPath((Path)p));
        ((Stream)this.whiskers.stream().parallel()).forEach(this::sortIntersections);
        this.whiskers.stream().forEach(this::relax);
        this.amendPaths();
        this.paths.stream().forEach(p -> update.apply(new APair(p.o, (Object)p.p)));
    }

    protected void amendPaths() {
        Path path;
        for (Map.Entry<Path, HashMap<ALine, LinkedList<NewPts>>> entry : this.splitPts.entrySet()) {
            path = entry.getKey();
            HashMap<ALine, LinkedList<NewPts>> segMap = entry.getValue();
            for (Map.Entry<ALine, LinkedList<NewPts>> segEntry : segMap.entrySet()) {
                ALine segLine = segEntry.getKey();
                LinkedList<NewPts> newPtsList = segEntry.getValue();
                APath dbPath = path.p;
                int startIndex = dbPath.getSegIndex(segLine);
                if (startIndex == -1) {
                    ALog.logInfo((String)"Segment does not match.");
                    continue;
                }
                APoint2D startPt = dbPath.getPoint(startIndex);
                ++startIndex;
                Collections.sort(newPtsList, new DistanceSorter(startPt));
                for (NewPts pt : newPtsList) {
                    dbPath.insertPoint(startIndex++, pt.newPt);
                }
            }
        }
        for (Map.Entry<Path, Cloneable> entry : this.replacePts.entrySet()) {
            path = entry.getKey();
            LinkedList newPtsList = (LinkedList)entry.getValue();
            for (NewPts rec : newPtsList) {
                boolean bl = path.p.replacePtWith(rec.oldPt, rec.newPt);
            }
        }
    }

    protected APoint2D getReplacePt(Path path, APoint2D pt) {
        APoint2D ret = pt;
        LinkedList<NewPts> list = this.replacePts.get(path);
        if (list == null) {
            return ret;
        }
        for (NewPts rec : list) {
            if (!APoint2D.isEqualPoint((APoint2D)rec.oldPt, (APoint2D)pt)) continue;
            return rec.newPt;
        }
        return ret;
    }

    protected APoint2D movePointOnLine(ALine l, APoint2D p, long s) {
        double angle = l.getAngleInRadians();
        long dx = Math.round(Math.cos(angle) * (double)s);
        long dy = Math.round(Math.sin(angle) * (double)s);
        APoint2D pPrime = p.add(dx, dy);
        return pPrime;
    }

    protected int findSegmentOfIntersection(WhiskerIntersection wi) {
        return 0;
    }

    protected void moveIntersection(WhiskerIntersection wi, APoint2D newPoint) {
        APoint2D oldPoint = wi.p;
        wi.p = newPoint;
        Path path = wi.path;
        NewPts np = null;
        LinkedList<NewPts> l = null;
        if (path.p.containsPoint(oldPoint)) {
            np = new NewPts(oldPoint, newPoint, null);
            l = this.replacePts.get(path);
            if (l == null) {
                l = new LinkedList();
                l.add(np);
                this.replacePts.put(path, l);
            } else {
                l.add(np);
            }
        } else {
            np = new NewPts(null, newPoint, wi.intersectSeg);
            HashMap<Object, LinkedList<NewPts>> hm = this.splitPts.get(path);
            if (hm == null) {
                l = new LinkedList();
                l.add(np);
                hm = new HashMap();
                hm.put(wi.intersectSeg, l);
                this.splitPts.put(path, hm);
            } else {
                l = hm.get(wi.intersectSeg);
                if (l == null) {
                    l = new LinkedList();
                    l.add(np);
                    hm.put(wi.intersectSeg, l);
                } else {
                    l.add(np);
                }
            }
        }
    }

    protected PrevState pushIntersection(WhiskerIntersection wi, PrevState ps) {
        PrevState newState;
        long thisDist = ps.p.distance(wi.p);
        Long minDist = this.getClearanceFn.apply(wi.path.o);
        double angle = ps.p.getAngle(wi.p);
        if (Math.abs(angle - wi.w.angle) > 1.0) {
            thisDist = -thisDist;
        }
        if (thisDist < minDist) {
            Whisker w = wi.w;
            APoint2D newPoint = this.movePointOnLine(w.l, wi.p, minDist - thisDist);
            this.moveIntersection(wi, newPoint);
            newState = new PrevState(newPoint, wi.path.o);
        } else {
            newState = new PrevState(wi.p, wi.path.o);
        }
        return newState;
    }

    protected Whisker relax(Whisker w) {
        PrevState ps = new PrevState(w.start, this.whiskerToObject.get(w));
        for (WhiskerIntersection wi : w.whiskerIntersections) {
            this.pushIntersection(wi, ps);
        }
        return w;
    }

    protected void insertPathSegmentIntoWhisker(Whisker w, Path path, ALine segment) {
        ALine wl = w.l;
        ALine segmentCopy = (ALine)segment.copy();
        segmentCopy.extendEnds(2L);
        if (segmentCopy.intersects((AGeom)wl)) {
            APoint2D pI = segmentCopy.getIntersectLines(wl);
            w.paths.add(path);
            w.whiskerIntersections.add(new WhiskerIntersection(w, pI, path, segment));
        }
    }

    protected void insertPathSegment(Path p, ALine segment) {
        ((Stream)this.whiskers.stream().parallel()).forEach(whisker -> this.insertPathSegmentIntoWhisker((Whisker)whisker, p, segment));
    }

    protected ALine extendLine(ALine line) {
        line.extendEnds(2L);
        return line;
    }

    protected void insertPath(Path p) {
        p.p.getLines().stream().forEach(eLine -> this.insertPathSegment(p, (ALine)eLine));
    }

    protected Whisker sortIntersections(Whisker w) {
        Collections.sort(w.whiskerIntersections, new WhiskerIntersectionSorter(w));
        return w;
    }

    public static class DistanceSorter
    implements Comparator<NewPts> {
        APoint2D pt = null;

        public DistanceSorter(APoint2D segPt) {
            this.pt = segPt;
        }

        @Override
        public int compare(NewPts p1, NewPts p2) {
            return Long.compare(p1.newPt.distance(this.pt), p2.newPt.distance(this.pt));
        }
    }

    public static class WhiskerIntersectionSorter
    implements Comparator<WhiskerIntersection> {
        Whisker w;

        public WhiskerIntersectionSorter(Whisker w) {
            this.w = w;
        }

        @Override
        public int compare(WhiskerIntersection w0, WhiskerIntersection w1) {
            return Long.compare(w0.p.distance(this.w.l.getP0()), w1.p.distance(this.w.l.getP0()));
        }
    }

    static class PrevState {
        APoint2D p;
        Object o;

        public PrevState(APoint2D p, Object o) {
            this.p = p;
            this.o = o;
        }
    }

    static class Path {
        protected APath p;
        protected Object o;

        public Path(APath p, Object o) {
            this.p = p;
            this.o = o;
        }
    }

    static class WhiskerIntersection {
        Whisker w;
        APoint2D p;
        Path path;
        ALine intersectSeg;

        public WhiskerIntersection(Whisker w, APoint2D p, Path path, ALine seg) {
            this.w = w;
            this.p = p;
            this.path = path;
            this.intersectSeg = seg;
        }
    }

    class Whisker {
        protected ALine l;
        protected APoint2D start;
        protected double angle;
        LinkedList<Path> paths = new LinkedList();
        LinkedList<WhiskerIntersection> whiskerIntersections = new LinkedList();

        public Whisker(ALine l, APoint2D start, Object o) {
            this.l = l;
            this.angle = l.getAngle();
            this.start = start;
            WhiskerMgmt.this.whiskerToObject.put(this, o);
        }
    }

    static class NewPts {
        APoint2D oldPt;
        APoint2D newPt;
        ALine seg;

        public NewPts(APoint2D o, APoint2D n, ALine l) {
            this.oldPt = o;
            this.newPt = n;
            this.seg = l;
        }
    }
}

