/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.automation.router.whiskerRouter;

import com.sigrity.acl.AUtil;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.orbit.automation.router.whiskerRouter.WhiskerMgmt;
import com.sigrity.orbit.ui.core.DesignCanvas2D;
import com.sigrity.orbit.ui.core.DesignView2D;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.GeneralPath;
import javax.swing.JComponent;

public class WhiskerOverlay {
    protected Overlay mOverlay;
    protected boolean mDrawing = false;
    protected DesignView2D mView;
    protected WhiskerMgmt mWM;

    public WhiskerOverlay(DesignView2D view, WhiskerMgmt wm) {
        this.mView = view;
        this.mWM = wm;
        if (!(view instanceof DesignView2D)) {
            return;
        }
        DesignView2D v2 = view;
        this.mOverlay = new Overlay();
        v2.addOverlay(this.mOverlay);
    }

    public class Overlay
    extends JComponent {
        protected DesignCanvas2D.XForm w2s;
        Graphics2D g;

        public Overlay() {
            this.setOpaque(false);
            this.setDoubleBuffered(true);
            this.setBackground(new Color(0, 0, 0, 0));
        }

        protected WhiskerMgmt.Whisker drawWhisker(Graphics2D g, WhiskerMgmt.Whisker w) {
            if (w.whiskerIntersections.size() == 0) {
                g.setColor(Color.red);
            } else {
                g.setColor(Color.green);
            }
            APoint2D p1 = w.start;
            APoint2D p2 = w.l.getP1();
            Point screenPt = this.w2s.getScreenPt(p1);
            GeneralPath screenPath = new GeneralPath();
            screenPath.moveTo(screenPt.x, screenPt.y);
            Point screenPt2 = this.w2s.getScreenPt(p2);
            screenPath.lineTo(screenPt2.x, screenPt2.y);
            g.draw(screenPath);
            return w;
        }

        protected void drawWhiskers(Graphics2D g) {
            WhiskerOverlay.this.mWM.whiskers.stream().forEach(w -> this.drawWhisker(g, (WhiskerMgmt.Whisker)w));
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            if (!AUtil.getAclDebugMode()) {
                return;
            }
            if (WhiskerOverlay.this.mDrawing) {
                return;
            }
            WhiskerOverlay.this.mDrawing = true;
            this.g = (Graphics2D)graphics;
            DesignView2D v2 = WhiskerOverlay.this.mView;
            this.w2s = v2.getCanvas().getXForm();
            this.drawWhiskers(this.g);
            WhiskerOverlay.this.mDrawing = false;
        }
    }
}

