/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.automation.router.whiskerRouter;

import com.sigrity.acl.APair;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.std.Constraint;
import com.sigrity.acl.db.std.Layer;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.acl.db.std.RuleSet;
import com.sigrity.acl.db.std.Wire;
import com.sigrity.acl.geom.ACircle;
import com.sigrity.acl.geom.AGeom;
import com.sigrity.acl.geom.AGeomUtil;
import com.sigrity.acl.geom.ALine;
import com.sigrity.acl.geom.APath;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.orbit.HierPin;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.RuleSetMgr;
import com.sigrity.orbit.automation.router.FloodableNode;
import com.sigrity.orbit.automation.router.PrettyRouter;
import com.sigrity.orbit.automation.router.Topstacle;
import com.sigrity.orbit.automation.router.whiskerRouter.WhiskerMgmt;
import com.sigrity.orbit.automation.router.whiskerRouter.WhiskerOverlay;
import com.sigrity.orbit.ui.core.DesignView2D;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Optional;

public class WhiskerRouter {
    static WhiskerOverlay theWhiskerOverlay = null;
    static HashSet<String> debugPins = new HashSet();

    public WhiskerRouter() {
        this.addDebugPins();
    }

    protected void addDebugPins() {
        debugPins.add("bi_pad_top");
        debugPins.add("ACFLAG");
    }

    protected static boolean isChannel(FloodableNode fn) {
        return fn.getIsChannel();
    }

    protected static void addPins(FloodableNode fn, HashSet<Topstacle> set) {
        set.add((Topstacle)fn.getChannel().getP1());
        set.add((Topstacle)fn.getChannel().getP2());
    }

    protected Topstacle insertWhiskers(WhiskerMgmt wv, Topstacle t) {
        double incAngle = 22.5;
        HierPin hp = (HierPin)t.getOwner();
        if (hp == null) {
            return t;
        }
        if (hp.second == null) {
            return t;
        }
        if (t.toPinInstance().getPinTemplate().getType().equals((Object)PinTemplate.Type.VIA)) {
            return t;
        }
        AGeom shape1 = t.getShape();
        ACircle p = new ACircle(new APoint2D(0L, 0L), 0L);
        for (double angle = 0.0; angle < 360.0; angle += incAngle) {
            ALine whisker = t.getPoint().makeVector(t.getMaxWhisker(), angle);
            ALine span = AGeomUtil.minSpan((APoint2D)whisker.getP0(), (APoint2D)whisker.getP1(), (AGeom)shape1, (AGeom)p);
            wv.addWhisker(whisker, span.getP0(), t);
        }
        return t;
    }

    private static long maxWhiskerLength(long a, long b) {
        return Math.max(a, b);
    }

    protected Topstacle injectMaxLength(PrettyRouter pr, Topstacle t) {
        ArrayList<FloodableNode> fns = pr.topstacleToFloodableNodes(t);
        Optional<Long> maxLength = fns.stream().map(FloodableNode::getLength).reduce(WhiskerRouter::maxWhiskerLength);
        t.setMaxWhisker(maxLength.get());
        return t;
    }

    public Long getClearance(Object w) {
        Long traceToPad;
        Wire wire = (Wire)w;
        RuleSet ruleSet = RuleSetMgr.getMyRuleSet((DbObject)wire);
        if (ruleSet != null && (traceToPad = (Long)RuleSetMgr.getConstraintValue((RuleSet)ruleSet, (Constraint.Descriptor)Constraint.DEF_TRACE_TO_BUMP_CLEAR, (Layer)wire.getLayer())) != null) {
            return (long)traceToPad;
        }
        return 50000L;
    }

    public void apply(PrettyRouter pr) {
        WhiskerMgmt wm = new WhiskerMgmt((DesignView2D)OrbitIO.getCurView());
        HashSet topstacles = new HashSet();
        pr.getmWiretoLastFn().keySet().stream().map(w -> w.clean()).forEach(w -> wm.addPath(w.getPath(), w));
        pr.getmFloodableNodes().stream().filter(fn -> WhiskerRouter.isChannel(fn)).forEach(fn -> WhiskerRouter.addPins(fn, topstacles));
        topstacles.stream().map(t -> this.injectMaxLength(pr, (Topstacle)t)).forEach(t -> this.insertWhiskers(wm, (Topstacle)t));
        wm.apply(p -> this.getClearance(p), q -> this.replacePath((APair<Object, APath>)q));
        DesignView2D view = (DesignView2D)OrbitIO.getCurView();
        if (theWhiskerOverlay != null) {
            DesignView2D v2 = view;
            v2.remove(WhiskerRouter.theWhiskerOverlay.mOverlay);
        }
        theWhiskerOverlay = new WhiskerOverlay(view, wm);
    }

    protected Boolean replacePath(APair<Object, APath> data) {
        Wire w = (Wire)data.first;
        w.setPath((APath)data.second);
        return true;
    }
}

