/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.automation.wirebonder;

import com.sigrity.acl.ALog;
import com.sigrity.acl.db.BondFingerUtil;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.acl.geom.ARect;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;

public class BondFingerGrouper {
    protected ArrayList<PinTemplate> candidates = new ArrayList();
    protected ArrayList<Island> workingIslands = new ArrayList();
    protected HashMap<PinTemplate, Island> mDevToIsland = new HashMap();
    protected long maxDs;
    protected long maxPerIsland;

    public ArrayList<Island> getIslands() {
        return this.workingIslands;
    }

    public void makePhysicalIslands(ArrayList<PinTemplate> dpList, int maxPerIsland, long maxDs) {
        this.candidates = dpList;
        this.maxDs = maxDs;
        this.maxPerIsland = maxPerIsland;
        if (maxPerIsland <= 1) {
            return;
        }
        for (PinTemplate dp : this.candidates) {
            Island island = this.groupBySameNet(dp);
            if (this.workingIslands.contains(island) || island == null || island.size() <= 0) continue;
            this.workingIslands.add(island);
        }
        ArrayList<Island> newIslands = this.splitIslandsBasedOnRing(this.workingIslands);
        for (Island ni : newIslands) {
            this.workingIslands.add(ni);
        }
        this.optimizeIslands();
        for (Island island : this.workingIslands) {
            this.moveToCenter(island);
        }
    }

    protected ArrayList<Island> splitIslandsBasedOnRing(ArrayList<Island> islands) {
        ArrayList<Island> newIslands = new ArrayList<Island>();
        for (Island island : islands) {
            ArrayList<Object> thisSplit = new ArrayList();
            thisSplit = this.splitIslandBasedOnRing(island);
            for (Island island2 : thisSplit) {
                newIslands.add(island2);
            }
        }
        return newIslands;
    }

    protected ArrayList<Island> splitIslandBasedOnRing(Island island) {
        Integer baseRing = null;
        ArrayList<Island> newIslands = new ArrayList<Island>();
        for (PinTemplate bf : island) {
            int thisRing = BondFingerUtil.getRing((PinTemplate)bf);
            if (baseRing == null) {
                baseRing = thisRing;
            }
            if (baseRing == thisRing) continue;
            boolean foundASimilarIsland = false;
            for (Island candidate : newIslands) {
                if (BondFingerUtil.getRing((PinTemplate)((PinTemplate)candidate.get(0))) != thisRing) continue;
                foundASimilarIsland = true;
                candidate.add(bf);
                break;
            }
            if (foundASimilarIsland) continue;
            Island newIsland = new Island();
            newIslands.add(newIsland);
            newIsland.add(bf);
        }
        for (Island i : newIslands) {
            for (PinTemplate dp : i) {
                island.remove(dp);
            }
        }
        return newIslands;
    }

    protected void optimizeIslands() {
        boolean changed = true;
        while (changed) {
            ArrayList<Island> createdIslands = new ArrayList<Island>();
            changed = false;
            for (Island island : this.workingIslands) {
                if (island.size() == 1) continue;
                this.sortIsland(island);
            }
            this.validate();
            for (Island island : this.workingIslands) {
                Island newIsland;
                if (island.size() == 1 || (newIsland = this.splitIsland(island)).size() <= 0) continue;
                changed = true;
                createdIslands.add(newIsland);
            }
            this.validate();
            for (Island island : createdIslands) {
                this.workingIslands.add(island);
            }
            this.validate();
        }
    }

    boolean islandHas(Island island, String name) {
        for (PinTemplate dp : island) {
            if (!dp.getName().contains(name)) continue;
            return true;
        }
        return false;
    }

    boolean validate() {
        int count = 0;
        for (Island island : this.workingIslands) {
            for (PinTemplate dp : island) {
                if (!dp.getName().contains("q2r0i87")) continue;
                ++count;
            }
        }
        return count <= true;
    }

    protected Island splitIsland(Island island) {
        int i;
        Island newIsland = new Island();
        this.sortIsland(island);
        PinTemplate anchor = (PinTemplate)island.get(0);
        for (i = 1; i < island.size(); ++i) {
            PinTemplate d = (PinTemplate)island.get(i);
            if (this.canBeInIsland(anchor, d)) continue;
            newIsland.add(d);
        }
        for (i = (int)this.maxPerIsland; i < island.size(); ++i) {
            if (newIsland.contains(island.get(i))) continue;
            newIsland.add((PinTemplate)island.get(i));
        }
        for (PinTemplate d : newIsland) {
            island.remove(d);
        }
        return newIsland;
    }

    protected void sortIsland(Island island) {
        APoint2D ll = this.islandLL(island);
        Collections.sort(island, new distFromPtSorter(ll));
    }

    protected boolean canBeInIsland(PinTemplate anchor, PinTemplate other) {
        long d1 = Math.abs(anchor.getBounds().center().distance(other.getBounds().center()));
        return d1 < this.maxDs;
    }

    protected APoint2D islandLL(Island island) {
        ARect r = null;
        for (PinTemplate dp : island) {
            if (r == null) {
                r = new ARect(dp.getBounds());
                continue;
            }
            r.expand(dp.getBounds());
        }
        return new APoint2D(r.getLL());
    }

    protected void moveToCenter(Island island) {
        if (island.size() <= 1) {
            return;
        }
        long dx = 0L;
        long dy = 0L;
        APoint2D center = ((PinTemplate)island.get(0)).getBounds().center();
        ARect bounds = ((PinTemplate)island.get(0)).getBounds();
        if (bounds.width() > bounds.height()) {
            dy = bounds.height();
        } else {
            dx = bounds.width();
        }
        PinTemplate islandGravity = (PinTemplate)island.get(0);
        BondFingerUtil.setIAmGravity((PinTemplate)islandGravity, (boolean)true);
        ArrayList<PinTemplate> list = new ArrayList<PinTemplate>();
        list.add(islandGravity);
        for (int i = 1; i < island.size(); ++i) {
            APoint2D ds = ((PinTemplate)island.get(i)).getBounds().center().sub(center);
            PinTemplate bf = (PinTemplate)island.get(i);
            bf.moveBy(-ds.getX() + dx * (long)i, -ds.getY() + dy * (long)i);
            BondFingerUtil.setGravity((PinTemplate)bf, (PinTemplate)islandGravity);
            list.add((PinTemplate)island.get(i));
        }
    }

    protected Net net(PinTemplate dp) {
        return dp.getNet();
    }

    protected Island groupBySameNet(PinTemplate center) {
        Island island = new Island();
        if (this.mDevToIsland.get(center) != null) {
            return island;
        }
        island.add(center);
        this.mDevToIsland.put(center, island);
        for (PinTemplate dp : this.candidates) {
            if (dp == center || this.mDevToIsland.get(dp) != null || this.net(dp) != this.net(center)) continue;
            if (this.net(dp).getName().contains("GND24")) {
                ALog.logInfo((String)("Grouping " + this.net(dp).getName() + " " + this.net(center).getName()));
            }
            island.add(dp);
            this.mDevToIsland.put(dp, island);
        }
        return island;
    }

    public static class distFromPtSorter
    implements Comparator<PinTemplate> {
        APoint2D mLL;

        public distFromPtSorter(APoint2D ll) {
            this.mLL = ll;
        }

        @Override
        public int compare(PinTemplate p1, PinTemplate p2) {
            long d1 = Math.abs(this.mLL.distance(p1.getBounds().center()));
            long d2 = Math.abs(this.mLL.distance(p2.getBounds().center()));
            return Long.compare(d1, d2);
        }
    }

    class Island
    extends ArrayList<PinTemplate> {
        Island() {
        }
    }
}

