/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.automation.wirebonder;

import com.sigrity.acl.db.std.PinInstance;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.acl.geom.AGeom;
import com.sigrity.acl.geom.ALine;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.HierPin;
import com.sigrity.orbit.automation.wirebonder.WireBonder;

public class BondFingerInstruction {
    DevicePath bfPath;
    PinTemplate bondFingerPin;
    HierPin fromPort;
    long x;
    long y;
    float angle;
    String uniqueName;
    int quad;
    int ring;
    AGeom guide;

    public void swapBF(BondFingerInstruction from) {
        DevicePath tbfPath = new DevicePath(this.bfPath);
        int tquad = this.quad;
        int tring = this.ring;
        AGeom tGuide = this.guide;
        this.bfPath = from.bfPath;
        this.quad = from.quad;
        this.ring = from.ring;
        this.guide = from.guide;
        from.bfPath = tbfPath;
        from.quad = tquad;
        from.ring = tring;
        from.guide = tGuide;
    }

    protected static boolean cross(long clr, int quad, BondFingerInstruction bfI, BondFingerInstruction bfJ, boolean pseudo3D) {
        ALine lJ;
        ALine lI = BondFingerInstruction.toLine(bfI);
        long d = lI.distance(lJ = BondFingerInstruction.toLine(bfJ));
        if (d <= clr) {
            if (bfI.ring == bfJ.ring && clr > 0L && d == 0L) {
                return true;
            }
            if (!pseudo3D) {
                return false;
            }
            switch (quad) {
                case 0: {
                    if (lI.getP0().getX() < lJ.getP0().getX() && lI.getP1().getX() > lJ.getP1().getX()) {
                        return false;
                    }
                    return lJ.getP0().getX() >= lI.getP0().getX() || lJ.getP1().getX() <= lI.getP1().getX();
                }
                case 1: {
                    if (lI.getP0().getY() < lJ.getP0().getY() && lI.getP1().getY() > lJ.getP1().getY()) {
                        return false;
                    }
                    return lJ.getP0().getY() >= lI.getP0().getY() || lJ.getP1().getY() <= lI.getP1().getY();
                }
                case 2: {
                    if (lI.getP0().getX() > lJ.getP0().getX() && lI.getP1().getX() < lJ.getP1().getX()) {
                        return false;
                    }
                    return lJ.getP0().getX() <= lI.getP0().getX() || lJ.getP1().getX() >= lI.getP1().getX();
                }
                case 3: {
                    if (lI.getP0().getY() > lJ.getP0().getY() && lI.getP1().getY() < lJ.getP1().getY()) {
                        return false;
                    }
                    return lJ.getP0().getY() <= lI.getP0().getY() || lJ.getP1().getY() >= lI.getP1().getY();
                }
            }
            return true;
        }
        return false;
    }

    protected static void swap(WireBonder wb, BondFingerInstruction mI, BondFingerInstruction mJ) {
        mI.swapBF(mJ);
        wb.copyNet(mI);
        wb.copyNet(mJ);
    }

    protected static ALine toLine(BondFingerInstruction bfi) {
        DevicePath pathFrom = bfi.fromPort.getPath();
        ALine l = new ALine();
        l.setP0(pathFrom.transformPt(bfi.fromPort.getPin().getLoc()));
        DevicePath pathTo = bfi.bfPath;
        PinInstance bfp = pathTo.getLast().getAnyPin();
        if (bfp != null) {
            l.setP1(pathTo.transformPt(bfp.getLoc()));
        } else {
            l.setP1(pathTo.transformPt(new APoint2D(0L, 0L)));
        }
        return l;
    }
}

