/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.automation.wirebonder;

import com.sigrity.orbit.automation.wirebonder.BondFingerInstruction;
import com.sigrity.orbit.automation.wirebonder.WireBonder;
import java.util.ArrayList;

public class BondFingerOptimizer {
    protected ArrayList<BondFingerInstruction> mInstr;
    protected long mClr = 0L;
    WireBonder mWB;

    public BondFingerOptimizer(WireBonder wb) {
        this.mWB = wb;
    }

    public void setClr(long clr) {
        this.mClr = clr;
    }

    public void loadInsr(ArrayList<BondFingerInstruction> instr) {
        this.mInstr = instr;
    }

    public void makePairs() {
        for (int q = 0; q < 4; ++q) {
            this.optimizeQuad(q);
        }
    }

    public void optimizeRings() {
        for (int q = 0; q < 4; ++q) {
            this.optimizeRing(q);
        }
    }

    protected void optimizeRing(int q) {
    }

    protected void optimizeQuadUsingPseudo3D(int q, boolean use3D) {
        int size = this.mInstr.size();
        for (int iter = 0; iter < 16; ++iter) {
            boolean changed = false;
            for (int i = 0; i < size; ++i) {
                BondFingerInstruction iA = this.mInstr.get(i);
                if (iA.quad != q) continue;
                for (int j = i + 1; j < size; ++j) {
                    BondFingerInstruction iB = this.mInstr.get(j);
                    if (iB.quad != q || !BondFingerInstruction.cross(this.mClr, q, iA, iB, use3D)) continue;
                    BondFingerInstruction.swap(this.mWB, iA, iB);
                    if (BondFingerInstruction.cross(this.mClr, q, iA, iB, use3D)) continue;
                    changed = true;
                }
            }
            if (!changed) break;
        }
    }

    protected void optimizeQuad(int q) {
        this.optimizeQuadUsingPseudo3D(q, true);
        this.optimizeQuadUsingPseudo3D(q, false);
    }
}

