/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.automation.wirebonder;

import com.sigrity.acl.ALog;
import com.sigrity.acl.AMutableReference;
import com.sigrity.acl.db.BondFingerUtil;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Layer;
import com.sigrity.acl.db.std.Personality;
import com.sigrity.acl.db.std.PinInstance;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.acl.db.std.Substrate;
import com.sigrity.acl.db.std.Wire;
import com.sigrity.acl.geom.AGeom;
import com.sigrity.acl.geom.ALine;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.acl.optimizer.LineSpringSpreader;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.HierPin;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.automation.wirebonder.WireBonder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;

public class BondFingerUncrosser {
    protected Substrate mSub;
    protected DevicePath mTopPath;
    protected HashMap<BWInfo, ALine> mWBIToLine = new HashMap();
    long mWidth;
    long mClr;
    double mAngle;
    ArrayList<BWInfo> mBWList = new ArrayList();

    protected void setMetalDRC(long w, long c, double a) {
        this.mWidth = w;
        this.mClr = c;
        this.mAngle = a;
    }

    protected void smoothMetalWiresWithSignalWires(String substrateKey) {
        this.mSub = (Substrate)OrbitIO.getCurDb().getByKeyStr(Substrate.class, substrateKey);
        if (this.mSub == null) {
            ALog.logWarn((String)"Substrate not found");
            return;
        }
        this.deriveData();
        this.optimizeData();
    }

    protected void optimizeQuad(ArrayList<BWInfo> list, int quad) {
        ArrayList<BWInfo> nonMovableWBs = new ArrayList<BWInfo>();
        ArrayList<BWInfo> movableWBs = new ArrayList<BWInfo>();
        for (BWInfo bwi : list) {
            PinTemplate bf = ((PinInstance)bwi.bfPathPort.second).getPinTemplate();
            if (BondFingerUtil.onMetal((PinTemplate)bf)) {
                movableWBs.add(bwi);
                continue;
            }
            nonMovableWBs.add(bwi);
        }
        ArrayList<Object> metalEnds = new ArrayList();
        metalEnds = quad % 2 == 0 ? this.determineMetalXs(movableWBs) : this.determineMetalYs(movableWBs);
        if (metalEnds.size() == 0) {
            return;
        }
        Collections.sort(metalEnds, new LongAbsSort());
        this.hashLocations(nonMovableWBs);
        for (int m = metalEnds.size() - 1; m >= 0; --m) {
            ArrayList<BWInfo> processed = new ArrayList<BWInfo>();
            long s = (Long)metalEnds.get(m);
            for (BWInfo bwi : movableWBs) {
                boolean bfOnThisMetal;
                if (quad % 2 == 0) {
                    bfOnThisMetal = bwi.bfPathPort.getWorldLoc().getX() == s;
                } else {
                    boolean bl = bfOnThisMetal = bwi.bfPathPort.getWorldLoc().getY() == s;
                }
                if (!bfOnThisMetal) continue;
                this.findBestLoc(nonMovableWBs, quad, bwi);
                nonMovableWBs.add(bwi);
                this.updateHashBMap(bwi);
                processed.add(bwi);
            }
            for (BWInfo bwi : processed) {
                nonMovableWBs.remove(bwi);
            }
            this.smoothMetalConnections(nonMovableWBs, movableWBs, quad, s);
            for (BWInfo bwi : processed) {
                movableWBs.remove(bwi);
                nonMovableWBs.add(bwi);
                this.updateHashBMap(bwi);
            }
        }
    }

    ArrayList<Long> determineMetalXs(ArrayList<BWInfo> candidates) {
        ArrayList<Long> xs = new ArrayList<Long>();
        for (BWInfo bwi : candidates) {
            long x = bwi.bfPathPort.getWorldLoc().getX();
            if (xs.contains(x)) continue;
            xs.add(x);
        }
        return xs;
    }

    ArrayList<Long> determineMetalYs(ArrayList<BWInfo> candidates) {
        ArrayList<Long> ys = new ArrayList<Long>();
        for (BWInfo bwi : candidates) {
            long y = bwi.bfPathPort.getWorldLoc().getY();
            if (ys.contains(y)) continue;
            ys.add(y);
        }
        return ys;
    }

    protected void smoothMetalConnections(ArrayList<BWInfo> nonMovableWBs, ArrayList<BWInfo> movableWBs, int quad, long onMetalS) {
        if (quad % 2 == 0) {
            ArrayList<BWInfo> sortedYIntercepts = this.getSortedYIntercepts(nonMovableWBs, onMetalS);
            for (int i = 0; i < sortedYIntercepts.size() - 1; ++i) {
                long yBefore = sortedYIntercepts.get((int)i).intercept;
                long yAfter = sortedYIntercepts.get((int)(i + 1)).intercept;
                this.smoothYBetween(yBefore, yAfter, movableWBs, onMetalS);
            }
        } else {
            ArrayList<BWInfo> sortedXIntercepts = this.getSortedXIntercepts(nonMovableWBs, onMetalS);
            for (int i = 0; i < sortedXIntercepts.size() - 1; ++i) {
                long xBefore = sortedXIntercepts.get((int)i).intercept;
                long xAfter = sortedXIntercepts.get((int)(i + 1)).intercept;
                this.smoothXBetween(xBefore, xAfter, movableWBs, onMetalS);
            }
        }
    }

    protected void smoothYBetween(long yBefore, long yAfter, ArrayList<BWInfo> candidates, long xIntercept) {
        LineSpringSpreader lss = new LineSpringSpreader();
        lss.minSep(50000L);
        ArrayList<BWInfo> between = new ArrayList<BWInfo>();
        for (int i = 0; i < candidates.size(); ++i) {
            Long y = candidates.get(i).getLine().yIntercept(xIntercept);
            if (y == null || y < yBefore || y > yAfter) continue;
            between.add(candidates.get(i));
            lss.addObject(candidates.get(i), y, 0L);
        }
        if (between.size() == 0) {
            return;
        }
        lss.line(yBefore, yAfter);
        lss.onUnderLoad(LineSpringSpreader.OnUnderLoad.MINMOVEMENT);
        if (!lss.relax()) {
            return;
        }
        for (BWInfo bwi : between) {
            long y1 = lss.getValue(bwi);
            long y0 = bwi.bfPathPort.getWorldLoc().getY();
            long dy = y1 - y0;
            bwi.bfPathPort.getPath().getLast().moveBy(0L, dy);
        }
    }

    protected ArrayList<BWInfo> getSortedXIntercepts(ArrayList<BWInfo> candidates, long yIntercept) {
        ArrayList<BWInfo> xList = new ArrayList<BWInfo>();
        for (int i = 0; i < candidates.size() - 1; ++i) {
            Long x = this.getLineFast(candidates.get(i)).xIntercept(yIntercept);
            if (x == null) continue;
            candidates.get((int)i).intercept = x;
            xList.add(candidates.get(i));
        }
        Collections.sort(xList, new InterceptSorter());
        return xList;
    }

    protected ArrayList<BWInfo> getSortedYIntercepts(ArrayList<BWInfo> candidates, long xIntercept) {
        ArrayList<BWInfo> yList = new ArrayList<BWInfo>();
        for (int i = 0; i < candidates.size() - 1; ++i) {
            Long x = this.getLineFast(candidates.get(i)).yIntercept(xIntercept);
            if (x == null) continue;
            candidates.get((int)i).intercept = x;
            yList.add(candidates.get(i));
        }
        Collections.sort(yList, new InterceptSorter());
        return yList;
    }

    protected void smoothXBetween(long xBefore, long xAfter, ArrayList<BWInfo> candidates, long yIntercept) {
        LineSpringSpreader lss = new LineSpringSpreader();
        lss.minSep(50000L);
        ArrayList<BWInfo> between = new ArrayList<BWInfo>();
        for (int i = 0; i < candidates.size(); ++i) {
            Long x = candidates.get(i).getLine().xIntercept(yIntercept);
            if (x == null || x < xBefore || x > xAfter) continue;
            between.add(candidates.get(i));
            lss.addObject(candidates.get(i), x, 0L);
        }
        if (between.size() == 0) {
            return;
        }
        lss.line(xBefore, xAfter);
        lss.onUnderLoad(LineSpringSpreader.OnUnderLoad.MINMOVEMENT);
        if (!lss.relax()) {
            return;
        }
        for (BWInfo bwi : between) {
            long x1 = lss.getValue(bwi);
            long x0 = bwi.bfPathPort.getWorldLoc().getX();
            long dx = x1 - x0;
            bwi.bfPathPort.getPath().getLast().moveBy(dx, 0L);
        }
    }

    protected boolean angleOkForQuad(double angle, int quad) {
        double clipAngle = 60.0;
        double normalAngle = 90.0 * (double)quad;
        double angleDiff = angle - normalAngle;
        angleDiff = Math.abs(angleDiff);
        return (angleDiff = Math.min(angleDiff, 360.0 - angleDiff)) <= clipAngle;
    }

    protected void findBestLoc(ArrayList<BWInfo> nonMovableWBs, int quad, BWInfo me) {
        APoint2D originalLoc = new APoint2D(me.bfPathPort.getPath().getLast().getLoc());
        int originalCrosses = this.numCrosses(nonMovableWBs, quad, me);
        ALine dynamicLine = me.getLine();
        ArrayList<Long> staticPts = new ArrayList<Long>();
        if (quad == 3 || quad == 1) {
            Collections.sort(nonMovableWBs, new DiePadSortHUsingHash());
            for (BWInfo staticBW : nonMovableWBs) {
                ALine staticLine = this.getLineFast(staticBW);
                Long xAtGuide = staticLine.xIntercept(dynamicLine.getP1().getY());
                if (xAtGuide == null) continue;
                staticPts.add(xAtGuide);
            }
            Collections.sort(staticPts, new LongSort());
            APoint2D bestLoc = null;
            int i = 0;
            int bestCrosses = 1;
            int size = staticPts.size();
            for (i = 0; i < size; ++i) {
                APoint2D p = new APoint2D();
                p.setY(dynamicLine.getP1().getY());
                Long midX = i == 0 ? Long.valueOf(me.getLine().getP0().getX()) : Long.valueOf(((Long)staticPts.get(i - 1) + (Long)staticPts.get(i)) / 2L);
                p.setX(midX.longValue());
                long x1 = midX;
                long x0 = me.bfPathPort.getWorldLoc().getX();
                long dx = x1 - x0;
                me.bfPathPort.getPath().getLast().moveBy(dx, 0L);
                ALine l = me.getLine();
                double angle = l.getAngle();
                if (!this.angleOkForQuad(angle, quad)) continue;
                int thisNumCrosses = this.numCrosses(nonMovableWBs, quad, me);
                if (i != 0 && thisNumCrosses >= bestCrosses) continue;
                bestLoc = new APoint2D(p);
                bestCrosses = thisNumCrosses;
            }
            if (bestCrosses > 0 && originalCrosses < bestCrosses) {
                me.bfPathPort.getPath().getLast().setLoc(originalLoc);
            } else if (bestLoc != null) {
                long x1 = bestLoc.getX();
                long x0 = me.bfPathPort.getWorldLoc().getX();
                long dx = x1 - x0;
                me.bfPathPort.getPath().getLast().moveBy(dx, 0L);
            }
        } else {
            Collections.sort(nonMovableWBs, new DiePadSortVUsingHash());
            for (BWInfo staticBW : nonMovableWBs) {
                ALine staticLine = this.getLineFast(staticBW);
                Long yAtGuide = staticLine.yIntercept(dynamicLine.getP1().getX());
                if (yAtGuide == null) continue;
                staticPts.add(yAtGuide);
            }
            Collections.sort(staticPts, new LongSort());
            APoint2D bestLoc = null;
            int i = 0;
            int bestCrosses = 1;
            int size = staticPts.size();
            for (i = 0; i < size; ++i) {
                APoint2D p = new APoint2D();
                p.setX(dynamicLine.getP1().getX());
                Long midY = i == 0 ? Long.valueOf(me.getLine().getP0().getY()) : Long.valueOf(((Long)staticPts.get(i - 1) + (Long)staticPts.get(i)) / 2L);
                p.setY(midY.longValue());
                long y1 = midY;
                long y0 = me.bfPathPort.getWorldLoc().getY();
                long dy = y1 - y0;
                me.bfPathPort.getPath().getLast().moveBy(0L, dy);
                ALine l = me.getLine();
                double angle = l.getAngle();
                if (!this.angleOkForQuad(angle, quad)) continue;
                int thisNumCrosses = this.numCrosses(nonMovableWBs, quad, me);
                if (i != 0 && thisNumCrosses >= bestCrosses) continue;
                bestLoc = new APoint2D(p);
                bestCrosses = thisNumCrosses;
            }
            if (bestCrosses > 0 && originalCrosses < bestCrosses) {
                me.bfPathPort.getPath().getLast().setLoc(originalLoc);
            } else if (bestLoc != null) {
                long y1 = bestLoc.getY();
                long y0 = me.bfPathPort.getWorldLoc().getY();
                long dy = y1 - y0;
                me.bfPathPort.getPath().getLast().moveBy(0L, dy);
            }
        }
    }

    protected int numCrosses(ArrayList<BWInfo> list, int quad, BWInfo me) {
        ALine meLine = me.getLine();
        int crosses = 0;
        for (int i = 0; i < list.size(); ++i) {
            BWInfo other = list.get(i);
            if (other == me) continue;
            ALine iL = this.getLineFast(other);
            if (iL == null) {
                ALog.logInfo((String)"foo");
            }
            if (iL == null || !iL.intersects((AGeom)meLine)) continue;
            ++crosses;
        }
        return crosses;
    }

    protected void optimizeData() {
        ArrayList<Layer> lList = new ArrayList<Layer>();
        for (BWInfo bwi : this.mBWList) {
            if (lList.contains(bwi.layer)) continue;
            lList.add(bwi.layer);
        }
        for (Layer l : lList) {
            for (int quad = 0; quad < 4; ++quad) {
                ArrayList<BWInfo> quadList = new ArrayList<BWInfo>();
                for (BWInfo bwi : this.mBWList) {
                    if (bwi.quad != quad || bwi.layer != l) continue;
                    quadList.add(bwi);
                }
                this.optimizeQuad(quadList, quad);
            }
        }
    }

    protected void deriveData() {
        AMutableReference bondToPath = new AMutableReference(null);
        for (DevicePath path : OrbitIO.getCurDesign().getDescendantDevices()) {
            if (!path.getLast().getIsSubstrate() || path.getSubstrate() != this.mSub) continue;
            bondToPath.set((Object)path);
            break;
        }
        for (DeviceTemplate devTemp : this.mSub.getDeviceTemplates()) {
            Personality.getPersonalities((DeviceTemplate)devTemp, (Personality.Type)Personality.Type.BONDRING).forEach(personality -> {
                for (PinInstance diePad : PinInstance.getBondRingPins((Personality)personality)) {
                    PinTemplate bf = BondFingerUtil.getConnectedBF((DeviceTemplate)((DevicePath)bondToPath.get()).getDeviceTemplate(), (PinInstance)diePad);
                    if (diePad == null || bf == null) continue;
                    HierPin diePathPort = null;
                    HierPin bfPathPort = null;
                    PinInstance bfInstance = bf.getPinInstance((DevicePath)bondToPath.get());
                    Device diePadDevice = diePad.getDevice();
                    diePathPort = new HierPin(diePadDevice.getADevicePath(), diePad);
                    bfPathPort = new HierPin(bf.getDeviceTemplate().getPathToPresentUser(), bfInstance);
                    this.mTopPath = diePathPort.getPath().pathToSubstrate();
                    Layer l = BondFingerUtil.getWireBond((PinTemplate)bf).getLayer();
                    int q = WireBonder.determineMyQuad(diePathPort, this.mTopPath);
                    BWInfo bwi = new BWInfo(bfPathPort, diePathPort, l, q);
                    this.mBWList.add(bwi);
                }
            });
        }
    }

    protected ALine getLineFast(BWInfo bwi) {
        return this.mWBIToLine.get(bwi);
    }

    protected void hashLocations(ArrayList<BWInfo> wbs) {
        this.mWBIToLine.clear();
        for (BWInfo bwi : wbs) {
            this.mWBIToLine.put(bwi, new ALine(bwi.getLine()));
        }
    }

    protected void updateHashBMap(BWInfo bwi) {
        this.mWBIToLine.put(bwi, new ALine(bwi.getLine()));
    }

    public static class WBLengthSort
    implements Comparator<BWInfo> {
        int mQuad;

        public WBLengthSort(int quad) {
            this.mQuad = quad;
        }

        @Override
        public int compare(BWInfo o1, BWInfo o2) {
            long d = this.mQuad % 2 == 0 ? Math.abs(o2.getLine().getP1().getX()) - Math.abs(o1.getLine().getP1().getX()) : Math.abs(o2.getLine().getP1().getY()) - Math.abs(o1.getLine().getP1().getY());
            if (d < 0L) {
                return -1;
            }
            if (d > 0L) {
                return 1;
            }
            if (this.mQuad % 2 == 0) {
                d = o2.getLine().getP0().getY() - o1.getLine().getP0().getY();
                if (d < 0L) {
                    return -1;
                }
                if (d > 0L) {
                    return 1;
                }
                return 0;
            }
            d = o2.getLine().getP0().getX() - o1.getLine().getP0().getX();
            if (d < 0L) {
                return -1;
            }
            if (d > 0L) {
                return 1;
            }
            return 0;
        }
    }

    public class DiePadSortHUsingHash
    implements Comparator<BWInfo> {
        @Override
        public int compare(BWInfo o1, BWInfo o2) {
            ALine l1 = BondFingerUncrosser.this.getLineFast(o1);
            ALine l2 = BondFingerUncrosser.this.getLineFast(o2);
            return Long.compare(l1.getP0().getX(), l2.getP0().getX());
        }
    }

    public class DiePadSortVUsingHash
    implements Comparator<BWInfo> {
        @Override
        public int compare(BWInfo o1, BWInfo o2) {
            ALine l1 = BondFingerUncrosser.this.getLineFast(o1);
            ALine l2 = BondFingerUncrosser.this.getLineFast(o2);
            return Long.compare(l1.getP0().getY(), l2.getP0().getY());
        }
    }

    public static class DiePadSortH
    implements Comparator<BWInfo> {
        @Override
        public int compare(BWInfo o1, BWInfo o2) {
            return Long.compare(o1.diePathPort.getWorldLoc().getX(), o2.diePathPort.getWorldLoc().getX());
        }
    }

    public static class DiePadSortV
    implements Comparator<BWInfo> {
        @Override
        public int compare(BWInfo o1, BWInfo o2) {
            return Long.compare(o1.diePathPort.getWorldLoc().getY(), o2.diePathPort.getWorldLoc().getY());
        }
    }

    public static class InterceptSorter
    implements Comparator<BWInfo> {
        @Override
        public int compare(BWInfo o1, BWInfo o2) {
            return Long.compare(o1.intercept, o2.intercept);
        }
    }

    public static class LongSort
    implements Comparator<Long> {
        @Override
        public int compare(Long o1, Long o2) {
            return Long.compare(o1, o2);
        }
    }

    public static class LongAbsSort
    implements Comparator<Long> {
        @Override
        public int compare(Long o1, Long o2) {
            return Long.compare(Math.abs(o1), Math.abs(o2));
        }
    }

    protected class BWInfo {
        HierPin bfPathPort;
        HierPin diePathPort;
        Layer layer;
        Wire wire;
        int quad;
        long intercept;

        public ALine getLine() {
            ALine l = new ALine();
            DevicePath dPath = new DevicePath(this.diePathPort.getPath());
            DevicePath pPath = new DevicePath(this.bfPathPort.getPath());
            l.setP0(dPath.transformPt(this.diePathPort.getPin().getLoc()));
            l.setP1(pPath.transformPt(this.bfPathPort.getPin().getLoc()));
            return l;
        }

        public BWInfo(HierPin bf, HierPin diePad, Layer l, int q) {
            Wire w;
            this.bfPathPort = bf;
            this.diePathPort = diePad;
            this.layer = l;
            this.quad = q;
            this.wire = w = BondFingerUtil.getWireBond((PinTemplate)((PinInstance)bf.second).getPinTemplate());
        }
    }
}

