/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.automation.wirebonder;

import com.sigrity.acl.Stopwatch;
import com.sigrity.orbit.automation.wirebonder.WireBonder;
import java.util.ArrayList;

public class BondingThreadController {
    ArrayList<BondingThread> mThreads = new ArrayList();
    ArrayList<String> mRingNames = new ArrayList();
    ExecutionMode mExecutionMode;

    public BondingThreadController(ExecutionMode m) {
        this.mExecutionMode = m;
    }

    public void add(String pString) {
        if (this.mExecutionMode == ExecutionMode.Parallel) {
            this.mThreads.add(new BondingThread(pString));
        } else {
            this.mRingNames.add(pString);
        }
    }

    public void run() {
        Stopwatch sw = new Stopwatch();
        sw.start();
        if (this.mExecutionMode == ExecutionMode.Parallel) {
            for (BondingThread thread : this.mThreads) {
                thread.start();
            }
        } else {
            for (String mPersonality : this.mRingNames) {
                WireBonder.bondRing(mPersonality);
            }
        }
        sw.stop();
        sw.logElapsed();
    }

    public class BondingThread
    extends Thread {
        protected String mPersonality;

        public BondingThread(String personalityKeyString) {
            this.mPersonality = personalityKeyString;
        }

        @Override
        public void run() {
            WireBonder.bondRing(this.mPersonality);
        }
    }

    public static enum ExecutionMode {
        Sequential,
        Parallel;

    }
}

