/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.automation.wirebonder;

import com.sigrity.acl.ALog;
import com.sigrity.acl.APair;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.std.Constraint;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.NetMap;
import com.sigrity.acl.db.std.Personality;
import com.sigrity.acl.db.std.PinInstance;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.acl.db.std.Substrate;
import com.sigrity.acl.edaMgrs.NameGenerator;
import com.sigrity.acl.optimizer.PortPairOpt;
import com.sigrity.acl.optimizer.genetic.GeneticFinishingFunction;
import com.sigrity.acl.optimizer.genetic.GeneticOptimizerBroker;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.DevicePathPortPair;
import com.sigrity.orbit.HierPin;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.UserCommands;
import com.sigrity.orbit.automation.connOpt.GeneticConnectionOptimizer;
import java.awt.EventQueue;
import java.util.ArrayList;
import javax.swing.SwingUtilities;

public class CreateConnections {
    private CreateConnections() {
    }

    public static void createBallNetListQuick(String substrateKey, boolean useWB) {
        Substrate s = (Substrate)OrbitIO.getCurDb().getByKeyStr(Substrate.class, substrateKey);
        if (s == null) {
            ALog.logWarn((String)"Substrate not found");
            return;
        }
        if (useWB) {
            for (DevicePath dp : OrbitIO.getCurDesign().getDescendantDevices()) {
                if (dp.getSubstrate() != s || dp.getLast().getDeviceType() != DeviceTemplate.Type.PACKAGE) continue;
                CreateConnections.createBFToBallNetListQuick(dp);
            }
        } else {
            boolean isPackageSubstrate = false;
            for (DeviceTemplate dt : s.getDeviceTemplates()) {
                if (!dt.getType().equals((Object)DeviceTemplate.Type.PACKAGE)) continue;
                isPackageSubstrate = true;
                break;
            }
            if (isPackageSubstrate) {
                CreateConnections.createBumpToBallNetlistQuick(s);
            } else {
                CreateConnections.createIOPadToBumpNetlistQuick(s);
            }
        }
    }

    public static void createBallNetListEvolve(String substrateKey, boolean byTime, long stoppingNumber, int maxPopulation, boolean useWB) {
        Substrate s = (Substrate)OrbitIO.getCurDb().getByKeyStr(Substrate.class, substrateKey);
        if (s == null) {
            ALog.logWarn((String)"Substrate not found");
            return;
        }
        if (useWB) {
            for (DevicePath dp : OrbitIO.getCurDesign().getDescendantDevices()) {
                if (dp.getSubstrate() != s || dp.getLast().getDeviceType() != DeviceTemplate.Type.PACKAGE) continue;
                CreateConnections.createBFToBallNetListEvolve(dp, byTime, stoppingNumber, maxPopulation);
            }
        } else {
            boolean isPackageSubstrate = false;
            for (DeviceTemplate dt : s.getDeviceTemplates()) {
                if (!dt.getType().equals((Object)DeviceTemplate.Type.PACKAGE)) continue;
                isPackageSubstrate = true;
                break;
            }
            if (isPackageSubstrate) {
                CreateConnections.createBumpToBallNetlistEvolve(s, byTime, stoppingNumber, maxPopulation);
            } else {
                CreateConnections.createIOPadToBumpNetlistEvolve(s, byTime, stoppingNumber, maxPopulation);
            }
        }
    }

    protected static void createIOPadToBumpNetlistQuick(Substrate s) {
        ArrayList<HierPin> from = new ArrayList<HierPin>();
        ArrayList<HierPin> to = new ArrayList<HierPin>();
        s.getPersonalitiesStream(Personality.Type.RDL).forEach(p -> {
            for (PinInstance port : PinInstance.getRoutePins((Personality)p)) {
                from.add(new HierPin(port.getDevice().getADevicePath(), port));
            }
        });
        if (!from.isEmpty()) {
            DevicePath aPath = ((HierPin)from.get(0)).getPath();
            DevicePath diePath = aPath.pathToLowestDie();
            if (diePath == null || diePath.isEmpty()) {
                return;
            }
            for (DevicePath dp : diePath.getDescendants()) {
                for (PinInstance dPort : dp.getLast().getPins()) {
                    if (dPort.getType() != PinTemplate.Type.BUMPPAD) continue;
                    to.add(new HierPin(dp, dPort));
                }
            }
        }
        CreateConnections.createNonEvolved(from, to);
    }

    protected static void createIOPadToBumpNetlistEvolve(Substrate s, boolean byTime, long stoppingNumber, int maxPopulation) {
        class RDLreateConnectionsEvolve
        implements GeneticFinishingFunction {
            GeneticConnectionOptimizer mCO;
            DevicePath mDp;

            RDLreateConnectionsEvolve() {
            }

            protected void updateConnections(GeneticConnectionOptimizer co) {
                ArrayList<APair<HierPin, HierPin>> created = co.getConnected();
                UserCommands.removeConnections();
                NameGenerator ng = new NameGenerator("NewNet");
                for (APair<HierPin, HierPin> pair : created) {
                    DevicePath stopPathA = ((HierPin)pair.first).getPath().pathToParent(this.mDp);
                    String netName = null;
                    if (((HierPin)pair.first).getNet().isUnused()) {
                        netName = Net.findAUniqueNetName((NameGenerator)ng);
                        NetMap.mapThroughPath((DevicePath)stopPathA, (PinTemplate)((HierPin)pair.first).getPinTemplate(), (String)netName);
                    } else {
                        NetMap.mapThroughPath((DevicePath)stopPathA, (Net)((HierPin)pair.first).getNet());
                        netName = NetMap.getTopmostNet((Net)((HierPin)pair.first).getNet(), (DevicePath)stopPathA).getName();
                    }
                    DevicePath stopPathB = ((HierPin)pair.second).getPath().pathToParent(this.mDp);
                    NetMap.mapThroughPath((DevicePath)stopPathB, (PinTemplate)((HierPin)pair.second).getPinTemplate(), (String)netName);
                    CreateConnections.copyNetPersonality(((HierPin)pair.first).getPin(), ((HierPin)pair.second).getPin());
                }
                UserCommands.createConnections();
                OrbitIO.getApp().refreshCurrentView(false);
            }

            @Override
            public void onGeneticOptimizationFinished() {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        this.updateConnections(mCO);
                    }
                });
            }

            public void start(Substrate s, boolean byTime, long stoppingNumber, int maxPopulation) {
                ArrayList<HierPin> from = new ArrayList<HierPin>();
                ArrayList<HierPin> to = new ArrayList<HierPin>();
                s.getPersonalitiesStream(Personality.Type.RDL).forEach(p -> {
                    for (PinInstance port : PinInstance.getRoutePins((Personality)p)) {
                        from.add(new HierPin(port.getDevice().getADevicePath(), port));
                    }
                });
                DevicePath aPath = ((HierPin)from.get(0)).getPath();
                DevicePath diePath = aPath.pathToLowestDie();
                if (diePath == null || diePath.isEmpty()) {
                    return;
                }
                for (DevicePath dp : diePath.getDescendants()) {
                    for (PinInstance dPort : dp.getLast().getPins()) {
                        if (dPort.getPinTemplate().getType() != PinTemplate.Type.BUMPPAD) continue;
                        to.add(new HierPin(dp, dPort));
                    }
                }
                this.mDp = diePath;
                this.mCO = new GeneticConnectionOptimizer();
                this.mCO.setASet(from);
                this.mCO.setBSet(to);
                this.mCO.optimizeGenetically(byTime, stoppingNumber, maxPopulation);
                GeneticOptimizerBroker.addFinishingFunction(OrbitIO.getCurDb().toString(), this);
            }
        }
        RDLreateConnectionsEvolve fcevolver = new RDLreateConnectionsEvolve();
        fcevolver.start(s, byTime, stoppingNumber, maxPopulation);
    }

    protected static void createBumpToBallNetlistEvolve(Substrate s, boolean byTime, long stoppingNumber, int maxPopulation) {
        class FCCreateConnectionsEvolve
        implements GeneticFinishingFunction {
            GeneticConnectionOptimizer mCO;
            DevicePath mDp;

            FCCreateConnectionsEvolve() {
            }

            protected void updateConnections(GeneticConnectionOptimizer co) {
                ArrayList<APair<HierPin, HierPin>> created = co.getConnected();
                UserCommands.removeConnections();
                NameGenerator ng = new NameGenerator("NewNet");
                for (APair<HierPin, HierPin> pair : created) {
                    DevicePath stopPathA = ((HierPin)pair.first).getPath().pathToParent(this.mDp);
                    String netName = null;
                    if (((HierPin)pair.first).getNet().isUnused()) {
                        netName = Net.findAUniqueNetName((NameGenerator)ng);
                        NetMap.mapThroughPath((DevicePath)stopPathA, (PinTemplate)((HierPin)pair.first).getPinTemplate(), (String)netName);
                    } else {
                        NetMap.mapThroughPath((DevicePath)stopPathA, (Net)((HierPin)pair.first).getNet());
                        netName = NetMap.getTopmostNet((Net)((HierPin)pair.first).getNet(), (DevicePath)stopPathA).getName();
                    }
                    DevicePath stopPathB = ((HierPin)pair.second).getPath().pathToParent(this.mDp);
                    NetMap.mapThroughPath((DevicePath)stopPathB, (PinTemplate)((HierPin)pair.second).getPinTemplate(), (String)netName);
                    CreateConnections.copyNetPersonality(((HierPin)pair.first).getPin(), ((HierPin)pair.second).getPin());
                }
                UserCommands.createConnections();
                OrbitIO.getApp().refreshCurrentView(false);
            }

            @Override
            public void onGeneticOptimizationFinished() {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        this.updateConnections(mCO);
                    }
                });
            }

            public void start(Substrate s, boolean byTime, long stoppingNumber, int maxPopulation) {
                ArrayList<HierPin> from = new ArrayList<HierPin>();
                ArrayList<HierPin> to = new ArrayList<HierPin>();
                ArrayList personalityNamesInvolved = new ArrayList();
                s.getPersonalitiesStream(Personality.Type.FC).forEach(p -> {
                    for (PinInstance port : PinInstance.getRoutePins((Personality)p)) {
                        if (port.getPersonality() == null) continue;
                        personalityNamesInvolved.add(port.getPersonality().getName());
                        from.add(new HierPin(port.getDevice().getADevicePath(), port));
                    }
                });
                DevicePath aPath = ((HierPin)from.get(0)).getPath();
                DevicePath packagePath = aPath.pathToLowestPackage();
                if (packagePath == null || packagePath.isEmpty()) {
                    return;
                }
                for (DevicePath dp : packagePath.getDescendants()) {
                    for (PinInstance dPort : dp.getLast().getPins()) {
                        Personality p2;
                        if (dPort.getType() != PinTemplate.Type.BALLPAD || (p2 = dPort.getPersonality()) == null || !personalityNamesInvolved.contains(p2.getName())) continue;
                        to.add(new HierPin(dp, dPort));
                    }
                }
                for (HierPin dpp : to) {
                    dpp.getPin().setNet(dpp.getPath().getDeviceTemplate().getNetUnused());
                }
                this.mDp = packagePath;
                this.mCO = new GeneticConnectionOptimizer();
                this.mCO.setASet(from);
                this.mCO.setBSet(to);
                this.mCO.optimizeGenetically(byTime, stoppingNumber, maxPopulation);
                GeneticOptimizerBroker.addFinishingFunction(OrbitIO.getCurDb().toString(), this);
            }
        }
        FCCreateConnectionsEvolve fcevolver = new FCCreateConnectionsEvolve();
        fcevolver.start(s, byTime, stoppingNumber, maxPopulation);
    }

    protected static void createBumpToBallNetlistQuick(Substrate s) {
        ArrayList<HierPin> from = new ArrayList<HierPin>();
        ArrayList<HierPin> to = new ArrayList<HierPin>();
        ArrayList personalityNamesInvolved = new ArrayList();
        s.getPersonalitiesStream(Personality.Type.FC).forEach(p -> {
            for (PinInstance port : PinInstance.getRoutePins((Personality)p)) {
                if (port.getPersonality() != null) {
                    personalityNamesInvolved.add(port.getPersonality().getName());
                    from.add(new HierPin(port.getDevice().getADevicePath(), port));
                    continue;
                }
                ALog.logInfo((String)(port.getName() + " does not belong to a personality and will be ignored"));
            }
        });
        if (!from.isEmpty()) {
            DevicePath aPath = ((HierPin)from.get(0)).getPath();
            DevicePath packagePath = aPath.pathToLowestPackage();
            if (packagePath == null || packagePath.isEmpty()) {
                return;
            }
            for (DevicePath dp : packagePath.getDescendants()) {
                for (PinInstance dPort : dp.getLast().getPins()) {
                    Personality p2;
                    if (dPort.getType() != PinTemplate.Type.BALLPAD || (p2 = dPort.getPersonality()) == null || !personalityNamesInvolved.contains(p2.getName())) continue;
                    to.add(new HierPin(dp, dPort));
                }
            }
        }
        CreateConnections.createNonEvolved(from, to);
    }

    protected static void createBFToBallNetListQuick(DevicePath dp) {
        CreateConnections.createConnectionsWBFtoBall(dp);
        UserCommands.createConnections();
    }

    protected static void createBFToBallNetListEvolve(DevicePath dp, boolean byTime, long stoppingNumber, int maxPopulation) {
        class WBCreateConnections
        implements GeneticFinishingFunction {
            GeneticConnectionOptimizer mCO;
            DevicePath mDp;

            WBCreateConnections() {
            }

            public void start(DevicePath dp, boolean byTime, long stoppingNumber, int maxPopulation) {
            }

            @Override
            public void onGeneticOptimizationFinished() {
                1WBCreateConnections.Finisher finisher = new 1WBCreateConnections.Finisher();
                finisher.setGCO(this.mCO);
                SwingUtilities.invokeLater(finisher);
            }

            class 1WBCreateConnections.Finisher
            implements Runnable {
                GeneticConnectionOptimizer co;

                1WBCreateConnections.Finisher() {
                }

                public void setGCO(GeneticConnectionOptimizer co) {
                    this.co = co;
                }

                @Override
                public void run() {
                    ArrayList<APair<HierPin, HierPin>> created = this.co.getConnected();
                    UserCommands.removeConnections();
                    NameGenerator ng = new NameGenerator("NewNet");
                    for (APair<HierPin, HierPin> pair : created) {
                        DevicePath stopPathA = ((HierPin)pair.first).getPath().pathToParent(mDp);
                        String netName = null;
                        if (((HierPin)pair.first).getNet().isUnused()) {
                            netName = Net.findAUniqueNetName((NameGenerator)ng);
                            NetMap.mapThroughPath((DevicePath)stopPathA, (PinTemplate)((HierPin)pair.first).getPinTemplate(), (String)netName);
                        } else {
                            NetMap.mapThroughPath((DevicePath)stopPathA, (Net)((HierPin)pair.first).getNet());
                            netName = NetMap.getTopmostNet((Net)((HierPin)pair.first).getNet(), (DevicePath)stopPathA).getName();
                        }
                        DevicePath stopPathB = ((HierPin)pair.second).getPath().pathToParent(mDp);
                        NetMap.mapThroughPath((DevicePath)stopPathB, (PinTemplate)((HierPin)pair.second).getPinTemplate(), (String)netName);
                        CreateConnections.copyNetPersonality(((HierPin)pair.first).getPin(), ((HierPin)pair.second).getPin());
                    }
                    UserCommands.createConnections();
                    OrbitIO.getApp().refreshCurrentView(false);
                }
            }
        }
        WBCreateConnections wb = new WBCreateConnections();
        wb.start(dp, byTime, stoppingNumber, maxPopulation);
    }

    public static void copyNetPersonality(PinInstance from, PinInstance to) {
        Db db = from.getDb();
        Net dieNet = from.getNet();
        Personality dieNetP = dieNet.getPersonality();
        if (dieNetP != null) {
            DeviceTemplate devTemp = to.getDeviceTemplate();
            Personality packageNetP = Personality.getOrCreate((DeviceTemplate)devTemp, (Personality.Type)Personality.Type.NET, (String)dieNetP.getName(), newPers -> {
                newPers.setColor(dieNetP.getColor());
                Personality.copyConstraint((Db)db, (Personality)dieNetP, (Personality)newPers, (Constraint.Descriptor)Constraint.NET_MATCHLENGTH);
            });
            Net parentNet = to.getNet();
            parentNet.assignToPersonality(packageNetP, null);
        }
    }

    public static ArrayList<DevicePathPortPair> createConnectionsWBFtoBall(DevicePath dp) {
        return null;
    }

    protected static ArrayList<DevicePathPortPair> createNonEvolved(ArrayList<HierPin> from, ArrayList<HierPin> to) {
        ArrayList<String> personalityNames = new ArrayList<String>();
        ArrayList<DevicePathPortPair> created = new ArrayList<DevicePathPortPair>();
        for (HierPin dp : from) {
            Personality p = dp.getPin().getPersonality();
            if (p == null || personalityNames.contains(p.getName())) continue;
            personalityNames.add(p.getName());
        }
        if (personalityNames.isEmpty()) {
            ALog.logInfo((String)"There are no personalities to optimize");
        }
        for (String personalityName : personalityNames) {
            ALog.logInfo((String)("Optimizing " + personalityName));
            ArrayList<HierPin> thisFrom = new ArrayList<HierPin>();
            ArrayList<HierPin> thisTo = new ArrayList<HierPin>();
            for (HierPin candidate : from) {
                if (candidate.getPin().getPersonality() == null || !candidate.getPin().getPersonality().getName().equals(personalityName)) continue;
                thisFrom.add(candidate);
            }
            for (HierPin candidate : to) {
                if (candidate.getPin().getPersonality() == null || !candidate.getPin().getPersonality().getName().equals(personalityName)) continue;
                thisTo.add(candidate);
            }
            PortPairOpt ppo = new PortPairOpt();
            ppo.setAPorts(thisFrom);
            ppo.setBPorts(thisTo);
            ppo.setFilter(false);
            ppo.assign();
            for (DevicePathPortPair dpp : ppo.getCreated()) {
                created.add(dpp);
            }
        }
        return created;
    }
}

