/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.automation.wirebonder;

import com.sigrity.acl.geom.AArc;
import com.sigrity.acl.geom.AGeom;
import com.sigrity.acl.geom.ALine;
import com.sigrity.acl.geom.APoint2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

public class GuideSpreader {
    AGeom mGuide;
    int mQuad;
    Long mStart = null;
    Long mEnd = null;
    ArrayList<BFInfo> mBFList = new ArrayList();
    long mMinSep = 0L;
    OnUnderLoad mOnUnderLoad = OnUnderLoad.MINMOVEMENT;

    public void onUnderLoad(OnUnderLoad oul) {
        this.mOnUnderLoad = oul;
    }

    public void geom(AGeom guide, int quad) {
        this.mGuide = guide;
        this.mQuad = quad;
    }

    public void minSep(long minSep) {
        this.mMinSep = minSep;
    }

    public long getStart() {
        if (this.mStart != null) {
            return this.mStart;
        }
        if (this.mGuide instanceof AArc) {
            AArc arc = (AArc)this.mGuide;
            this.mStart = this.mQuad % 2 == 0 ? Long.valueOf(arc.getP0().getY()) : Long.valueOf(arc.getP0().getX());
        } else {
            ALine line = (ALine)this.mGuide;
            this.mStart = this.mQuad % 2 == 0 ? Long.valueOf(line.getP0().getY()) : Long.valueOf(line.getP0().getX());
        }
        return this.mStart;
    }

    public long getEnd() {
        if (this.mEnd != null) {
            return this.mEnd;
        }
        if (this.mGuide instanceof AArc) {
            AArc arc = (AArc)this.mGuide;
            this.mEnd = this.mQuad % 2 == 0 ? Long.valueOf(arc.getP1().getY()) : Long.valueOf(arc.getP1().getX());
        } else {
            ALine line = (ALine)this.mGuide;
            this.mEnd = this.mQuad % 2 == 0 ? Long.valueOf(line.getP1().getY()) : Long.valueOf(line.getP1().getX());
        }
        return this.mEnd;
    }

    public long fOfs(long s) {
        if (this.mGuide instanceof AArc) {
            AArc arc = (AArc)this.mGuide;
            if (this.mQuad % 2 == 0) {
                APoint2D p0 = arc.getP0();
                APoint2D p1 = arc.getP1();
                long dy = p1.getY() - p1.getY();
                double dp = s - p0.getY() / dy;
                double a = arc.getEndAngle() - arc.getStartAngle() * dp + arc.getStartAngle();
                long x = arc.getCenter().getX() + (long)((double)arc.getRadius() * Math.cos(a));
                return x;
            }
            APoint2D p0 = arc.getP0();
            APoint2D p1 = arc.getP1();
            long dx = p1.getX() - p1.getX();
            double dp = s - p0.getX() / dx;
            double a = arc.getEndAngle() - arc.getStartAngle() * dp + arc.getStartAngle();
            long y = arc.getCenter().getY() + (long)((double)arc.getRadius() * Math.sin(a));
            return y;
        }
        ALine l = (ALine)this.mGuide;
        if (this.mQuad % 2 == 0) {
            return l.getP0().getX();
        }
        return l.getP0().getY();
    }

    public void addObject(Object obj, long s, long width, APoint2D other) {
        BFInfo bfi = new BFInfo();
        this.mBFList.add(bfi);
        bfi.obj = obj;
        bfi.s = s;
        bfi.otherEnd = other;
        bfi.width = width;
    }

    public APoint2D getLoc(Object o) {
        for (int i = 0; i < this.mBFList.size(); ++i) {
            if (this.mBFList.get((int)i).obj != o) continue;
            long s = this.mBFList.get((int)i).s;
            if (this.mQuad % 2 == 0) {
                return new APoint2D(this.fOfs(s), s);
            }
            return new APoint2D(s, this.fOfs(s));
        }
        return null;
    }

    public boolean relax() {
        if (this.mBFList.size() == 0) {
            return false;
        }
        Collections.sort(this.mBFList, new LineSorter());
        return this.relaxLine();
    }

    protected long getGuideLength() {
        if (this.mGuide instanceof AArc) {
            return ((AArc)this.mGuide).getLength();
        }
        return ((ALine)this.mGuide).getLength();
    }

    protected boolean relaxLine() {
        long length = this.getGuideLength();
        int numObj = this.mBFList.size();
        long spaceRequired = 0L;
        for (int i = 0; i < numObj; ++i) {
            spaceRequired += this.mBFList.get((int)i).width;
        }
        if (length < (spaceRequired += (long)numObj * this.mMinSep + this.mMinSep)) {
            this.mOnUnderLoad = OnUnderLoad.EVEN;
        }
        if (this.mOnUnderLoad == OnUnderLoad.MINMOVEMENT) {
            this.relaxLineABit();
        } else {
            long slack = length - spaceRequired;
            long sep = this.mMinSep + slack / (long)(numObj + 1);
            long start = this.getStart() + sep;
            for (BFInfo o : this.mBFList) {
                o.s = start;
                start += sep;
                start += o.width / 2L;
            }
        }
        return true;
    }

    protected long beforeSlack(int index) {
        long lastS = this.getStart();
        long slack = 0L;
        for (int i = 0; i <= index; ++i) {
            slack += this.mBFList.get((int)i).s - lastS;
            lastS = this.mBFList.get((int)i).s;
        }
        return slack;
    }

    protected long afterSlack(int index) {
        long lastS = this.getEnd();
        long slack = 0L;
        for (int i = this.mBFList.size() - 1; i >= index; --i) {
            slack += lastS - this.mBFList.get((int)i).s;
            lastS = this.mBFList.get((int)i).s;
        }
        return slack;
    }

    protected boolean atMinSep() {
        long lastS = this.getStart();
        for (int i = 0; i < this.mBFList.size(); ++i) {
            long slack = this.mBFList.get((int)i).s - lastS;
            if (slack < this.mMinSep) {
                return false;
            }
            lastS = this.mBFList.get((int)i).s;
        }
        return this.getEnd() - lastS >= this.mMinSep;
    }

    protected long beforeClr(int i) {
        int last = this.mBFList.size();
        if (i == last) {
            return this.getEnd() - this.mBFList.get((int)(last - 1)).s - this.mBFList.get((int)(last - 1)).width / 2L;
        }
        if (i == 0) {
            return this.mBFList.get((int)i).s - this.getStart() - this.mBFList.get((int)i).width / 2L;
        }
        return this.mBFList.get((int)i).s - this.mBFList.get((int)(i - 1)).s - this.mBFList.get((int)i).width / 2L - this.mBFList.get((int)(i - 1)).width / 2L;
    }

    protected long afterClr(int i) {
        int last = this.mBFList.size();
        if (i == -1) {
            return this.mBFList.get((int)0).s - this.getStart() - this.mBFList.get((int)0).width / 2L;
        }
        if (i == last - 1) {
            return this.getEnd() - this.mBFList.get((int)i).s - this.mBFList.get((int)i).width / 2L;
        }
        return this.mBFList.get((int)(i + 1)).s - this.mBFList.get((int)i).s - this.mBFList.get((int)i).width / 2L - this.mBFList.get((int)(i + 1)).width / 2L;
    }

    protected boolean pushAfter(int i, long ds) {
        boolean canDo = true;
        long currentAfter = this.afterClr(i);
        if (currentAfter < ds + this.mMinSep) {
            canDo = i < this.mBFList.size() - 1 ? this.pushAfter(i + 1, ds + this.mMinSep - currentAfter) : false;
        }
        this.mBFList.get((int)i).s += ds;
        if (this.mBFList.get((int)i).s > this.getEnd()) {
            this.mBFList.get((int)i).s = this.getEnd();
        }
        return canDo;
    }

    protected boolean pushBefore(int i, long ds) {
        boolean canDo = true;
        long currentBefore = this.beforeClr(i);
        if (currentBefore < ds + this.mMinSep) {
            canDo = i > 0 ? this.pushBefore(i - 1, ds + this.mMinSep - currentBefore) : false;
        }
        this.mBFList.get((int)i).s -= ds;
        if (this.mBFList.get((int)i).s < this.getStart()) {
            this.mBFList.get((int)i).s = this.getStart();
        }
        return canDo;
    }

    protected boolean relaxLineABit() {
        int i;
        boolean canDoAfter = true;
        boolean canDoBefore = true;
        if (this.mBFList.size() > 2) {
            int i2;
            boolean canDoCenter = true;
            int center = this.mBFList.size() / 2;
            for (i2 = center + 1; i2 > 0 && canDoCenter; --i2) {
                if (this.beforeClr(i2) >= this.mMinSep || this.pushBefore(i2 - 1, this.mMinSep - this.beforeClr(i2))) continue;
                canDoCenter = false;
            }
            for (i2 = center; i2 < this.mBFList.size() - 1 && canDoAfter; ++i2) {
                if (this.afterClr(i2) >= this.mMinSep || this.pushAfter(i2 + 1, this.mMinSep - this.afterClr(i2))) continue;
                canDoCenter = false;
            }
            if (canDoCenter) {
                return true;
            }
        }
        for (i = -1; i < this.mBFList.size() - 1 && canDoAfter; ++i) {
            if (this.afterClr(i) >= this.mMinSep || this.pushAfter(i + 1, this.mMinSep - this.afterClr(i))) continue;
            canDoAfter = false;
        }
        if (canDoAfter) {
            return true;
        }
        for (i = this.mBFList.size(); i > 0 && canDoBefore; --i) {
            if (this.beforeClr(i) >= this.mMinSep || this.pushBefore(i - 1, this.mMinSep - this.beforeClr(i))) continue;
            canDoBefore = false;
        }
        if (canDoBefore) {
            return true;
        }
        canDoAfter = true;
        this.mBFList.get((int)0).s = this.getStart() + this.mMinSep;
        for (i = -1; i < this.mBFList.size() - 1 && canDoAfter; ++i) {
            if (this.afterClr(i) >= this.mMinSep || this.pushAfter(i + 1, this.mMinSep - this.afterClr(i))) continue;
            canDoAfter = false;
        }
        return canDoAfter;
    }

    public static class LineSorter
    implements Comparator<BFInfo> {
        @Override
        public int compare(BFInfo o1, BFInfo o2) {
            return Long.compare(o1.s, o2.s);
        }
    }

    public static enum OnUnderLoad {
        MINMOVEMENT,
        EVEN;

    }

    static class BFInfo {
        Object obj;
        long s;
        long width;
        APoint2D otherEnd;

        BFInfo() {
        }
    }
}

