/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.automation.wirebonder;

import com.sigrity.acl.ALog;
import com.sigrity.acl.db.BondFingerUtil;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.std.Connection;
import com.sigrity.acl.db.std.Constraint;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Layer;
import com.sigrity.acl.db.std.LayerShape;
import com.sigrity.acl.db.std.Metal;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.NetMap;
import com.sigrity.acl.db.std.PadTemplate;
import com.sigrity.acl.db.std.Personality;
import com.sigrity.acl.db.std.PinInstance;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.acl.db.std.PortTemplate;
import com.sigrity.acl.db.std.StoredPath;
import com.sigrity.acl.db.std.Substrate;
import com.sigrity.acl.db.std.Wire;
import com.sigrity.acl.geom.AArc;
import com.sigrity.acl.geom.ACircle;
import com.sigrity.acl.geom.AGeom;
import com.sigrity.acl.geom.AGeomUtil;
import com.sigrity.acl.geom.ALine;
import com.sigrity.acl.geom.APath;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.acl.geom.APolygon;
import com.sigrity.acl.geom.ARect;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.HierPin;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.automation.wirebonder.BondFingerGrouper;
import com.sigrity.orbit.automation.wirebonder.BondFingerInstruction;
import com.sigrity.orbit.automation.wirebonder.BondFingerInstructionManager;
import com.sigrity.orbit.automation.wirebonder.BondFingerOptimizer;
import com.sigrity.orbit.automation.wirebonder.BondFingerUncrosser;
import com.sigrity.orbit.automation.wirebonder.BondingThreadController;
import com.sigrity.orbit.automation.wirebonder.GuideSpreader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.Objects;
import org.w3c.dom.Element;

public class WireBonder {
    protected Db mDb;
    protected Constraint.RingType mRingType = Constraint.RingType.FINGER;
    protected ArrayList<HierPin> mPorts = new ArrayList();
    protected ArrayList<Personality> mBondSet = new ArrayList();
    protected String[] mSideNames = new String[]{"Right", "Top", "Left", "Bottom"};
    protected Device mBondTo = null;
    protected Device mBondAround = null;
    protected DevicePath mBondToPath = null;
    protected DevicePath mBondAroundPath = null;
    protected long mClearanceAround;
    protected long mFingerLength = 1L;
    protected long mFingerWidth = 1L;
    protected long mFingerSpace = 1L;
    protected long mTierSpace = 1L;
    protected long mMetalRingWidth = 1L;
    protected long mRouteWidth = 1L;
    protected long mRouteClear = 1L;
    protected Layer mBondFingerLayer = null;
    protected Layer mWireBondLayer = null;
    protected int mMaxGrouping = 1;
    protected boolean mRotateFingers = true;
    protected long mWireWidth = 1L;
    protected double mMinAngle = 90.0;
    protected Constraint.RingGeom mRingGeom;
    protected ArrayList<Connection> mPendingConnection = new ArrayList();
    protected Personality mBondRingPersonality;
    protected Element mLastSection;
    protected boolean mJustReWire;
    protected BondFingerPlaceFactory mBFPF;
    protected Metal mMetal;
    protected long mNextNameSuffix = 1L;

    DevicePath createBondAroundPath(PinInstance port) {
        return WireBonder.createPortPath(this.mBondAroundPath, port);
    }

    DevicePath createBondToPath(PinInstance port) {
        return WireBonder.createPortPath(this.mBondToPath, port);
    }

    public static WireBonder create() {
        return new WireBonder();
    }

    protected static boolean validateBonding(Personality p) {
        WireBonder bonder = WireBonder.create();
        bonder.setPersonality(p);
        bonder.determinePaths();
        for (PinInstance port : PinInstance.getBondRingPins((Personality)p)) {
            PinTemplate bf = BondFingerUtil.getConnectedBF((DeviceTemplate)bonder.mBondTo.getTemplate(), (PinInstance)port);
            if (bf == null || bf.getDeviceTemplate() != bonder.mBondTo.getTemplate()) continue;
            ALog.logWarn((String)"There are already bondfingers for this Personality, please unBond first");
            return false;
        }
        return true;
    }

    public static void unBondRing(String personalityKey) {
        Db db = OrbitIO.getCurDb();
        Personality p = Personality.getByKeyStr((Db)db, (String)personalityKey);
        if (p == null) {
            ALog.logWarn((String)"Can not find bond ring definition to bond");
            return;
        }
        WireBonder bonder = WireBonder.create();
        bonder.setPersonality(p);
        bonder.determinePaths();
        DeviceTemplate bondToTemplate = bonder.mBondTo.getTemplate();
        ArrayList<PinTemplate> toBeDeletedBondFingers = new ArrayList<PinTemplate>();
        ArrayList<Wire> toBeDeletedWires = new ArrayList<Wire>();
        ArrayList<PinTemplate> toBeDeletedWireEnds = new ArrayList<PinTemplate>();
        ArrayList<Metal> toBeDeletedMetal = new ArrayList<Metal>();
        for (PinInstance port : PinInstance.getBondRingPins((Personality)p)) {
            Wire w;
            PinTemplate bf = BondFingerUtil.getConnectedBF((DeviceTemplate)bondToTemplate, (PinInstance)port);
            if (bf == null) continue;
            toBeDeletedBondFingers.add(bf);
            Metal m = BondFingerUtil.getMetal((PinTemplate)bf);
            if (m != null && !toBeDeletedMetal.contains(m)) {
                toBeDeletedMetal.add(m);
            }
            if (bf.getDeviceTemplate().getType() == DeviceTemplate.Type.GROUP && !toBeDeletedBondFingers.contains(bf)) {
                toBeDeletedBondFingers.add(bf);
            }
            if ((w = BondFingerUtil.getWireBond((PinTemplate)bf)) == null) continue;
            PinTemplate wireEnd = (PinTemplate)w.getPinA().second;
            if (wireEnd.getType() == PinTemplate.Type.WIREEND) {
                toBeDeletedWireEnds.add(wireEnd);
            }
            toBeDeletedWires.add(w);
        }
        for (Metal m : toBeDeletedMetal) {
            m.deleteFromDb();
        }
        for (Wire w : toBeDeletedWires) {
            w.deleteFromDb();
        }
        for (PinTemplate pt : toBeDeletedBondFingers) {
            pt.deleteFromDb();
        }
        for (PinTemplate pt : toBeDeletedWireEnds) {
            pt.deleteFromDb();
        }
    }

    protected static void refresh(Db db) {
    }

    public static void bondSubstrate(String substrateKey) {
        Substrate s = (Substrate)OrbitIO.getCurDb().getByKeyStr(Substrate.class, substrateKey);
        if (s == null) {
            ALog.logWarn((String)"Substrate not found");
            return;
        }
        BondingThreadController tc = new BondingThreadController(BondingThreadController.ExecutionMode.Sequential);
        for (DeviceTemplate devTemp : s.getDeviceTemplates()) {
            if (Personality.getPersonalities((DeviceTemplate)devTemp, (Personality.Type)Personality.Type.BONDRING).anyMatch(p -> !WireBonder.validateBonding(p))) {
                return;
            }
            Personality.getPersonalities((DeviceTemplate)devTemp, (Personality.Type)Personality.Type.BONDRING).forEach(p -> tc.add(p.getKeyStr()));
        }
        tc.run();
        BondFingerUncrosser bfu = new BondFingerUncrosser();
        bfu.smoothMetalWiresWithSignalWires(substrateKey);
    }

    public static void unBondSubstrate(String substrateKey) {
        Substrate s = (Substrate)OrbitIO.getCurDb().getByKeyStr(Substrate.class, substrateKey);
        if (s == null) {
            ALog.logWarn((String)"Substrate not found");
            return;
        }
        for (DeviceTemplate devTemp : s.getDeviceTemplates()) {
            Personality.getPersonalities((DeviceTemplate)devTemp, (Personality.Type)Personality.Type.BONDRING).forEach(p -> WireBonder.unBondRing(p.getKeyStr()));
        }
    }

    public static void reWireRing(String personalityKey) {
    }

    public static void bondRing(String personalityKey) {
        WireBonder.bondRing(personalityKey, false);
    }

    public static void bondRing(String personalityKey, boolean justReWire) {
        Personality p = Personality.getByKeyStr((Db)OrbitIO.getCurDb(), (String)personalityKey);
        if (p == null) {
            ALog.logError((String)"Can not find bond ring definition to bond");
            return;
        }
        Db db = p.getDb();
        WireBonder bonder = WireBonder.create();
        bonder.setPersonality(p);
        Constraint.RingType rt = (Constraint.RingType)Constraint.getValue((Db)db, (DbObject)p, (Constraint.Descriptor)Constraint.BONDRING_TYPE);
        bonder.setRingType(rt);
        Layer l = (Layer)Constraint.getValue((Db)db, (DbObject)p, (Constraint.Descriptor)Constraint.BONDFINGER_LAYER);
        if (l == null) {
            ALog.logError((String)"Bond Ring Descriptor '%s' does not specify a Bond Finger Layer.", (Object[])new Object[]{p.getName()});
            return;
        }
        bonder.setBondFingerLayer(l);
        l = (Layer)Constraint.getValue((Db)db, (DbObject)p, (Constraint.Descriptor)Constraint.WIREBOND_LAYER);
        if (l == null) {
            ALog.logError((String)"Bond Ring Descriptor '%s' does not specify a Wire Bond Layer.", (Object[])new Object[]{p.getName()});
            return;
        }
        if (l.getType() == null || l.getType() == Layer.LayerType.Unknown) {
            l.setType(Layer.LayerType.Jumper);
        }
        bonder.setWireBondLayer(l);
        bonder.determinePaths();
        if (rt == Constraint.RingType.METAL) {
            long width = (Long)Constraint.getValue((Db)db, (DbObject)p, (Constraint.Descriptor)Constraint.METALRING_WIDTH);
            bonder.setMetalRingWidth(width);
            long clearAround = (Long)Constraint.getValue((Db)db, (DbObject)p, (Constraint.Descriptor)Constraint.METALRING_DIST);
            bonder.setClearanceAround(clearAround);
            long wireWidth = (Long)Constraint.getValue((Db)db, (DbObject)p, (Constraint.Descriptor)Constraint.BONDWIRE_WIDTH);
            wireWidth = Math.max(wireWidth, Design.micronToInternal((Db)db, (double)10.0));
            bonder.setWireWidth(wireWidth);
            long fingerWidth = wireWidth;
            bonder.setFingerSize(fingerWidth, fingerWidth);
            long fingerSpace = (Long)Constraint.getValue((Db)db, (DbObject)p, (Constraint.Descriptor)Constraint.BONDFINGER_SEPARATION);
            bonder.setFingerSpacing(fingerSpace);
            Double bondMinAngle = (Double)Constraint.getValue((Db)db, (DbObject)p, (Constraint.Descriptor)Constraint.BONDMIN_ANGLE);
            if (bondMinAngle != null) {
                bonder.setMinAngle(bondMinAngle);
            }
        } else {
            long fingerLength = (Long)Constraint.getValue((Db)db, (DbObject)p, (Constraint.Descriptor)Constraint.BONDFINGER_LENGTH);
            long fingerWidth = (Long)Constraint.getValue((Db)db, (DbObject)p, (Constraint.Descriptor)Constraint.BONDFINGER_WIDTH);
            bonder.setFingerSize(fingerLength, fingerWidth);
            long clearAround = (Long)Constraint.getValue((Db)db, (DbObject)p, (Constraint.Descriptor)Constraint.BONDMIN_LENGTH);
            bonder.setClearanceAround(clearAround);
            Long fingerSpace = (Long)Constraint.getValue((Db)db, (DbObject)p, (Constraint.Descriptor)Constraint.BONDFINGER_SEPARATION);
            if (fingerSpace != null) {
                bonder.setFingerSpacing(fingerSpace);
            }
            long wireWidth = (Long)Constraint.getValue((Db)db, (DbObject)p, (Constraint.Descriptor)Constraint.BONDWIRE_WIDTH);
            bonder.setWireWidth(wireWidth);
            long tierSpace = (Long)Constraint.getValue((Db)db, (DbObject)p, (Constraint.Descriptor)Constraint.BONDFINGER_TIER_DIST);
            bonder.setTierDistance(tierSpace);
            Constraint.BondFingerAngle angleFingers = (Constraint.BondFingerAngle)Constraint.getValue((Db)db, (DbObject)p, (Constraint.Descriptor)Constraint.BONDFINGER_ANGLE);
            if (angleFingers == Constraint.BondFingerAngle.FOLLOWWIRE) {
                bonder.setRotateFingers(true);
            } else {
                bonder.setRotateFingers(false);
            }
            Constraint.RingGeom ringGeom = (Constraint.RingGeom)Constraint.getValue((Db)db, (DbObject)p, (Constraint.Descriptor)Constraint.RING_GEOM);
            bonder.setRingGeom(ringGeom);
            double bondMinAngle = (Double)Constraint.getValue((Db)db, (DbObject)p, (Constraint.Descriptor)Constraint.BONDMIN_ANGLE);
            bonder.setMinAngle(bondMinAngle);
            bonder.setJustReWire(justReWire);
        }
        if (!WireBonder.validateBonding(p)) {
            return;
        }
        bonder.bond();
        WireBonder.refresh(OrbitIO.getCurDb());
    }

    protected WireBonder() {
        this.mDb = OrbitIO.getCurDb();
    }

    public void clearPorts() {
        this.mPorts.clear();
    }

    protected void determinePaths() {
        Substrate s = this.mBondRingPersonality.getOwner().getSubstrate();
        for (Object path2 : OrbitIO.getCurDesign().getDescendantDevices()) {
            if (!path2.getLast().getIsSubstrate() || path2.getSubstrate() != s) continue;
            this.mBondToPath = path2;
            this.mBondTo = path2.getLast();
            break;
        }
        int onUnused = 0;
        for (PinInstance port : PinInstance.getBondRingPins((Personality)this.mBondRingPersonality)) {
            if (port.getNet().isUnused()) {
                ++onUnused;
                continue;
            }
            Device d = port.getDevice();
            DevicePath portPath = d.getAllPaths().filter(path -> path.contains(this.mBondTo)).findFirst().orElse(null);
            this.mPorts.add(new HierPin(portPath, port));
        }
        if (onUnused > 0) {
            ALog.logWarn((String)(onUnused + " pins will not be bonded because they are on NetUnused"));
        }
        if (this.mPorts.size() > 0) {
            Device d = this.mPorts.get(0).getPath().getLast();
            Substrate substrateOfDie = d.getSubstrate();
            for (DevicePath child : this.mBondToPath.getDescendants()) {
                if (!child.getLast().getIsSubstrate() || child.getSubstrate() != substrateOfDie) continue;
                this.mBondAroundPath = child;
                this.mBondAround = this.mBondAroundPath.getLast();
                break;
            }
        }
    }

    public void setAMetalDRC(long bfWidth, long bfClr, double bfAngle) {
    }

    public void setMinAngle(double angle) {
        this.mMinAngle = angle;
    }

    public void setRingGeom(Constraint.RingGeom geom) {
        this.mRingGeom = geom;
    }

    public void setJustReWire(boolean justReWire) {
        this.mJustReWire = justReWire;
    }

    public ArrayList<HierPin> getPorts() {
        return this.mPorts;
    }

    public void setRingType(Constraint.RingType ringType) {
        this.mRingType = ringType;
    }

    public void setBondTo(String deviceKey) {
        this.setBondTo((Device)this.mDb.getByKeyStr(Device.class, deviceKey));
    }

    public void setBondTo(Device device) {
        this.mBondTo = device;
    }

    public void setBondFingerLayer(Layer l) {
        this.mBondFingerLayer = l;
    }

    public void setWireBondLayer(Layer l) {
        this.mWireBondLayer = l;
    }

    public void setPersonality(Personality p) {
        this.mBondRingPersonality = p;
    }

    public void setMaxGrouping(int maxGrouping) {
        this.mMaxGrouping = maxGrouping;
    }

    public void setFingerSize(long length, long width) {
        this.mFingerLength = length;
        this.mFingerWidth = width;
    }

    public void setMetalRingWidth(long width) {
        this.mMetalRingWidth = width;
    }

    public void setFingerSpacing(long space) {
        this.mFingerSpace = space;
    }

    public void setRotateFingers(boolean rotate) {
        this.mRotateFingers = rotate;
    }

    public void setBondAround(String deviceKey) {
        this.setBondAround((Device)this.mDb.getByKeyStr(Device.class, deviceKey));
    }

    public void setBondAround(Device device) {
        this.mBondAround = device;
    }

    public void setClearanceAround(long clearance) {
        this.mClearanceAround = clearance;
    }

    public void setWireWidth(long wireWidth) {
        this.mWireWidth = wireWidth;
    }

    public void setTierDistance(long tierSpace) {
        this.mTierSpace = tierSpace;
    }

    public void setRoutingInformation(long traceWidth, long traceClear) {
        this.mRouteWidth = traceWidth;
        this.mRouteClear = traceClear;
    }

    protected PadTemplate getBondFingerTemplate(String name) {
        PadTemplate pt = null;
        pt = PadTemplate.get((Db)this.mDb, (Substrate)this.mBondFingerLayer.getSubstrate(), (String)name);
        if (pt == null) {
            pt = PadTemplate.create((Db)this.mDb, (Substrate)this.mBondFingerLayer.getSubstrate());
            if (this.mRingType == Constraint.RingType.FINGER) {
                int i;
                int numPts = 16;
                APolygon geom = new APolygon();
                ArrayList topArc = AArc.genPoints((APoint2D)new APoint2D(0L, this.mFingerLength / 2L - this.mFingerWidth / 2L), (long)(this.mFingerWidth / 2L), (double)Math.toRadians(0.0), (double)Math.toRadians(180.0), (int)numPts);
                ArrayList botArc = AArc.genPoints((APoint2D)new APoint2D(0L, -this.mFingerLength / 2L + this.mFingerWidth / 2L), (long)(this.mFingerWidth / 2L), (double)Math.toRadians(180.0), (double)Math.toRadians(180.0), (int)numPts);
                for (i = 0; i < numPts; ++i) {
                    geom.addPoint((APoint2D)topArc.get(i));
                }
                for (i = 0; i < numPts; ++i) {
                    geom.addPoint((APoint2D)botArc.get(i));
                }
                LayerShape.create((Layer)this.mBondFingerLayer, (DbObject)pt, (AGeom)geom);
            } else {
                ACircle geom = new ACircle(0L, 0L, this.mFingerWidth / 2L);
                LayerShape.create((Layer)this.mBondFingerLayer, (DbObject)pt, (AGeom)geom);
            }
        }
        return pt;
    }

    protected void globalPlace(PadTemplate bfdt) {
        ALog.logInfo((String)"Global Bonding");
        if (this.mJustReWire) {
            this.mBFPF = new FindPlaceFactory();
        }
        this.mBFPF = this.mRingType == Constraint.RingType.FINGER ? (this.mRingGeom == Constraint.RingGeom.ARC ? new SPlaceFactoryArc() : new SPlaceFactoryLine()) : new MetalPlaceFactory();
        this.mBFPF.setMinDist(this.mClearanceAround);
        this.mBFPF.setPorts(this.mPorts);
        this.mBFPF.start();
        ArrayList<BondFingerInstruction> bfts = this.mBFPF.locations();
        ALog.logInfo((String)"Creating Bond Fingers");
        if (!this.mJustReWire) {
            for (BondFingerInstruction bft : bfts) {
                APoint2D placePoint = new APoint2D(bft.x, bft.y);
                placePoint = Device.getALocRelativeToMeFromWorld((DevicePath)this.mBondToPath, (APoint2D)placePoint);
                String name = "BF_" + bft.uniqueName;
                PinTemplate thisBondFinger = BondFingerUtil.create((String)name, (PadTemplate)bfdt, (DeviceTemplate)this.mBondTo.getTemplate());
                if (this.mRingType == Constraint.RingType.METAL) {
                    BondFingerUtil.setMetal((PinTemplate)thisBondFinger, (Metal)this.mMetal);
                } else {
                    BondFingerUtil.setMetal((PinTemplate)thisBondFinger, null);
                }
                thisBondFinger.setLoc(placePoint);
                thisBondFinger.setRotate(bft.angle);
                BondFingerUtil.setPersonality((PinTemplate)thisBondFinger, (Personality)this.mBondRingPersonality);
                BondFingerUtil.setRing((PinTemplate)thisBondFinger, (int)bft.ring);
                BondFingerUtil.setQuad((PinTemplate)thisBondFinger, (int)bft.quad);
                bft.bfPath = new DevicePath(this.mBondToPath);
                bft.bondFingerPin = thisBondFinger;
            }
        }
        BondFingerOptimizer bfo = new BondFingerOptimizer(this);
        bfo.loadInsr(bfts);
        bfo.setClr(this.mWireWidth * 2L);
        bfo.makePairs();
    }

    public void bond() {
        PadTemplate bfDT = null;
        if (this.mPorts.isEmpty()) {
            ALog.logWarn((String)"No pins to bond.");
            return;
        }
        if (this.mRingType == Constraint.RingType.FINGER) {
            String baseName = String.format("%s/BF%dx%d", this.mBondTo.getSubstrate().getName(), this.mFingerWidth, this.mFingerLength);
            bfDT = this.getBondFingerTemplate(baseName);
        } else {
            DevicePath diePath = new DevicePath(this.mBondAroundPath.getLast());
            ARect around = diePath.getBB();
            around.grow(this.mClearanceAround);
            String baseName = String.format("BondFinger%dx%d", this.mWireWidth, this.mFingerLength);
            bfDT = this.getBondFingerTemplate(baseName);
            ARect pathCenter = new ARect(around);
            APath path = new APath();
            path.setWidth(this.mMetalRingWidth);
            path.addPoint(pathCenter.getUR());
            path.addPoint(pathCenter.getUL());
            path.addPoint(pathCenter.getLL());
            path.addPoint(pathCenter.getLR());
            path.addPoint(pathCenter.getUR());
            this.mMetal = Metal.create((Net)this.mBondTo.getTemplate().getNetUnused(), (Layer)this.mBondFingerLayer, (AGeom)path);
        }
        this.globalPlace(bfDT);
        this.detailPlacer(this.mBFPF.locations());
        ALog.logInfo((String)"Bonding Done!");
    }

    public void matchPersonality(HierPin from, HierPin to) {
        Personality diePinP = from.getPin().getPersonality();
        if (diePinP != null) {
            Personality packagePinP = Personality.getOrCreate((DeviceTemplate)to.getPin().getDeviceTemplate(), (Personality.Type)Personality.Type.PORT, (String)diePinP.getName(), p -> p.setColor(diePinP.getColor()));
            to.getPin().moveToPersonality(packagePinP);
        }
        DevicePath path = from.getPath();
        DevicePath pathFrom = path.pathToParent(this.mBondAroundPath);
        pathFrom.removeFirst();
        Net dieNet = NetMap.getTopmostNet((Net)from.getNet(), (DevicePath)pathFrom);
        Personality dieNetP = dieNet.getPersonality();
        if (dieNetP != null) {
            Net parentNet = NetMap.getParentNet((Device)to.getPath().getLast(), (Net)to.getNet());
            Personality packageNetP = Personality.getOrCreate((DeviceTemplate)to.getPin().getDeviceTemplate(), (Personality.Type)Personality.Type.NET, (String)dieNetP.getName(), p -> {
                p.setColor(dieNetP.getColor());
                Personality.copyConstraint((Db)this.mDb, (Personality)dieNetP, (Personality)p, (Constraint.Descriptor)Constraint.NET_MATCHLENGTH);
            });
            parentNet.moveToPersonality(packageNetP);
        }
    }

    protected void createIslands(ArrayList<BondFingerInstruction> bfis) {
        if (this.mJustReWire) {
            return;
        }
        for (int quad = 0; quad < 4; ++quad) {
            ArrayList<PinTemplate> candidates = new ArrayList<PinTemplate>();
            for (BondFingerInstruction bfi : bfis) {
                if (bfi.quad != quad) continue;
                candidates.add(bfi.bondFingerPin);
            }
            BondFingerGrouper bfg = new BondFingerGrouper();
            bfg.makePhysicalIslands(candidates, this.mMaxGrouping, 3L * this.mFingerLength);
            ArrayList<BondFingerGrouper.Island> islands = bfg.getIslands();
            for (BondFingerGrouper.Island island : islands) {
                if (island.size() <= 1) continue;
                int islandGravityRing = -1;
                ArrayList<BondFingerInstruction> islandInstructions = new ArrayList<BondFingerInstruction>();
                block3: for (BondFingerInstruction bfi : bfis) {
                    for (PinTemplate dp : island) {
                        if (bfi.bondFingerPin != dp) continue;
                        islandInstructions.add(bfi);
                        if (!BondFingerUtil.getIAmGravity((PinTemplate)bfi.bondFingerPin)) continue block3;
                        islandGravityRing = bfi.ring;
                        continue block3;
                    }
                }
                for (int i = 0; i < islandInstructions.size(); ++i) {
                    BondFingerInstruction bfi;
                    bfi = (BondFingerInstruction)islandInstructions.get(i);
                    bfi.ring = islandGravityRing;
                }
                BondFingerOptimizer bfo = new BondFingerOptimizer(this);
                bfo.loadInsr(islandInstructions);
                bfo.setClr(this.mWireWidth * 2L);
                bfo.makePairs();
            }
        }
    }

    protected void smoothBondfingers(ArrayList<BondFingerInstruction> bfis) {
        for (int quad = 0; quad < 4; ++quad) {
            int maxRingsForQuad = 0;
            for (BondFingerInstruction bfi : bfis) {
                if (bfi.quad != quad) continue;
                maxRingsForQuad = Math.max(maxRingsForQuad, bfi.ring);
            }
            for (int r = 0; r <= maxRingsForQuad; ++r) {
                ArrayList<PinTemplate> bfPathsOnThisGuide = new ArrayList<PinTemplate>();
                ArrayList<Long> startingS = new ArrayList<Long>();
                GuideSpreader lss = new GuideSpreader();
                lss.minSep(this.mFingerSpace);
                AGeom derivedGuide = null;
                for (BondFingerInstruction bfi : bfis) {
                    AGeom g;
                    if (bfi.quad != quad || bfi.ring != r) continue;
                    PinTemplate bf = bfi.bondFingerPin;
                    if (this.bfIsPartOfAnIsland(bfi) && !BondFingerUtil.getIAmGravity((PinTemplate)bf)) continue;
                    APoint2D fromPortLoc = bf.getBounds().center();
                    long s = 0L;
                    s = quad % 2 == 0 ? fromPortLoc.getY() : fromPortLoc.getX();
                    long size = 0L;
                    size = quad % 2 == 0 ? bf.getBounds().height() : bf.getBounds().width();
                    lss.addObject(bf, s, size, null);
                    bfPathsOnThisGuide.add(bf);
                    startingS.add(s);
                    if (derivedGuide != null) continue;
                    derivedGuide = g = bfi.guide;
                }
                lss.geom(derivedGuide, quad);
                lss.relax();
                for (int i = 0; i < bfPathsOnThisGuide.size(); ++i) {
                    long ds;
                    PinTemplate bf = (PinTemplate)bfPathsOnThisGuide.get(i);
                    if (quad % 2 == 0) {
                        long y = lss.getLoc(bf).getY();
                        long startY = (Long)startingS.get(i);
                        ds = y - startY;
                        bf.moveBy(new APoint2D(0L, ds));
                        continue;
                    }
                    long x = lss.getLoc(bf).getX();
                    long startX = (Long)startingS.get(i);
                    ds = x - startX;
                    bf.moveBy(new APoint2D(ds, 0L));
                }
            }
        }
    }

    protected void setFinalRots(ArrayList<BondFingerInstruction> bfts) {
        for (BondFingerInstruction bfi : bfts) {
            DevicePath path = bfi.fromPort.getPath();
            DevicePath pathFrom = path.pathToParent(this.mBondAroundPath);
            PinTemplate bf = bfi.bondFingerPin;
            BondFingerUtil.setFollowWire((PinTemplate)bf, (boolean)this.mRotateFingers);
            if (this.mRingType != Constraint.RingType.FINGER || !this.mRotateFingers) continue;
            ALine l = new ALine();
            l.setP0(pathFrom.transformPt(bfi.fromPort.getPin().getLoc()));
            l.setP1(new APoint2D(bfi.x, bfi.y));
            float rot = (float)l.getAngle();
            rot = (450.0f - rot) % 360.0f;
            bf.setRotate(rot);
        }
    }

    protected void setInitialNets(ArrayList<BondFingerInstruction> bfts) {
        for (BondFingerInstruction bfi : bfts) {
            HierPin fromPort = bfi.fromPort;
            HierPin toPort = new HierPin(bfi.bfPath, bfi.bondFingerPin.getPinInstance(bfi.bfPath));
            this.copyNet(fromPort, toPort);
        }
    }

    protected void copyNet(BondFingerInstruction bfi) {
        HierPin fromPort = bfi.fromPort;
        HierPin toPort = new HierPin(bfi.bfPath, bfi.bondFingerPin.getPinInstance(bfi.bfPath));
        this.copyNet(fromPort, toPort);
    }

    protected void copyNet(HierPin fromPort, HierPin toPort) {
        this.moveNetFromDiePadToBondFinger(fromPort, toPort);
    }

    protected void moveNetFromDiePadToBondFinger(HierPin dppDie, HierPin dppBF) {
        DevicePath path = dppDie.getPath();
        DevicePath pathFrom = path.pathToParent(this.mBondAroundPath);
        Net net = NetMap.getTopmostNet((Net)dppDie.getNet(), (DevicePath)pathFrom);
        String netName = net.getName();
        if (net.isUnused()) {
            return;
        }
        NetMap.mapThroughPath((DevicePath)dppDie.getPath(), (PinTemplate)dppDie.getPinTemplate(), (String)netName);
        NetMap.mapThroughPath((DevicePath)dppBF.getPath(), (PinTemplate)dppBF.getPinTemplate(), (String)netName);
    }

    protected void detailPlacer(ArrayList<BondFingerInstruction> bfts) {
        this.setInitialNets(bfts);
        if (this.mRingType == Constraint.RingType.FINGER) {
            ALog.logInfo((String)"Creating Islands");
            ALog.logInfo((String)"Detailed Bonding");
            this.smoothBondfingers(bfts);
            for (int pass = 0; pass < 4; ++pass) {
                this.resolveIslandConflicts(bfts);
                this.smoothBondfingers(bfts);
            }
        }
        for (BondFingerInstruction bfi : bfts) {
            this.makeABondWire(bfi.fromPort, bfi.bfPath, bfi.bondFingerPin, bfi.ring);
        }
    }

    protected void makeABondWire(HierPin diePathPort, DevicePath bondFingerPath, PinTemplate bondFinger, int ring) {
        NetMap.mapThroughPath((DevicePath)diePathPort.getPath(), (Net)diePathPort.getNet());
        DevicePath path = new DevicePath(diePathPort.getPath());
        while (path.getFirst().getTemplate() != this.mBondTo.getTemplate()) {
            path.removeFirst();
        }
        path.removeFirst();
        Net net = NetMap.getTopmostNet((Net)diePathPort.getNet(), (DevicePath)path);
        assert (net.getDeviceTemplate() == this.mBondTo.getTemplate()) : "internal bonding error";
        bondFinger.setNet(net);
        APath wirePath = new APath(this.mWireWidth);
        Layer l = this.getLayer(this.mWireBondLayer, ring);
        Wire w = new Wire(net, l, wirePath);
        w.setType(Wire.Type.BOND);
        PinInstance bfPort = bondFinger.getPinInstance(bondFingerPath);
        HierPin bfPathPort = new HierPin(bondFingerPath, bfPort);
        APoint2D dieWorldPt = diePathPort.getWorldLoc();
        APoint2D diePt = Device.getALocRelativeToMeFromWorld((DevicePath)this.mBondToPath, (APoint2D)dieWorldPt);
        wirePath.addPoint(diePt);
        wirePath.addPoint(bondFinger.getLoc());
        PinTemplate wireEndAtDieT = PinTemplate.create((Net)net, (String)"wireEndA");
        wireEndAtDieT.setType(PinTemplate.Type.WIREEND);
        PinInstance wireEndAtDieP = PinInstance.create((Db)this.mDb, (String)"wireEndA", (Device)this.mBondToPath.getLast(), (PinTemplate)wireEndAtDieT);
        wireEndAtDieT.setLoc(diePt);
        w.setPinA(StoredPath.get((DeviceTemplate)wireEndAtDieT.getDeviceTemplate()), wireEndAtDieT);
        w.setPinB(StoredPath.get((DeviceTemplate)bondFingerPath.getDeviceTemplate()), bondFinger);
        wireEndAtDieP.setChildExternallyConnected(diePathPort.getPin());
        this.matchPersonality(diePathPort, bfPathPort);
        BondFingerUtil.setFollowWire((PinTemplate)bondFinger, (boolean)this.mRotateFingers);
        if (this.mRingType == Constraint.RingType.FINGER && this.mRotateFingers) {
            ALine line = new ALine();
            line.setP0(wirePath.getFirstPoint());
            line.setP1(wirePath.getLastPoint());
            float rot = (float)line.getAngle();
            rot = (450.0f - rot) % 360.0f;
            bondFinger.setRotate(rot);
        }
        this.mDb.add((DbObject)w);
        PinTemplate testDiePort = BondFingerUtil.getConnectedDiePad((DevicePath)bondFingerPath, (PinTemplate)bondFinger).getPinTemplate();
        assert (testDiePort == ((PinInstance)diePathPort.second).getPinTemplate()) : "internal bonding error";
        Wire testWire = BondFingerUtil.getWireBond((PinTemplate)bondFinger);
        assert (testWire == w) : "internal bonding error";
        PinTemplate testBondFinger = BondFingerUtil.getConnectedBF((DeviceTemplate)this.mBondTo.getTemplate(), (PinInstance)diePathPort.getPin());
        assert (testBondFinger == bondFinger) : "internal bond error";
    }

    protected Layer getLayer(Layer l, int ring) {
        String newLayerName;
        Substrate s = l.getSubstrate();
        Layer layer = Layer.get((Db)this.mDb, (Substrate)s, (String)(newLayerName = l.getName() + "_" + ring));
        if (layer == null) {
            layer = Layer.create((Substrate)s, (String)newLayerName);
        }
        return layer;
    }

    public static int determineMyQuad(HierPin dpp, DevicePath bondFromPath) {
        DevicePath diePath = bondFromPath.pathToLowestOfType(DeviceTemplate.Type.DIE);
        ARect rOfDie = diePath.getBB();
        APoint2D pOfDie = dpp.getWorldLoc();
        int dQuad = AGeomUtil.getQuadrant((APoint2D)pOfDie, (ARect)rOfDie);
        return dQuad;
    }

    protected AArc limitForAngle(AArc arc, ArrayList<PinInstance> ports, int quad) {
        PinInstance first = ports.get(0);
        PinInstance last = ports.get(ports.size() - 1);
        APoint2D firstPt = first.getWorldBounds(this.createBondAroundPath(first)).center();
        APoint2D lastPt = last.getWorldBounds(this.createBondAroundPath(last)).center();
        APoint2D p0 = arc.getP0();
        APoint2D p1 = arc.getP1();
        switch (quad) {
            case 0: {
                ALine vlr = new ALine(firstPt, p0);
                double alr = vlr.getAngle() - 270.0;
                while (alr < this.mMinAngle && this.mMinAngle <= 90.0) {
                    arc.setStartAngle(arc.getStartAngle() + 1.0);
                    p0 = arc.getP0();
                    p1 = arc.getP1();
                    vlr = new ALine(firstPt, p0);
                    alr = vlr.getAngle() - 270.0;
                }
                ALine vur = new ALine(lastPt, p1);
                double aur = 90.0 - vur.getAngle();
                while (aur < this.mMinAngle && this.mMinAngle <= 90.0) {
                    arc.setA1(arc.getEndAngle() - 1.0);
                    p0 = arc.getP0();
                    p1 = arc.getP1();
                    vur = new ALine(lastPt, p1);
                    aur = 90.0 - vur.getAngle();
                }
                break;
            }
            case 1: {
                ALine vur = new ALine(lastPt, p1);
                double aur = vur.getAngle();
                while (aur < this.mMinAngle && this.mMinAngle <= 90.0) {
                    arc.setA1(arc.getEndAngle() + 1.0);
                    p0 = arc.getP0();
                    p1 = arc.getP1();
                    vur = new ALine(lastPt, p1);
                    aur = vur.getAngle();
                }
                ALine vul = new ALine(firstPt, p0);
                double aul = 180.0 - vul.getAngle();
                while (aul < this.mMinAngle && this.mMinAngle <= 90.0) {
                    arc.setStartAngle(arc.getStartAngle() - 1.0);
                    p0 = arc.getP0();
                    p1 = arc.getP1();
                    vul = new ALine(firstPt, p0);
                    aul = 180.0 - vul.getAngle();
                }
                break;
            }
            case 2: {
                ALine vll = new ALine(firstPt, p0);
                double all = 270.0 - vll.getAngle();
                while (all < this.mMinAngle && this.mMinAngle <= 90.0) {
                    arc.setStartAngle(arc.getStartAngle() - 1.0);
                    p0 = arc.getP0();
                    p1 = arc.getP1();
                    vll = new ALine(firstPt, p0);
                    all = 270.0 - vll.getAngle();
                }
                ALine vul = new ALine(lastPt, p1);
                double aul = vul.getAngle() - 90.0;
                while (aul < this.mMinAngle && this.mMinAngle <= 90.0) {
                    arc.setA1(arc.getEndAngle() + 1.0);
                    p0 = arc.getP0();
                    p1 = arc.getP1();
                    vul = new ALine(lastPt, p1);
                    aul = vul.getAngle() - 90.0;
                }
                break;
            }
            case 3: {
                ALine vlr = new ALine(lastPt, p1);
                double alr = 360.0 - vlr.getAngle();
                while (alr < this.mMinAngle && this.mMinAngle <= 90.0) {
                    arc.setA1(arc.getEndAngle() - 1.0);
                    p0 = arc.getP0();
                    p1 = arc.getP1();
                    vlr = new ALine(lastPt, p1);
                    alr = 360.0 - vlr.getAngle();
                }
                ALine vll = new ALine(firstPt, p0);
                double all = vll.getAngle() - 180.0;
                while (all < this.mMinAngle && this.mMinAngle <= 90.0) {
                    arc.setStartAngle(arc.getStartAngle() + 1.0);
                    p0 = arc.getP0();
                    p1 = arc.getP1();
                    vll = new ALine(firstPt, p0);
                    all = vll.getAngle() - 180.0;
                }
                break;
            }
        }
        return arc;
    }

    protected ALine limitForAngle(ALine line, ArrayList<HierPin> ports, int quad) {
        HierPin first = ports.get(0);
        HierPin last = ports.get(ports.size() - 1);
        APoint2D firstPt = first.getWorldLoc();
        APoint2D lastPt = last.getWorldLoc();
        switch (quad) {
            case 0: {
                ALine vur;
                double aur;
                ALine vlr = new ALine(firstPt, line.getP0());
                double alr = vlr.getAngle() - 270.0;
                if (alr < this.mMinAngle && this.mMinAngle < 90.0) {
                    long dx = line.getP0().getX() - firstPt.getX();
                    double r = (double)dx / Math.sin(Math.toRadians(this.mMinAngle));
                    long inset = (long)(r * Math.cos(Math.toRadians(this.mMinAngle)));
                    long y = firstPt.getY() - inset;
                    long x = line.getP0().getX();
                    line.setP0(x, y);
                }
                if (!((aur = 90.0 - (vur = new ALine(last.getWorldLoc(), line.getP1())).getAngle()) < this.mMinAngle) || !(this.mMinAngle < 90.0)) break;
                long dx = line.getP0().getX() - lastPt.getX();
                double r = (double)dx / Math.sin(Math.toRadians(this.mMinAngle));
                long inset = (long)(r * Math.cos(Math.toRadians(this.mMinAngle)));
                long y = lastPt.getY() + inset;
                long x = line.getP0().getX();
                line.setP1(x, y);
                break;
            }
            case 1: {
                ALine vur;
                double aur;
                ALine vul = new ALine(firstPt, line.getP0());
                double aul = 180.0 - vul.getAngle();
                if (aul < this.mMinAngle && this.mMinAngle < 90.0) {
                    long dy = line.getP0().getY() - firstPt.getY();
                    double r = (double)dy / Math.sin(Math.toRadians(this.mMinAngle));
                    long inset = (long)(r * Math.cos(Math.toRadians(this.mMinAngle)));
                    long x = firstPt.getX() - inset;
                    long y = line.getP0().getY();
                    line.setP0(x, y);
                }
                if (!((aur = (vur = new ALine(last.getWorldLoc(), line.getP1())).getAngle()) < this.mMinAngle) || !(this.mMinAngle < 90.0)) break;
                long dy = line.getP0().getY() - lastPt.getY();
                double r = (double)dy / Math.sin(Math.toRadians(this.mMinAngle));
                long inset = (long)(r * Math.cos(Math.toRadians(this.mMinAngle)));
                long x = lastPt.getX() + inset;
                long y = line.getP0().getY();
                line.setP1(x, y);
                break;
            }
            case 2: {
                ALine vul;
                double aul;
                ALine vll = new ALine(firstPt, line.getP0());
                double all = 270.0 - vll.getAngle();
                if (all < this.mMinAngle && this.mMinAngle < 90.0) {
                    long dx = firstPt.getX() - line.getP0().getX();
                    double r = (double)dx / Math.sin(Math.toRadians(this.mMinAngle));
                    long inset = (long)(r * Math.cos(Math.toRadians(this.mMinAngle)));
                    long y = firstPt.getY() - inset;
                    long x = line.getP0().getX();
                    line.setP0(x, y);
                }
                if (!((aul = 90.0 - (vul = new ALine(last.getWorldLoc(), line.getP1())).getAngle()) < this.mMinAngle) || !(this.mMinAngle < 90.0)) break;
                long dx = firstPt.getX() - line.getP1().getX();
                double r = (double)dx / Math.sin(Math.toRadians(this.mMinAngle));
                long inset = (long)(r * Math.cos(Math.toRadians(this.mMinAngle)));
                long y = lastPt.getY() + inset;
                long x = line.getP0().getX();
                line.setP1(x, y);
                break;
            }
            case 3: {
                ALine vlr;
                double alr;
                ALine vll = new ALine(firstPt, line.getP0());
                double all = vll.getAngle() - 180.0;
                if (all < this.mMinAngle && this.mMinAngle < 90.0) {
                    long dy = firstPt.getY() - line.getP0().getY();
                    double r = (double)dy / Math.sin(Math.toRadians(this.mMinAngle));
                    long inset = (long)(r * Math.cos(Math.toRadians(this.mMinAngle)));
                    long x = firstPt.getX() - inset;
                    long y = line.getP0().getY();
                    line.setP0(x, y);
                }
                if (!((alr = 360.0 - (vlr = new ALine(last.getWorldLoc(), line.getP1())).getAngle()) < this.mMinAngle) || !(this.mMinAngle < 90.0)) break;
                long dy = lastPt.getY() - line.getP0().getY();
                double r = (double)dy / Math.sin(Math.toRadians(this.mMinAngle));
                long inset = (long)(r * Math.cos(Math.toRadians(this.mMinAngle)));
                long x = lastPt.getX() + inset;
                long y = line.getP0().getY();
                line.setP1(x, y);
            }
        }
        return line;
    }

    protected ArrayList<PinInstance> prunedList(ArrayList<PinInstance> fromPorts) {
        ArrayList<PinInstance> pruned = new ArrayList<PinInstance>();
        int size = fromPorts.size();
        int i = 0;
        while (i < size) {
            boolean collapse = false;
            PinInstance port = fromPorts.get(i);
            if (i < size - 1) {
                Net nextPortNet;
                PinInstance nextPort = fromPorts.get(i + 1);
                Net portNet = NetMap.getTopmostNet((Net)port.getNet(), (DevicePath)WireBonder.createPortPath(this.mBondAroundPath, port));
                if (portNet == (nextPortNet = NetMap.getTopmostNet((Net)nextPort.getNet(), (DevicePath)WireBonder.createPortPath(this.mBondAroundPath, nextPort)))) {
                    collapse = true;
                }
            }
            pruned.add(port);
            if (collapse) {
                i += 2;
                continue;
            }
            ++i;
        }
        return pruned;
    }

    protected void resolveIslandConflicts(ArrayList<BondFingerInstruction> bfis) {
        long clr = this.mWireWidth * 2L;
        for (int quad = 0; quad < 4; ++quad) {
            int maxRingsForQuad = 0;
            for (BondFingerInstruction bfi : bfis) {
                if (bfi.quad != quad) continue;
                maxRingsForQuad = Math.max(maxRingsForQuad, bfi.ring);
            }
            for (int r = 0; r <= maxRingsForQuad; ++r) {
                ArrayList<BondFingerInstruction> ring = new ArrayList<BondFingerInstruction>();
                for (BondFingerInstruction bfi : bfis) {
                    if (bfi.quad != quad || bfi.ring != r) continue;
                    ring.add(bfi);
                }
                for (int i = 0; i < ring.size(); ++i) {
                    for (int j = i + 1; j < ring.size(); ++j) {
                        BondFingerInstruction bfI = (BondFingerInstruction)ring.get(i);
                        BondFingerInstruction bfJ = (BondFingerInstruction)ring.get(j);
                        if (this.bfIsIsland(bfI) || this.bfIsIsland(bfJ) || !BondFingerInstruction.cross(clr, quad, bfI, bfJ, false)) continue;
                        if (this.bfIsPartOfAnIsland(bfI) && !this.bfIsPartOfAnIsland(bfJ)) {
                            this.bustIsland(bfis, bfI);
                            BondFingerInstruction.swap(this, bfI, bfJ);
                        }
                        if (!this.bfIsPartOfAnIsland(bfI) && this.bfIsPartOfAnIsland(bfJ)) {
                            this.bustIsland(bfis, bfJ);
                            BondFingerInstruction.swap(this, bfI, bfJ);
                            continue;
                        }
                        if (this.bfIsPartOfAnIsland(bfI) && this.bfIsPartOfAnIsland(bfJ)) {
                            int jSize;
                            int iSize = this.islandSize(bfI);
                            if (iSize < (jSize = this.islandSize(bfJ))) {
                                this.bustIsland(bfis, bfI);
                                continue;
                            }
                            this.bustIsland(bfis, bfJ);
                            continue;
                        }
                        BondFingerInstruction.swap(this, bfI, bfJ);
                    }
                }
            }
        }
    }

    protected int islandSize(BondFingerInstruction bfi) {
        DeviceTemplate dt = bfi.bfPath.getDeviceTemplate();
        if (dt.getType() == DeviceTemplate.Type.GROUP) {
            return dt.childCount();
        }
        return 1;
    }

    protected void bustIsland(ArrayList<BondFingerInstruction> bfis, BondFingerInstruction bfi) {
        DevicePath group = bfi.bfPath.getParent();
        Device.unGroup((DevicePath)group);
        for (BondFingerInstruction bf : bfis) {
            DevicePath p;
            DevicePath path = bf.bfPath.getParent();
            if (!path.sameAs(group)) continue;
            bf.bfPath = p = new DevicePath(bf.bfPath);
        }
    }

    protected boolean bfIsPartOfAnIsland(BondFingerInstruction bfi) {
        if (bfi.bfPath.getLast().getType() == DeviceTemplate.Type.GROUP) {
            return false;
        }
        PinTemplate bf = bfi.bondFingerPin;
        if (BondFingerUtil.getIAmGravity((PinTemplate)bf)) {
            return true;
        }
        return BondFingerUtil.getGravity((PinTemplate)bf) != null;
    }

    protected boolean bfIsIsland(BondFingerInstruction bfi) {
        return bfi.bfPath.getLast().getType() == DeviceTemplate.Type.GROUP;
    }

    public static DevicePath createPortPath(DevicePath path, PinInstance port) {
        Device d = port.getDevice();
        for (DevicePath child : path.getDescendants()) {
            if (child.getLast() != d) continue;
            return child;
        }
        return null;
    }

    public static void promoteBF(String devicePathString, String padTemplateName) {
        Db db = OrbitIO.getCurDb();
        DevicePath dp = DevicePath.fromString((Db)db, (String)devicePathString);
        if (dp == null) {
            return;
        }
        LinkedList<Device> toBeDeleted = new LinkedList<Device>();
        for (DevicePath child : dp.getDescendants()) {
            if (child.getDeviceTemplate().getType() != DeviceTemplate.Type.BONDFINGER) continue;
            toBeDeleted.add(child.getLast());
            PinTemplate pinTemplate = child.getLast().getAnyPin().getPinTemplate();
            PortTemplate portTemplate = pinTemplate.getFirstPortTemplate();
            PadTemplate pt = portTemplate.getPadTemplate();
            Net net = NetMap.getParentNet((Device)child.getLast(), (Net)pinTemplate.getNet());
            PinTemplate newPinTemplate = PinTemplate.create((Net)net, (String)child.getLast().getName());
            PinInstance.create((Db)db, (String)child.getLast().getName(), (Device)child.getLast(), (PinTemplate)newPinTemplate);
            newPinTemplate.setPadTemplate(pt);
            newPinTemplate.setLoc(child.getLast().getLoc());
            newPinTemplate.setRotate(child.getLast().getRotate());
            newPinTemplate.setType(PinTemplate.Type.BONDFINGERPAD);
        }
        for (Device d : toBeDeleted) {
            d.deleteFromDb();
        }
        OrbitIO.getApp().refreshCurrentView(false);
    }

    protected class FindPlaceFactory
    extends BondFingerPlaceFactory {
        protected FindPlaceFactory() {
        }

        @Override
        public void start() {
            this.deriveQuads();
            for (int quad = 0; quad < 4; ++quad) {
                ArrayList fromPorts = (ArrayList)this.portsByQ.get(quad);
                if (fromPorts.isEmpty()) continue;
                Collections.sort(fromPorts, quad % 2 == 0 ? new DeviceSortV(WireBonder.this.mBondAroundPath) : new DeviceSortH(WireBonder.this.mBondAroundPath));
                int size = fromPorts.size();
                for (int i = 0; i < size; ++i) {
                    HierPin fromPort = (HierPin)fromPorts.get(i);
                    PinTemplate bf = BondFingerUtil.getConnectedBF((DeviceTemplate)WireBonder.this.mBondTo.getTemplate(), (PinInstance)fromPort.getPin());
                    Wire w = BondFingerUtil.getWireBond((PinTemplate)bf);
                    if (w == null) continue;
                    float fingerAngle = 0.0f;
                    switch (quad) {
                        case 0: {
                            fingerAngle = 90.0f;
                            break;
                        }
                        case 1: {
                            fingerAngle = 0.0f;
                            break;
                        }
                        case 2: {
                            fingerAngle = 270.0f;
                            break;
                        }
                        case 3: {
                            fingerAngle = 180.0f;
                            break;
                        }
                        default: {
                            throw new UnsupportedOperationException();
                        }
                    }
                    int thisRow = 0;
                    BondFingerInstruction bft = new BondFingerInstruction();
                    bft.x = w.getPath().getLastPoint().getX();
                    bft.y = w.getPath().getLastPoint().getY();
                    bft.quad = quad;
                    bft.ring = thisRow;
                    bft.angle = fingerAngle;
                    bft.fromPort = fromPort;
                    this.mRetLocations.add(bft);
                    bft.uniqueName = "q" + quad + "r" + thisRow + "i" + i;
                    w.deleteFromDb();
                }
            }
        }
    }

    protected class SPlaceFactoryLine
    extends BondFingerPlaceFactory {
        protected SPlaceFactoryLine() {
        }

        QuadCharacter deriveQuadCharacter(ALine base, ArrayList<HierPin> ports, int quad) {
            QuadCharacter qc = new QuadCharacter();
            qc.diePorts = ports;
            int numPorts = ports.size();
            qc.lengthRequired = WireBonder.this.mFingerSpace + (long)numPorts * WireBonder.this.mFingerWidth + (long)(numPorts - 1) * WireBonder.this.mFingerSpace;
            if (qc.lengthRequired > base.getLength()) {
                qc.lengthRequired = WireBonder.this.mFingerSpace + (long)numPorts * WireBonder.this.mFingerWidth + (long)(numPorts - 1) * WireBonder.this.mFingerSpace;
            }
            qc.numRows = (int)(qc.lengthRequired / base.getLength());
            if ((long)qc.numRows * base.getLength() < qc.lengthRequired) {
                ++qc.numRows;
            }
            qc.derivedSpacing = base.getLength();
            qc.derivedSpacing -= (long)(numPorts / qc.numRows) * WireBonder.this.mFingerWidth;
            qc.derivedSpacing -= WireBonder.this.mFingerSpace;
            qc.derivedSpacing /= (long)(numPorts / qc.numRows);
            return qc;
        }

        @Override
        public void start() {
            this.deriveQuads();
            for (int quad = 0; quad < 4; ++quad) {
                int i;
                ArrayList fromPorts = (ArrayList)this.portsByQ.get(quad);
                if (fromPorts.isEmpty()) continue;
                Collections.sort(fromPorts, quad % 2 == 0 ? new DeviceSortV(WireBonder.this.mBondAroundPath) : new DeviceSortH(WireBonder.this.mBondAroundPath));
                int size = fromPorts.size();
                ALine base = null;
                switch (quad) {
                    case 0: {
                        base = new ALine(this.mRectGuide.getLR(), this.mRectGuide.getUR());
                        base = WireBonder.this.limitForAngle(base, fromPorts, quad);
                        break;
                    }
                    case 1: {
                        base = new ALine(this.mRectGuide.getUL(), this.mRectGuide.getUR());
                        base = WireBonder.this.limitForAngle(base, fromPorts, quad);
                        break;
                    }
                    case 2: {
                        base = new ALine(this.mRectGuide.getLL(), this.mRectGuide.getUL());
                        base = WireBonder.this.limitForAngle(base, fromPorts, quad);
                        break;
                    }
                    case 3: {
                        base = new ALine(this.mRectGuide.getLL(), this.mRectGuide.getLR());
                        base = WireBonder.this.limitForAngle(base, fromPorts, quad);
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException();
                    }
                }
                int numPorts = fromPorts.size();
                QuadCharacter qc = this.deriveQuadCharacter(base, fromPorts, quad);
                ArrayList<GuideSpreader> lineSpreaders = new ArrayList<GuideSpreader>();
                for (int r = 0; r < qc.numRows; ++r) {
                    GuideSpreader lss = new GuideSpreader();
                    lss.minSep(WireBonder.this.mFingerSpace);
                    lineSpreaders.add(lss);
                }
                int thisRow = 0;
                for (i = 0; i < numPorts; ++i) {
                    HierPin fromPort = (HierPin)fromPorts.get(i);
                    APoint2D fromPortLoc = fromPort.getWorldLoc();
                    long s = 0L;
                    s = quad % 2 == 0 ? fromPortLoc.getY() : fromPortLoc.getX();
                    ((GuideSpreader)lineSpreaders.get(thisRow)).addObject(fromPort, s, WireBonder.this.mFingerWidth, null);
                    if (++thisRow < qc.numRows) continue;
                    thisRow = 0;
                }
                for (int r = 0; r < qc.numRows; ++r) {
                    ((GuideSpreader)lineSpreaders.get(r)).geom((AGeom)base, quad);
                    ((GuideSpreader)lineSpreaders.get(r)).relax();
                }
                thisRow = 0;
                for (i = 0; i < size; ++i) {
                    long y;
                    long x;
                    GuideSpreader lss = (GuideSpreader)lineSpreaders.get(thisRow);
                    HierPin fromPort = (HierPin)fromPorts.get(i);
                    Objects.requireNonNull(base);
                    float fingerAngle = 0.0f;
                    switch (quad) {
                        case 0: {
                            fingerAngle = 90.0f;
                            x = base.getP0().getX() + (long)thisRow * (WireBonder.this.mFingerLength + WireBonder.this.mTierSpace);
                            y = lss.getLoc(fromPort).getY();
                            break;
                        }
                        case 1: {
                            fingerAngle = 0.0f;
                            y = base.getP0().getY() + (long)thisRow * (WireBonder.this.mFingerLength + WireBonder.this.mTierSpace);
                            x = lss.getLoc(fromPort).getX();
                            break;
                        }
                        case 2: {
                            fingerAngle = 270.0f;
                            x = base.getP0().getX() - (long)thisRow * (WireBonder.this.mFingerLength + WireBonder.this.mTierSpace);
                            y = lss.getLoc(fromPort).getY();
                            break;
                        }
                        case 3: {
                            fingerAngle = 180.0f;
                            y = base.getP0().getY() - (long)thisRow * (WireBonder.this.mFingerLength + WireBonder.this.mTierSpace);
                            x = lss.getLoc(fromPort).getX();
                            break;
                        }
                        default: {
                            throw new UnsupportedOperationException();
                        }
                    }
                    BondFingerInstruction bft = new BondFingerInstruction();
                    bft.x = x;
                    bft.y = y;
                    bft.quad = quad;
                    bft.ring = thisRow;
                    bft.angle = fingerAngle;
                    bft.fromPort = fromPort;
                    bft.guide = base;
                    this.mRetLocations.add(bft);
                    this.mBFMgr.add(bft, quad, thisRow);
                    bft.uniqueName = WireBonder.this.mBondRingPersonality.getName() + "_q" + quad + "i" + i;
                    if (++thisRow < qc.numRows) continue;
                    thisRow = 0;
                }
            }
        }

        class QuadCharacter {
            ArrayList<HierPin> diePorts = new ArrayList();
            long lengthRequired;
            long requiredSpacing;
            long derivedSpacing;
            int numRows;

            QuadCharacter() {
            }
        }
    }

    protected class SPlaceFactoryArc
    extends BondFingerPlaceFactory {
        protected SPlaceFactoryArc() {
        }

        QuadCharacter deriveQuadCharacter(ALine base, ArrayList<HierPin> ports, int quad) {
            QuadCharacter qc = new QuadCharacter();
            qc.diePorts = ports;
            int numPorts = ports.size();
            qc.lengthRequired = WireBonder.this.mFingerSpace + (long)numPorts * WireBonder.this.mFingerWidth + (long)(numPorts - 1) * WireBonder.this.mFingerSpace;
            if (qc.lengthRequired > base.getLength()) {
                qc.lengthRequired = WireBonder.this.mFingerSpace + (long)numPorts * WireBonder.this.mFingerWidth + (long)(numPorts - 1) * WireBonder.this.mFingerSpace;
            }
            qc.numRows = (int)(qc.lengthRequired / base.getLength());
            if ((long)qc.numRows * base.getLength() < qc.lengthRequired) {
                ++qc.numRows;
            }
            qc.derivedSpacing = base.getLength();
            qc.derivedSpacing -= (long)(numPorts / qc.numRows) * WireBonder.this.mFingerWidth;
            qc.derivedSpacing -= WireBonder.this.mFingerSpace;
            qc.derivedSpacing /= (long)(numPorts / qc.numRows);
            return qc;
        }

        @Override
        public void start() {
            this.deriveQuads();
            for (int quad = 0; quad < 4; ++quad) {
                ArrayList fromPorts = (ArrayList)this.portsByQ.get(quad);
                if (fromPorts.isEmpty()) continue;
                Collections.sort(fromPorts, quad % 2 == 0 ? new DeviceSortV(WireBonder.this.mBondAroundPath) : new DeviceSortH(WireBonder.this.mBondAroundPath));
                int size = fromPorts.size();
                ALine base = null;
                switch (quad) {
                    case 0: {
                        base = new ALine(this.mRectGuide.getLR(), this.mRectGuide.getUR());
                        break;
                    }
                    case 1: {
                        base = new ALine(this.mRectGuide.getUL(), this.mRectGuide.getUR());
                        break;
                    }
                    case 2: {
                        base = new ALine(this.mRectGuide.getLL(), this.mRectGuide.getUL());
                        break;
                    }
                    case 3: {
                        base = new ALine(this.mRectGuide.getLL(), this.mRectGuide.getLR());
                    }
                }
                int numPorts = fromPorts.size();
                base = WireBonder.this.limitForAngle(base, fromPorts, quad);
                QuadCharacter qc = this.deriveQuadCharacter(base, fromPorts, quad);
                int thisRow = 0;
                HierPin first = (HierPin)fromPorts.get(0);
                HierPin last = (HierPin)fromPorts.get(fromPorts.size() - 1);
                APoint2D firstPt = first.getWorldLoc();
                APoint2D lastPt = last.getWorldLoc();
                ALine l0 = new ALine(firstPt, base.getP0());
                ALine l1 = new ALine(lastPt, base.getP1());
                double a0 = l0.getAngle();
                double a1 = l1.getAngle();
                double a = 0.0;
                switch (quad) {
                    case 0: {
                        a = a1 + 360.0 - a0;
                        break;
                    }
                    case 1: {
                        a = -(a0 - a1);
                        break;
                    }
                    case 2: {
                        a = -(a0 - a1);
                        break;
                    }
                    case 3: {
                        a = a1 - a0;
                    }
                }
                a /= (double)fromPorts.size();
                long ds = base.getLength() / (long)numPorts;
                for (int i = 0; i < size; ++i) {
                    HierPin fromPathPort = (HierPin)fromPorts.get(i);
                    APoint2D fromPortLoc = fromPathPort.getWorldLoc();
                    long distToEdge = 0L;
                    long r = distToEdge + this.mMinDist + (long)thisRow * (WireBonder.this.mFingerLength + WireBonder.this.mTierSpace);
                    double thisA = Math.toRadians(a0 + (double)i * a);
                    long x = 0L;
                    long y = 0L;
                    switch (quad) {
                        case 0: {
                            distToEdge = WireBonder.this.mBondAroundPath.getBB().right() - fromPortLoc.getX();
                            x = WireBonder.this.mBondAroundPath.getBB().right() + (long)((double)r * Math.cos(thisA));
                            y = base.getP0().getY() + (long)i * ds;
                            break;
                        }
                        case 1: {
                            distToEdge = WireBonder.this.mBondAroundPath.getBB().top() - fromPortLoc.getY();
                            x = base.getP0().getX() + (long)i * ds;
                            y = WireBonder.this.mBondAroundPath.getBB().top() + (long)((double)r * Math.sin(thisA));
                            break;
                        }
                        case 2: {
                            distToEdge = fromPortLoc.getX() - WireBonder.this.mBondAroundPath.getBB().left();
                            x = WireBonder.this.mBondAroundPath.getBB().left() + (long)((double)r * Math.cos(thisA));
                            y = base.getP0().getY() + (long)i * ds;
                            break;
                        }
                        case 3: {
                            distToEdge = fromPortLoc.getY() - WireBonder.this.mBondAroundPath.getBB().bottom();
                            x = base.getP0().getX() + (long)i * ds;
                            y = WireBonder.this.mBondAroundPath.getBB().bottom() + (long)((double)r * Math.sin(thisA));
                        }
                    }
                    Net fromNet = fromPathPort.getNet();
                    if (fromNet == null) {
                        fromNet = fromPathPort.getPath().getLast().getTemplate().getNetUnused();
                    }
                    float fingerAngle = 0.0f;
                    switch (quad) {
                        case 0: {
                            fingerAngle = 90.0f;
                            break;
                        }
                        case 1: {
                            fingerAngle = 0.0f;
                            break;
                        }
                        case 2: {
                            fingerAngle = 270.0f;
                            break;
                        }
                        case 3: {
                            fingerAngle = 180.0f;
                        }
                    }
                    BondFingerInstruction bft = new BondFingerInstruction();
                    bft.x = x;
                    bft.y = y;
                    bft.quad = quad;
                    bft.ring = thisRow;
                    bft.angle = fingerAngle;
                    bft.fromPort = fromPathPort;
                    bft.guide = base;
                    this.mRetLocations.add(bft);
                    this.mBFMgr.add(bft, quad, thisRow);
                    bft.uniqueName = WireBonder.this.mBondRingPersonality.getName() + "_q" + quad + "i" + i;
                    if (++thisRow < qc.numRows) continue;
                    thisRow = 0;
                }
            }
        }

        class QuadCharacter {
            ArrayList<HierPin> diePorts = new ArrayList();
            long lengthRequired;
            long requiredSpacing;
            long derivedSpacing;
            int numRows;

            QuadCharacter() {
            }
        }
    }

    protected class MetalPlaceFactory
    extends BondFingerPlaceFactory {
        protected MetalPlaceFactory() {
        }

        @Override
        public void start() {
            this.deriveQuads();
            for (int quad = 0; quad < 4; ++quad) {
                ArrayList fromPorts = (ArrayList)this.portsByQ.get(quad);
                if (fromPorts.isEmpty()) continue;
                int numPorts = fromPorts.size();
                Collections.sort(fromPorts, quad % 2 == 0 ? new DeviceSortV(WireBonder.this.mBondAroundPath) : new DeviceSortH(WireBonder.this.mBondAroundPath));
                ALine base = null;
                switch (quad) {
                    case 0: {
                        base = new ALine(this.mRectGuide.getLR(), this.mRectGuide.getUR());
                        break;
                    }
                    case 1: {
                        base = new ALine(this.mRectGuide.getUL(), this.mRectGuide.getUR());
                        break;
                    }
                    case 2: {
                        base = new ALine(this.mRectGuide.getLL(), this.mRectGuide.getUL());
                        break;
                    }
                    case 3: {
                        base = new ALine(this.mRectGuide.getLL(), this.mRectGuide.getLR());
                    }
                }
                base = WireBonder.this.limitForAngle(base, fromPorts, quad);
                HierPin first = (HierPin)fromPorts.get(0);
                HierPin last = (HierPin)fromPorts.get(fromPorts.size() - 1);
                APoint2D firstPt = first.getWorldLoc();
                APoint2D lastPt = last.getWorldLoc();
                for (int i = 0; i < numPorts; ++i) {
                    double l;
                    double percent;
                    HierPin fromPort = (HierPin)fromPorts.get(i);
                    Net fromNet = fromPort.getNet();
                    if (fromNet == null) {
                        fromNet = fromPort.getPath().getDeviceTemplate().getNetUnused();
                    }
                    APoint2D thisPt = fromPort.getWorldLoc();
                    long x = base.getP0().getX();
                    long y = base.getP0().getY();
                    if (quad % 2 == 0) {
                        percent = (double)(thisPt.getY() - firstPt.getY()) / (double)(lastPt.getY() - firstPt.getY());
                        l = (double)base.getLength() * percent;
                        y = base.getP0().getY() + (long)l;
                    } else {
                        percent = (double)(thisPt.getX() - firstPt.getX()) / (double)(lastPt.getX() - firstPt.getX());
                        l = (double)base.getLength() * percent;
                        x = base.getP0().getX() + (long)l;
                    }
                    float fingerAngle = 0.0f;
                    switch (quad) {
                        case 0: {
                            fingerAngle = 90.0f;
                            break;
                        }
                        case 1: {
                            fingerAngle = 0.0f;
                            break;
                        }
                        case 2: {
                            fingerAngle = 270.0f;
                            break;
                        }
                        case 3: {
                            fingerAngle = 180.0f;
                        }
                    }
                    BondFingerInstruction bft = new BondFingerInstruction();
                    bft.x = x;
                    bft.y = y;
                    bft.angle = fingerAngle;
                    bft.fromPort = fromPort;
                    bft.quad = quad;
                    bft.ring = 0;
                    bft.angle = fingerAngle;
                    this.mBFMgr.add(bft, quad, 0);
                    bft.uniqueName = WireBonder.this.mBondRingPersonality.getName() + "_q" + quad + "i" + i;
                    this.mRetLocations.add(bft);
                }
            }
        }
    }

    protected abstract class BondFingerPlaceFactory {
        protected long mMinDist = 0L;
        protected DevicePath mFromPath;
        protected DevicePath mToPath;
        protected ARect mRectGuide;
        protected ArrayList<HierPin> fromPorts = new ArrayList();
        protected ArrayList<ArrayList<HierPin>> portsByQ = new ArrayList();
        protected ArrayList<BondFingerInstruction> mRetLocations = new ArrayList();
        protected BondFingerInstructionManager mBFMgr = new BondFingerInstructionManager();

        protected BondFingerPlaceFactory() {
        }

        public abstract void start();

        public ArrayList<BondFingerInstruction> locations() {
            return this.mRetLocations;
        }

        public void setPorts(ArrayList<HierPin> ports) {
            this.fromPorts = ports;
        }

        public void setMinDist(long dist) {
            this.mMinDist = dist;
        }

        public void setPaths(DevicePath fromPath, DevicePath toPath) {
            this.mFromPath = fromPath;
            this.mToPath = toPath;
        }

        protected void deriveQuads() {
            this.mRectGuide = WireBonder.this.mBondAroundPath.getBB();
            this.mRectGuide.grow(WireBonder.this.mClearanceAround);
            for (int i = 0; i < 4; ++i) {
                this.portsByQ.add(new ArrayList());
            }
            Constraint.BondSide bondSide = (Constraint.BondSide)Constraint.getValue((Db)OrbitIO.getCurDb(), (DbObject)WireBonder.this.mBondRingPersonality, (Constraint.Descriptor)Constraint.BOND_SIDE);
            for (HierPin p : WireBonder.this.mPorts) {
                if (bondSide == null || bondSide == Constraint.BondSide.DEFAULT) {
                    int q = WireBonder.determineMyQuad(p, WireBonder.this.mBondAroundPath);
                    this.portsByQ.get(q).add(p);
                    continue;
                }
                if (bondSide == Constraint.BondSide.EAST) {
                    this.portsByQ.get(0).add(p);
                    continue;
                }
                if (bondSide == Constraint.BondSide.NORTH) {
                    this.portsByQ.get(1).add(p);
                    continue;
                }
                if (bondSide == Constraint.BondSide.WEST) {
                    this.portsByQ.get(2).add(p);
                    continue;
                }
                if (bondSide != Constraint.BondSide.SOUTH) continue;
                this.portsByQ.get(3).add(p);
            }
        }
    }

    public static class DeviceSortH
    implements Comparator<HierPin> {
        DevicePath mDevicePath;

        public DeviceSortH(DevicePath path) {
            this.mDevicePath = path;
        }

        @Override
        public int compare(HierPin o1, HierPin o2) {
            return Long.compare(o1.getWorldLoc().getX(), o2.getWorldLoc().getX());
        }
    }

    public static class DeviceSortV
    implements Comparator<HierPin> {
        DevicePath mDevicePath;

        public DeviceSortV(DevicePath path) {
            this.mDevicePath = path;
        }

        @Override
        public int compare(HierPin o1, HierPin o2) {
            return Long.compare(o1.getWorldLoc().getY(), o2.getWorldLoc().getY());
        }
    }
}

