/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.bump;

import com.sigrity.acl.AUtil;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Term;
import com.sigrity.acl.jfxui.JFXUtil;
import com.sigrity.orbit.DeviceFilters;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.bump.BumpSelectedInfo;
import com.sigrity.orbit.jfxui.EditorTableView;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javafx.scene.Node;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ChoiceDialog;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.Dialog;
import javafx.scene.control.DialogPane;
import javafx.scene.control.Label;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableCell;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.util.StringConverter;

public class BumpContentsChooserDlg
extends ChoiceDialog<Map<DeviceTemplate, BumpSelectedInfo>> {
    private static final String TITLE = "Bump Contents";
    private static final String HEADER_TEXT = "Bump has multiple terms";
    private final Map<DeviceTemplate, BumpSelectedInfo> bumpDevT2SelectedInfo = new HashMap<DeviceTemplate, BumpSelectedInfo>();

    public static Optional<Map<DeviceTemplate, BumpSelectedInfo>> showAndWait(Window owner, DevicePath devPath) {
        ArrayList bumpDevTs = AUtil.arrayList((Iterator)devPath.getDeviceTemplate().getChildren(DeviceFilters.FILTER_BUMP).filter(devT -> devT.getTerms().ifExactlyOne().isEmpty()).mapAndNonNull(Device::getTemplate).distinct());
        return BumpContentsChooserDlg.showAndWait(owner, bumpDevTs);
    }

    public static Optional<Map<DeviceTemplate, BumpSelectedInfo>> showAndWait(Window owner, List<DeviceTemplate> bumpDevTs) {
        if (bumpDevTs == null) {
            return Optional.empty();
        }
        if (bumpDevTs.isEmpty()) {
            return Optional.of(Collections.emptyMap());
        }
        BumpContentsChooserDlg dlg = new BumpContentsChooserDlg(bumpDevTs);
        JFXUtil.tryToAddTitleIcon((Dialog)dlg);
        JFXUtil.placeDialogPos((Dialog)dlg, (Window)owner);
        return dlg.showAndWait();
    }

    private BumpContentsChooserDlg(List<DeviceTemplate> bumpDevTs) {
        bumpDevTs.forEach(bump -> this.bumpDevT2SelectedInfo.put((DeviceTemplate)bump, new BumpSelectedInfo((DeviceTemplate)bump)));
        this.initUI();
    }

    private void initUI() {
        this.setTitle(TITLE);
        this.setHeaderText(HEADER_TEXT);
        this.setResizable(true);
        DialogPane dlgPane = this.getDialogPane();
        dlgPane.setMinHeight(Double.NEGATIVE_INFINITY);
        VBox contentBox = new VBox(8.0);
        Label infoLabel = new Label("Choose a term in the bump device template.");
        VBox.setVgrow((Node)infoLabel, (Priority)Priority.NEVER);
        contentBox.getChildren().add((Object)infoLabel);
        BumpTableView tableView = new BumpTableView();
        VBox.setVgrow((Node)tableView, (Priority)Priority.NEVER);
        contentBox.getChildren().add((Object)tableView);
        dlgPane.setContent((Node)contentBox);
        this.setResultConverter(dlgBtn -> {
            if (dlgBtn == ButtonType.OK) {
                return this.bumpDevT2SelectedInfo;
            }
            return null;
        });
    }

    private class BumpTableView
    extends EditorTableView<DeviceTemplate> {
        public BumpTableView() {
            this.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
            this.getSelectionModel().setCellSelectionEnabled(true);
            this.setEditable(true);
            this.setPrefHeight(100.0);
        }

        @Override
        protected List<DeviceTemplate> getItemList() {
            return AUtil.arrayList(BumpContentsChooserDlg.this.bumpDevT2SelectedInfo.keySet());
        }

        @Override
        protected void initHeader() {
            this.initRowNumCol();
        }

        @Override
        protected void bindKeys() {
        }

        private void initRowNumCol() {
            this.addNewRowNumCol();
            this.initNameCol();
            this.initTermCol();
        }

        private void initNameCol() {
            EditorTableView.EditorTableColumn<String> col = this.addNewEditorTableColumn("Bump Template", s -> s, DeviceTemplate::getName);
            col.setSortable(false);
            col.setPrefWidth(200.0);
            col.setCellValueFactory(col.newSimpleObjectFactory());
            col.setCellFactory(col.newValueTextCellFactory());
        }

        private void initTermCol() {
            EditorTableView.EditorTableColumn<Term> col = this.addNewEditorTableColumn("Bump Term", Term::getName, devT -> devT.getTerms().findFirst().orElse(null));
            col.setSortable(false);
            col.setPrefWidth(200.0);
            col.setCellValueFactory(col.newSimpleObjectFactory());
            col.setCellFactory(param -> new TableCell<DeviceTemplate, Term>(){

                public void updateItem(Term item, boolean empty) {
                    super.updateItem((Object)item, empty);
                    if (!empty) {
                        ComboBox<Term> comboBox = this.createTermComboBox(item);
                        this.setGraphic((Node)comboBox);
                        this.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
                    } else {
                        this.setGraphic(null);
                    }
                }

                private ComboBox<Term> createTermComboBox(Term item) {
                    DeviceTemplate bumpDevT = item.getDeviceTemplate();
                    ComboBox comboBox = new ComboBox();
                    ArrayList bumpTerms = AUtil.arrayList((Iterator)bumpDevT.getTerms());
                    comboBox.getItems().setAll((Collection)bumpTerms);
                    comboBox.getSelectionModel().selectedItemProperty().addListener((observable, oldValue, newValue) -> BumpContentsChooserDlg.this.bumpDevT2SelectedInfo.get(bumpDevT).setTerm((Term)newValue));
                    StringConverter<Term> converter = new StringConverter<Term>(){

                        public String toString(Term item) {
                            return item == null ? null : item.getName();
                        }

                        public Term fromString(String string) {
                            return null;
                        }
                    };
                    comboBox.setConverter((StringConverter)converter);
                    comboBox.getSelectionModel().select(0);
                    comboBox.setMaxWidth(Double.MAX_VALUE);
                    return comboBox;
                }
            });
        }
    }
}

