/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.cmd;

import com.sigrity.acl.AAlphaNumComp;
import com.sigrity.acl.ALog;
import com.sigrity.acl.AUtil;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.Selection;
import com.sigrity.acl.db.SelectionContext;
import com.sigrity.acl.db.Selectors;
import com.sigrity.acl.db.std.Bundle;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Layer;
import com.sigrity.acl.db.std.LayerShape;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.NetMap;
import com.sigrity.acl.db.std.Personality;
import com.sigrity.acl.db.std.PinInstance;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.acl.db.std.PortTemplate;
import com.sigrity.acl.db.std.SchedConn;
import com.sigrity.acl.db.std.Wire;
import com.sigrity.acl.geom.AGeom;
import com.sigrity.acl.geom.APath;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.acl.geom.ARect;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.HierInst;
import com.sigrity.orbit.HierPin;
import com.sigrity.orbit.HierPort;
import com.sigrity.orbit.OrbitApp;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.automation.RouterMgmt;
import com.sigrity.orbit.automation.router.InteractiveBundleCreator;
import com.sigrity.orbit.ui.core.DesignView2D;
import com.sigrity.orbit.util.PinUtil;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;

public class BundleCommands {
    private BundleCommands() {
    }

    public static HierInst<Bundle> findBundleAtLoc(DesignView2D view, long x, long y, long delta, String devicePath) {
        Db db = view.getDb();
        if (db == null) {
            assert (false);
            return null;
        }
        DevicePath dpath = null;
        if (devicePath != null && (dpath = DevicePath.fromString((Db)db, (String)devicePath)) == null) {
            ALog.logWarn((String)"Path '%s' specified to WireCommands.findWireAtLoc() is invalid.", (Object[])new Object[]{devicePath});
            return null;
        }
        ARect rect = new ARect(x - delta, y - delta, x + delta, y + delta);
        Selectors.BundleSelector selector = new Selectors.BundleSelector(SelectionContext.create((Db)db));
        HierInst bestChoice = null;
        for (HierInst hw : selector.getMatching((AGeom)rect, Selection.AreaMode.Touch, null, null)) {
            if (dpath != null && !dpath.equals((Object)hw.getPath())) continue;
            if (bestChoice == null) {
                bestChoice = hw;
                continue;
            }
            bestChoice = selector.getBetter(hw, bestChoice, null);
        }
        if (bestChoice == null) {
            return null;
        }
        return new HierInst(bestChoice.getPath(), (DbObject)((Bundle)bestChoice.getDbObject()));
    }

    public static void addBundlePoint(Bundle bundle, long x, long y) {
        APath path = bundle.getPath().copy();
        path.addPoint(x, y);
        bundle.setPath(path);
    }

    public static void insertBundleVertex(Bundle bundle, int vertexIndex, long x, long y) {
        APath path = bundle.getPath().copy();
        path.insertPoint(vertexIndex, new APoint2D(x, y));
        bundle.setPath(path);
    }

    public static void moveBundleVertex(Bundle bundle, int vertexIndex, long x, long y) {
        Personality routeGroup;
        if (vertexIndex == 0) {
            routeGroup = bundle.getRouteGroup();
            if (routeGroup != null) {
                Cp.exec((String)"com.sigrity.orbit.ui.wb_route.WbFcFeasibilityUI.deleteStrategy (\"%s\")", (Object[])new Object[]{routeGroup.getKeyStr()});
            }
            BundleCommands.deleteFixedContacts(bundle);
        }
        if (vertexIndex == bundle.getPath().getPointCount() - 1) {
            routeGroup = bundle.getRouteGroupFree();
            if (routeGroup != null) {
                Cp.exec((String)"com.sigrity.orbit.ui.wb_route.WbFcFeasibilityUI.deleteStrategy (\"%s\")", (Object[])new Object[]{routeGroup.getKeyStr()});
            }
            BundleCommands.deleteFreeContacts(bundle);
        }
        APath path = bundle.getPath().copy();
        path.setPoint(vertexIndex, new APoint2D(x, y));
        bundle.setPath(path);
    }

    public static void deleteFreeContacts(Bundle bundle) {
        LinkedList toBeDeletedContacts = new LinkedList(bundle.getFreeContacts());
        for (PinTemplate pt : toBeDeletedContacts) {
            pt.deleteFromDb();
        }
    }

    public static void deleteFixedContacts(Bundle bundle) {
        LinkedList toBeDeletedContacts = new LinkedList(bundle.getFixedContacts());
        for (PinTemplate pt : toBeDeletedContacts) {
            pt.deleteFromDb();
        }
    }

    public static void deleteBundleVertex(Bundle bundle, int vertexIndex) {
        Personality routeGroup;
        if (vertexIndex == 0) {
            routeGroup = bundle.getRouteGroup();
            if (routeGroup != null) {
                Cp.exec((String)"com.sigrity.orbit.ui.wb_route.WbFcFeasibilityUI.deleteStrategy (\"%s\")", (Object[])new Object[]{routeGroup.getKeyStr()});
            }
            BundleCommands.deleteFixedContacts(bundle);
        }
        if (vertexIndex == bundle.getPath().getPointCount() - 1) {
            routeGroup = bundle.getRouteGroupFree();
            if (routeGroup != null) {
                Cp.exec((String)"com.sigrity.orbit.ui.wb_route.WbFcFeasibilityUI.deleteStrategy (\"%s\")", (Object[])new Object[]{routeGroup.getKeyStr()});
            }
            BundleCommands.deleteFreeContacts(bundle);
        }
        APath path = bundle.getPath().copy();
        path.removePointAt(vertexIndex);
        bundle.setPath(path);
    }

    public static int completeCount(String devicePathString, String bundleName) {
        Db db = OrbitIO.getCurDb();
        DevicePath devicePath = DevicePath.fromString((Db)db, (String)devicePathString);
        if (devicePath == null) {
            ALog.logWarn((String)"DevicePath '%s' does not exist", (Object[])new Object[]{devicePathString});
            return -1;
        }
        DeviceTemplate deviceTemplate = devicePath.getDeviceTemplate();
        Bundle b = Bundle.getBundle((Db)db, (String)bundleName, (DeviceTemplate)deviceTemplate);
        if (b == null) {
            ALog.logWarn((String)"Bundle '%s' does not exist", (Object[])new Object[]{bundleName});
            return -1;
        }
        int numCompleted = 0;
        for (SchedConn sc : b.getSchedConn()) {
            if (!sc.isValidBoth()) continue;
            ++numCompleted;
        }
        return numCompleted;
    }

    public static void updateBundleConnections(boolean via) {
        Db db = OrbitIO.getCurDb();
        Design design = Design.getDesign((Db)db);
        boolean selected = false;
        Selection s = design.getCurSelection();
        for (Bundle b : s.get(Bundle.class)) {
            BundleCommands.updateBundleAfterSwap(b, true);
            selected = true;
        }
        if (!selected) {
            for (Bundle b : db.getObjects(Bundle.class)) {
                BundleCommands.updateBundleAfterSwap(b, true);
            }
        }
        if (via) {
            for (PinTemplate pT : db.getObjects(PinTemplate.class)) {
                DeviceTemplate dT;
                DevicePath dP;
                if (!pT.getType().equals((Object)PinTemplate.Type.VIA) || (dP = (dT = pT.getDeviceTemplate()).getPathToPresentUser().getFirst().getADevicePath()) == null || dP.isEmpty() || dP.getDevice().getTemplate() != pT.getDeviceTemplate()) continue;
                PinInstance pI = pT.getPinInstance(dP);
                HierPin hPin = new HierPin(dP, pI);
                HierInst hNet = new HierInst(dP, (DbObject)pI.getNet());
                PinUtil.floodNet((HierPin)hPin, (HierInst)hNet);
            }
        }
        LinkedList<Net> listNets = new LinkedList<Net>();
        for (Net n : db.getObjects(Net.class)) {
            if (!n.getName().contains("NewNet_") || n.getPinCount() != 0) continue;
            listNets.add(n);
        }
        for (Net n : listNets) {
            n.deleteFromDb();
        }
    }

    public static void updatePerSchedConn(Bundle b, HierPin p1, HierPin p2, boolean fixedSide) {
        Personality personality;
        Personality personality2 = personality = fixedSide ? b.getRouteGroup() : b.getRouteGroupFree();
        if (personality == null) {
            return;
        }
        for (SchedConn routeSC : personality.getSchedConns()) {
            if (routeSC.getPortB() == null || routeSC.getPortA() == null) continue;
            if (routeSC.getDPPA().equals((Object)p1)) {
                routeSC.setPortA(p2.getPath(), p2.getPinTemplate().getFirstPortTemplate());
                continue;
            }
            if (!routeSC.getDPPA().equals((Object)p2)) continue;
            routeSC.setPortA(p1.getPath(), p1.getPinTemplate().getFirstPortTemplate());
        }
    }

    public static void updateBundleAfterSwap(Bundle b, boolean isFixedGood) {
        HashMap<HierPin, HierPort> mapPortA = new HashMap<HierPin, HierPort>();
        HashMap<HierPin, HierPort> mapPortB = new HashMap<HierPin, HierPort>();
        for (SchedConn sc : b.getSchedConn()) {
            if (sc.getPortA() == null) continue;
            HierPort aPort = new HierPort((DevicePath)sc.getDPPA().first, ((PinInstance)sc.getDPPA().second).getPinTemplate().getFirstPortTemplate());
            mapPortA.put(sc.getDPPA(), aPort);
            HierPort bPort = null;
            if (sc.getPortB() != null) {
                bPort = new HierPort((DevicePath)sc.getDPPB().first, ((PinInstance)sc.getDPPB().second).getPinTemplate().getFirstPortTemplate());
                mapPortB.put(sc.getDPPB(), bPort);
            }
            DevicePath dpA = ((DevicePath)sc.getDPPA().first).isEmpty() ? sc.getAnAbsolutePathA().getDevicePath() : (DevicePath)sc.getDPPA().first;
            PinUtil.floodNet((HierPin)sc.getDPPA(), (HierInst)new HierInst(dpA, (DbObject)sc.getDPPA().getNet()));
            if (sc.getPortB() != null && sc.getDPPB() != null) {
                DevicePath dpB = ((DevicePath)sc.getDPPB().first).size() == 0 ? sc.getAnAbsolutePathB().getDevicePath() : (DevicePath)sc.getDPPB().first;
                PinUtil.floodNet((HierPin)sc.getDPPB(), (HierInst)new HierInst(dpB, (DbObject)sc.getDPPB().getNet()));
            }
            if (isFixedGood) {
                if (sc.getPortB() == null || bPort == null) continue;
                sc.setPortB(bPort.getPath(), bPort.getDPort());
                continue;
            }
            if (aPort == null) continue;
            sc.setPortA(aPort.getPath(), aPort.getDPort());
        }
        for (int side = 0; side < 2; ++side) {
            Personality personality;
            Personality personality2 = personality = side == 0 ? b.getRouteGroup() : b.getRouteGroupFree();
            if (personality == null) continue;
            for (SchedConn routeSC : personality.getSchedConns()) {
                HierPort hp;
                Net toSide;
                if (routeSC.getPortB() == null || routeSC.getPortA() == null) continue;
                Net fromSide = NetMap.getNetAt((Net)routeSC.getDPPA().getNet(), (DevicePath)routeSC.getDPPA().getPath(), (DeviceTemplate)b.getTemplate());
                if (fromSide != (toSide = NetMap.getNetAt((Net)routeSC.getDPPB().getNet(), (DevicePath)routeSC.getDPPB().getPath(), (DeviceTemplate)b.getTemplate()))) {
                    BundleCommands.deleteWires(b, side == 0, true, routeSC.getDPPA());
                }
                if (side == 0) {
                    hp = (HierPort)mapPortA.get(routeSC.getDPPA());
                    if (hp == null) continue;
                    routeSC.setPortA((DevicePath)hp.first, (PortTemplate)hp.second);
                    continue;
                }
                hp = (HierPort)mapPortB.get(routeSC.getDPPA());
                if (hp == null) continue;
                routeSC.setPortA((DevicePath)hp.first, (PortTemplate)hp.second);
            }
        }
    }

    public static void duplicateBundleVertex(Bundle bundle, int vertexIndex) {
        APath path = bundle.getPath().copy();
        path.insertPoint(vertexIndex, path.getPoint(vertexIndex).copy());
        bundle.setPath(path);
    }

    public static void deleteWires(Bundle b, boolean isFixed, boolean removeVias, HierPin thisOne) {
        Personality personality = null;
        personality = isFixed ? b.getRouteGroup() : b.getRouteGroupFree();
        if (personality == null) {
            return;
        }
        HashSet<Object> toBeDeletedWires = new HashSet<Object>();
        LinkedList<PinTemplate> toBeDeletedVias = new LinkedList<PinTemplate>();
        for (SchedConn schedConn : personality.getSchedConns()) {
            HierInst hPt;
            if (thisOne != null && !thisOne.equals((Object)schedConn.getDPPA())) continue;
            HierPin from = schedConn.getDPPA();
            from = PinUtil.getWireEnd((HierPin)from, (DeviceTemplate)b.getTemplate());
            LinkedList<Wire> wiresA = BundleCommands.getRoutes(from, schedConn.getOwningTemplate(), b);
            LinkedList<Object> wiresB = new LinkedList();
            toBeDeletedWires.addAll(wiresA);
            if (schedConn.getDPPB() != null) {
                wiresB = BundleCommands.getRoutes(schedConn.getDPPB(), schedConn.getOwningTemplate(), b);
                toBeDeletedWires.addAll(wiresB);
            }
            if (!removeVias) continue;
            for (Wire wire : wiresA) {
                hPt = wire.getPinA();
                if (hPt != null && hPt.second != null) {
                    toBeDeletedVias.add((PinTemplate)hPt.second);
                }
                if ((hPt = wire.getPinB()) == null || hPt.second == null) continue;
                toBeDeletedVias.add((PinTemplate)hPt.second);
            }
            for (Wire wire : wiresB) {
                hPt = wire.getPinA();
                if (hPt != null && hPt.second != null) {
                    toBeDeletedVias.add((PinTemplate)hPt.second);
                }
                if ((hPt = wire.getPinB()) == null || hPt.second == null) continue;
                toBeDeletedVias.add((PinTemplate)hPt.second);
            }
        }
        for (Wire wire : toBeDeletedWires) {
            if (wire.getDb() == null || !BundleCommands.addedByRouter(wire, b)) continue;
            wire.deleteFromDb();
        }
        for (PinTemplate pinTemplate : toBeDeletedVias) {
            if (pinTemplate.getDb() == null) continue;
            String creator = null;
            for (LayerShape ls : AUtil.linkedList((Iterator)pinTemplate.getPadTemplate().getLayerShapes())) {
                creator = (String)ls.getValue("Creator");
                if (creator == null || !creator.equals("router")) continue;
                ls.deleteFromDb();
            }
            if (pinTemplate.getType() != PinTemplate.Type.VIA || (creator = (String)pinTemplate.getValue("creatorProcess")) == null || !creator.equals("router")) continue;
            pinTemplate.deleteFromDb();
        }
    }

    public static void updatePotentialBundleOnSwap(HierPin p1, HierPin p2) {
        Db db = ((PinInstance)p1.second).getDb();
        for (Bundle b : db.getObjects(Bundle.class)) {
            Wire w = ((PinInstance)p1.second).getBundleWire(b);
            if (w != null) {
                w.deleteFromDb();
            }
            if ((w = ((PinInstance)p2.second).getBundleWire(b)) != null) {
                w.deleteFromDb();
            }
            Bundle.SwapInfo si = Bundle.deriveInvolved((Db)db, (Bundle)b, (HierPin)p1, (HierPin)p2);
            HierPin rp1 = new HierPin(((DevicePath)p1.first).getRelativePathFromAnchor(b.getTemplate()), (PinInstance)p1.second);
            HierPin rp2 = new HierPin(((DevicePath)p2.first).getRelativePathFromAnchor(b.getTemplate()), (PinInstance)p2.second);
            if (si.getInvolved() == 2) {
                if (Boolean.TRUE.equals(si.getFixedSideInvolved())) {
                    si.getSc1().swapA(si.getSc2());
                    BundleCommands.updatePerSchedConn(b, rp1, rp2, true);
                    BundleCommands.updateBundleAfterSwap(b, true);
                    continue;
                }
                si.getSc1().swapB(si.getSc2());
                BundleCommands.updatePerSchedConn(b, rp1, rp2, false);
                BundleCommands.updateBundleAfterSwap(b, true);
                continue;
            }
            if (si.getInvolved() != 1) continue;
            if (si.getSc1().getDPPB().equals((Object)rp1)) {
                si.getSc1().setPortB(rp2.getPath(), p2.getPinTemplate().getFirstPortTemplate());
                BundleCommands.updatePerSchedConn(b, rp1, rp2, false);
                BundleCommands.updateBundleAfterSwap(b, true);
                continue;
            }
            if (si.getSc1().getDPPB().equals((Object)rp2)) {
                si.getSc1().setPortB(rp1.getPath(), p1.getPinTemplate().getFirstPortTemplate());
                BundleCommands.updatePerSchedConn(b, rp1, rp2, false);
                BundleCommands.updateBundleAfterSwap(b, true);
                continue;
            }
            if (si.getSc1().getDPPA().equals((Object)rp1)) {
                si.getSc1().setPortA(rp2.getPath(), p2.getPinTemplate().getFirstPortTemplate());
                BundleCommands.updatePerSchedConn(b, rp1, rp2, true);
                BundleCommands.updateBundleAfterSwap(b, true);
                continue;
            }
            if (!si.getSc1().getDPPA().equals((Object)rp2)) continue;
            si.getSc1().setPortA(rp1.getPath(), p1.getPinTemplate().getFirstPortTemplate());
            BundleCommands.updatePerSchedConn(b, rp1, rp2, true);
            BundleCommands.updateBundleAfterSwap(b, true);
        }
    }

    public static LinkedList<Wire> getRoutes(HierPin originalHierPin, DeviceTemplate routingTemplate, Bundle bundle) {
        return new LinkedList<Wire>(RouterMgmt.getRoutes((HierPin)originalHierPin, (DeviceTemplate)routingTemplate, (Bundle)bundle));
    }

    public static boolean addedByRouter(Wire w, Bundle bundle) {
        return RouterMgmt.addedByRouter((Wire)w, (Bundle)bundle);
    }

    public static void UntangleAndOptimizeBundles(Db db) {
        for (Bundle b : AUtil.linkedList((Iterator)db.getObjects(Bundle.class))) {
            InteractiveBundleCreator ibr = InteractiveBundleCreator.show();
            ibr.untangleStart(b);
            ibr.optimizeFreeEnd(b);
        }
    }

    public static void writeAllBundleCoords(String fileName) {
        try (BufferedWriter out = new BufferedWriter(new FileWriter(fileName));){
            String s = null;
            ArrayList<Bundle> bundleList = new ArrayList<Bundle>();
            for (Bundle b : AUtil.linkedList((Iterator)OrbitIO.getCurDb().getObjects(Bundle.class))) {
                bundleList.add(b);
            }
            Collections.sort(bundleList, new BundleNameSorter());
            for (Bundle bundle : bundleList) {
                Object sc2;
                if (bundle == null) continue;
                s = String.format("\n%s %s\n", bundle.getName(), bundle.getKeyStr());
                out.write(s);
                out.write("\n Schedule Connections\n");
                for (Object sc2 : bundle.getSchedConn()) {
                    s = String.format(" %d %d %d %d\n", sc2.getHierPortA().getWorldLoc().getX(), sc2.getHierPortA().getWorldLoc().getY(), sc2.getHierPortB().getWorldLoc().getX(), sc2.getHierPortB().getWorldLoc().getY());
                    out.write(s);
                }
                out.write("\n Fixed Rake Patterns\n");
                ArrayList rpFixed = bundle.getRakePattern(true);
                sc2 = rpFixed.iterator();
                while (sc2.hasNext()) {
                    APoint2D fixedRake = (APoint2D)sc2.next();
                    s = String.format(" %d %d\n", fixedRake.getX(), fixedRake.getY());
                    out.write(s);
                }
                out.write("\n Free Rake Patterns\n");
                ArrayList rpFree = bundle.getRakePattern(false);
                for (APoint2D freeRake : rpFree) {
                    s = String.format(" %d %d\n", freeRake.getX(), freeRake.getY());
                    out.write(s);
                }
            }
        }
        catch (IOException e) {
            ALog.logError((Throwable)e, (String)("Problem writing to " + fileName), (Object[])new Object[0]);
        }
    }

    public static void rakeSelectedBundlesByRouteLayers() {
        Selection s = Design.getSelection((Db)OrbitApp.getCurDb());
        for (Bundle b : s.get(Bundle.class)) {
            b.rakeBundleByRouteLayer(true);
            b.rakeBundleByRouteLayer(false);
        }
    }

    public static boolean clearBundleLayer(Db db, String bundleKeyStr) {
        Bundle bundle = (Bundle)db.getByKeyStr(Bundle.class, bundleKeyStr);
        if (bundle == null) {
            ALog.logWarn((String)"Can not find bundle from '%s', ignore clear layers in use.", (Object[])new Object[]{bundleKeyStr});
            return false;
        }
        bundle.clearLayers();
        return true;
    }

    public static boolean addBundleLayer(Db db, String bundleKeyStr, String layerKeyStr) {
        Bundle bundle = (Bundle)db.getByKeyStr(Bundle.class, bundleKeyStr);
        if (bundle == null) {
            ALog.logWarn((String)"Can not find bundle from '%s', ignore add layer '%s'.", (Object[])new Object[]{bundleKeyStr, layerKeyStr});
            return false;
        }
        Layer layer = (Layer)db.getByKeyStr(Layer.class, layerKeyStr);
        if (layer == null) {
            ALog.logWarn((String)"Can not find layer from '%s', ignore add layer for bundle '%s'.", (Object[])new Object[]{layerKeyStr, bundle});
            return false;
        }
        bundle.addLayer(layer);
        return true;
    }

    public static class BundleNameSorter
    implements Comparator<Bundle> {
        @Override
        public int compare(Bundle b0, Bundle b1) {
            AAlphaNumComp c = AAlphaNumComp.get();
            int nameCmp = c.compare((Object)b0.getName(), (Object)b1.getName());
            if (nameCmp != 0) {
                return nameCmp;
            }
            return c.compare((Object)b0.getKeyStr(), (Object)b1.getKeyStr());
        }
    }
}

