/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.cmd;

import com.sigrity.acl.db.std.Bundle;
import com.sigrity.acl.db.std.SchedConn;
import com.sigrity.acl.geom.APoint2D;
import java.util.ArrayList;

public class BundleLengths {
    long skewLength;
    long averageLength;
    long maxLength;
    long minLength;
    SchedConn maxSc;
    SchedConn minSc;

    public BundleLengths(long s, long a, long maxL, long minL, SchedConn maxS, SchedConn minS) {
        this.skewLength = s;
        this.averageLength = a;
        this.maxLength = maxL;
        this.minLength = minL;
        this.maxSc = maxS;
        this.minSc = minS;
    }

    public long getSkewLength() {
        return this.skewLength;
    }

    public long getAverageLength() {
        return this.averageLength;
    }

    public long getMaxLength() {
        return this.maxLength;
    }

    public long getMinLength() {
        return this.minLength;
    }

    public SchedConn getMaxSchedConn() {
        return this.maxSc;
    }

    public SchedConn getMinSchedConn() {
        return this.minSc;
    }

    public static BundleLengths getBundleLengths(Bundle bundle, ArrayList<APoint2D> fixedPattern, ArrayList<APoint2D> freePattern) {
        long minLength = Long.MAX_VALUE;
        long maxLength = Long.MIN_VALUE;
        long skewLength = 0L;
        ArrayList rpFixed = fixedPattern;
        ArrayList rpFree = freePattern;
        if (bundle == null || bundle.getSchedConnCount() == 0) {
            return new BundleLengths(0L, 0L, 0L, 0L, null, null);
        }
        if (rpFixed == null) {
            rpFixed = bundle.getRakePattern(true);
        }
        if (rpFree == null) {
            rpFree = bundle.getRakePattern(false);
        }
        int i = 0;
        long totalLength = 0L;
        long averageLength = 0L;
        SchedConn maxSc = null;
        SchedConn minSc = null;
        for (SchedConn sc : bundle.getSchedConn()) {
            APoint2D fixedPt = null;
            APoint2D freePt = null;
            if (i < rpFixed.size()) {
                fixedPt = (APoint2D)rpFixed.get(i);
            }
            if (i < rpFree.size()) {
                freePt = (APoint2D)rpFree.get(i);
            }
            ++i;
            long length = sc.getLength(fixedPt, freePt);
            totalLength += length;
            if (length < minLength) {
                minLength = length;
                minSc = sc;
            }
            if (length <= maxLength) continue;
            maxLength = length;
            maxSc = sc;
        }
        skewLength = maxLength - minLength;
        averageLength = totalLength / (long)bundle.getSchedConnCount();
        return new BundleLengths(skewLength, averageLength, maxLength, minLength, maxSc, minSc);
    }
}

