/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.cmd;

import com.sigrity.acl.ALog;
import com.sigrity.acl.APair;
import com.sigrity.acl.AUtil;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.Selection;
import com.sigrity.acl.db.std.Connection;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.Layer;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.acl.db.std.Wire;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.HierInst;
import com.sigrity.orbit.HierPin;
import com.sigrity.orbit.OrbitApp;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.cmd.DbObjectCmd;
import com.sigrity.orbit.ui.wb_route.BundleEscapeInterface;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;

public class ConnectionCommands {
    private ConnectionCommands() {
    }

    public static int routeSelectedConnections(long wireBumpClearance, long wireWireClearance, long wireWidth) {
        return ConnectionCommands.routeSelectedConnections(null, wireBumpClearance, wireWireClearance, wireWidth, true);
    }

    public static int routeSelectedConnections(String layerName, long wireBumpClearance, long wireWireClearance, long wireWidth) {
        return ConnectionCommands.routeSelectedConnections(layerName, wireBumpClearance, wireWireClearance, wireWidth, true);
    }

    public static int routeSelectedConnections(String layerName, long wireBumpClearance, long wireWireClearance, long wireWidth, boolean addToDb) {
        LinkedList<APair<DbObject, Layer>> connections = new LinkedList<APair<DbObject, Layer>>();
        Db db = OrbitApp.getCurDb();
        Selection s = Design.getSelection((Db)db);
        for (Connection con : s.get(Connection.class)) {
            Layer layer = (Layer)con.getValue("layer");
            connections.add(new APair((Object)con, (Object)layer));
        }
        Collections.sort(connections, APair::compare);
        int conSize = connections.size();
        if (conSize != 0) {
            ALog.logInfo((String)"Routing %d selected connections.", (Object[])new Object[]{conSize});
            BundleEscapeInterface bei = new BundleEscapeInterface();
            DevicePath common = null;
            for (APair aPair : connections) {
                Connection conn = (Connection)aPair.first;
                common = conn.getDPPA().getPath().commonParent(common);
                common = conn.getDPPB().getPath().commonParent(common);
            }
            if (common == null) {
                ALog.logInfo((String)"No common device paths for selected connections.");
                return 0;
            }
            bei.setRoutingPath(common.escapedString());
            return bei.routeConns(connections, layerName, wireBumpClearance * Design.getUnitDistDbuPerMicron((Db)db), wireWireClearance * Design.getUnitDistDbuPerMicron((Db)db), wireWidth * Design.getUnitDistDbuPerMicron((Db)db), true, addToDb);
        }
        ALog.logInfo((String)"No connection selected. No routing performed.");
        return 0;
    }

    public static void replaceWiresWithConnections() {
        Db db = OrbitApp.getCurDb();
        if (db == null) {
            return;
        }
        for (Wire wire : AUtil.linkedList((Iterator)db.getObjects(Wire.class))) {
            Net net = wire.getNet();
            if (!net.isUnused()) {
                HierInst pinA = wire.getPinA();
                HierInst pinB = wire.getPinB();
                if (pinA == null || pinB == null) {
                    wire.deleteFromDb();
                    continue;
                }
                HierInst hip1 = new HierInst(((DevicePath)pinA.getFirst()).getAFullPath(), (DbObject)((PinTemplate)pinA.getSecond()));
                HierInst hip2 = new HierInst(((DevicePath)pinB.getFirst()).getAFullPath(), (DbObject)((PinTemplate)pinB.getSecond()));
                Layer layer = wire.getLayer();
                HierPin hp1 = HierPin.forHPinT((HierInst)hip1);
                HierPin hp2 = HierPin.forHPinT((HierInst)hip2);
                Connection conn = new Connection(hp1, hp2, false);
                db.add((DbObject)conn);
                conn.setValue("layer", (Object)layer);
            }
            wire.deleteFromDb();
        }
        OrbitIO.getApp().refreshCurrentView(true);
    }

    public static void writeConnections(Db db, String filePath) {
        FileWriter fileWriter = null;
        try {
            fileWriter = new FileWriter(new File(filePath));
        }
        catch (IOException e) {
            ALog.logError((String)("Can not open " + filePath + " for writing"));
            return;
        }
        LinkedList<Connection> connections = new LinkedList<Connection>();
        for (Connection c : db.getObjects(Connection.class)) {
            connections.add(c);
        }
        Collections.sort(connections);
        for (Connection c : connections) {
            try {
                fileWriter.write(c.toFullString() + "\n");
            }
            catch (IOException e) {
                ALog.logError((Throwable)e);
            }
        }
        try {
            fileWriter.close();
            ALog.logInfo((String)("Wrote to file: " + filePath));
        }
        catch (IOException e) {
            ALog.logError((Throwable)e, (String)"Problems when closing", (Object[])new Object[0]);
        }
    }

    public static void deleteSelectedConnections(Db db) {
        DbObjectCmd.deleteSelected((Db)db, Connection.class);
    }

    public static void deleteUnselectedConnections(Db db) {
        Selection sel = Selection.getCurrentSelectionForDb((Db)db);
        for (Connection c : AUtil.arrayList((Iterator)db.getObjects(Connection.class))) {
            if (sel.contains((DbObject)c)) continue;
            c.deleteFromDb();
        }
    }
}

