/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.cmd;

import com.sigrity.acl.ALog;
import com.sigrity.acl.ATransformUtil;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbHistory;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.Selection;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.acl.geom.ARect;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.automation.contact_sync.ContactObjectSyncEngine;
import com.sigrity.orbit.ui.ContactToParentUI;
import com.sigrity.orbit.ui.cphelper.CpHelper;
import java.awt.geom.AffineTransform;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.Icon;
import javax.swing.UIManager;

public class DeviceCommands {
    private DeviceCommands() {
    }

    public static void moveDeviceOrigin(Db db, String devicePathStr, ORIGIN_POS originPos) {
        DevicePath path = DevicePath.fromEscapedString((Db)db, (String)devicePathStr);
        if (path == null) {
            ALog.logError((String)"Invalid device path '%s'", (Object[])new Object[]{devicePathStr});
            return;
        }
        DeviceTemplate dt = path.getDeviceTemplate();
        for (Device d : path) {
            originPos = originPos.rotate(d.getRotate());
            if (!d.getMirror()) continue;
            originPos = originPos.mirror();
        }
        APoint2D p = ORIGIN_POS.getPos(dt.getBounds(true).getBounds(), originPos);
        dt.shiftOrigin(p.getX(), p.getY());
    }

    public static void deleteChildDevices(Db db, String devicePathStr, DeviceTemplate.Type childType) {
        DevicePath path = DevicePath.fromEscapedString((Db)db, (String)devicePathStr);
        if (path == null) {
            ALog.logError((String)"Invalid device path '%s'", (Object[])new Object[]{devicePathStr});
            return;
        }
        DeviceTemplate dt = path.getDeviceTemplate();
        List childDevs = dt.getChildren().stream().filter(dev -> dev.getType() == childType).collect(Collectors.toList());
        ContactObjectSyncEngine sync = new ContactObjectSyncEngine(db);
        for (Device dev2 : childDevs) {
            sync.addToSyncDelete((DbObject)dev2);
        }
        sync.execute();
        for (Device dev2 : childDevs) {
            dev2.deleteFromDb();
        }
    }

    public static void selectChildDevices(Db db, String devicePathStr, DeviceTemplate.Type childType) {
        DevicePath path = DevicePath.fromEscapedString((Db)db, (String)devicePathStr);
        if (path == null) {
            ALog.logError((String)"Invalid device path '%s'", (Object[])new Object[]{devicePathStr});
            return;
        }
        DeviceTemplate dt = path.getDeviceTemplate();
        List childDevs = dt.getChildren().stream().filter(dev -> dev.getType() == childType).collect(Collectors.toList());
        Selection sel = Design.getSelection((Db)db);
        for (Device dev2 : childDevs) {
            sel.add(path, (DbObject)dev2);
        }
    }

    public static void setDeviceToNewParent(Db db, DevicePath srcPath, DevicePath tgtPath) {
        assert (!Cp.getCp().isCmdRecording()) : "Illegal Cp state";
        try (DbHistory.DbTransaction txn = DbHistory.newDbTransaction((Db)db, (String)"Reparent Device");){
            Cp.exec((String)"com.sigrity.orbit.cmd.DeviceCommands.moveDeviceToNewParent(curDb(), %s, %s)", (Object[])new Object[]{CpHelper.getCmdStr(srcPath), CpHelper.getCmdStr(tgtPath)});
            DevicePath newPath = tgtPath.withChild(srcPath.getLast());
            if (!tgtPath.isDesign() && newPath.getDevice().getIsSubstrate()) {
                ContactToParentUI.showUI(newPath);
            }
        }
    }

    public static void moveDeviceToNewParent(Db db, DevicePath srcPath, DevicePath tgtPath) {
        try (DbHistory.DbTransaction txn = DbHistory.newDbTransaction((Db)db, (String)"Reparent Device");){
            APoint2D origWorldLoc = srcPath.getLoc();
            boolean mirror = srcPath.getMirror() ^ tgtPath.getMirror();
            float rotate = srcPath.getDevice().getRotate();
            Iterator dItr = srcPath.descendingIterator();
            dItr.next();
            while (dItr.hasNext()) {
                Device d = (Device)dItr.next();
                if (d.getMirror()) {
                    rotate = -rotate;
                }
                rotate += d.getRotate();
            }
            for (Device d : tgtPath) {
                rotate -= d.getRotate();
                if (!d.getMirror()) continue;
                rotate = -rotate;
            }
            Device moveDevice = srcPath.getDevice();
            AffineTransform parentX = tgtPath.getTransform();
            AffineTransform parentXInv = ATransformUtil.inverse((AffineTransform)parentX);
            moveDevice.setParent(tgtPath.getDevice(), true);
            moveDevice.setMirror(mirror);
            moveDevice.setRotate(rotate);
            moveDevice.setLoc(origWorldLoc.transform(parentXInv));
        }
    }

    public static final class ORIGIN_POS
    extends Enum<ORIGIN_POS> {
        public static final /* enum */ ORIGIN_POS LEFT_BOTTOM = new ORIGIN_POS("Lower Left", UIManager.getIcon("CDNS.bottomLeftCornerIcon"));
        public static final /* enum */ ORIGIN_POS LEFT_TOP = new ORIGIN_POS("Upper Left", UIManager.getIcon("CDNS.topLeftCornerIcon"));
        public static final /* enum */ ORIGIN_POS RIGHT_BOTTOM = new ORIGIN_POS("Lower Right", UIManager.getIcon("CDNS.bottomRightCornerIcon"));
        public static final /* enum */ ORIGIN_POS RIGHT_TOP = new ORIGIN_POS("Upper Right", UIManager.getIcon("CDNS.topRightCornerIcon"));
        public static final /* enum */ ORIGIN_POS CENTER = new ORIGIN_POS("Center", null);
        private final String text;
        private final Icon icon;
        private static final /* synthetic */ ORIGIN_POS[] $VALUES;

        public static ORIGIN_POS[] values() {
            return (ORIGIN_POS[])$VALUES.clone();
        }

        public static ORIGIN_POS valueOf(String name) {
            return Enum.valueOf(ORIGIN_POS.class, name);
        }

        private ORIGIN_POS(String text, Icon icon) {
            this.text = text;
            this.icon = icon;
        }

        public String getText() {
            return this.text;
        }

        public static APoint2D getPos(ARect b, ORIGIN_POS originPos) {
            if (originPos == LEFT_BOTTOM) {
                return b.getLL();
            }
            if (originPos == LEFT_TOP) {
                return b.getUL();
            }
            if (originPos == RIGHT_BOTTOM) {
                return b.getLR();
            }
            if (originPos == RIGHT_TOP) {
                return b.getUR();
            }
            if (originPos == CENTER) {
                return b.center();
            }
            assert (false);
            return null;
        }

        public ORIGIN_POS rotate(float rotate) {
            if (this == CENTER) {
                return this;
            }
            ORIGIN_POS ret = this;
            while (rotate > 0.0f) {
                if (ret == LEFT_BOTTOM) {
                    ret = LEFT_TOP;
                } else if (ret == LEFT_TOP) {
                    ret = RIGHT_TOP;
                } else if (ret == RIGHT_BOTTOM) {
                    ret = LEFT_BOTTOM;
                } else if (ret == RIGHT_TOP) {
                    ret = RIGHT_BOTTOM;
                } else {
                    assert (false);
                    return null;
                }
                rotate -= 90.0f;
            }
            while (rotate < 0.0f) {
                if (ret == LEFT_BOTTOM) {
                    ret = RIGHT_BOTTOM;
                } else if (ret == LEFT_TOP) {
                    ret = LEFT_BOTTOM;
                } else if (ret == RIGHT_BOTTOM) {
                    ret = RIGHT_TOP;
                } else if (ret == RIGHT_TOP) {
                    ret = LEFT_TOP;
                } else {
                    assert (false);
                    return null;
                }
                rotate += 90.0f;
            }
            return ret;
        }

        public ORIGIN_POS mirror() {
            ORIGIN_POS ret = this;
            if (this == CENTER) {
                return this;
            }
            if (ret == LEFT_BOTTOM) {
                ret = RIGHT_BOTTOM;
            } else if (ret == LEFT_TOP) {
                ret = RIGHT_TOP;
            } else if (ret == RIGHT_BOTTOM) {
                ret = LEFT_BOTTOM;
            } else if (ret == RIGHT_TOP) {
                ret = LEFT_TOP;
            }
            return ret;
        }

        public Icon getIcon() {
            return UIUtil.getScaledIcon((Icon)this.icon, (int)16, (int)16);
        }

        static {
            $VALUES = new ORIGIN_POS[]{LEFT_BOTTOM, LEFT_TOP, RIGHT_BOTTOM, RIGHT_TOP, CENTER};
        }
    }
}

