/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.cmd;

import com.sigrity.acl.ALog;
import com.sigrity.acl.APatternColor;
import com.sigrity.acl.AUtil;
import com.sigrity.acl.AValidator;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.std.Layer;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.ui.LayerUI;
import com.sigrity.orbit.ui.core.ViewColorizer;
import java.awt.Color;

public class LayerCommands {
    private LayerCommands() {
    }

    public static void setLayerColor(String layerKeyStr, String colorStr) {
        Db curDb = OrbitIO.getCurDb();
        if (curDb == null) {
            return;
        }
        ViewColorizer colorizer = LayerCommands.getViewColorizer(curDb);
        if (colorizer == null) {
            return;
        }
        Layer l = (Layer)curDb.getByKeyStr(Layer.class, layerKeyStr);
        ViewColorizer.LayerKey key = colorizer.getLayerKey(l, true);
        Color c = AUtil.colorFromString((String)colorStr);
        l.setColor(c);
        colorizer.setColor(null, (ViewColorizer.Key)key, c);
    }

    public static void setAllLayersVisible(Db db, boolean visible) {
        AValidator.validateNotNull((Object)db);
        for (Layer l : db.getObjects(Layer.class)) {
            if (LayerCommands.getLayerVisible(l) == visible) continue;
            LayerCommands.setLayerVisible(l, visible);
        }
    }

    public static void setLayerVisible(Layer l, boolean visible) {
        LayerCommands.setLayerVisible(l, visible, null);
    }

    public static void setLayerVisible(Layer l, boolean visible, DevicePath dp) {
        AValidator.validateNotNull((Object)l);
        ViewColorizer colorizer = LayerCommands.getViewColorizer(l.getDb());
        if (colorizer == null) {
            ALog.logWarn((String)"Cannot set layer visibility because colorizer was not found.");
            return;
        }
        ViewColorizer overColorizer = colorizer;
        if (dp != null) {
            overColorizer = colorizer.getOverride(dp, true);
        }
        APatternColor inheritColor = null;
        if (overColorizer.getLayerKey(l, false) == null) {
            inheritColor = colorizer.getColor(null, l);
        }
        ViewColorizer.LayerKey key = overColorizer.getLayerKey(l, true);
        assert (key != null);
        overColorizer.setDisplay(null, (ViewColorizer.Key)key, visible);
        if (inheritColor != null) {
            overColorizer.setColor(null, (ViewColorizer.Key)key, inheritColor.getColor());
        }
    }

    private static boolean getLayerVisible(Layer l) {
        return LayerUI.getLayerVisible(l);
    }

    private static ViewColorizer getViewColorizer(Db db) {
        return LayerUI.getViewColorizer(db);
    }
}

