/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.cmd;

import com.sigrity.acl.ALog;
import com.sigrity.acl.AUtil;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.std.Constraint;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.NetMap;
import com.sigrity.acl.db.std.Personality;
import com.sigrity.acl.db.std.PersonalityMap;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.acl.db.std.Term;
import com.sigrity.orbit.NetFilters;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.mutable.MutableLong;

public class NetCommands {
    private NetCommands() {
    }

    public static boolean classifyAsSignal(Db db, String netKeyStr) {
        Net net = (Net)db.getByKeyStr(Net.class, netKeyStr);
        if (net == null) {
            ALog.logWarn((String)"Cannot find Net from '%s'", (Object[])new Object[]{netKeyStr});
            return false;
        }
        return NetCommands.classifyAsSignal(net);
    }

    public static boolean classifyAsSignal(Net net) {
        PersonalityMap.getPersonalities((Personality.Type)Personality.Type.NET, (DbObject)net).forEach(pm -> {
            Personality p = pm.getPersonality();
            Constraint b = Constraint.getConstraint((DbObject)p, (Constraint.Descriptor)Constraint.IS_POWER);
            if (b != null && ((Boolean)b.getValue()).booleanValue()) {
                pm.deleteFromDb();
            }
        });
        net.setUse(Net.Use.SIGNAL);
        for (PinTemplate pt : net.getPinTemplates()) {
            pt.setUse(PinTemplate.Use.SIGNAL);
        }
        for (Term term : net.getTerms()) {
            term.setUse(Term.Use.SIGNAL);
        }
        return true;
    }

    public static Personality getPowerNetPersonality(DeviceTemplate devT, String powerNetName) {
        return Personality.getOrCreate((DeviceTemplate)devT, (Personality.Type)Personality.Type.NET, (String)powerNetName, newPers -> {
            newPers.setColor(AUtil.colorFromString((String)Personality.nextColor()));
            Constraint.getOrCreate((DbObject)newPers, (Constraint.Descriptor)Constraint.IS_POWER, (Object)true);
        });
    }

    public static boolean classifyAsPower(Db db, String netKeyStr, String personalityKeyStr) {
        Net net = (Net)db.getByKeyStr(Net.class, netKeyStr);
        if (net == null) {
            ALog.logWarn((String)"Cannot find Net from '%s'", (Object[])new Object[]{netKeyStr});
            return false;
        }
        Personality personality = (Personality)db.getByKeyStr(Personality.class, personalityKeyStr);
        if (personality == null) {
            ALog.logWarn((String)"Cannot find Personality from '%s'", (Object[])new Object[]{personalityKeyStr});
            return false;
        }
        return NetCommands.classifyAsPower(net, personality);
    }

    public static boolean classifyAsPower(Net net, Personality personality) {
        if (net == null || personality == null) {
            return false;
        }
        net.setUse(Net.Use.POWER);
        net.assignToPersonality(personality);
        for (PinTemplate pt : net.getPinTemplates()) {
            pt.setUse(PinTemplate.Use.POWER);
        }
        for (Term term : net.getTerms()) {
            term.setUse(Term.Use.POWER);
        }
        return true;
    }

    public static boolean classifyAsGround(Db db, String netKeyStr, String personalityKeyStr) {
        Net net = (Net)db.getByKeyStr(Net.class, netKeyStr);
        if (net == null) {
            ALog.logWarn((String)"Cannot find Net from '%s'", (Object[])new Object[]{netKeyStr});
            return false;
        }
        Personality personality = (Personality)db.getByKeyStr(Personality.class, personalityKeyStr);
        if (personality == null) {
            ALog.logWarn((String)"Cannot find Personality from '%s'", (Object[])new Object[]{personalityKeyStr});
            return false;
        }
        return NetCommands.classifyAsGround(net, personality);
    }

    public static boolean classifyAsGround(Net net, Personality personality) {
        if (net == null || personality == null) {
            return false;
        }
        net.setUse(Net.Use.GROUND);
        net.assignToPersonality(personality);
        for (PinTemplate pt : net.getPinTemplates()) {
            pt.setUse(PinTemplate.Use.GROUND);
        }
        for (Term term : net.getTerms()) {
            term.setUse(Term.Use.GROUND);
        }
        return true;
    }

    public static long bulkMap(Db db, String childDevKey, String parentRegex, int parentRegexFlags, String childRegex, int childRegexFlags, DeviceTemplate.NetFilter parentNetFilter, DeviceTemplate.NetFilter childNetFilter) {
        return NetMap.bulkMap((Db)db, (String)childDevKey, (String)parentRegex, (int)parentRegexFlags, (String)childRegex, (int)childRegexFlags, (DeviceTemplate.NetFilter)parentNetFilter, (DeviceTemplate.NetFilter)childNetFilter);
    }

    public static long bulkCreateParentNets(Db db, String childDevKey, DeviceTemplate.NetFilter childNetFilter, String childRegex, int childRegexFlags, String parentNameFmt) {
        return NetMap.bulkCreateParentNets((Db)db, (String)childDevKey, (DeviceTemplate.NetFilter)childNetFilter, (String)childRegex, (int)childRegexFlags, (String)parentNameFmt);
    }

    public static long bulkCreateChildNets(Db db, String childDevKey, DeviceTemplate.NetFilter parentNetFilter, String parentRegex, int parentRegexFlags, String childNameFmt) {
        Device devChild = (Device)db.getByKeyStr(Device.class, childDevKey);
        if (devChild == null) {
            ALog.flogError((String)"Invalid child device key specified '%s', no such child exists.", (Object[])new Object[]{childDevKey});
            return 0L;
        }
        DeviceTemplate dtChild = devChild.getTemplate();
        DeviceTemplate dtParent = devChild.getParent();
        List allParentNets = dtParent.getNets(parentNetFilter, false).stream().sorted(Net.NameComparator).collect(Collectors.toCollection(ArrayList::new));
        NetFilters.RegexNetFilter parentRegexFilter = new NetFilters.RegexNetFilter(parentRegex, parentRegexFlags, false);
        parentRegexFilter.setSaveCapturedValues(true);
        List parentNets = NetFilters.filter((Iterable)allParentNets, (DeviceTemplate.NetFilter)parentRegexFilter).stream().collect(Collectors.toCollection(ArrayList::new));
        List capturedVals = parentRegexFilter.getCapturedValues();
        MutableLong mapped = new MutableLong(0L);
        NetMap.generateNames((List)parentNets, (String)childNameFmt, (List)capturedVals, (parentNet, childNetName) -> {
            if (dtChild.getNet(childNetName) != null) {
                ALog.flogWarn((String)"Net '%s' already exists on '%s', it is not being created and parent net '%s' is not being mapped.", (Object[])new Object[]{childNetName, dtChild.getName(), parentNet.getName()});
                return;
            }
            Net newChildNet = Net.create((DeviceTemplate)dtChild, (String)childNetName);
            if (newChildNet == null) {
                ALog.flogWarn((String)"Unable to create Net '%s' on '%s', parent net '%s' is not being mapped.", (Object[])new Object[]{childNetName, dtParent.getName(), parentNet.getName()});
                return;
            }
            boolean result = NetMap.mapChildNet((Device)devChild, (Net)newChildNet, (Net)parentNet);
            if (result) {
                mapped.increment();
            } else {
                ALog.flogWarn((String)"Error mapping child Net '%s' on '%s' to parent net '%s' on '%s'.", (Object[])new Object[]{childNetName, dtChild.getName(), parentNet.getName(), dtParent.getName()});
            }
        });
        return mapped.longValue();
    }
}

