/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.cmd;

import com.sigrity.acl.ALog;
import com.sigrity.acl.AMathUtil;
import com.sigrity.acl.APair;
import com.sigrity.acl.AReflection;
import com.sigrity.acl.AUtil;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.Selection;
import com.sigrity.acl.db.SelectionContext;
import com.sigrity.acl.db.Selectors;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Layer;
import com.sigrity.acl.db.std.LayerShape;
import com.sigrity.acl.db.std.Obstacle;
import com.sigrity.acl.db.std.Substrate;
import com.sigrity.acl.geom.ACircle;
import com.sigrity.acl.geom.AGeom;
import com.sigrity.acl.geom.ALine;
import com.sigrity.acl.geom.AOctagon;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.acl.geom.APolygon;
import com.sigrity.acl.geom.ARect;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.HierInst;
import com.sigrity.orbit.OrbitIO;
import java.awt.geom.AffineTransform;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Optional;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public class ShapeCommands {
    public static void moveShape(OwnedGeom<?> ownedGeom, long x, long y) {
        AGeom g = ownedGeom.getGeom().copy();
        g.moveBy(x, y);
        ownedGeom.setGeom(g);
    }

    public static void deleteShape(OwnedGeom<?> ownedGeom) {
        Db db = ownedGeom.getDb();
        assert (db != null);
        ownedGeom.delete();
        OrbitIO.refreshViewsOf(db);
    }

    public static int addVertex(OwnedGeom<?> ownedGeom, int afterVert) {
        AGeom g = ownedGeom.getGeom();
        if (g instanceof ARect) {
            g = g.toPoly();
        }
        if (g instanceof APolygon) {
            APolygon poly = (APolygon)g;
            poly = poly.makeOpen();
            if (afterVert < 0 || afterVert > poly.getPointCount() - 1) {
                ALog.logError((String)"Attempt to add a vertex to %s after invalid vertex index %d.", (Object[])new Object[]{ownedGeom.getGeom(), afterVert});
                return -1;
            }
            APoint2D afterPt = poly.getPoint(afterVert);
            int newVertIdx = afterVert + 1;
            APoint2D beforePt = afterVert > poly.getPointCount() - 2 ? poly.getFirstPoint() : poly.getPoint(newVertIdx);
            APoint2D newPt = new ALine(afterPt, beforePt).center();
            poly = poly.copy();
            poly.insertPoint(newVertIdx, newPt);
            ownedGeom.setGeom((AGeom)poly);
            return newVertIdx;
        }
        ALog.logError((String)"Adding a vertex to a %s is not currently supported.", (Object[])new Object[]{g.getName()});
        return -1;
    }

    public static void insertVertex(OwnedGeom<?> ownedGeom, int idx, long x, long y) {
        AGeom g = ownedGeom.getGeom();
        if (g instanceof ARect) {
            g = g.toPoly();
        }
        if (g instanceof APolygon) {
            APolygon poly = (APolygon)g;
            poly = poly.makeOpen();
            if (idx < 0 || idx > poly.getPointCount()) {
                ALog.logError((String)"Attempt to insert a vertex into %s at invalid vertex index %d.", (Object[])new Object[]{ownedGeom.getGeom(), idx});
                return;
            }
            APoint2D newPt = new APoint2D(x, y);
            poly = poly.copy();
            poly.insertPoint(idx, newPt);
            ownedGeom.setGeom((AGeom)poly);
        } else {
            ALog.logError((String)"Inserting a vertex into a %s is not currently supported.", (Object[])new Object[]{g.getName()});
        }
    }

    public static void insertVertex(OwnedGeom<?> ownedGeom, long stX, long stY, long endX, long endY, long ext, int idx) {
        AGeom g = ownedGeom.getGeom();
        if (g instanceof ARect) {
            g = g.toPoly();
        }
        if (g instanceof APolygon) {
            APolygon poly = (APolygon)g;
            poly = poly.makeOpen();
            if (idx < 0 || idx > poly.getPointCount()) {
                ALog.logError((String)"Attempt to insert a vertex into %s at invalid vertex index %d.", (Object[])new Object[]{ownedGeom.getGeom(), idx});
                return;
            }
            APoint2D newPt = ALine.getPointOnSegment((double)stX, (double)stY, (double)endX, (double)endY, (double)ext, (ACircle.RoundDirection)ACircle.RoundDirection.CLOSEST);
            poly = poly.copy();
            poly.insertPoint(idx, newPt);
            ownedGeom.setGeom((AGeom)poly);
        } else {
            ALog.logError((String)"Inserting a vertex into a %s is not currently supported.", (Object[])new Object[]{g.getName()});
        }
    }

    public static boolean deleteVertex(OwnedGeom<?> ownedGeom, int vert) {
        AGeom g = ownedGeom.getGeom();
        if (g instanceof ARect) {
            g = g.toPoly();
        }
        if (g instanceof APolygon) {
            APolygon poly = (APolygon)g;
            poly = poly.makeOpen();
            if (vert < 0 || vert > poly.getPointCount() - 1) {
                ALog.logError((String)"Attempt to delete invalid vertex %d from to %s.", (Object[])new Object[]{vert, ownedGeom.getGeom()});
                return false;
            }
            poly = poly.copy();
            poly.removePoint(vert);
            ownedGeom.setGeom((AGeom)poly);
            return true;
        }
        ALog.logError((String)"Deleting a vertex from a %s is not currently supported.", (Object[])new Object[]{g.getName()});
        return false;
    }

    public static void moveEditPoint(OwnedGeom<?> ownedGeom, int idx, long newX, long newY) {
        if (ownedGeom == null || idx < 0) {
            return;
        }
        AGeom geom = ownedGeom.getGeom();
        if (geom == null) {
            return;
        }
        if (geom instanceof ARect) {
            geom = geom.toPoly();
        }
        if (geom instanceof APolygon) {
            APolygon poly = (APolygon)geom;
            poly = poly.makeOpen();
            poly = poly.copy();
            poly.setPoint(idx, new APoint2D(newX, newY));
            ownedGeom.setGeom((AGeom)poly);
        } else if (geom instanceof ACircle) {
            ACircle c = (ACircle)geom;
            long newR = c.getC().distance(newX, newY);
            c = c.copy();
            c.setR(newR);
            ownedGeom.setGeom((AGeom)c);
        } else {
            ALog.logError((String)"Moving vertices of a %s is not currently supported.", (Object[])new Object[]{geom.getName()});
        }
    }

    public static Optional<APair<Integer, APoint2D>> move(APoint2D[] pts, APoint2D move, NeighborPoints neighbors, SnapAngle snapAngle) {
        if (pts == null || pts.length == 0) {
            return Optional.empty();
        }
        switch (snapAngle) {
            case Orthogonal: {
                return ShapeCommands.moveOrthogonal(pts, move, neighbors);
            }
            case None: {
                for (APoint2D pt : pts) {
                    pt.moveBy(move);
                }
                return Optional.empty();
            }
        }
        assert (false) : "Unknown snap angle option.";
        return Optional.empty();
    }

    public static Optional<APair<Integer, APoint2D>> moveOrthogonal(APoint2D[] pts, APoint2D move, NeighborPoints neighbors) {
        if (pts.length == 1) {
            APoint2D pt = pts[0].add(move);
            if (neighbors.getFirst() != null && neighbors.getSecond() != null) {
                if (((APoint2D)neighbors.getFirst()).getX() == ((APoint2D)neighbors.getSecond()).getX()) {
                    pt.setX(((APoint2D)neighbors.getFirst()).getX());
                    pt.setY(AMathUtil.range((long)pt.getY(), (long)((APoint2D)neighbors.getFirst()).getY(), (long)((APoint2D)neighbors.getSecond()).getY()));
                } else if (((APoint2D)neighbors.getFirst()).getY() == ((APoint2D)neighbors.getSecond()).getY()) {
                    pt.setY(((APoint2D)neighbors.getFirst()).getY());
                    pt.setX(AMathUtil.range((long)pt.getX(), (long)((APoint2D)neighbors.getFirst()).getX(), (long)((APoint2D)neighbors.getSecond()).getX()));
                } else {
                    pt = pt.closest(new APoint2D[]{new APoint2D(((APoint2D)neighbors.getFirst()).getX(), ((APoint2D)neighbors.getSecond()).getY()), new APoint2D(((APoint2D)neighbors.getSecond()).getX(), ((APoint2D)neighbors.getFirst()).getY())});
                }
            } else {
                APoint2D relTo = neighbors.getFirst() != null ? (APoint2D)neighbors.getFirst() : (APoint2D)neighbors.getSecond();
                pt = pt.closest(new APoint2D[]{new APoint2D(relTo.getX(), pt.getY()), new APoint2D(pt.getX(), relTo.getY())});
            }
            pts[0] = pt;
        } else {
            if (pts.length == 2) {
                if (pts[0].equals((Object)pts[1])) {
                    APoint2D[] tempPts = new APoint2D[]{pts[0]};
                    ShapeCommands.moveOrthogonal(tempPts, move, neighbors);
                    pts[1] = tempPts[0];
                    return Optional.empty();
                }
                for (APoint2D pt : pts) {
                    pt.moveBy(move);
                }
                boolean freeOrtho = neighbors.eitherColinear();
                APair result = null;
                if (pts[0].vert(pts[1])) {
                    if (neighbors.getFirst() != null) {
                        if (!neighbors.getFirstColinear()) {
                            pts[0].setY(((APoint2D)neighbors.getFirst()).getY());
                        } else if (freeOrtho) {
                            pts[0].moveBy(0L, -move.getY());
                            result = APair.create((Object)0, (Object)new APoint2D(((APoint2D)neighbors.getFirst()).getX(), pts[0].getY()));
                        }
                    }
                    if (neighbors.getSecond() != null) {
                        if (!neighbors.getSecondColinear()) {
                            pts[1].setY(((APoint2D)neighbors.getSecond()).getY());
                        } else if (freeOrtho) {
                            pts[1].moveBy(0L, -move.getY());
                            result = APair.create((Object)2, (Object)new APoint2D(((APoint2D)neighbors.getSecond()).getX(), pts[1].getY()));
                        }
                    }
                } else if (pts[0].horiz(pts[1])) {
                    if (neighbors.getFirst() != null) {
                        if (!neighbors.getFirstColinear()) {
                            pts[0].setX(((APoint2D)neighbors.getFirst()).getX());
                        } else if (freeOrtho) {
                            pts[0].moveBy(-move.getX(), 0L);
                            result = APair.create((Object)0, (Object)new APoint2D(pts[0].getX(), ((APoint2D)neighbors.getFirst()).getY()));
                        }
                    }
                    if (neighbors.getSecond() != null) {
                        if (!neighbors.getSecondColinear()) {
                            pts[1].setX(((APoint2D)neighbors.getSecond()).getX());
                        } else if (freeOrtho) {
                            pts[1].moveBy(-move.getX(), 0L);
                            result = APair.create((Object)2, (Object)new APoint2D(pts[1].getX(), ((APoint2D)neighbors.getSecond()).getY()));
                        }
                    }
                } else {
                    long dy;
                    long dx = Math.abs(pts[1].xDistance(pts[0]));
                    if (dx <= (dy = Math.abs(pts[1].yDistance(pts[0])))) {
                        pts[1].setX(pts[0].getX());
                    } else {
                        pts[1].setY(pts[0].getY());
                    }
                    ShapeCommands.moveOrthogonal(pts, move, neighbors);
                }
                return result == null ? Optional.empty() : Optional.of(result);
            }
            assert (false) : "Currently can only moveOrthogonal 1 or 2 points.";
        }
        return Optional.empty();
    }

    public static Stream<APoint2D> getEditPoints(AGeom geom) {
        if (geom instanceof ARect) {
            return Arrays.asList(((ARect)geom).getPoints()).stream();
        }
        if (geom instanceof APolygon) {
            APolygon g = ((APolygon)geom).makeOpen();
            return g.getPoints().stream();
        }
        if (geom instanceof ACircle) {
            ACircle c = (ACircle)geom;
            return IntStream.range(0, 8).mapToObj(i -> {
                double a = (double)i / 8.0 * Math.PI * 2.0;
                return new APoint2D((long)((double)(c.getC().getX() + 1L) + (double)c.getR() * Math.cos(a)), (long)((double)c.getC().getY() + (double)c.getR() * Math.sin(a)));
            });
        }
        if (geom instanceof AOctagon) {
            return ((AOctagon)geom).getPoints().stream();
        }
        assert (false);
        ALog.logWarn((String)"Unhandled geometry type %s in ShapeEditMode.EditShapeMode.getScreenGrabPts.", (Object[])new Object[]{geom == null ? null : AReflection.getJavaClassName(geom.getClass())});
        return Stream.empty();
    }

    public static OwnedGeom<Obstacle> createObstacleShape(Db db, Obstacle owner, String layerKey, AGeom geom) {
        Layer layer = (Layer)db.getByKeyStr(Layer.class, layerKey);
        if (layer == null) {
            ALog.logError((String)"Unable to start shape, layer key '%s' is invalid.", (Object[])new Object[]{layerKey});
            return null;
        }
        LayerShape ls = LayerShape.create((Db)db, (Layer)layer, (DbObject)owner, (AGeom)geom);
        return ObstacleGeom.create(ls);
    }

    public static void setObstacleShapeLayer(ObstacleGeom obsGeom, String layerKey) {
        Db db = obsGeom.getDb();
        Layer l = (Layer)db.getByKeyStr(Layer.class, layerKey);
        if (l == null) {
            ALog.logWarn((String)"Layer key '%s' is not valid, can't set Layer.", (Object[])new Object[]{layerKey});
            return;
        }
        obsGeom.setLayer(l);
        ALog.logInfo((String)"Shape layer set to '%s'.", (Object[])new Object[]{l.getName()});
    }

    public static HierGeom<Obstacle> findObstacleShapeAtLoc(Db db, long x, long y, long delta, String devicePath) {
        DevicePath dpath = null;
        if (devicePath != null && (dpath = DevicePath.fromString((Db)db, (String)devicePath)) == null) {
            ALog.logWarn((String)"Path '%s' specified to ShapeCommands.findObstacleShapeAtLoc() is invalid.", (Object[])new Object[]{devicePath});
            return null;
        }
        ARect rect = new ARect(x - delta, y - delta, x + delta, y + delta);
        Selectors.ObstacleLayerShapeSelector selector = new Selectors.ObstacleLayerShapeSelector(SelectionContext.create((Db)db));
        HierInst bestChoice = null;
        for (HierInst hls : selector.getMatching((AGeom)rect, Selection.AreaMode.Touch, null, null)) {
            if (dpath != null && !dpath.equals((Object)hls.getPath())) continue;
            if (bestChoice == null) {
                bestChoice = hls;
                continue;
            }
            bestChoice = selector.getBetter(hls, bestChoice, null);
        }
        if (bestChoice == null) {
            return null;
        }
        LayerShape ols = (LayerShape)bestChoice.getDbObject();
        return HierGeom.create(bestChoice.getPath(), ObstacleGeom.create(ols));
    }

    public static Stream<LayerShape> getObstacleShapes(DevicePath path, long x, long y) {
        ARect r = new ARect(x, y, x, y);
        LinkedList shapes = AUtil.linkedList((Iterator)Selectors.ObstacleLayerShapeSelector.getLayerShapes((DevicePath)path, (ARect)r, (Selection.AreaMode)Selection.AreaMode.Touch));
        Collections.sort(shapes);
        return shapes.stream();
    }

    public static LayerShape getNthObstacleShape(Db db, String devicePath, long x, long y, int n) {
        DevicePath dpath = DevicePath.fromString((Db)db, (String)devicePath);
        if (dpath == null) {
            ALog.logWarn((String)"Path '%s' specified to getNthObstacleShape() is invalid.", (Object[])new Object[]{devicePath});
            return null;
        }
        return ShapeCommands.getObstacleShapes(dpath, x, y).skip(n).findFirst().orElse(null);
    }

    public static Device createDevice(Db db, String parent, String name, APoint2D loc, AGeom geom) {
        assert (db != null);
        assert (geom != null);
        DevicePath parentPath = DevicePath.fromEscapedString((Db)db, (String)parent);
        if (parentPath == null) {
            ALog.logError((String)"Parent path '%s' specified to ShapeCommands.createDevice() is invalid.", (Object[])new Object[]{parent});
            return null;
        }
        DeviceTemplate parentT = parentPath.getDeviceTemplate();
        if (name == null || name.isEmpty()) {
            name = ShapeCommands.getDeviceName(parentT, geom);
        }
        if (parentT.getChild(name) != null) {
            ALog.logError((String)"Device name '%s' specified to ShapeCommands.createDevice() already exists in parent '%s', unable to create Device.", (Object[])new Object[]{name, parent});
            return null;
        }
        Substrate subst = parentT.getSubstrate();
        if (subst == null) {
            subst = Substrate.create((Db)db, (String)"Substrate", (boolean)true);
        }
        String devTName = String.format("%sT", name);
        DeviceTemplate devT = DeviceTemplate.create((Substrate)subst, (String)devTName, (boolean)true);
        devT.setBounds(geom);
        Device device = Device.create((String)name, (DeviceTemplate)devT, (DeviceTemplate)parentT);
        device.setLoc(loc.copy());
        return device;
    }

    public static String getDeviceName(DeviceTemplate parentT, AGeom geom) {
        return ShapeCommands.getDeviceName(parentT, geom == null ? null : geom.getClass());
    }

    public static String getDeviceName(DeviceTemplate parentT, Class<? extends AGeom> geomType) {
        Object devName = AGeom.getName(geomType);
        if (((String)devName).length() > 0) {
            devName = ((String)devName).substring(0, 1).toUpperCase() + ((String)devName).substring(1);
        }
        long i = 0L;
        while (parentT != null) {
            String n = String.format("%s%d", devName, i);
            if (parentT.getChild(n) == null) {
                devName = n;
                break;
            }
            ++i;
        }
        return devName;
    }

    public static HierGeom<DeviceTemplate> findDeviceTemplateShapeAtLoc(Db db, long x, long y, long delta, String parentPath) {
        DevicePath dpath = null;
        if (parentPath != null && (dpath = DevicePath.fromEscapedString((Db)db, (String)parentPath)) == null) {
            ALog.logWarn((String)"Path '%s' specified to ShapeCommands.findDeviceShapeAtLoc() is invalid.", (Object[])new Object[]{parentPath});
            return null;
        }
        ARect rect = new ARect(x - delta, y - delta, x + delta, y + delta);
        Selectors.DeviceSelector selector = new Selectors.DeviceSelector(SelectionContext.create((Db)db));
        HierInst bestChoice = null;
        for (HierInst hiDev : selector.getMatching((AGeom)rect, Selection.AreaMode.Touch, null, null)) {
            Device d;
            if (dpath != null && !dpath.equals((Object)hiDev.getPath()) || (d = (Device)hiDev.getDbObject()) == null || d.getTemplate() == null || d.getTemplate().getBounds() == null) continue;
            if (bestChoice == null) {
                bestChoice = hiDev;
                continue;
            }
            bestChoice = selector.getBetter(hiDev, bestChoice, null);
        }
        if (bestChoice == null) {
            return null;
        }
        Device dev = (Device)bestChoice.getDbObject();
        return HierGeom.create(bestChoice.getPath().withChild(dev), DeviceTemplateGeom.create(dev.getTemplate()));
    }

    public static Stream<OwnedGeom<DeviceTemplate>> getDeviceShapes(DevicePath path, long x, long y) {
        Selectors.DeviceSelector selector = new Selectors.DeviceSelector(SelectionContext.create((Db)path.getDb()));
        ARect area = new ARect(x, y, x, y);
        LinkedList devices = AUtil.linkedList((Iterator)selector.getMatching((AGeom)area, Selection.AreaMode.Touch, null, null));
        Collections.sort(devices);
        return devices.stream().filter(hDev -> hDev.getPath().equals((Object)path)).map(hDev -> {
            Device dev = (Device)hDev.getDbObject();
            return DeviceTemplateGeom.create(dev.getTemplate());
        });
    }

    public static OwnedGeom<DeviceTemplate> getNthDeviceShape(Db db, String path, long x, long y, int n) {
        DevicePath dpath = DevicePath.fromString((Db)db, (String)path);
        if (dpath == null) {
            ALog.logWarn((String)"Path '%s' specified to getNthDeviceShape() is invalid.", (Object[])new Object[]{path});
            return null;
        }
        return ShapeCommands.getDeviceShapes(dpath, x, y).skip(n).findFirst().orElse(null);
    }

    public static class DeviceTemplateGeom
    implements OwnedGeom<DeviceTemplate> {
        protected DeviceTemplate mDevT;

        public static DeviceTemplateGeom create(DeviceTemplate devT) {
            return new DeviceTemplateGeom(devT);
        }

        protected DeviceTemplateGeom(DeviceTemplate devT) {
            this.mDevT = devT;
        }

        @Override
        public AGeom getGeom() {
            return this.mDevT.getBounds();
        }

        @Override
        public void setGeom(AGeom geom) {
            this.mDevT.setBounds(geom);
        }

        @Override
        public DeviceTemplate getOwner() {
            return this.mDevT;
        }

        @Override
        public void delete() {
            this.mDevT.setBounds(null);
        }

        public String toString() {
            return String.format("%s[DeviceTemplate: %s; Geom: %s]@%s", this.getClass().getName(), this.mDevT == null ? null : this.mDevT.getName(), this.getGeom() == null ? null : this.getGeom(), Integer.toHexString(this.hashCode()));
        }
    }

    public static class ObstacleGeom
    implements OwnedGeom<Obstacle> {
        protected LayerShape mLayerShape;

        public static ObstacleGeom create(LayerShape ls) {
            return new ObstacleGeom(ls);
        }

        protected ObstacleGeom(LayerShape ls) {
            assert (ls.getOwner() instanceof Obstacle);
            this.mLayerShape = ls;
        }

        public void setLayer(Layer l) {
            this.mLayerShape.setLayer(l);
        }

        public Layer getLayer() {
            return this.mLayerShape.getLayer();
        }

        @Override
        public AGeom getGeom() {
            return this.mLayerShape.getGeom();
        }

        @Override
        public void setGeom(AGeom geom) {
            this.mLayerShape.setGeom(geom);
        }

        @Override
        public Obstacle getOwner() {
            return (Obstacle)this.mLayerShape.getOwner();
        }

        @Override
        public void delete() {
            Obstacle owner = this.getOwner();
            this.mLayerShape.deleteFromDb();
            if (!owner.getLayerShapes().hasNext()) {
                owner.deleteFromDb();
            }
        }

        public String toString() {
            return String.format("%s[Obstacle: %s; LayerShape: %s]@%s", this.getClass().getName(), this.getOwner(), this.mLayerShape, Integer.toHexString(this.hashCode()));
        }
    }

    public static class NeighborPoints
    extends APair<APoint2D, APoint2D> {
        boolean mFirstColinear;
        boolean mSecondColinear;

        public NeighborPoints(APoint2D first, boolean firstColinear, APoint2D second, boolean secondColinear) {
            super((Object)first, (Object)second);
            this.mFirstColinear = firstColinear;
            this.mSecondColinear = secondColinear;
        }

        public boolean getFirstColinear() {
            return this.mFirstColinear;
        }

        public boolean getSecondColinear() {
            return this.mSecondColinear;
        }

        public boolean eitherColinear() {
            return this.getFirstColinear() || this.getSecondColinear();
        }

        public String toString() {
            return String.format("NeighborPoints[%s %b, %s %b]", this.getFirst(), this.mFirstColinear, this.getSecond(), this.mSecondColinear);
        }

        public boolean equals(Object other) {
            if (!(other instanceof NeighborPoints)) {
                return false;
            }
            NeighborPoints o = (NeighborPoints)((Object)other);
            return super.equals(other) && this.mFirstColinear == o.mFirstColinear && this.mSecondColinear == o.mSecondColinear;
        }

        public int hashCode() {
            return super.hashCode() ^ (this.mFirstColinear ? 1 : 0) ^ (this.mSecondColinear ? 1 : 0);
        }
    }

    public static enum SnapAngle {
        None,
        Orthogonal;

    }

    public static class HierGeom<T extends DbObject>
    implements OwnedGeom<T> {
        protected DevicePath mPath;
        protected OwnedGeom<T> mOwnedGeom;

        public static <T extends DbObject> HierGeom<T> create(DevicePath path, OwnedGeom<T> g) {
            return new HierGeom<T>(path, g);
        }

        public HierGeom(DevicePath path, OwnedGeom<T> ownedGeom) {
            this.mPath = path;
            this.mOwnedGeom = ownedGeom;
        }

        public DevicePath getPath() {
            return this.mPath;
        }

        public OwnedGeom<T> getOwnedGeom() {
            return this.mOwnedGeom;
        }

        public AffineTransform getPathTransform() {
            return this.getPath().getTransform();
        }

        @Override
        public AGeom getGeom() {
            return this.mOwnedGeom.getGeom();
        }

        @Override
        public void setGeom(AGeom geom) {
            this.mOwnedGeom.setGeom(geom);
        }

        @Override
        public T getOwner() {
            return this.mOwnedGeom.getOwner();
        }

        @Override
        public void delete() {
            this.mOwnedGeom.delete();
        }

        public String toString() {
            return String.format("%s[OwnedGeom: %s; Path: %s]@%s", this.getClass().getName(), this.mOwnedGeom, this.mPath == null ? null : this.mPath.escapedString(), Integer.toHexString(this.hashCode()));
        }
    }

    public static interface OwnedGeom<T extends DbObject> {
        public AGeom getGeom();

        public void setGeom(AGeom var1);

        public T getOwner();

        public void delete();

        default public Db getDb() {
            return this.getOwner() == null ? null : this.getOwner().getDb();
        }
    }
}

