/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.cmd;

import com.sigrity.acl.AIterableItr;
import com.sigrity.acl.ALog;
import com.sigrity.acl.APair;
import com.sigrity.acl.AUtil;
import com.sigrity.acl.IterableIterator;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.Selection;
import com.sigrity.acl.db.SelectionContext;
import com.sigrity.acl.db.Selectors;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Layer;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.NetObject;
import com.sigrity.acl.db.std.PadTemplate;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.acl.db.std.PortTemplate;
import com.sigrity.acl.db.std.Substrate;
import com.sigrity.acl.db.std.Wire;
import com.sigrity.acl.geom.AGeom;
import com.sigrity.acl.geom.APath;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.acl.geom.ARect;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.HierInst;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.ui.core.DesignView2D;
import com.sigrity.orbit.ui.core.ViewColorizer;
import com.sigrity.orbit.util.PhysicalNetUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;

public class WireCommands {
    private WireCommands() {
    }

    public static IterableIterator<Wire> getWires(DevicePath path, long x, long y) {
        ARect r = new ARect(x, y, x, y);
        LinkedList wires = AUtil.linkedList((Iterator)Selectors.WireSelector.getWires((DevicePath)path, (AGeom)r, (Selection.AreaMode)Selection.AreaMode.Touch));
        Collections.sort(wires, Wire.StableComparator);
        return AIterableItr.itr((Collection)wires);
    }

    public static Wire getNthWire(Db db, String devicePath, long x, long y, int n) {
        DevicePath dpath = DevicePath.fromString((Db)db, (String)devicePath);
        if (dpath == null) {
            ALog.logWarn((String)"Path '%s' specified to getNthWire() is invalid.", (Object[])new Object[]{devicePath});
            return null;
        }
        int i = 0;
        for (Wire w : WireCommands.getWires(dpath, x, y)) {
            if (i == n) {
                return w;
            }
            ++i;
        }
        return null;
    }

    public static HierInst<Wire> findWireAtLoc(DesignView2D view, long x, long y, long delta, String devicePath) {
        Db db = view.getDb();
        if (db == null) {
            assert (false);
            return null;
        }
        DevicePath dpath = null;
        if (devicePath != null && (dpath = DevicePath.fromString((Db)db, (String)devicePath)) == null) {
            ALog.logWarn((String)"Path '%s' specified to WireCommands.findWireAtLoc() is invalid.", (Object[])new Object[]{devicePath});
            return null;
        }
        ViewColorizer colorizer = view.getCanvas().getColorizer();
        ARect rect = new ARect(x - delta, y - delta, x + delta, y + delta);
        Selectors.WireSelector selector = new Selectors.WireSelector(SelectionContext.create((Db)db));
        HierInst bestChoice = null;
        for (HierInst hw : selector.getMatching((AGeom)rect, Selection.AreaMode.Touch, null, null)) {
            if (dpath != null && !dpath.equals((Object)hw.getPath()) || colorizer.getColor(dpath, (Wire)hw.getDbObject()) == null) continue;
            if (bestChoice == null) {
                bestChoice = hw;
                continue;
            }
            bestChoice = selector.getBetter(hw, bestChoice, null);
        }
        if (bestChoice == null) {
            return null;
        }
        return new HierInst(bestChoice.getPath(), (DbObject)((Wire)bestChoice.getDbObject()));
    }

    public static Wire createWire(Db db, String devTmpltKeyStr, String netName, String layerName) {
        DeviceTemplate dt = (DeviceTemplate)db.getByKeyStr(DeviceTemplate.class, devTmpltKeyStr);
        if (dt == null) {
            ALog.logError((String)"Unable to start wire, device template '%s' is invalid.", (Object[])new Object[]{devTmpltKeyStr});
            return null;
        }
        Net net = Net.get((DeviceTemplate)dt, (String)netName);
        if (net == null) {
            ALog.logError((String)"Unable to start wire, net '%s' on device template '%s' is invalid.", (Object[])new Object[]{netName, devTmpltKeyStr});
            return null;
        }
        Layer layer = Layer.get((Db)db, (Substrate)dt.getSubstrate(), (String)layerName);
        if (layer == null) {
            ALog.logError((String)"Unable to start wire, layer '%s' on device template '%s' is invalid.", (Object[])new Object[]{layerName, devTmpltKeyStr});
            return null;
        }
        APath path = new APath();
        Wire wire = Wire.create((Net)net, (Layer)layer, (APath)path);
        if (wire != null && (layer.getType() == null || layer.getType() == Layer.LayerType.Unknown)) {
            layer.setType(Layer.LayerType.Signal);
        }
        return wire;
    }

    public static void setWireWidth(Wire wire, long width) {
        if (wire == null) {
            return;
        }
        wire.setWidth(width);
    }

    public static void setWireNet(Wire wire, String netName) {
        DeviceTemplate dt = wire.getDeviceTemplate();
        if (dt == null) {
            ALog.logWarn((String)"Unable to determine DeviceTemplate for specified Wire, can't set Net.");
            return;
        }
        Net n = dt.getNet(netName);
        if (n == null) {
            ALog.logWarn((String)"Unable to find Net '%s' on DeviceTemplate '%s' for specified Wire,can't set the Net.", (Object[])new Object[]{netName, dt.getName()});
            return;
        }
        wire.setNet(n);
        ALog.logInfo((String)"Wire net set to '%s'.", (Object[])new Object[]{n.getName()});
    }

    public static void setWireLayer(Wire wire, String layer) {
        DeviceTemplate dt = wire.getDeviceTemplate();
        if (dt == null) {
            ALog.logWarn((String)"Unable to determine DeviceTemplate for specified Wire, can't set Layer.");
            return;
        }
        Substrate s = dt.getSubstrate();
        if (s == null) {
            ALog.logWarn((String)"Unable to determine Substrate for specified Wire, can't set Layer.");
            return;
        }
        Layer l = s.getLayer(layer);
        if (l == null) {
            ALog.logWarn((String)"Layer '%s' is not valid for specified Wire, can't set Layer.", (Object[])new Object[]{layer});
            return;
        }
        wire.setLayer(l);
        if (l.getType() == null || l.getType() == Layer.LayerType.Unknown) {
            l.setType(Layer.LayerType.Signal);
        }
        ALog.logInfo((String)"Wire layer set to '%s'.", (Object[])new Object[]{layer});
    }

    public static void addWirePoint(Wire wire, long x, long y) {
        APath path = wire.getPath().copy();
        path.addPoint(x, y);
        wire.setPath(path);
    }

    public static void insertWireVertex(Wire wire, int vertexIndex, long x, long y) {
        APath path = wire.getPath().copy();
        path.insertPoint(vertexIndex, new APoint2D(x, y));
        wire.setPath(path);
    }

    public static void moveWireVertex(Wire wire, int vertexIndex, long x, long y) {
        HierInst hViaPort = wire.getViaPin(vertexIndex);
        APath path = wire.getPath().copy();
        path.setPoint(vertexIndex, new APoint2D(x, y));
        wire.setPath(path);
        if (hViaPort == null || ((PortTemplate)hViaPort.second).getDeviceTemplate() != wire.getDeviceTemplate()) {
            return;
        }
        LinkedList<APair> connWireVertices = new LinkedList<APair>();
        for (APair wv : ((PortTemplate)hViaPort.second).getConnectedWires()) {
            if (wv.first == wire) continue;
            connWireVertices.add(wv);
        }
        ((PortTemplate)hViaPort.second).setLoc(new APoint2D(x, y));
        for (APair wv : connWireVertices) {
            Wire connWire = (Wire)wv.first;
            APath cwp = connWire.getPath().copy();
            cwp.setPoint(((Integer)wv.second).intValue(), new APoint2D(x, y));
            connWire.setPath(cwp);
        }
    }

    public static PortTemplate addVia(Wire wire, int vertexIndex, String padTemplateKey) {
        if (wire == null) {
            ALog.logError((String)"Wire must be specified to WireCommands.addVia().");
            return null;
        }
        Db db = wire.getDb();
        APath path = wire.getPath();
        APoint2D pt = path.getPoint(vertexIndex);
        if (pt == null) {
            ALog.logError((String)"Invalid vertexIndex '%d' specified to WireCommands.addVia(), the specified Wire has %d vertices.", (Object[])new Object[]{vertexIndex, path.getPointCount()});
            return null;
        }
        pt = pt.copy();
        PadTemplate padT = PadTemplate.get((Db)db, (Substrate)wire.getSubstrate(), (String)padTemplateKey);
        if (padT == null) {
            ALog.logError((String)"Invalid padTemplateKey '%s' specified to WireCommands.addVia().", (Object[])new Object[]{padTemplateKey});
            return null;
        }
        Net net = wire.getNet();
        PinTemplate pinT = PinTemplate.create((Net)net, (String)"WireVia");
        pinT.setType(PinTemplate.Type.VIA);
        PortTemplate portT = PortTemplate.create((PinTemplate)pinT);
        portT.setPadTemplate(padT);
        portT.setLoc(pt);
        pinT.createPinInstances();
        return portT;
    }

    public static void deleteWireVertex(Wire wire, int vertexIndex) {
        APath path = wire.getPath().copy();
        if (path.getPointCount() < 2) {
            WireCommands.deleteWire(wire);
        } else {
            path.removePointAt(vertexIndex);
            wire.setPath(path);
        }
    }

    public static void duplicateWireVertex(Wire wire, int vertexIndex) {
        APath path = wire.getPath().copy();
        path.insertPoint(vertexIndex, path.getPoint(vertexIndex).copy());
        wire.setPath(path);
    }

    public static void deleteWire(Wire wire) {
        wire.deleteFromDb();
    }

    public static void markSelectedAsType(String strType) {
        WireCommands.markSelectedAsType(OrbitIO.getCurDb(), strType);
    }

    public static void markSelectedAsType(Db db, String strType) {
        Wire.Type type = Wire.Type.valueOf((String)strType);
        if (type == null) {
            ALog.logError((String)"Invalid type '%s' specified.", (Object[])new Object[]{strType});
            return;
        }
        Selection s = Selection.getCurrentSelectionForDb((Db)db);
        if (s == null) {
            ALog.logError((String)"Unable to get the current selection for the specified Db '%s'.", (Object[])new Object[]{db.getDescription(false)});
            return;
        }
        int i = 0;
        for (Wire w : s.get(Wire.class)) {
            if (w.getType() == type) continue;
            w.setType(type);
            ++i;
        }
        ALog.logInfo((String)"Type changed to '%s' on %d wires.", (Object[])new Object[]{strType, i});
    }

    public static boolean connects(Wire w, PinTemplate.Type t1, PinTemplate.Type t2) {
        if (w.getPinA() == null || w.getPinB() == null) {
            return false;
        }
        PinTemplate.Type w1 = ((PinTemplate)w.getPinA().second).getType();
        PinTemplate.Type w2 = ((PinTemplate)w.getPinB().second).getType();
        return w1 == t1 && w2 == t2 || w1 == t2 && w2 == t1;
    }

    public static long wireCountBetween(PinTemplate.Type t1, PinTemplate.Type t2) {
        Db db = OrbitIO.getCurDb();
        return db.getObjects(Wire.class).stream().filter(w -> WireCommands.connects(w, t1, t2)).count();
    }

    public static void delSelWires() {
        Wire.deleteSelected((Db)OrbitIO.getCurDb());
        OrbitIO.getApp().refreshCurrentView(false);
    }

    public static void deleteWire(Db db, String wireKeyStr) {
        Wire wire = (Wire)db.getByKeyStr(Wire.class, wireKeyStr);
        if (wire != null) {
            wire.deleteFromDb();
        }
    }

    public static List<Wire> getAllBondWires() {
        Db db = OrbitIO.getCurDb();
        LinkedList<Wire> wires = new LinkedList<Wire>();
        for (Wire w : db.getObjects(Wire.class)) {
            if (w.getType() != Wire.Type.BOND) continue;
            wires.add(w);
        }
        return wires;
    }

    public static HierInst<PortTemplate> getDiePadOrFinger(Wire w, boolean pad) {
        if (w == null || w.getType() != Wire.Type.BOND) {
            return null;
        }
        PinTemplate pt = (PinTemplate)w.getPinA().second;
        DevicePath dp = pt.getDeviceTemplate().getPathToPresentUser();
        if (pt.getType() != PinTemplate.Type.WIREEND) {
            return null;
        }
        List list = PhysicalNetUtil.getPhysConn((NetObject)pt, (DevicePath)dp).collect(Collectors.toCollection(LinkedList::new));
        for (HierInst hno : list) {
            DevicePath path = (DevicePath)hno.first;
            NetObject o = (NetObject)hno.second;
            if (!(o instanceof PinTemplate)) continue;
            PinTemplate pinT = (PinTemplate)o;
            if (pad && pinT != pt && (pinT.getType() == PinTemplate.Type.IOPAD || pinT.getType() == PinTemplate.Type.BUMPPAD || pinT.getType() == PinTemplate.Type.WIREBONDPAD)) {
                return HierInst.create((DevicePath)path, (DbObject)pinT.getFirstPortTemplate());
            }
            if (pad || pinT == pt || pinT.getType() != PinTemplate.Type.BONDFINGERPAD) continue;
            return HierInst.create((DevicePath)path, (DbObject)pinT.getFirstPortTemplate());
        }
        return null;
    }

    public static HierInst<PortTemplate> getFromPinOrToPin(Wire w, boolean fromPin) {
        if (w == null || w.getType() != Wire.Type.BOND) {
            return null;
        }
        PinTemplate pt = fromPin ? (PinTemplate)w.getPinA().second : (PinTemplate)w.getPinB().second;
        DevicePath dp = pt.getDeviceTemplate().getPathToPresentUser();
        if (pt.getType() == PinTemplate.Type.IOPAD || pt.getType() == PinTemplate.Type.BUMPPAD || pt.getType() == PinTemplate.Type.WIREBONDPAD || pt.getType() == PinTemplate.Type.BONDFINGERPAD) {
            return HierInst.create((DevicePath)dp, (DbObject)pt.getFirstPortTemplate());
        }
        if (pt.getType() != PinTemplate.Type.WIREEND) {
            return null;
        }
        List list = PhysicalNetUtil.getPhysConn((NetObject)pt, (DevicePath)dp).collect(Collectors.toCollection(LinkedList::new));
        for (HierInst hno : list) {
            PinTemplate pinT;
            DevicePath path = (DevicePath)hno.first;
            NetObject o = (NetObject)hno.second;
            if (!(o instanceof PinTemplate) || (pinT = (PinTemplate)o) == pt || pinT.getType() != PinTemplate.Type.IOPAD && pinT.getType() != PinTemplate.Type.BUMPPAD && pinT.getType() != PinTemplate.Type.WIREBONDPAD) continue;
            return HierInst.create((DevicePath)path, (DbObject)pinT.getFirstPortTemplate());
        }
        return null;
    }

    public static void printAllWirebonds() {
        for (Wire w : WireCommands.getAllBondWires()) {
            HierInst<PortTemplate> fromPin = WireCommands.getFromPinOrToPin(w, true);
            HierInst<PortTemplate> toPin = WireCommands.getFromPinOrToPin(w, false);
            if (fromPin == null || toPin == null) {
                ALog.logWarn((String)"Cannot find the wire '%s' from port '%s', to port '%s'", (Object[])new Object[]{w, fromPin, toPin});
                continue;
            }
            ALog.logInfo((String)("Wire: " + w.getName() + " From DevicePath: " + fromPin.first + " DiePad:" + ((PortTemplate)fromPin.getDbObject()).getKeyStr() + " To DevicePath:" + toPin.first + " Finger: " + ((PortTemplate)toPin.getDbObject()).getKeyStr()));
        }
    }

    public static void selectAllWires() {
        Db db = OrbitIO.getCurDb();
        Selection selection = Selection.getCurrentSelectionForDb((Db)db);
        for (Wire wire : db.getObjects(Wire.class)) {
            selection.add((DbObject)wire);
        }
    }
}

