/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.colView;

import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.edaMgrs.NameGenerator;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.acl.geom.ARect;
import com.sigrity.orbit.colView.ColData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

public class ColView {
    public static final String ShowTemplateNames = "ColView.showTemplateNames";
    public static final String ShowInstanceNames = "ColView.showInstanceNames";
    public static final String ShowGapValues = "ColView.showGapValues";
    public static final String ShowDimensions = "ColView.showDimensions";
    public static ColView TheColView = null;
    protected static int MAXCOLS = 16;
    protected DeviceTemplate dieTemplate = null;
    protected ArrayList<ColData> columns = new ArrayList();

    public ColView(DeviceTemplate dieTemplate) {
        TheColView = this;
        this.dieTemplate = dieTemplate;
        this.columns.clear();
    }

    public DeviceTemplate getDieTemplate() {
        return this.dieTemplate;
    }

    public ArrayList<ColData> getColumns() {
        return this.columns;
    }

    public int getColumnCount() {
        int max = 0;
        for (int i = 0; i < MAXCOLS; ++i) {
            Long d = (Long)this.dieTemplate.getValue(ColView.colToName(i) + ".inset");
            if (d == null) {
                return max;
            }
            max = i + 1;
        }
        return max;
    }

    public void addColumn() {
        ColData cd = new ColData();
        cd.alignLeft = true;
        cd.inset = this.dieTemplate.getBounds(true).getBounds().width() / 5L * (long)this.getColumnCount();
        this.columns.add(cd);
        this.saveColumnAttributesToDieTemplate();
    }

    public void saveColumnAttributesToDieTemplate() {
        this.clearColumnAttributesDieData();
        int ith = 0;
        for (ColData c : this.columns) {
            this.dieTemplate.setValue(ColView.colToName(ith) + ".inset", (Object)c.inset);
            this.dieTemplate.setValue(ColView.colToName(ith) + ".leftAligned", (Object)c.alignLeft);
            ++ith;
        }
    }

    public ColData getColumn(String name) {
        for (ColData cd : this.columns) {
            if (!cd.name.equals(name)) continue;
            return cd;
        }
        return null;
    }

    protected void restoreColumnAttributesFromDieTemplate() {
        this.columns.clear();
        int count = this.getColumnCount();
        for (int i = 0; i < count; ++i) {
            String name = ColView.colToName(i);
            Long d = (Long)this.dieTemplate.getValue(name + ".inset");
            Boolean b = (Boolean)this.dieTemplate.getValue(name + ".leftAligned");
            ColData cd = new ColData();
            cd.alignLeft = b;
            cd.inset = d;
            cd.name = name;
            this.columns.add(cd);
        }
    }

    protected void clearColumnAttributesDieData() {
        for (int i = 0; i < MAXCOLS; ++i) {
            this.dieTemplate.unsetSoftValue(ColView.colToName(i) + ".inset");
            this.dieTemplate.unsetSoftValue(ColView.colToName(i) + ".leftAligned");
        }
    }

    public void insert(Device d, int column, int position) {
        if (position < 0) {
            this.columns.get(column).add(d);
        } else if (position < this.columns.get(column).size()) {
            this.columns.get(column).add(position, d);
        } else {
            this.columns.get(column).add(d);
        }
    }

    public void remove(int column, int position) {
        this.columns.get(column).remove(position);
    }

    public void updateDataBaseFromColView() {
        this.renameCells();
        for (ColData c : this.columns) {
            long x = c.inset;
            long y = this.dieTemplate.getBB().top();
            int row = 0;
            for (Device d : c) {
                long dy;
                if (d == null) continue;
                long myHeight = d.getBB().height();
                long myWidth = d.getBB().width();
                if (c.alignLeft) {
                    x = d.getParent().getBB().left() + c.inset;
                    dy = myHeight + this.getGap(row);
                    this.putDevLLAt(d, new APoint2D(x, y - dy));
                    y -= dy;
                } else {
                    x = this.dieTemplate.getBB().right() - myWidth - c.inset;
                    dy = myHeight + this.getGap(row);
                    this.putDevLLAt(d, new APoint2D(x, y - dy));
                    y -= dy;
                }
                ++row;
            }
        }
    }

    protected void putDevLLAt(Device d, APoint2D ll) {
        d.setLoc(ll);
        ARect bb = d.getLocalBB();
        long xOff = ll.getX() - bb.getLL().getX();
        long yOff = ll.getY() - bb.getLL().getY();
        APoint2D newPos = new APoint2D();
        newPos.setX(ll.getX() + xOff);
        newPos.setY(ll.getY() + yOff);
        d.setLoc(newPos);
    }

    public void makeColViewFromDataBase() {
        this.makeColViewFromDataBase(true);
    }

    public void makeColViewFromDataBase(boolean save) {
        this.restoreColumnAttributesFromDieTemplate();
        for (Device d : this.dieTemplate.getChildren()) {
            boolean foundColumn = false;
            for (ColData col : this.columns) {
                if (col.alignLeft) {
                    if (d.getBB().getLL().getX() == col.inset) {
                        col.add(d);
                        foundColumn = true;
                    }
                } else if (d.getParent().getBB().right() - d.getBB().getUR().getX() == col.inset) {
                    col.add(d);
                    foundColumn = true;
                }
                if (!foundColumn) continue;
                break;
            }
            if (foundColumn) continue;
            ColData c = new ColData();
            c.add(d);
            long dLeft = d.getBB().getLL().getX();
            long dRight = d.getParent().getBB().right() - d.getBB().getUR().getX();
            if (dLeft < dRight) {
                c.alignLeft = true;
                c.inset = dLeft;
            } else {
                c.alignLeft = false;
                c.inset = dRight;
            }
            this.columns.add(c);
        }
        for (ColData c : this.columns) {
            Collections.sort(c, new ColumnYSorter());
        }
        Collections.sort(this.columns, new ColumnsXSorter());
        this.renameColumns();
        if (save) {
            this.saveColumnAttributesToDieTemplate();
        }
    }

    static String colToName(int num) {
        return "Column." + num;
    }

    protected long getGap(int r) {
        Long g = (Long)this.dieTemplate.getValue(this.rowToName(r) + ".gap");
        if (g == null) {
            return 0L;
        }
        return g;
    }

    String rowToName(int ith) {
        return "Row." + ith;
    }

    public void setGap(int row, long g) {
        this.dieTemplate.setValue(this.rowToName(row) + ".gap", (Object)g);
    }

    protected void renameColumns() {
        int col = 0;
        for (ColData cd : this.columns) {
            cd.name = ColView.colToName(col);
            ++col;
        }
    }

    protected void renameCells() {
        int maxRows = 0;
        NameGenerator ng = new NameGenerator("c", false);
        for (ColData cd : this.columns) {
            for (Device d : cd) {
                d.setName(Device.getNextArrayName((DeviceTemplate)d.getParent(), (NameGenerator)ng));
            }
            int rows = cd.size();
            maxRows = Math.max(maxRows, rows);
        }
        int col = 0;
        for (ColData cd : this.columns) {
            int row = 0;
            for (Device d : cd) {
                String rowVal = "" + row;
                if (maxRows > 10 && row < 10) {
                    rowVal = "0" + row;
                }
                d.setName("c_" + col + "_" + rowVal);
                ++row;
            }
            ++col;
        }
    }

    class ColumnsXSorter
    implements Comparator<ColData> {
        ColumnsXSorter() {
        }

        @Override
        public int compare(ColData c1, ColData c2) {
            long c2x;
            long c1x = c1.alignLeft ? c1.inset : ColView.this.dieTemplate.getBB().right() - c1.inset;
            if (c1x < (c2x = c2.alignLeft ? c2.inset : ColView.this.dieTemplate.getBB().right() - c2.inset)) {
                return -1;
            }
            if (c2x < c1x) {
                return 1;
            }
            c1x = ColView.this.columns.indexOf(c1);
            if (c1x < (c2x = (long)ColView.this.columns.indexOf(c2))) {
                return -1;
            }
            if (c2x < c1x) {
                return 1;
            }
            return 0;
        }
    }

    class ColumnYSorter
    implements Comparator<Device> {
        ColumnYSorter() {
        }

        @Override
        public int compare(Device d1, Device d2) {
            return Long.compare(d2.getBB().getLL().getY(), d1.getBB().getLL().getY());
        }
    }
}

