/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.colView;

import com.sigrity.acl.Unit;
import com.sigrity.acl.app.AAppView;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.ui.AButtonGroup;
import com.sigrity.acl.ui.ADialog;
import com.sigrity.acl.ui.AFieldValidator;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.colView.ColData;
import com.sigrity.orbit.colView.ColView;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.HeadlessException;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class ColViewColEditDlg
extends ADialog {
    protected AAppView mView;
    protected JTextField mLeftEdgeDistance;
    protected JTextField mRightEdgeDistance;
    protected ButtonGroup mAlignGroup = new AButtonGroup();
    protected JRadioButton mLeftAligned;
    protected JRadioButton mRightAligned;
    protected int mIth;
    protected ColData mAccepted;
    protected ActionListener mOk = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            Db db = OrbitIO.getCurDb();
            Design currentDesign = Design.getDesign((Db)db);
            Unit.Distance unit = currentDesign.getUnit();
            ColViewColEditDlg.this.mAccepted = ColView.TheColView.columns.get(ColViewColEditDlg.this.mIth);
            ColViewColEditDlg.this.mAccepted.setAlignLeft(ColViewColEditDlg.this.mLeftAligned.isSelected());
            long d = 0L;
            if (ColViewColEditDlg.this.mLeftAligned.isSelected()) {
                if (!ColViewColEditDlg.this.mLeftEdgeDistance.getText().isEmpty()) {
                    try {
                        AFieldValidator.validateDouble((JTextField)ColViewColEditDlg.this.mLeftEdgeDistance);
                    }
                    catch (AFieldValidator.AFieldValidationException ve) {
                        return;
                    }
                    d = unit.fromUser(Double.parseDouble(ColViewColEditDlg.this.mLeftEdgeDistance.getText().replace(",", "")));
                }
            } else if (!ColViewColEditDlg.this.mRightEdgeDistance.getText().isEmpty()) {
                try {
                    AFieldValidator.validateDouble((JTextField)ColViewColEditDlg.this.mRightEdgeDistance);
                }
                catch (AFieldValidator.AFieldValidationException ve) {
                    return;
                }
                d = unit.fromUser(Double.parseDouble(ColViewColEditDlg.this.mRightEdgeDistance.getText().replace(",", "")));
            }
            ColViewColEditDlg.this.mAccepted.setInset(d);
            UIUtil.closeWindow((Window)((Object)ColViewColEditDlg.this));
        }
    };

    public static ColViewColEditDlg createDialog(Window owner, boolean create, int ith) {
        ColViewColEditDlg dlg = null;
        dlg = new ColViewColEditDlg(owner);
        dlg.init(create, ith);
        return dlg;
    }

    public ColViewColEditDlg(Window owner) throws HeadlessException {
        super(owner);
    }

    public ColData getAccepted() {
        return this.mAccepted;
    }

    protected void init(boolean create, int ith) {
        this.mView = OrbitIO.getCurView();
        this.mIth = ith;
        this.setTitle("Edit Column ");
        this.setModal(true);
        GridBagManager l = new GridBagManager(this.getContentPane());
        l.pushFill();
        this.mLeftAligned = new JRadioButton("Align Left");
        this.mLeftEdgeDistance = new JTextField(10);
        this.mRightAligned = new JRadioButton("Align Right");
        this.mRightEdgeDistance = new JTextField(10);
        l.add((Component)this.mLeftAligned, (GridBagConstraints)GridBagManager.FILLX_REMAINX);
        l.newline();
        l.add("Inset from left edge of  die:");
        l.add((Component)this.mLeftEdgeDistance);
        l.newline();
        l.add((Component)this.mRightAligned, (GridBagConstraints)GridBagManager.FILLX_REMAINX);
        l.newline();
        l.add("Inset from right edge of die:");
        l.add((Component)this.mRightEdgeDistance);
        this.mAlignGroup.add(this.mLeftAligned);
        this.mAlignGroup.add(this.mRightAligned);
        l.pop();
        l.newline();
        l.push((Container)new JPanel(), (GridBagConstraints)GridBagManager.RIGHT_REMAINX);
        JButton btnOk = new JButton("OK");
        l.add((Component)btnOk, (GridBagConstraints)GridBagManager.RIGHT);
        btnOk.addActionListener(this.mOk);
        JButton btnClose = new JButton("Cancel");
        l.add((Component)btnClose, (GridBagConstraints)GridBagManager.RIGHT);
        l.pop();
        UIUtil.enableEscCloseDefaultMinSize((JDialog)((Object)this), (AbstractButton)btnClose, (JButton)btnOk);
        this.pack();
        this.setMinimumSize(this.getPreferredSize());
        this.updateUI();
        UIUtil.center((Component)((Object)this));
        this.enableUI();
        this.mLeftAligned.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ColViewColEditDlg.this.enableUI();
            }
        });
        this.mRightAligned.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ColViewColEditDlg.this.enableUI();
            }
        });
    }

    protected void enableUI() {
        if (this.mLeftAligned.isSelected()) {
            this.mLeftEdgeDistance.setEnabled(true);
            this.mRightEdgeDistance.setEnabled(false);
        } else {
            this.mLeftEdgeDistance.setEnabled(false);
            this.mRightEdgeDistance.setEnabled(true);
        }
    }

    protected void updateUI() {
        Unit unit = Design.getUnit((Db)OrbitIO.getCurDb());
        ColData cd = ColView.TheColView.columns.get(this.mIth);
        long d = cd.inset;
        if (cd.isAlignLeft()) {
            this.mLeftAligned.setSelected(true);
            this.mLeftEdgeDistance.setText(unit.toUserStr(d));
        } else {
            this.mRightAligned.setSelected(true);
            this.mRightEdgeDistance.setText(unit.toUserStr(d));
        }
    }

    protected void populateControl() {
    }
}

