/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.colView;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.sigrity.acl.AColor;
import com.sigrity.acl.ALog;
import com.sigrity.acl.app.AAppView;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Substrate;
import com.sigrity.acl.ui.ADialog;
import com.sigrity.acl.ui.AList;
import com.sigrity.acl.ui.AListModel;
import com.sigrity.acl.ui.DbDialog;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.acl.ui.RegexFilterField;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.ui.OrbitIcons;
import com.sigrity.tools.dbexplorer.DbExplorerPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.regex.Pattern;
import javax.swing.AbstractButton;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;

public class ColViewEditCellDlg
extends DbDialog {
    protected AAppView mView;
    protected JComboBox<DeviceTemplate> mCboTemplate;
    protected boolean create = false;
    protected CellInfo mAccepted = null;
    protected Device mEditMe;
    protected DeviceTemplate mParentTemplate;
    protected JComboBox<DeviceTemplate.DefTransform> mSouthTransform;
    protected String STARTNAME = "cell.0";
    protected ActionListener mOk = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            ColViewEditCellDlg.this.mAccepted = new CellInfo();
            ColViewEditCellDlg.this.mAccepted.make();
            UIUtil.closeWindow((Window)((Object)ColViewEditCellDlg.this));
        }
    };
    protected ActionListener mDoSelectTemplateDlg = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            SelectTemplateDialog dlg = new SelectTemplateDialog();
            if (dlg.doModal()) {
                ColViewEditCellDlg.this.mCboTemplate.setSelectedItem(dlg.getSelectedTemplate());
            }
        }
    };

    public static ColViewEditCellDlg createDialog(Window owner, Db db, boolean create, DeviceTemplate parentTemplate, Device editMe) {
        ColViewEditCellDlg dlg = null;
        dlg = new ColViewEditCellDlg(db, owner);
        dlg.init(create, parentTemplate, editMe);
        return dlg;
    }

    public ColViewEditCellDlg(Db db, Window owner) throws HeadlessException {
        super(db, (Component)owner);
    }

    public CellInfo getAccepted() {
        return this.mAccepted;
    }

    protected void init(boolean create, DeviceTemplate parentTemplate, Device editMe) {
        this.mParentTemplate = parentTemplate;
        this.mEditMe = editMe;
        this.mView = OrbitIO.getCurView();
        this.create = create;
        if (create) {
            this.setTitle("Create " + this.STARTNAME);
        } else {
            this.setTitle("Edit " + editMe.getName());
        }
        this.setModal(true);
        GridBagManager l = new GridBagManager(this.getContentPane());
        l.pushFillX();
        l.pushFillX();
        this.mCboTemplate = (JComboBox)l.add(new JComboBox(), (GridBagConstraints)GridBagManager.FILLX);
        this.mCboTemplate.setRenderer(new IOCellTemplateRenderer());
        JButton btnSearchLefTemplate = (JButton)l.add((Component)new JButton("Search..."));
        Font btnFont = btnSearchLefTemplate.getFont();
        btnSearchLefTemplate.setFont(btnFont.deriveFont((float)btnFont.getSize() - 2.0f));
        btnSearchLefTemplate.setMargin(new Insets(2, 2, 2, 2));
        btnSearchLefTemplate.addActionListener(this.mDoSelectTemplateDlg);
        l.pop();
        l.newline();
        l.pushNoFill();
        l.pop();
        l.newline();
        l.newline();
        l.push("Attribute", (GridBagConstraints)GridBagManager.LEFT);
        l.add("Orientation");
        this.mSouthTransform = new JComboBox();
        this.mSouthTransform.setRenderer(new TransformRenderer());
        l.addNl(this.mSouthTransform);
        l.pop();
        l.newline();
        l.push((Container)new JPanel(), (GridBagConstraints)GridBagManager.RIGHT_REMAINX);
        JButton btnOk = new JButton("OK");
        l.add((Component)btnOk, (GridBagConstraints)GridBagManager.RIGHT);
        btnOk.addActionListener(this.mOk);
        JButton btnClose = new JButton("Cancel");
        l.add((Component)btnClose, (GridBagConstraints)GridBagManager.RIGHT);
        l.pop();
        this.updateUI();
        UIUtil.enableEscCloseDefaultMinSize((JDialog)((Object)this), (AbstractButton)btnClose, (JButton)btnOk);
        this.pack();
        this.setMinimumSize(this.getPreferredSize());
        UIUtil.center((Component)((Object)this));
    }

    public void addNotify() {
        super.addNotify();
        this.updateUI();
    }

    protected void updateUI() {
        this.mSouthTransform.removeAllItems();
        for (DeviceTemplate.DefTransform defTransform : DeviceTemplate.DefTransform.values()) {
            this.mSouthTransform.addItem(defTransform);
        }
        this.mCboTemplate.removeAllItems();
        int numMembers = 0;
        LinkedList<DeviceTemplate> list = this.getValidTemplates();
        for (DeviceTemplate deviceTemplate : list) {
            this.mCboTemplate.addItem(deviceTemplate);
            ++numMembers;
        }
        DeviceTemplate myT = null;
        if (this.create) {
            if (numMembers > 0) {
                this.mCboTemplate.setSelectedIndex(0);
            } else {
                ALog.logWarn((String)"There does not seem to be any Device Template defined in the substrate");
            }
        } else {
            myT = this.mEditMe.getTemplate();
            int n = this.mCboTemplate.getItemCount();
            if (myT != null) {
                for (int i = 0; i < n; ++i) {
                    if (this.mCboTemplate.getItemAt(i) != myT) continue;
                    this.mCboTemplate.setSelectedIndex(i);
                }
            } else {
                return;
            }
            DeviceTemplate.DefTransform df = this.mEditMe.getMyDefTransform();
            this.mSouthTransform.setSelectedItem(df);
        }
    }

    protected LinkedList<DeviceTemplate> getValidTemplates() {
        Substrate s = this.mParentTemplate.getSubstrate();
        LinkedList<DeviceTemplate> sortedList = new LinkedList<DeviceTemplate>();
        for (DeviceTemplate t : this.mDb.getObjects(DeviceTemplate.class)) {
            if (t.getSubstrate() != s || t.getType() != DeviceTemplate.Type.COVER) continue;
            sortedList.add(t);
        }
        Collections.sort(sortedList, new TemplateSorter());
        return sortedList;
    }

    protected class SelectTemplateDialog
    extends ADialog {
        protected JRadioButton mRbHighlight;
        protected JRadioButton mRbFilter;
        protected RegexFilterField mFilterField;
        protected BiMap<DeviceTemplate.Type, JCheckBox> mTemplateTypeCheckBoxes;
        protected AList<DeviceTemplate> mLstTemplates;
        protected AListModel<DeviceTemplate> mLstModelTemplates;
        protected LinkedList<DeviceTemplate> mAllTemplates;
        protected LinkedHashSet<DeviceTemplate> mSelectedTemplates;
        protected boolean mOK;
        protected Color mHighlightColor;
        protected ActionListener mOkListener;
        protected RegexFilterField.FilterListener mFilterListener;
        ActionListener mFilterHighlightChanged;

        public SelectTemplateDialog() {
            super(ColViewEditCellDlg.this.mCboTemplate);
            this.mTemplateTypeCheckBoxes = HashBiMap.create();
            this.mAllTemplates = ColViewEditCellDlg.this.getValidTemplates();
            this.mOK = false;
            this.mHighlightColor = new Color(0x77FF77);
            this.mOkListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SelectTemplateDialog.this.mOK = true;
                    UIUtil.closeWindow((Window)((Object)SelectTemplateDialog.this));
                }
            };
            this.mFilterListener = new RegexFilterField.FilterListener(){

                public void filter(Pattern pattern) {
                    int oldSel = SelectTemplateDialog.this.mLstTemplates.getSelectedIndex();
                    LinkedList<DeviceTemplate> included = new LinkedList<DeviceTemplate>();
                    SelectTemplateDialog.this.mSelectedTemplates = new LinkedHashSet();
                    for (DeviceTemplate t : SelectTemplateDialog.this.mAllTemplates) {
                        if (!SelectTemplateDialog.this.includeByType(t) || !SelectTemplateDialog.this.includeByPattern(pattern, t)) continue;
                        included.add(t);
                    }
                    SelectTemplateDialog.this.mLstModelTemplates.setContents(included);
                    if (oldSel >= included.size()) {
                        oldSel = -1;
                    }
                    if (!SelectTemplateDialog.this.mRbHighlight.isSelected()) {
                        SelectTemplateDialog.this.mSelectedTemplates = null;
                        if (oldSel < 0 && SelectTemplateDialog.this.mLstModelTemplates.getSize() > 0) {
                            SelectTemplateDialog.this.mLstTemplates.setSelectedIndex(0);
                            SelectTemplateDialog.this.mLstTemplates.ensureIndexIsVisible(0);
                        }
                    } else {
                        for (DeviceTemplate t : included) {
                            if (pattern != null && !pattern.matcher(t.getName()).matches()) continue;
                            SelectTemplateDialog.this.mSelectedTemplates.add(t);
                        }
                        if (!(SelectTemplateDialog.this.mSelectedTemplates.size() <= 0 || oldSel > 0 && SelectTemplateDialog.this.mSelectedTemplates.contains(included.get(oldSel)))) {
                            DeviceTemplate firstSel = (DeviceTemplate)SelectTemplateDialog.this.mSelectedTemplates.iterator().next();
                            int i = SelectTemplateDialog.this.mLstModelTemplates.indexOf(firstSel);
                            SelectTemplateDialog.this.mLstTemplates.setSelectedIndex(i);
                            SelectTemplateDialog.this.mLstTemplates.ensureIndexIsVisible(i);
                        }
                        SelectTemplateDialog.this.repaint();
                    }
                }
            };
            this.mFilterHighlightChanged = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SelectTemplateDialog.this.mFilterField.updateFilteredData();
                    SelectTemplateDialog.this.mLstTemplates.repaint();
                }
            };
            this.setModal(true);
            this.setTitle("Select Template");
            GridBagManager l = GridBagManager.layout((JDialog)((Object)this));
            Insets indentInsets = new Insets(0, 12, 0, 0);
            l.push("Search Options", (GridBagConstraints)GridBagManager.FILLX_REMAINX.noInsets());
            l.add("Show types:");
            l.newline();
            l.push((GridBagConstraints)GridBagManager.LEFT_REMAINX.insets(indentInsets));
            Insets in = new Insets(0, 0, 0, 0);
            GridBagManager.GridBagConstraintsEx cs = GridBagManager.LEFT.insets(in);
            l.add((Component)this.createTemplateTypeCheckBox(DeviceTemplate.Type.COVER), (GridBagConstraints)cs);
            l.add((Component)this.createTemplateTypeCheckBox(DeviceTemplate.Type.RING), (GridBagConstraints)cs);
            l.add((Component)this.createTemplateTypeCheckBox(DeviceTemplate.Type.BLOCK), (GridBagConstraints)cs);
            l.add((Component)this.createTemplateTypeCheckBox(DeviceTemplate.Type.PAD), (GridBagConstraints)cs);
            l.newline();
            l.add((Component)this.createTemplateTypeCheckBox(DeviceTemplate.Type.ENDCAP), (GridBagConstraints)cs);
            l.add((Component)this.createTemplateTypeCheckBox(DeviceTemplate.Type.CORE), (GridBagConstraints)cs);
            l.add((Component)this.createTemplateTypeCheckBox(DeviceTemplate.Type.BUMP), (GridBagConstraints)cs);
            l.add((Component)this.createTemplateTypeCheckBox(DeviceTemplate.Type.MACRO), (GridBagConstraints)cs);
            l.newline();
            l.add((Component)this.createTemplateTypeCheckBox(DeviceTemplate.Type.STDCELL), (GridBagConstraints)cs);
            l.pop();
            l.addFillX();
            l.newline();
            l.push((GridBagConstraints)GridBagManager.FILLX_REMAINX.noInsets());
            l.add("Pattern:");
            this.mFilterField = (RegexFilterField)l.add((Component)new RegexFilterField(this.mFilterListener), (GridBagConstraints)GridBagManager.FILLX.noInsets());
            l.newline();
            l.push((GridBagConstraints)GridBagManager.LEFT_REMAINX.insets(indentInsets));
            l.add("Use pattern to: ");
            this.mRbFilter = (JRadioButton)l.add((Component)new JRadioButton("Filter"), (GridBagConstraints)GridBagManager.LEFT.noInsets());
            this.mRbHighlight = (JRadioButton)l.add((Component)new JRadioButton("Highlight"), (GridBagConstraints)GridBagManager.LEFT.noInsets());
            UIUtil.groupButtons((AbstractButton[])new AbstractButton[]{this.mRbFilter, this.mRbHighlight});
            this.mRbFilter.addActionListener(this.mFilterHighlightChanged);
            this.mRbHighlight.addActionListener(this.mFilterHighlightChanged);
            this.mRbFilter.setSelected(true);
            l.pop();
            l.pop();
            l.popNl();
            l.addNl("Select Template:");
            this.mLstTemplates = new AList();
            l.add((Component)new JScrollPane(this.mLstTemplates), (GridBagConstraints)GridBagManager.FILLALL_REMAINX);
            this.mLstModelTemplates = new AListModel<DeviceTemplate>(this.mAllTemplates);
            this.mLstTemplates.setModel(this.mLstModelTemplates);
            this.mLstTemplates.setSelectionMode(0);
            this.mLstTemplates.setCellRenderer(new IOCellTemplateRenderer(){

                @Override
                public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    Component c = super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                    if (SelectTemplateDialog.this.mRbHighlight.isSelected() && (SelectTemplateDialog.this.mSelectedTemplates == null || SelectTemplateDialog.this.mSelectedTemplates.contains(value))) {
                        Color bg = AColor.mix((Color)c.getBackground(), (Color)SelectTemplateDialog.this.mHighlightColor, (float)0.66f);
                        c.setBackground(bg);
                    }
                    return c;
                }
            });
            this.mLstTemplates.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getButton() == 1 && e.getClickCount() == 2) {
                        SelectTemplateDialog.this.mOkListener.actionPerformed(new ActionEvent(e.getSource(), 1001, "DoubleClick", e.getWhen(), e.getModifiers()));
                    }
                }
            });
            l.newline();
            l.pushFillXRemainX();
            l.addFillX();
            JButton btnOK = (JButton)l.add((Component)new JButton("OK"));
            JButton btnCancel = (JButton)l.add((Component)new JButton("Cancel"));
            l.pop();
            UIUtil.enableEscCloseDefaultMinSize((JDialog)((Object)this), (AbstractButton)btnCancel, (JButton)btnOK);
            this.pack();
            UIUtil.center((Component)((Object)this));
            btnOK.addActionListener(this.mOkListener);
        }

        public void addNotify() {
            super.addNotify();
            this.mFilterField.requestFocus();
        }

        public boolean doModal() {
            this.mLstTemplates.setSelectedValue(ColViewEditCellDlg.this.mCboTemplate.getSelectedItem(), true);
            this.setVisible(true);
            return this.mOK;
        }

        public DeviceTemplate getSelectedTemplate() {
            if (!this.mOK) {
                return null;
            }
            return (DeviceTemplate)this.mLstTemplates.getSelectedValue();
        }

        protected JCheckBox createTemplateTypeCheckBox(DeviceTemplate.Type dtt) {
            JCheckBox cb = new JCheckBox(dtt.name(), true);
            cb.addActionListener(this.mFilterHighlightChanged);
            this.mTemplateTypeCheckBoxes.put((Object)dtt, (Object)cb);
            return cb;
        }

        protected boolean includeByType(DeviceTemplate t) {
            JCheckBox cb = (JCheckBox)this.mTemplateTypeCheckBoxes.get((Object)t.getType());
            if (cb == null) {
                return false;
            }
            return cb.isSelected();
        }

        protected boolean includeByPattern(Pattern pattern, DeviceTemplate t) {
            if (!this.mRbFilter.isSelected()) {
                return true;
            }
            return pattern == null || pattern.matcher(t.getName()).matches();
        }
    }

    public static class IOCellTemplateRenderer
    extends DefaultListCellRenderer {
        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            DeviceTemplate t = (DeviceTemplate)value;
            if (t == null) {
                this.setText(" ");
                return this;
            }
            this.setIcon(DbExplorerPanel.getIconForTemplate(t));
            this.setText(t.getName());
            String ttt = String.format("(%s) There are %d instances on Substrate %s", t.getType().toString(), t.getDeviceInstanceCount(), t.getSubstrate().getName());
            this.setToolTipText(ttt);
            return this;
        }
    }

    public static class TransformRenderer
    extends DefaultListCellRenderer {
        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            DeviceTemplate.DefTransform t = (DeviceTemplate.DefTransform)value;
            if (t == null) {
                t = DeviceTemplate.DefTransform.N;
            }
            this.setText(t.shortDescriptor());
            this.setIcon(OrbitIcons.getDefTransformIcon(t));
            return this;
        }
    }

    public class CellInfo {
        DeviceTemplate mTemplate;
        long mGap;
        DeviceTemplate.DefTransform mTransform;

        protected void make() {
            this.mTemplate = (DeviceTemplate)ColViewEditCellDlg.this.mCboTemplate.getSelectedItem();
            this.mTransform = (DeviceTemplate.DefTransform)ColViewEditCellDlg.this.mSouthTransform.getSelectedItem();
        }
    }

    public static class TemplateSorter
    implements Comparator<DeviceTemplate> {
        @Override
        public int compare(DeviceTemplate dt0, DeviceTemplate dt1) {
            int usage1;
            int usage0 = dt0.getDeviceInstanceCount();
            if (usage0 > (usage1 = dt1.getDeviceInstanceCount())) {
                return -1;
            }
            if (usage1 > usage0) {
                return 1;
            }
            int c = dt0.getType().compareTo((Enum)dt1.getType());
            if (c == 0) {
                c = dt0.getName().compareTo(dt1.getName());
            }
            return c;
        }
    }
}

