/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.colView;

import com.sigrity.acl.app.Settings;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.geom.AGeomUtil;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.colView.ColData;
import com.sigrity.orbit.colView.ColView;
import com.sigrity.orbit.ui.DeviceDimensionUI;
import com.sigrity.orbit.ui.core.DesignCanvas2D;
import com.sigrity.orbit.ui.core.DesignView2D;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import javax.swing.JComponent;

public class ColViewOverlay
extends JComponent {
    DeviceTemplate die = null;
    boolean mDrawing = false;
    Graphics2D g;
    protected static final long ARROWWIDTH = Design.getDefaultUnitDist().fromUser(400.0);
    protected static final int MIN_ARROWWIDTH = 1;
    protected static final int MAX_ARROWWIDTH = 4;
    protected static final long LINESPACING = Design.getDefaultUnitDist().fromUser(200.0);
    protected static final int MIN_LINESPACING = 0;
    protected static final int MAX_LINESPACING = 10;
    protected static final long ARROWHEIGHT = Design.getDefaultUnitDist().fromUser(1200.0);
    protected static final int MIN_ARROWHEIGHT = 1;
    protected static final int MAX_ARROWHEIGHT = 8;
    protected static final long ARROWLINELEN = Design.getDefaultUnitDist().fromUser(2000.0);
    protected static final int MIN_ARROWLINELEN = 0;
    protected static final int MAX_ARROWLINELEN = 12;

    @Override
    public void addNotify() {
        super.addNotify();
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
    }

    protected Font selectFitFont(Graphics2D g, Rectangle bounds, String str) {
        int oldSize = g.getFont().getSize();
        float fsize = UIUtil.getFontSizeToFitText((Graphics2D)g, (String)str, (Rectangle2D)bounds);
        Font oldFont = null;
        if (fsize >= 6.0f) {
            fsize = Math.min((float)oldSize, fsize);
            Font f = g.getFont();
            f = f.deriveFont(fsize);
            oldFont = g.getFont();
            g.setFont(f);
        }
        return oldFont;
    }

    protected void drawDimensionLine(Graphics2D g, APoint2D p1, APoint2D p2) {
        Font oldFont;
        DesignView2D view = (DesignView2D)OrbitIO.getCurView();
        AffineTransform oldTransform = g.getTransform();
        DesignCanvas2D.XForm screenForm = view.getCanvas().getXForm();
        Point pt1 = screenForm.getScreenPt(p1);
        Point pt2 = screenForm.getScreenPt(p2);
        if (pt1.x > pt2.x) {
            Point pt3 = (Point)pt1.clone();
            pt1.setLocation(pt2);
            pt2.setLocation(pt3);
        }
        long dx = p2.getX() - p1.getX();
        long dy = p2.getY() - p1.getY();
        Design design = Design.getDesign((Db)OrbitIO.getCurDb());
        String microLen = String.format("%.02f", Math.sqrt((double)dx * (double)dx + (double)dy * (double)dy) / (double)((int)design.getInternalPerMicron()));
        dx = (int)(pt2.getX() - pt1.getX());
        dy = (int)(pt2.getY() - pt1.getY());
        int pixelLen = (int)Math.sqrt((double)dx * (double)dx + (double)dy * (double)dy);
        double at = dx != 0L ? Math.atan((double)dy / (double)dx) : (dy < 0L ? -1.5707963267948966 : 1.5707963267948966);
        g.rotate(at, (int)pt1.getX(), (int)pt1.getY());
        pt2 = new Point((int)pt1.getX() + pixelLen, (int)pt1.getY());
        FontMetrics metrics = g.getFontMetrics();
        int capHeight = metrics.getHeight();
        int capWidth = metrics.charsWidth(microLen.toCharArray(), 0, microLen.length());
        int lenAH = DeviceDimensionUI.microToPixel(view, ARROWHEIGHT, 1, 8);
        int lenALine = DeviceDimensionUI.microToPixel(view, ARROWLINELEN, 0, 12);
        boolean changeDirec = capWidth + lenAH * 2 + 2 > pixelLen;
        Font font = oldFont = changeDirec ? this.selectFitFont(g, new Rectangle(0, 0, pixelLen, capHeight), microLen) : null;
        if (oldFont != null) {
            metrics = g.getFontMetrics();
            capHeight = metrics.getHeight();
            capWidth = metrics.charsWidth(microLen.toCharArray(), 0, microLen.length());
        }
        int xCaption = (int)pt1.getX() + (pixelLen - capWidth) / 2;
        int yCaption = (int)pt1.getY();
        int yLine = yCaption - capHeight / 2;
        if (!changeDirec) {
            int l = changeDirec ? 1 : lenAH + lenALine + 1;
            g.drawLine(pt1.x + l, yLine, xCaption, yLine);
            g.drawLine(xCaption + capWidth, yLine, pt2.x - l, yLine);
        }
        if (!changeDirec || changeDirec && oldFont != null) {
            AffineTransform t = g.getTransform();
            g.setTransform(oldTransform);
            if (at == 0.0) {
                g.rotate(0.0, (int)pt1.getX(), (int)pt1.getY());
                g.drawString(microLen, xCaption, yCaption);
            } else {
                g.translate(pt1.getX() - (double)capWidth / 2.0, (double)yCaption + (double)dy / 2.0);
                g.drawString(microLen, 0, 0);
            }
            g.setTransform(t);
        }
        Point ptArrow1 = new Point(pt1.x, yLine);
        Point ptArrow2 = new Point(pt2.x, yLine);
        DesignCanvas2D.drawArrow(view, g, ptArrow1, changeDirec ? AGeomUtil.Orient.E : AGeomUtil.Orient.W);
        DesignCanvas2D.drawArrow(view, g, ptArrow2, changeDirec ? AGeomUtil.Orient.W : AGeomUtil.Orient.E);
        g.setTransform(oldTransform);
        if (oldFont != null) {
            g.setFont(oldFont);
        }
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        if (this.mDrawing) {
            return;
        }
        this.g = (Graphics2D)graphics;
        DesignView2D view = (DesignView2D)OrbitIO.getCurView();
        if (view == null) {
            return;
        }
        ColView cv = ColView.TheColView;
        if (cv == null) {
            return;
        }
        Settings userPrefs = Settings.getSettings((String)"UserPreferences");
        Boolean showDimensions = (Boolean)userPrefs.getSetting("ColView.showDimensions", (Object)false);
        if (!showDimensions.booleanValue()) {
            return;
        }
        this.mDrawing = true;
        DeviceTemplate dt = cv.dieTemplate;
        DevicePath dp = dt.getAnInstance().getADevicePath();
        int colLeft = 0;
        int colRight = 0;
        for (ColData cd : cv.columns) {
            long y;
            long dx = cd.inset;
            if (!cd.alignLeft) {
                dx = dt.getBB().width() - cd.inset;
            }
            APoint2D top = dp.transformPt(new APoint2D(dt.getBB().left() + dx, dt.getBB().top()));
            APoint2D bot = dp.transformPt(new APoint2D(dt.getBB().left() + dx, dt.getBB().bottom()));
            DesignCanvas2D.XForm w2s = view.getCanvas().getXForm();
            Point p0 = w2s.getScreenPt(top);
            Point p1 = w2s.getScreenPt(bot);
            if (cd.alignLeft) {
                y = dt.getBB().top() + (long)colLeft * Design.getDefaultUnitDist().fromUser(400.0);
                this.g.setStroke(new BasicStroke(3.0f, 0, 1));
                this.g.setColor(Color.green);
                this.g.drawLine(p0.x, p0.y, p1.x, p1.y);
                APoint2D left = dp.transformPt(new APoint2D(dt.getBB().left(), y));
                APoint2D right = dp.transformPt(new APoint2D(dt.getBB().left() + dx, y));
                if (left.distance(right) < 10000L) continue;
                this.g.setStroke(new BasicStroke(1.0f, 0, 1));
                this.g.setColor(Color.black);
                this.drawDimensionLine(this.g, left, right);
                ++colLeft;
                continue;
            }
            y = dt.getBB().top() + (long)colRight * Design.getDefaultUnitDist().fromUser(400.0);
            this.g.setStroke(new BasicStroke(3.0f, 0, 1));
            this.g.setColor(Color.cyan);
            this.g.drawLine(p0.x, p0.y, p1.x, p1.y);
            APoint2D right = dp.transformPt(new APoint2D(dt.getBB().right(), y));
            APoint2D left = dp.transformPt(new APoint2D(dt.getBB().left() + dx, y));
            if (left.distance(right) < 10000L) continue;
            this.g.setStroke(new BasicStroke(1.0f, 0, 1));
            this.g.setColor(Color.black);
            this.drawDimensionLine(this.g, left, right);
            ++colRight;
        }
        int maxRow = 0;
        long maxHeight = 0L;
        for (ColData cd : cv.columns) {
            maxRow = Math.max(maxRow, cd.size());
            for (Device d : cd) {
                maxHeight = Math.max(maxHeight, d.getBB().height());
            }
        }
        this.g.setStroke(new BasicStroke(1.0f, 0, 1));
        this.g.setColor(Color.black);
        for (ColData cd : cv.columns) {
            long y = dt.getBB().top();
            int row = 0;
            long x = cd.getInset();
            if (!cd.alignLeft) {
                x = dt.getBB().right() - x;
            }
            boolean first = true;
            for (Device d : cd) {
                y -= cv.getGap(row);
                y -= d.getBB().height();
                if (first) {
                    x = cd.alignLeft ? (x += d.getBB().width() / 2L) : (x -= d.getBB().width() / 2L);
                    first = false;
                }
                ++row;
            }
            long bot = dt.getBB().bottom();
            this.g.setColor(Color.black);
            if (y - bot <= 0L) continue;
            this.drawDimensionLine(this.g, new APoint2D(x, y), new APoint2D(x, bot));
        }
        long dy = 0L;
        for (int r = 0; r < maxRow; ++r) {
            long gap = cv.getGap(r);
            if (gap > 0L) {
                APoint2D top = dp.transformPt(new APoint2D(dt.getBB().left() - 20000L, dt.getBB().top() - dy));
                APoint2D bot = dp.transformPt(new APoint2D(dt.getBB().left() - 20000L, dt.getBB().top() - (dy + gap)));
                this.g.setStroke(new BasicStroke(1.0f, 0, 1));
                this.g.setColor(Color.black);
                this.drawDimensionLine(this.g, bot, top);
            }
            dy = dy + gap + maxHeight;
        }
        this.mDrawing = false;
    }
}

