/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.colView;

import bibliothek.gui.dock.common.CControl;
import bibliothek.gui.dock.common.CLocation;
import bibliothek.gui.dock.common.DefaultSingleCDockable;
import bibliothek.gui.dock.common.SingleCDockable;
import bibliothek.gui.dock.common.SingleCDockableFactory;
import bibliothek.gui.dock.common.action.CAction;
import bibliothek.gui.dock.common.location.TreeLocationRoot;
import com.sigrity.acl.ALog;
import com.sigrity.acl.AUtil;
import com.sigrity.acl.Unit;
import com.sigrity.acl.app.AAppView;
import com.sigrity.acl.app.Settings;
import com.sigrity.acl.app.ViewAdapter;
import com.sigrity.acl.app.ViewListener;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbClass;
import com.sigrity.acl.db.DbHistory;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.acl.ui.AFileChooser;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.acl.ui.RegexFilterField;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.acl.ui.atree.ALazyTreeNode;
import com.sigrity.acl.ui.atree.ATreeCellRenderer;
import com.sigrity.acl.ui.atree.ATreeModel;
import com.sigrity.decorators.DieDecorator;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.automation.BumpFactoryData;
import com.sigrity.orbit.colView.ColData;
import com.sigrity.orbit.colView.ColView;
import com.sigrity.orbit.colView.ColViewColEditDlg;
import com.sigrity.orbit.colView.ColViewDecorator;
import com.sigrity.orbit.colView.ColViewDecoratorRegistry;
import com.sigrity.orbit.colView.ColViewEditCellDlg;
import com.sigrity.orbit.colView.ColViewOverlay;
import com.sigrity.orbit.colView.ColViewPreferencesDlg;
import com.sigrity.orbit.colView.ColViewSetGapDlg;
import com.sigrity.orbit.ui.DbObjectDetailsUI;
import com.sigrity.orbit.ui.ExternalDeviceUpdateListener;
import com.sigrity.orbit.ui.OrbitIcons;
import com.sigrity.orbit.ui.OrbitLibrarySerializerUI;
import com.sigrity.orbit.ui.PatternPlacementUI;
import com.sigrity.orbit.ui.core.DesignView2D;
import com.sigrity.orbit.ui.core.DesignView3D;
import com.sigrity.orbit.ui.core.OrbitGuiWS;
import com.sigrity.tools.dbexplorer.DBEResources;
import com.sigrity.tools.dbexplorer.DbExplorerPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.Autoscroll;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DropMode;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.ToolTipManager;
import javax.swing.TransferHandler;
import javax.swing.plaf.ColorUIResource;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class ColViewPanel
extends JPanel {
    protected static boolean IsRegistered = false;
    protected static ColViewPanel ThePanel = null;
    protected static ColViewOverlay cvo = null;
    protected static ViewListener TheViewListener = null;
    protected static Db.DbListener TheDbListener = null;
    protected static ExternalDeviceUpdateListener.ListenerInterface TheUpdateListener;
    protected static Db TheDb;
    protected static HistoryListener historyListener;
    protected static ExternalAddInfo externalAddState;
    protected static SingleCDockableFactory DockableFactory;
    protected AAppView mView = null;
    protected ColView mColView = null;
    protected DeviceTemplate mDieTemplate = null;
    protected RegexFilterField findField;
    protected JLabel findResults;
    protected TreeSearcher treeSearcher;
    protected ColViewTree colViewTree;
    protected JScrollPane sp;
    protected RootNode rn;
    protected ArrayList<String> lastExpandedSet = new ArrayList();
    protected boolean refreshPending = false;
    protected ActionListener mNextResultAction = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            ColViewPanel.this.treeSearcher.next();
        }
    };
    protected ActionListener mPrevResultAction = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            ColViewPanel.this.treeSearcher.back();
        }
    };
    protected RegexFilterField.FilterListener mFilterListener = new RegexFilterField.FilterListener(){

        public void filter(Pattern pattern) {
            if (pattern != null) {
                if (ColViewPanel.this.treeSearcher.getLastPattern() == null || !ColViewPanel.this.treeSearcher.getLastPattern().pattern().equals(pattern.pattern())) {
                    ColViewPanel.this.treeSearcher.searchFor(pattern);
                } else {
                    ColViewPanel.this.treeSearcher.next();
                }
            }
        }
    };
    protected DbClass.DbObjectListener mDboListener = new DbClass.DbObjectAdapter(){

        public void addedObject(DbClass.ObjectAdd add) {
        }

        public void removedObject(DbClass.ObjectRemove remove) {
        }

        public void changedObject(DbClass.ObjectChange change) {
        }
    };
    protected Action clone = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            TreePath treePath = ColViewPanel.this.colViewTree.getSelectionPath();
            if (treePath == null) {
                return;
            }
            if (treePath.getLastPathComponent() instanceof CellNode) {
                CellNode cn = (CellNode)((Object)treePath.getLastPathComponent());
                int[] selectionRow = ColViewPanel.this.colViewTree.getSelectionRows();
                int col = cn.colNum;
                int pos = cn.ith + 1;
                Device d = cn.d;
                DeviceTemplate dt = d.getTemplate();
                String name = d.getName();
                DeviceTemplate.DefTransform theXForm = d.getMyDefTransform();
                Cp.exec((String)"com.sigrity.orbit.colView.ColViewPanel.cCreateCell (\"%s\", \"%s\", \"%s\",\"%s\", %d, %d);", (Object[])new Object[]{name, dt.getKeyStr(), ColViewPanel.this.mDieTemplate.getKeyStr(), theXForm.name(), col, pos});
                ColViewPanel.this.colViewTree.setSelectionRow(selectionRow[0]);
                ThePanel.refreshTree();
                OrbitIO.getOrbitIO().refreshCurrentView(false);
            }
        }
    };
    public static final DataFlavor DeviceBlockDataFlavor;
    public static final DataFlavor[] SupportedDataFlavors;
    JPopupMenu mColTreePopupMenuForCell = new JPopupMenu(){
        {
            this.add("Delete", new DelCellCommand(), "Delete", UIUtil.getIcon(DbObjectDetailsUI.class, (String)"res/iconDelete.png"));
            this.add("Clone", new CloneCellCommand(), "Clone", UIUtil.getIcon(DbObjectDetailsUI.class, (String)"res/iconAdd.png"));
            this.add("Protect DeviceTemplate", new ProtectDeviceTemplateCommand(), "Change the protection status of this Device's template", DBEResources.ICON_STOP);
            this.add("Insert Gap", new EditGapCommand(), "Edit", UIUtil.getIcon(DbObjectDetailsUI.class, (String)"res/iconEdit.png"));
            this.add("Edit Cell Attributes ", new EditCellCommand(), "Change the template or transform of the cell", UIUtil.getIcon(DbObjectDetailsUI.class, (String)"res/iconEdit.png"));
            this.add("Edit Bump Pattern", new EditBumpPattern(), "Edit Bump Pattern", UIUtil.getIcon(DbObjectDetailsUI.class, (String)"res/iconEdit.png"));
        }

        protected JMenuItem add(String text, ActionListener listener, String toolTip, Icon icon) {
            JMenuItem jmi = this.add(new JMenuItem(text));
            jmi.addActionListener(listener);
            if (toolTip != null) {
                jmi.setToolTipText(toolTip);
            }
            if (icon != null) {
                jmi.setIcon(icon);
            }
            return jmi;
        }

        @Override
        public void show(Component invoker, int x, int y) {
            super.show(invoker, x, y);
        }
    };
    JPopupMenu mColTreePopupMenuForColumn = new JPopupMenu(){
        {
            this.add("Add cell from template", new AddCellCommand(), "", UIUtil.getIcon(DbObjectDetailsUI.class, (String)"res/iconAdd.png"));
            this.add("Add cell from ratio driven", new AddRatioCellCommand(), "", UIUtil.getIcon(DbObjectDetailsUI.class, (String)"res/iconAdd.png"));
            this.addSeparator();
            this.add("Edit Column Attributes", new EditColumnCommand(), "", UIUtil.getIcon(DbObjectDetailsUI.class, (String)"res/iconEdit.png"));
            this.addSeparator();
            this.add("Delete Column and Devices", new DelColumnCommand(), "", UIUtil.getIcon(DbObjectDetailsUI.class, (String)"res/iconDelete.png"));
        }

        protected JMenuItem add(String text, ActionListener listener, String toolTip, Icon icon) {
            JMenuItem jmi = this.add(new JMenuItem(text));
            jmi.addActionListener(listener);
            if (toolTip != null) {
                jmi.setToolTipText(toolTip);
            }
            if (icon != null) {
                jmi.setIcon(icon);
            }
            return jmi;
        }

        @Override
        public void show(Component invoker, int x, int y) {
            super.show(invoker, x, y);
        }
    };
    JPopupMenu mColTreePopupMenuForRoot = new JPopupMenu(){
        {
            this.add("Add A Column", new AddColumnCommand(), "add a column", UIUtil.getIcon(DbObjectDetailsUI.class, (String)"res/iconAdd.png"));
            this.addSeparator();
            JMenu decorate = new JMenu("Decorate Die With");
            this.add(decorate);
            this.add("Preferences..", new PreferencesCommand(), "show preferences menu", DBEResources.ICON_COG_EDIT);
            for (ColViewDecorator cvd : ColViewDecoratorRegistry.getDecorators()) {
                JMenuItem p1 = new JMenuItem(cvd.name());
                p1.setToolTipText(cvd.toolTip());
                p1.addActionListener(new DoDecorationCommand(cvd));
                decorate.add(p1);
            }
            this.addSeparator();
            this.add("Import directory of templates", new ImportDirectory(ColViewPanel.this.mDieTemplate), "read all .oios in a directory ", null);
            this.addSeparator();
            this.add("Update Screen From Tree", new UpdateColCommand(), "Use this to refresh the screen", null);
        }

        protected JMenuItem add(String text, ActionListener listener, String toolTip, Icon icon) {
            JMenuItem jmi = this.add(new JMenuItem(text));
            jmi.addActionListener(listener);
            if (toolTip != null) {
                jmi.setToolTipText(toolTip);
            }
            if (icon != null) {
                jmi.setIcon(icon);
            }
            return jmi;
        }

        @Override
        public void show(Component invoker, int x, int y) {
            super.show(invoker, x, y);
        }
    };
    protected ColViewTree.PopupMenuHandler mTreePopupMenuHandler = new ColViewTree.PopupMenuHandler(){

        @Override
        public void handlePopup(int x, int y) {
            TreePath[] treePaths = ColViewPanel.this.colViewTree.getSelectionPaths();
            if (treePaths == null || treePaths.length <= 1) {
                int row = ColViewPanel.this.colViewTree.getRowForLocation(x, y);
                ColViewPanel.this.colViewTree.setSelectionRow(row);
                TreePath treePath = ColViewPanel.this.colViewTree.getSelectionPath();
                if (treePath == null) {
                    return;
                }
                if (treePath.getLastPathComponent() instanceof RootNode) {
                    ColViewPanel.this.mColTreePopupMenuForRoot.show(ColViewPanel.this.colViewTree, x, y);
                } else if (treePath.getLastPathComponent() instanceof ColNode) {
                    ColViewPanel.this.mColTreePopupMenuForColumn.show(ColViewPanel.this.colViewTree, x, y);
                } else if (treePath.getLastPathComponent() instanceof CellNode) {
                    ColViewPanel.this.mColTreePopupMenuForCell.show(ColViewPanel.this.colViewTree, x, y);
                }
            }
        }
    };

    protected static OrbitGuiWS getWorkspace() {
        OrbitIO app = OrbitIO.getOrbitIO();
        return app == null ? null : app.getWorkspace();
    }

    public static void show(DevicePath devicePath) {
        OrbitGuiWS ws;
        TheDb = devicePath.getDb();
        if (IsRegistered) {
            ColViewPanel.setPanelVisible(false, devicePath);
        }
        if ((ws = ColViewPanel.getWorkspace()) == null) {
            return;
        }
        DesignView2D v2 = (DesignView2D)OrbitIO.getCurView();
        cvo = new ColViewOverlay();
        v2.addOverlay(cvo);
        CControl dockControl = ws.getDockingController();
        dockControl.addSingleDockableFactory(ColViewPanel.class.getName(), DockableFactory);
        IsRegistered = true;
        TheViewListener = new ViewAdapter(){

            public void activeViewChanged(AAppView oldView, AAppView newView) {
                ColViewPanel.notifyViewChange();
                OrbitGuiWS ws = ColViewPanel.getWorkspace();
                if (ws == null) {
                    return;
                }
                ws.setSingleDockableVisible(ThePanel, false, new OrbitGuiWS.OnDockClosed(){

                    @Override
                    public void closed() {
                        ThePanel = null;
                    }
                });
            }
        };
        TheDbListener = new Db.DbListenerAdapter(){

            public void dbObjectListenerStateChange(Db db, boolean listenersEnabled) {
                if (listenersEnabled) {
                    ColViewPanel.notifyViewChange();
                }
            }

            public void dbLoaded(Db db) {
                if (db == TheDb) {
                    return;
                }
                OrbitGuiWS ws = ColViewPanel.getWorkspace();
                if (ws == null) {
                    return;
                }
                ws.setSingleDockableVisible(ThePanel, false, new OrbitGuiWS.OnDockClosed(){

                    @Override
                    public void closed() {
                        ThePanel = null;
                    }
                });
            }

            public void dbClosing(Db db) {
                if (db != TheDb) {
                    return;
                }
                OrbitGuiWS ws = ColViewPanel.getWorkspace();
                if (ws == null) {
                    return;
                }
                ws.setSingleDockableVisible(ThePanel, false, new OrbitGuiWS.OnDockClosed(){

                    @Override
                    public void closed() {
                        ThePanel = null;
                    }
                });
            }
        };
        ColViewPanel.setPanelVisible(true, devicePath);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (historyListener != null) {
            return;
        }
        Db db = OrbitIO.getCurDb();
        DbHistory h = db.getHistory();
        historyListener = new HistoryListener();
        h.addListener((DbHistory.Listener)historyListener);
        TheUpdateListener = new ratioDrivenListener();
        ExternalDeviceUpdateListener.addListener(TheUpdateListener);
    }

    public static void updateToAllBumps(String deviceKeyStr) {
        Device d = (Device)OrbitIO.getCurDb().getByKeyStr(Device.class, deviceKeyStr);
        for (Device child : d.getChildren()) {
            child.getTemplate().setType(DeviceTemplate.Type.BUMP);
            for (PinTemplate pt : child.getTemplate().getPins()) {
                pt.setType(PinTemplate.Type.BUMPPAD);
            }
        }
    }

    @Override
    public void removeNotify() {
        Db db = OrbitIO.getCurDb();
        if (db != null) {
            DbHistory h = db.getHistory();
            if (h != null) {
                h.removeListener((DbHistory.Listener)historyListener);
            }
            historyListener = null;
            ExternalDeviceUpdateListener.removeListener(TheUpdateListener);
            DesignView2D v2 = (DesignView2D)OrbitIO.getCurView();
            if (v2 != null && cvo != null) {
                v2.removeOverlay(cvo);
            }
            cvo = null;
        }
    }

    public static boolean getPanelVisible() {
        return ThePanel != null;
    }

    public static void setPanelVisible(boolean show, DevicePath devicePath) {
        OrbitGuiWS ws;
        OrbitIO app = OrbitIO.getOrbitIO();
        OrbitGuiWS orbitGuiWS = ws = app == null ? null : app.getWorkspace();
        if (ws == null) {
            ALog.logError((String)"Unable to show the Column View Panel, unable to find an OrbitIO GUI workspace.");
            assert (false);
            return;
        }
        if (show && ThePanel == null) {
            ThePanel = new ColViewPanel(devicePath);
            Db.addDbListener((Db.DbListener)TheDbListener);
            ws.addViewListener(TheViewListener);
        }
        OrbitGuiWS.OnDockClosed dockClosedListener = new OrbitGuiWS.OnDockClosed(){

            @Override
            public void closed() {
                ws.removeViewListener(TheViewListener);
                Db.removeDbListener((Db.DbListener)TheDbListener);
                ThePanel = null;
            }
        };
        ws.setSingleDockableVisible(ThePanel, show, dockClosedListener);
        if (!show && ThePanel != null) {
            ThePanel = null;
        }
    }

    protected static void refreshView(AAppView v) {
        if (v instanceof DesignView2D) {
            ((DesignView2D)v).getCanvas().refresh();
        } else if (v instanceof DesignView3D) {
            ((DesignView3D)v).repaint();
        }
    }

    public static void notifyViewChange() {
        OrbitGuiWS ws = ColViewPanel.getWorkspace();
        AAppView view = ws == null ? null : ws.getCurrentView();
        ThePanel.setView(view);
    }

    protected void refreshView() {
        ColViewPanel.refreshView(this.mView);
    }

    public ColViewPanel(DevicePath devicePath) {
        this.mDieTemplate = devicePath.getDeviceTemplate();
        this.mColView = new ColView(this.mDieTemplate);
        Cp.exec((String)"com.sigrity.orbit.colView.ColViewPanel.cBuildColView (\"%s\");", (Object[])new Object[]{this.mDieTemplate.getKeyStr()});
        this.setName("Column View for " + this.mDieTemplate.getName());
        GridBagManager l = GridBagManager.layout((Container)this);
        l.pushFillX();
        l.add("Find: ");
        this.findField = (RegexFilterField)l.add((Component)new RegexFilterField(this.mFilterListener), (GridBagConstraints)GridBagManager.FILLX.noInsets());
        JButton nextResult = new JButton();
        nextResult.setIcon(OrbitIcons.SRCH_NEXT);
        nextResult.setMargin(new Insets(0, 0, 0, 0));
        nextResult.addActionListener(this.mNextResultAction);
        l.add((Component)nextResult);
        JButton prevResult = new JButton();
        prevResult.setIcon(OrbitIcons.SRCH_PREV);
        prevResult.setMargin(new Insets(0, 0, 0, 0));
        prevResult.addActionListener(this.mPrevResultAction);
        l.add((Component)prevResult);
        this.findResults = new JLabel("");
        l.add((Component)this.findResults);
        l.popNl();
        ATreeModel tm = new ATreeModel();
        this.colViewTree = new ColViewTree(tm, this);
        this.rn = new RootNode(tm, this.mDieTemplate);
        tm.setRoot((TreeNode)((Object)this.rn));
        this.colViewTree.requestFocusInWindow();
        this.colViewTree.setDragEnabled(true);
        this.colViewTree.setEditable(false);
        this.colViewTree.setTransferHandler(new MyTransferHandler(this.colViewTree));
        this.colViewTree.setDropMode(DropMode.ON);
        this.colViewTree.getSelectionModel().setSelectionMode(4);
        this.colViewTree.setPopupMenuHandler(this.mTreePopupMenuHandler);
        this.colViewTree.setCellRenderer((TreeCellRenderer)((Object)new ColViewRenderer()));
        this.colViewTree.setRootVisible(true);
        this.colViewTree.setShowsRootHandles(true);
        this.colViewTree.setOpaque(false);
        ToolTipManager.sharedInstance().registerComponent(this.colViewTree);
        this.treeSearcher = new TreeSearcher(this.colViewTree);
        this.sp = new JScrollPane(this.colViewTree);
        l.add((Component)this.sp, (GridBagConstraints)GridBagManager.FILLALL);
        this.setExpansion(this.colViewTree, 3);
        this.createKeyBindings();
        this.setView(OrbitIO.getCurView());
    }

    public void setView(AAppView view) {
        if (this.mView != null) {
            this.enableListeners(false);
        }
        this.mView = view;
        this.enableListeners(true);
    }

    protected void enableListeners(boolean enable) {
        if (this.mView == null) {
            return;
        }
        Db db = this.mView.getDb();
        if (db != null) {
            if (enable) {
                db.getDbClass(DeviceTemplate.class).addObjectListener(this.mDboListener, DbClass.DbObjectEventType.getUpdated());
                db.getDbClass(Device.class).addObjectListener(this.mDboListener, DbClass.DbObjectEventType.getUpdated());
            } else {
                db.getDbClass(DeviceTemplate.class).removeObjectListener(this.mDboListener, DbClass.DbObjectEventType.getUpdated());
                db.getDbClass(Device.class).removeObjectListener(this.mDboListener, DbClass.DbObjectEventType.getUpdated());
            }
        }
    }

    protected void createKeyBindings() {
        this.colViewTree.getActionMap().put("CLONE", this.clone);
        this.bindKey("C", "CLONE");
        this.colViewTree.requestFocus();
    }

    public void bindKey(String key, String action) {
        KeyStroke keyStroke = KeyStroke.getKeyStroke(key);
        if (keyStroke == null) {
            ALog.logWarn((String)"Invalid key stroke '%s' specified while attempting to bind key stroketo action '%s'.", (Object[])new Object[]{key, action});
            return;
        }
        InputMap inputMap = this.colViewTree.getInputMap(1);
        inputMap.put(keyStroke, action);
    }

    public static void cBuildColView(String dieKey) {
        Db db = OrbitIO.getCurDb();
        DeviceTemplate die = (DeviceTemplate)db.getByKeyStr(DeviceTemplate.class, dieKey);
        ColView cv = new ColView(die);
        cv.makeColViewFromDataBase();
        cv.updateDataBaseFromColView();
    }

    public static void cBuildDataBase(String dieKey) {
        Db db = OrbitIO.getCurDb();
        DeviceTemplate die = (DeviceTemplate)db.getByKeyStr(DeviceTemplate.class, dieKey);
        ColView cv = new ColView(die);
        cv.updateDataBaseFromColView();
        cv.makeColViewFromDataBase();
    }

    public static void cDelCell(String dieKey, String deviceKey) {
        Db db = OrbitIO.getCurDb();
        DeviceTemplate die = (DeviceTemplate)db.getByKeyStr(DeviceTemplate.class, dieKey);
        Device device = (Device)db.getByKeyStr(Device.class, deviceKey);
        ColView cv = new ColView(die);
        cv.makeColViewFromDataBase();
        block0: for (ColData cd : cv.columns) {
            for (Device d : cd) {
                if (!d.equals(device)) continue;
                cd.remove(device);
                device.deleteFromDb();
                continue block0;
            }
        }
        cv.updateDataBaseFromColView();
    }

    public static void cProtectTemplate(String deviceKeyStr) {
        Device d;
        Db db = OrbitIO.getCurDb();
        d.setIsFixed(!(d = (Device)db.getByKeyStr(Device.class, deviceKeyStr)).getIsFixed());
        OrbitIO.getOrbitIO().refreshCurrentView(true);
    }

    public static void delCol(String dieKey, int c) {
        Db db = OrbitIO.getCurDb();
        DeviceTemplate die = (DeviceTemplate)db.getByKeyStr(DeviceTemplate.class, dieKey);
        ColView cv = new ColView(die);
        cv.makeColViewFromDataBase();
        ColData cd = cv.columns.get(c);
        for (Device d : cd) {
            d.deleteFromDb();
        }
        cv.columns.remove(c);
        cv.saveColumnAttributesToDieTemplate();
        cv.updateDataBaseFromColView();
    }

    public static void setColData(String dieKey, String name, long d, boolean isLeft) {
        Db db = OrbitIO.getCurDb();
        DeviceTemplate die = (DeviceTemplate)db.getByKeyStr(DeviceTemplate.class, dieKey);
        ColView cv = new ColView(die);
        cv.makeColViewFromDataBase();
        ColData cd = cv.getColumn(name);
        cd.setInset(d);
        cd.setAlignLeft(isLeft);
        cv.saveColumnAttributesToDieTemplate();
        cv.updateDataBaseFromColView();
        cv.makeColViewFromDataBase();
    }

    public static void cInsertGap(String templateKey, int row, long gap) {
        Db db = OrbitIO.getCurDb();
        DeviceTemplate template = (DeviceTemplate)db.getByKeyStr(DeviceTemplate.class, templateKey);
        ColView cv = new ColView(template);
        cv.makeColViewFromDataBase();
        cv.setGap(row, gap);
        cv.updateDataBaseFromColView();
        cv.makeColViewFromDataBase();
    }

    public static void cEditCell(String cellKey, String templateKey, String dieKey, String xform) {
        Db db = OrbitIO.getCurDb();
        Device cell = (Device)db.getByKeyStr(Device.class, cellKey);
        DeviceTemplate template = (DeviceTemplate)db.getByKeyStr(DeviceTemplate.class, templateKey);
        DeviceTemplate die = (DeviceTemplate)db.getByKeyStr(DeviceTemplate.class, dieKey);
        DeviceTemplate.DefTransform df = DeviceTemplate.DefTransform.valueOf((String)xform);
        ColView cv = new ColView(die);
        cv.makeColViewFromDataBase();
        cell.setTemplate(template);
        cell.setMirror(df.getMirror());
        cell.setRotate(df.getRot());
        cv.updateDataBaseFromColView();
        cv.makeColViewFromDataBase();
    }

    public static void cCreateCell(String cellName, String templateKey, String dieKey, String xform, int col, int pos) {
        Db db = OrbitIO.getCurDb();
        DeviceTemplate template = (DeviceTemplate)db.getByKeyStr(DeviceTemplate.class, templateKey);
        DeviceTemplate die = (DeviceTemplate)db.getByKeyStr(DeviceTemplate.class, dieKey);
        ColView cv = new ColView(die);
        cv.makeColViewFromDataBase();
        String name = Device.getNextArrayName((DeviceTemplate)die, (String)AUtil.stripTrailingDigits((String)cellName));
        Device cell = Device.create((Db)OrbitIO.getCurDb(), (String)name, (DeviceTemplate)template, (DeviceTemplate)die);
        DeviceTemplate.DefTransform dt = DeviceTemplate.DefTransform.valueOf((String)xform);
        cell.setRotate(dt.getRot());
        cell.setMirror(dt.getMirror());
        cell.setLoc(new APoint2D(0L, 0L));
        cv.insert(cell, col, pos);
        cv.updateDataBaseFromColView();
        cv.makeColViewFromDataBase();
    }

    public static void cAddRatioDrivenCell(String dieKey, int col, int pos) {
        Db db = OrbitIO.getCurDb();
        DeviceTemplate dieTemplate = (DeviceTemplate)db.getByKeyStr(DeviceTemplate.class, dieKey);
        PatternPlacementUI ui = PatternPlacementUI.create(OrbitIO.getMainWindow(), dieTemplate);
        ColView cv = new ColView(dieTemplate);
        cv.makeColViewFromDataBase();
        ColViewPanel.externalAddState.state = ExternalAddState.Waiting;
        ColViewPanel.externalAddState.addColumn = col;
        ColViewPanel.externalAddState.addRow = 0;
        BumpFactoryData abfd = null;
        for (BumpFactoryData bfdi : db.getObjects(BumpFactoryData.class)) {
            if (!bfdi.getFactoryType().equals((Object)BumpFactoryData.BumpFactoryType.RATIO_DRIVEN) || !bfdi.getTemplate().getSubstrate().equals((Object)dieTemplate.getSubstrate())) continue;
            abfd = bfdi;
            break;
        }
        if (abfd != null) {
            BumpFactoryData bfd = new BumpFactoryData();
            bfd.setFactoryType(BumpFactoryData.BumpFactoryType.RATIO_DRIVEN);
            bfd.setBumpBaseName(abfd.getBumpBaseName());
            bfd.setBumpTemplate(abfd.getBumpTemplate());
            bfd.setBumpNameIsScript(abfd.getBumpNameIsScript());
            bfd.setCornerKeepoutX(abfd.getCornerKeepoutX());
            bfd.setCornerKeepoutY(abfd.getCornerKeepoutY());
            bfd.setXPitch(abfd.getXPitch());
            bfd.setYPitch(abfd.getYPitch());
            bfd.setMinPitch(abfd.getMinPitch());
            bfd.setRatioInstructions(abfd.getRatioInstructions());
            bfd.setWidth(abfd.getTemplate().getBB().width());
            bfd.setHeight(abfd.getTemplate().getBB().height());
            bfd.setLeftKeepout(abfd.getLeftKeepout());
            bfd.setRightKeepout(abfd.getRightKeepout());
            bfd.setBottomKeepout(abfd.getBottomKeepout());
            bfd.setTopKeepout(abfd.getTopKeepout());
            bfd.setBumpSize(abfd.getBumpSize());
            bfd.setBumpSize2(abfd.getBumpSize2());
            bfd.setLayer(abfd.getLayer());
            bfd.setPadStyle(abfd.getPadStyle());
            ui.load(bfd);
        }
        ui.setJustRatioDriven();
        ui.setVisible(true);
    }

    public static void cInsertDeviceIntoColRow(String dieKey, String deviceKeyString, int col, int row) {
        Db db = OrbitIO.getCurDb();
        ColView cv = ColView.TheColView;
        Device cell = (Device)db.getByKeyStr(Device.class, deviceKeyString);
        if (cell != null) {
            cv.insert(cell, col, row);
            cv.updateDataBaseFromColView();
            cv.makeColViewFromDataBase();
        }
    }

    public static void cDoDecoration(String decorationCommand) {
        ColViewDecorator cvd = ColViewDecoratorRegistry.get(decorationCommand);
        ColView cv = new ColView(ColView.TheColView.dieTemplate);
        cv.makeColViewFromDataBase();
        cvd.decorate();
    }

    public static void cUpdateColCommand(String dieKey) {
        Db db = OrbitIO.getCurDb();
        DeviceTemplate die = (DeviceTemplate)db.getByKeyStr(DeviceTemplate.class, dieKey);
        ColView cv = new ColView(die);
        cv.updateDataBaseFromColView();
        cv.makeColViewFromDataBase();
        cv.updateDataBaseFromColView();
    }

    public static void addColumnCommand(String dieKey) {
        Db db = OrbitIO.getCurDb();
        DeviceTemplate die = (DeviceTemplate)db.getByKeyStr(DeviceTemplate.class, dieKey);
        ColView cv = new ColView(die);
        cv.makeColViewFromDataBase();
        cv.addColumn();
        cv.updateDataBaseFromColView();
        cv.makeColViewFromDataBase();
    }

    public static void moveCell(String dieKey, int fromCol, int fromPos, int toCol, int toPos) {
        Db db = OrbitIO.getCurDb();
        DeviceTemplate die = (DeviceTemplate)db.getByKeyStr(DeviceTemplate.class, dieKey);
        ColView cv = new ColView(die);
        cv.makeColViewFromDataBase();
        Device d = (Device)cv.getColumns().get(fromCol).get(fromPos);
        cv.remove(fromCol, fromPos);
        if (fromCol == toCol) {
            if (fromPos < toPos) {
                cv.insert(d, toCol, toPos - 1);
            } else {
                cv.insert(d, toCol, toPos);
            }
        } else {
            cv.insert(d, toCol, toPos);
        }
        cv.updateDataBaseFromColView();
        cv.makeColViewFromDataBase();
    }

    public void restoreExpansion(JTree tree) {
        TreeModel tm = this.colViewTree.getModel();
        RootNode rn = (RootNode)((Object)tm.getRoot());
        rn.invalidateChildren();
        this.restoreExpansion(tree, new TreePath((Object)rn));
        this.refreshPending = false;
    }

    protected void restoreExpansion(JTree tree, TreePath tp) {
        TreeNode node = (TreeNode)tp.getLastPathComponent();
        if (node.getChildCount() > 0) {
            CellNode dn;
            if (node instanceof CellNode && !this.lastExpandedSet.contains((dn = (CellNode)((Object)node)).getName())) {
                return;
            }
            Enumeration<? extends TreeNode> e = node.children();
            while (e != null && e.hasMoreElements()) {
                TreeNode n = e.nextElement();
                TreePath path = tp.pathByAddingChild(n);
                this.restoreExpansion(tree, path);
            }
            tree.expandPath(tp);
        } else {
            tree.collapsePath(tp);
        }
    }

    protected void saveCurrentExpansion(JTree tree, TreePath tp) {
        Enumeration<TreePath> expanded = tree.getExpandedDescendants(tp);
        if (expanded != null) {
            if (tp.getLastPathComponent() instanceof CellNode) {
                CellNode dn = (CellNode)((Object)tp.getLastPathComponent());
                this.lastExpandedSet.add(dn.getName());
            }
            for (TreePath p : AUtil.getIterable(expanded)) {
                this.saveCurrentExpansion(tree, p);
            }
        }
    }

    protected void saveCurrentExpansion() {
        this.lastExpandedSet = new ArrayList();
        TreePath rootPath = new TreePath(this.colViewTree.getModel().getRoot());
        this.saveCurrentExpansion(this.colViewTree, rootPath);
    }

    private void expandAll(JTree tree, TreePath parent, boolean expand, int depth, int stopDepth) {
        if (depth >= stopDepth) {
            return;
        }
        TreeNode node = (TreeNode)parent.getLastPathComponent();
        if (node.getChildCount() >= 0) {
            Enumeration<? extends TreeNode> e = node.children();
            while (e != null && e.hasMoreElements()) {
                TreeNode n = e.nextElement();
                TreePath path = parent.pathByAddingChild(n);
                this.expandAll(tree, path, expand, depth + 1, stopDepth);
            }
        }
        if (expand) {
            tree.expandPath(parent);
        } else {
            tree.collapsePath(parent);
        }
    }

    protected void clearTree() {
        this.lastExpandedSet.clear();
        ATreeModel tm = (ATreeModel)this.colViewTree.getModel();
        RootNode rn = (RootNode)((Object)tm.getRoot());
        rn.invalidateChildren();
    }

    public void expandAll(JTree tree, boolean expand, int stopDepth) {
        TreeNode root = (TreeNode)tree.getModel().getRoot();
        this.expandAll(tree, new TreePath(root), expand, 0, stopDepth);
    }

    public void setExpansion(JTree tree, int stopDepth) {
        TreeNode root = (TreeNode)tree.getModel().getRoot();
        this.setExpansion(tree, new TreePath(root), 0, stopDepth);
    }

    private void setExpansion(JTree tree, TreePath parent, int depth, int stopDepth) {
        TreeNode node = (TreeNode)parent.getLastPathComponent();
        if (node.getChildCount() >= 0) {
            Enumeration<? extends TreeNode> e = node.children();
            while (e != null && e.hasMoreElements()) {
                TreeNode n = e.nextElement();
                TreePath path = parent.pathByAddingChild(n);
                this.setExpansion(tree, path, depth + 1, stopDepth);
            }
        }
        if (depth < stopDepth) {
            tree.expandPath(parent);
        } else {
            tree.collapsePath(parent);
        }
    }

    protected void expandHierLevels() {
        ATreeModel tm = (ATreeModel)this.colViewTree.getModel();
        RootNode rn = (RootNode)((Object)tm.getRoot());
        rn.invalidateChildren();
        this.expandAll(this.colViewTree, true, 5);
        this.colViewTree.scrollPathToVisible(this.colViewTree.getSelectionPath());
    }

    public void refreshTree() {
        if (this.refreshPending) {
            return;
        }
        this.refreshPending = true;
        this.treeSearcher.invalidate();
        this.saveCurrentExpansion();
        TreeModel tm = this.colViewTree.getModel();
        RootNode rn = (RootNode)((Object)tm.getRoot());
        rn.invalidateChildren();
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                ColViewPanel.this.restoreExpansion(ColViewPanel.this.colViewTree);
            }
        });
    }

    static {
        TheDb = null;
        DieDecorator.registerSpecialNetlistCommand();
        externalAddState = new ExternalAddInfo();
        DockableFactory = new SingleCDockableFactory(){

            public SingleCDockable createBackup(String id) {
                TreeLocationRoot loc = CLocation.base().normalWest(0.25);
                DefaultSingleCDockable dockable = new DefaultSingleCDockable(id, new CAction[0]);
                dockable.setLocation((CLocation)loc);
                dockable.setCloseable(true);
                dockable.setMinimizable(false);
                dockable.setTitleIcon(null);
                return dockable;
            }
        };
        DeviceBlockDataFlavor = new DataFlavor(Device.class, "Device");
        SupportedDataFlavors = new DataFlavor[]{DeviceBlockDataFlavor};
    }

    public class ColViewRenderer
    extends ATreeCellRenderer {
        public void setBackground(Color color) {
            if (color instanceof ColorUIResource) {
                color = null;
            }
            super.setBackground(color);
        }

        public Color getBackgroundNonSelectionColor() {
            return null;
        }

        public Color getBackground() {
            return null;
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Component c = super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
            this.setOpaque(false);
            if (value instanceof RootNode) {
                RootNode rn = (RootNode)((Object)value);
                this.setIcon(DbExplorerPanel.getIconForTemplate(rn.getTemplate()));
                this.setText(rn.getTemplate().getName());
            } else if (value instanceof ColNode) {
                ColNode cn = (ColNode)((Object)value);
                if (cn.isAddNode()) {
                    this.setIcon(OrbitIcons.ADD);
                    this.setText("Add a column");
                } else {
                    this.setIcon(DbExplorerPanel.getFolderIcon());
                    this.setText(cn.getName());
                }
            } else {
                CellNode cn = (CellNode)((Object)value);
                if (cn.d != null) {
                    this.setIcon(DbExplorerPanel.getIconForTemplate(cn.d.getTemplate()));
                    this.setText(cn.getName());
                    if (cn.d.getTemplate() == null) {
                        return c;
                    }
                    String templateName = cn.d.getTemplate().getName();
                    long gap = ColView.TheColView.getGap(cn.ith);
                    if (gap > 0L) {
                        this.setForeground(Color.blue);
                    }
                    Unit unit = Design.getUnit((Db)OrbitIO.getCurDb());
                    String gapString = unit.toUserStr(gap);
                    String toolTip = "<html><b>Template:</b> " + templateName + "<br><b>Gap:</b> " + gapString + "</html>";
                    this.setToolTipText(toolTip);
                } else {
                    this.setText("GAP");
                }
            }
            return c;
        }
    }

    public class MyTransferHandler
    extends TransferHandler {
        JTree tree;

        public MyTransferHandler(JTree tree) {
            this.tree = tree;
        }

        @Override
        protected Transferable createTransferable(JComponent c) {
            TreePath[] treePaths = this.tree.getSelectionPaths();
            if (treePaths == null) {
                return null;
            }
            final ArrayList<CellNode> froms = new ArrayList<CellNode>();
            for (TreePath tp : treePaths) {
                if (!(tp.getLastPathComponent() instanceof CellNode)) {
                    ALog.logWarn((String)"Can only move interfaces or devices");
                    return null;
                }
                CellNode fromNode = (CellNode)((Object)tp.getLastPathComponent());
                froms.add(fromNode);
            }
            return new Transferable(){

                @Override
                public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException {
                    if (flavor == DeviceBlockDataFlavor) {
                        return froms;
                    }
                    throw new UnsupportedFlavorException(flavor);
                }

                @Override
                public DataFlavor[] getTransferDataFlavors() {
                    return SupportedDataFlavors;
                }

                @Override
                public boolean isDataFlavorSupported(DataFlavor flavor) {
                    return AUtil.find((Object)flavor, (Object[])SupportedDataFlavors) >= 0;
                }
            };
        }

        @Override
        public int getSourceActions(JComponent c) {
            return 2;
        }

        @Override
        public boolean canImport(TransferHandler.TransferSupport support) {
            if (!support.isDataFlavorSupported(DeviceBlockDataFlavor)) {
                return false;
            }
            JTree.DropLocation dropLoc = (JTree.DropLocation)support.getDropLocation();
            int insertAt = dropLoc.getChildIndex();
            if (insertAt == -1) {
                // empty if block
            }
            return true;
        }

        @Override
        public boolean importData(TransferHandler.TransferSupport support) {
            if (!support.isDrop()) {
                return false;
            }
            JTree.DropLocation dropLoc = (JTree.DropLocation)support.getDropLocation();
            TreePath treePath = dropLoc.getPath();
            if (treePath == null) {
                return false;
            }
            if (treePath.getLastPathComponent() instanceof CellNode) {
                ArrayList fromBlocks;
                CellNode toCellNode = (CellNode)((Object)treePath.getLastPathComponent());
                try {
                    fromBlocks = (ArrayList)support.getTransferable().getTransferData(DeviceBlockDataFlavor);
                }
                catch (Exception e) {
                    ALog.logError((Throwable)e, (String)"Error dropping.", (Object[])new Object[0]);
                    return false;
                }
                Cp.exec((String)"com.sigrity.orbit.colView.ColViewPanel.moveCell (\"%s\", %d, %d, %d, %d);", (Object[])new Object[]{ColViewPanel.this.mDieTemplate.getKeyStr(), ((CellNode)((Object)fromBlocks.get((int)0))).colNum, ((CellNode)((Object)fromBlocks.get((int)0))).ith, toCellNode.colNum, toCellNode.ith + 1});
                ThePanel.refreshTree();
                OrbitIO.getOrbitIO().refreshCurrentView(false);
                return true;
            }
            if (treePath.getLastPathComponent() instanceof ColNode) {
                ArrayList fromBlocks;
                ColNode toColNode = (ColNode)((Object)treePath.getLastPathComponent());
                try {
                    fromBlocks = (ArrayList)support.getTransferable().getTransferData(DeviceBlockDataFlavor);
                }
                catch (Exception e) {
                    ALog.logError((Throwable)e, (String)"Error dropping.", (Object[])new Object[0]);
                    return false;
                }
                Cp.exec((String)"com.sigrity.orbit.colView.ColViewPanel.moveCell (\"%s\", %d, %d, %d, %d);", (Object[])new Object[]{ColViewPanel.this.mDieTemplate.getKeyStr(), ((CellNode)((Object)fromBlocks.get((int)0))).colNum, ((CellNode)((Object)fromBlocks.get((int)0))).ith, toColNode.colNum, 0});
                ThePanel.refreshTree();
                OrbitIO.getOrbitIO().refreshCurrentView(false);
                return true;
            }
            return false;
        }
    }

    protected class RootNode
    extends ALazyTreeNode {
        protected ArrayList<ALazyTreeNode> mColNodes;
        protected DeviceTemplate dieTemplate;
        ATreeModel m;

        public RootNode(ATreeModel m, DeviceTemplate dieTemplate) {
            super(m);
            this.mColNodes = new ArrayList();
            this.m = m;
            this.dieTemplate = dieTemplate;
        }

        public DeviceTemplate getTemplate() {
            return this.dieTemplate;
        }

        public ArrayList<ALazyTreeNode> populateChildren() {
            this.mColNodes.clear();
            Integer numColumns = ColViewPanel.this.mColView.getColumnCount();
            for (int i = 0; i < numColumns; ++i) {
                this.addColNode(ColView.colToName(i), i);
            }
            return this.mColNodes;
        }

        public String getText() {
            return "";
        }

        public void addColNode(String name, int ith) {
            ColNode colNode = new ColNode(this.m, name, ith);
            this.mColNodes.add(colNode);
        }
    }

    protected class ColNode
    extends ALazyTreeNode {
        String name;
        int colNum;
        static final String ADDNAME = "ADD";
        ATreeModel m;
        protected ArrayList<ALazyTreeNode> mChildNodes;

        public ColNode(ATreeModel m, String name, int colNum) {
            super(m);
            this.mChildNodes = new ArrayList();
            this.m = m;
            this.name = name;
            this.colNum = colNum;
        }

        public String getName() {
            return this.name;
        }

        public ArrayList<ALazyTreeNode> populateChildren() {
            this.mChildNodes.clear();
            if (this.isAddNode()) {
                return this.mChildNodes;
            }
            if (ColView.TheColView.getColumnCount() > 0) {
                int i = 0;
                for (Device d : ColView.TheColView.columns.get(this.colNum)) {
                    this.mChildNodes.add(new CellNode(this.m, this.colNum, d, i++));
                }
            }
            return this.mChildNodes;
        }

        public String getText() {
            return "";
        }

        boolean isAddNode() {
            return this.name.equals(ADDNAME);
        }
    }

    protected class CellNode
    extends ALazyTreeNode {
        Device d;
        int colNum;
        int ith;
        protected ArrayList<ALazyTreeNode> mChildNodes;

        public CellNode(ATreeModel m, int colNum, Device d, int ith) {
            super(m);
            this.colNum = 0;
            this.d = d;
            this.colNum = colNum;
            this.ith = ith;
        }

        public String getName() {
            long gap;
            Object name = "";
            if (this.d.getDb() == null) {
                return "";
            }
            Settings userPrefs = Settings.getSettings((String)"UserPreferences");
            Boolean showInstanceNames = (Boolean)userPrefs.getSetting("ColView.showInstanceNames", (Object)false);
            Boolean showTemplateNames = (Boolean)userPrefs.getSetting("ColView.showTemplateNames", (Object)false);
            Boolean showGapValues = (Boolean)userPrefs.getSetting("ColView.showGapValues", (Object)false);
            if (showInstanceNames.booleanValue()) {
                name = (String)name + this.d.getName();
                if (showTemplateNames.booleanValue()) {
                    name = (String)name + " (" + this.d.getTemplate().getName() + ")";
                }
            } else {
                name = showTemplateNames != false ? (String)name + this.d.getTemplate().getName() : this.colNum + "_" + this.ith;
            }
            if (showGapValues.booleanValue() && (gap = ColView.TheColView.getGap(this.ith)) > 0L) {
                Unit unit = Design.getUnit((Db)OrbitIO.getCurDb());
                String gapString = unit.toUserStr(gap);
                name = (String)name + " @" + gapString;
            }
            return name;
        }

        public ArrayList<ALazyTreeNode> populateChildren() {
            return this.mChildNodes;
        }

        public String getText() {
            return "";
        }
    }

    class UpdateColCommand
    implements ActionListener {
        UpdateColCommand() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Cp.exec((String)"com.sigrity.orbit.colView.ColViewPanel.cUpdateColCommand(\"%s\");", (Object[])new Object[]{ColViewPanel.this.mDieTemplate.getKeyStr()});
            ThePanel.refreshTree();
            OrbitIO.getOrbitIO().refreshCurrentView(false);
        }
    }

    class AddColumnCommand
    implements ActionListener {
        AddColumnCommand() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Cp.exec((String)"com.sigrity.orbit.colView.ColViewPanel.addColumnCommand(\"%s\");", (Object[])new Object[]{ColViewPanel.this.mDieTemplate.getKeyStr()});
            ColViewPanel.this.refreshTree();
            OrbitIO.getOrbitIO().refreshCurrentView(false);
        }
    }

    class PreferencesCommand
    implements ActionListener {
        PreferencesCommand() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ColViewPreferencesDlg dlg = ColViewPreferencesDlg.createDialog(OrbitIO.getMainWindow());
            dlg.setVisible(true);
            ThePanel.refreshTree();
            OrbitIO.getOrbitIO().refreshCurrentView(false);
        }
    }

    class DoDecorationCommand
    implements ActionListener {
        ColViewDecorator cvd;

        public DoDecorationCommand(ColViewDecorator cvd) {
            this.cvd = cvd;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String decorationCommand = this.cvd.name();
            Cp.exec((String)"com.sigrity.orbit.colView.ColViewPanel.cDoDecoration (\"%s\");", (Object[])new Object[]{decorationCommand});
            ColViewPanel.this.refreshTree();
        }
    }

    class ImportDieAbstractCommand
    implements ActionListener {
        ImportDieAbstractCommand() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ColViewPanel.this.refreshTree();
        }
    }

    class ExportDieAbstractCommand
    implements ActionListener {
        ExportDieAbstractCommand() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Class<?> da = null;
            try {
                da = Class.forName("com.cadence.orbit.pi.die_abstract.DieAbstractPI");
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            if (da != null) {
                Cp.exec((String)"com.cadence.orbit.pi.die_abstract.ui.DieAbstractExportUI.showFor (\"%s\");", (Object[])new Object[]{ColViewPanel.this.mDieTemplate});
            } else {
                ALog.logWarn((String)"The DieAbstract Plugin is not available.");
            }
        }
    }

    class ImportDirectory
    implements ActionListener {
        DeviceTemplate mTemplate;

        public ImportDirectory(DeviceTemplate dt) {
            this.mTemplate = dt;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AFileChooser fc = new AFileChooser();
            fc.setFileSelectionMode(1);
            fc.setMultiSelectionEnabled(false);
            if (fc.showOpenDialog((Component)OrbitIO.getMainWindow()) != 0) {
                return;
            }
            File f = fc.getSelectedFile();
            if (f == null) {
                return;
            }
            OrbitLibrarySerializerUI.readDirectoryOfTemplates(f.getPath(), this.mTemplate.getKeyStr());
        }
    }

    class AddRatioCellCommand
    implements ActionListener {
        AddRatioCellCommand() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TreePath treePath = ColViewPanel.this.colViewTree.getSelectionPath();
            ColNode cn = (ColNode)((Object)treePath.getLastPathComponent());
            int col = cn.colNum;
            int pos = 0;
            Cp.exec((String)"com.sigrity.orbit.colView.ColViewPanel.cAddRatioDrivenCell (\"%s\", %d, %d);", (Object[])new Object[]{ColViewPanel.this.mDieTemplate.getKeyStr(), col, pos});
        }
    }

    class EditGapCommand
    implements ActionListener {
        EditGapCommand() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Db db = OrbitIO.getCurDb();
            Unit unit = Design.getUnit((Db)db);
            TreePath treePath = ColViewPanel.this.colViewTree.getSelectionPath();
            CellNode cn = (CellNode)((Object)treePath.getLastPathComponent());
            int row = cn.ith;
            ColView cv = new ColView(ColViewPanel.this.mDieTemplate);
            double g = unit.toUser(cv.getGap(row));
            ColViewSetGapDlg dlg = ColViewSetGapDlg.createDialog(OrbitIO.getMainWindow(), OrbitIO.getCurDb(), row, g);
            dlg.setVisible(true);
            ColViewSetGapDlg.GapInfo gi = dlg.getAccepted();
            if (gi != null) {
                Cp.exec((String)"com.sigrity.orbit.colView.ColViewPanel.cInsertGap (\"%s\", %d, (long) %d);", (Object[])new Object[]{ColViewPanel.this.mDieTemplate.getKeyStr(), row, gi.mGap});
                ThePanel.refreshTree();
                OrbitIO.getOrbitIO().refreshCurrentView(false);
            }
        }
    }

    class AddCellCommand
    implements ActionListener {
        AddCellCommand() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TreePath treePath = ColViewPanel.this.colViewTree.getSelectionPath();
            ColNode cn = (ColNode)((Object)treePath.getLastPathComponent());
            ColViewEditCellDlg dlg = ColViewEditCellDlg.createDialog(OrbitIO.getMainWindow(), OrbitIO.getCurDb(), true, ColViewPanel.this.mDieTemplate, null);
            dlg.setVisible(true);
            ColViewEditCellDlg.CellInfo ci = dlg.getAccepted();
            if (ci != null) {
                int col = cn.colNum;
                int pos = -1;
                Cp.exec((String)"com.sigrity.orbit.colView.ColViewPanel.cCreateCell (\"%s\", \"%s\", \"%s\",\"%s\", %d, %d);", (Object[])new Object[]{"cell", ci.mTemplate.getKeyStr(), ColViewPanel.this.mDieTemplate.getKeyStr(), ci.mTransform.name(), col, pos});
                ThePanel.refreshTree();
                OrbitIO.getOrbitIO().refreshCurrentView(false);
            }
        }
    }

    class AddGapCommand
    implements ActionListener {
        AddGapCommand() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TreePath treePath = ColViewPanel.this.colViewTree.getSelectionPath();
            ColNode cn = (ColNode)((Object)treePath.getLastPathComponent());
            int col = cn.colNum;
            int pos = -1;
            Cp.exec((String)"com.sigrity.orbit.colView.ColViewPanel.addGapCell (\"%s\", %d, %d);", (Object[])new Object[]{ColViewPanel.this.mDieTemplate.getKeyStr(), col, pos});
        }
    }

    class EditColumnCommand
    implements ActionListener {
        EditColumnCommand() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TreePath treePath = ColViewPanel.this.colViewTree.getSelectionPath();
            ColNode cn = (ColNode)((Object)treePath.getLastPathComponent());
            ColViewColEditDlg dlg = ColViewColEditDlg.createDialog(OrbitIO.getMainWindow(), false, cn.colNum);
            dlg.setVisible(true);
            ColData ci = dlg.getAccepted();
            if (ci != null) {
                Cp.exec((String)"com.sigrity.orbit.colView.ColViewPanel.setColData (\"%s\", \"%s\", %d, %b);", (Object[])new Object[]{ColViewPanel.this.mDieTemplate.getKeyStr(), ColView.colToName(cn.colNum), ci.inset, ci.alignLeft});
                ThePanel.refreshTree();
                OrbitIO.getOrbitIO().refreshCurrentView(false);
            }
        }
    }

    class DelColumnCommand
    implements ActionListener {
        DelColumnCommand() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TreePath treePath = ColViewPanel.this.colViewTree.getSelectionPath();
            ColNode cn = (ColNode)((Object)treePath.getLastPathComponent());
            Cp.exec((String)"com.sigrity.orbit.colView.ColViewPanel.delCol (\"%s\", %d);", (Object[])new Object[]{ColViewPanel.this.mDieTemplate.getKeyStr(), cn.colNum});
            ThePanel.refreshTree();
            OrbitIO.getOrbitIO().refreshCurrentView(false);
        }
    }

    class EditCellCommand
    implements ActionListener {
        EditCellCommand() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TreePath treePath = ColViewPanel.this.colViewTree.getSelectionPath();
            CellNode cn = (CellNode)((Object)treePath.getLastPathComponent());
            ColViewEditCellDlg dlg = ColViewEditCellDlg.createDialog(OrbitIO.getMainWindow(), OrbitIO.getCurDb(), false, ColViewPanel.this.mDieTemplate, cn.d);
            dlg.setVisible(true);
            ColViewEditCellDlg.CellInfo ci = dlg.getAccepted();
            if (ci != null) {
                Cp.exec((String)"com.sigrity.orbit.colView.ColViewPanel.cEditCell (\"%s\", \"%s\", \"%s\",\"%s\");", (Object[])new Object[]{cn.d.getKeyStr(), ci.mTemplate.getKeyStr(), ColViewPanel.this.mDieTemplate.getKeyStr(), ci.mTransform.name()});
                ThePanel.refreshTree();
                OrbitIO.getOrbitIO().refreshCurrentView(false);
            }
        }
    }

    class EditBumpPattern
    implements ActionListener {
        EditBumpPattern() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PatternPlacementUI ui;
            TreePath treePath = ColViewPanel.this.colViewTree.getSelectionPath();
            CellNode cn = (CellNode)((Object)treePath.getLastPathComponent());
            Device d = cn.d;
            ColViewPanel.externalAddState.state = ExternalAddState.NotWaiting;
            BumpFactoryData bfd = BumpFactoryData.getForTemplate((DeviceTemplate)d.getTemplate(), (boolean)false);
            if (bfd != null && (ui = PatternPlacementUI.create(OrbitIO.getMainWindow(), d.getParent())) != null) {
                ui.setEditPattern(d);
                ui.setVisible(true);
            }
        }
    }

    class ProtectDeviceTemplateCommand
    implements ActionListener {
        ProtectDeviceTemplateCommand() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TreePath treePath = ColViewPanel.this.colViewTree.getSelectionPath();
            CellNode cn = (CellNode)((Object)treePath.getLastPathComponent());
            Device d = cn.d;
            Cp.exec((String)"com.sigrity.orbit.colView.ColViewPanel.cProtectTemplate (\"%s\");", (Object[])new Object[]{d.getKeyStr()});
        }
    }

    class CloneCellCommand
    implements ActionListener {
        CloneCellCommand() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TreePath treePath = ColViewPanel.this.colViewTree.getSelectionPath();
            CellNode cn = (CellNode)((Object)treePath.getLastPathComponent());
            int col = cn.colNum;
            int pos = cn.ith + 1;
            Device d = cn.d;
            DeviceTemplate dt = d.getTemplate();
            String name = d.getName();
            DeviceTemplate.DefTransform theXForm = d.getMyDefTransform();
            Cp.exec((String)"com.sigrity.orbit.colView.ColViewPanel.cCreateCell (\"%s\", \"%s\", \"%s\",\"%s\", %d, %d);", (Object[])new Object[]{name, dt.getKeyStr(), ColViewPanel.this.mDieTemplate.getKeyStr(), theXForm.name(), col, pos});
            ThePanel.refreshTree();
            OrbitIO.getOrbitIO().refreshCurrentView(false);
        }
    }

    class DelCellCommand
    implements ActionListener {
        DelCellCommand() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TreePath treePath = ColViewPanel.this.colViewTree.getSelectionPath();
            CellNode cn = (CellNode)((Object)treePath.getLastPathComponent());
            Device d = cn.d;
            Cp.exec((String)"com.sigrity.orbit.colView.ColViewPanel.cDelCell (\"%s\", \"%s\");", (Object[])new Object[]{ColViewPanel.this.mDieTemplate.getKeyStr(), d.getKeyStr()});
            ThePanel.refreshTree();
            OrbitIO.getOrbitIO().refreshCurrentView(false);
        }
    }

    protected static class ColViewTree
    extends JTree
    implements Autoscroll {
        protected ATreeModel mDbTreeModel;
        protected PopupMenuHandler mPopupMenuHandler = null;
        protected ColViewPanel owner = null;
        public TreeSearcher ts;
        protected MouseListener mMouseListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    this.popupMenu(e);
                } else if (e.getButton() != 1 || e.getClickCount() == 2) {
                    // empty if block
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    this.popupMenu(e);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    this.popupMenu(e);
                }
            }
        };
        protected Insets m_autoscrollInsets = new Insets(20, 20, 20, 20);

        public ColViewTree(ATreeModel tm, ColViewPanel owner) {
            super((TreeModel)tm);
            this.owner = owner;
            this.mDbTreeModel = tm;
            this.addMouseListener(this.mMouseListener);
        }

        public void setPopupMenuHandler(PopupMenuHandler h) {
            this.mPopupMenuHandler = h;
        }

        protected void popupMenu(MouseEvent e) {
            if (this.mPopupMenuHandler != null) {
                this.mPopupMenuHandler.handlePopup(e.getX(), e.getY());
            }
        }

        @Override
        public Insets getAutoscrollInsets() {
            return this.m_autoscrollInsets;
        }

        @Override
        public void autoscroll(Point cursorLocation) {
            Insets insets = this.getAutoscrollInsets();
            Rectangle outer = this.getVisibleRect();
            Rectangle inner = new Rectangle(outer.x + insets.left, outer.y + insets.top, outer.width - (insets.left + insets.right), outer.height - (insets.top + insets.bottom));
            if (!inner.contains(cursorLocation)) {
                Rectangle scrollRect = new Rectangle(cursorLocation.x - insets.left, cursorLocation.y - insets.top, insets.left + insets.right, insets.top + insets.bottom);
                this.scrollRectToVisible(scrollRect);
            }
        }

        static interface PopupMenuHandler {
            public void handlePopup(int var1, int var2);
        }
    }

    protected class TreeSearcher {
        JTree tree;
        Pattern lastPattern;
        int nth = 1;
        ArrayList<TreePath> matchNodes = new ArrayList();

        public TreeSearcher(JTree tree) {
            this.tree = tree;
        }

        public void searchFor(Pattern pattern) {
            this.matchNodes.clear();
            this.nth = 1;
            TreeNode root = (TreeNode)this.tree.getModel().getRoot();
            this.findNodesThatMatch(new TreePath(root), this.matchNodes, pattern);
            this.showSearchResults(1);
            this.lastPattern = pattern;
        }

        public void next() {
            ++this.nth;
            if (this.nth - 1 >= this.matchNodes.size()) {
                this.nth = 1;
            }
            this.showSearchResults(this.nth);
        }

        public void back() {
            --this.nth;
            if (this.nth <= 0) {
                this.nth = this.matchNodes.size();
            }
            this.showSearchResults(this.nth);
        }

        protected Pattern getLastPattern() {
            return this.lastPattern;
        }

        protected void invalidate() {
            this.lastPattern = null;
        }

        private void showSearchResults(int nth) {
            int arrayIndex = nth - 1;
            if (arrayIndex >= 0 && this.matchNodes.size() > arrayIndex) {
                this.tree.setSelectionPath(this.matchNodes.get(arrayIndex));
                this.tree.makeVisible(this.matchNodes.get(arrayIndex));
                this.showMe(this.matchNodes.get(arrayIndex));
                ColViewPanel.this.findResults.setText(nth + " of " + this.matchNodes.size());
                ColViewPanel.this.findResults.paintImmediately(ColViewPanel.this.findResults.getVisibleRect());
            } else {
                this.tree.clearSelection();
                ColViewPanel.this.findResults.setText("0 of 0");
                ColViewPanel.this.findResults.paintImmediately(ColViewPanel.this.findResults.getVisibleRect());
            }
        }

        protected void showMe(TreePath path) {
            if (path == null) {
                return;
            }
            Rectangle r1 = ColViewPanel.this.colViewTree.getParent().getBounds();
            if (ColViewPanel.this.colViewTree.getPathBounds(path) != null) {
                Rectangle r2 = new Rectangle(ColViewPanel.this.colViewTree.getPathBounds(path));
                r2.setSize(r1.width, r1.height);
                ColViewPanel.this.colViewTree.scrollRectToVisible(r2);
            }
        }

        private void findNodesThatMatch(TreePath parent, ArrayList<TreePath> matchNodes, Pattern pattern) {
        }
    }

    protected class HistoryListener
    extends DbHistory.ListenerAdapter {
        protected HistoryListener() {
        }

        public void endUndoRedo(boolean isRedo) {
            if (ColViewPanel.this.mDieTemplate == null) {
                return;
            }
            ColViewPanel.this.mColView = new ColView(ColViewPanel.this.mDieTemplate);
            ColView cv = new ColView(ColViewPanel.this.mDieTemplate);
            cv.makeColViewFromDataBase(false);
            ThePanel.refreshTree();
            OrbitIO.getOrbitIO().refreshCurrentView(false);
        }
    }

    class ratioDrivenListener
    implements ExternalDeviceUpdateListener.ListenerInterface {
        ratioDrivenListener() {
        }

        @Override
        public void updated(Device d) {
            if (ColViewPanel.externalAddState.state.equals((Object)ExternalAddState.Waiting)) {
                ColViewPanel.externalAddState.state = ExternalAddState.NotWaiting;
                Cp.exec((String)"com.sigrity.orbit.colView.ColViewPanel.cInsertDeviceIntoColRow(\"%s\",\"%s\", %d, %d);", (Object[])new Object[]{ColViewPanel.this.mDieTemplate.getKeyStr(), d.getKeyStr(), ColViewPanel.externalAddState.addColumn, ColViewPanel.externalAddState.addRow});
            } else {
                Cp.exec((String)"com.sigrity.orbit.colView.ColViewPanel.cUpdateColCommand(\"%s\");", (Object[])new Object[]{ColViewPanel.this.mDieTemplate.getKeyStr()});
            }
            ThePanel.refreshTree();
            OrbitIO.getOrbitIO().refreshCurrentView(false);
            ThePanel.refreshTree();
        }
    }

    static class ExternalAddInfo {
        ExternalAddState state = ExternalAddState.NotWaiting;
        int addColumn;
        int addRow;

        ExternalAddInfo() {
        }
    }

    static enum ExternalAddState {
        NotWaiting,
        Waiting;

    }
}

