/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.colView;

import com.sigrity.acl.app.Settings;
import com.sigrity.acl.ui.ADialog;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.acl.ui.UIUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.HeadlessException;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JPanel;

public class ColViewPreferencesDlg
extends ADialog {
    protected JCheckBox mShowTemplateNames;
    protected JCheckBox mShowInstanceNames;
    protected JCheckBox mShowGapValues;
    protected JCheckBox mShowDimensions;
    protected ActionListener mOk = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            ColViewPreferencesDlg.this.writeSettings();
            UIUtil.closeWindow((Window)((Object)ColViewPreferencesDlg.this));
        }
    };

    public static ColViewPreferencesDlg createDialog(Window owner) {
        ColViewPreferencesDlg dlg = null;
        dlg = new ColViewPreferencesDlg(owner);
        dlg.init();
        return dlg;
    }

    public ColViewPreferencesDlg(Window owner) throws HeadlessException {
        super(owner);
    }

    protected void init() {
        this.setTitle("Column View Preferences");
        this.setModal(true);
        GridBagManager l = new GridBagManager(this.getContentPane());
        l.push("Tree Look", (GridBagConstraints)GridBagManager.LEFT);
        this.mShowTemplateNames = new JCheckBox("Show Template Names");
        l.add((Component)this.mShowTemplateNames);
        l.newline();
        this.mShowInstanceNames = new JCheckBox("Show Instance Names");
        l.add((Component)this.mShowInstanceNames);
        l.newline();
        this.mShowGapValues = new JCheckBox("Show Gap Values");
        l.add((Component)this.mShowGapValues);
        l.newline();
        this.mShowDimensions = new JCheckBox("Show Dimensions on Canvas");
        l.add((Component)this.mShowDimensions);
        l.newline();
        l.popNl();
        l.push((Container)new JPanel(), (GridBagConstraints)GridBagManager.RIGHT_REMAINX);
        JButton btnOk = new JButton("OK");
        l.add((Component)btnOk, (GridBagConstraints)GridBagManager.RIGHT);
        btnOk.addActionListener(this.mOk);
        JButton btnClose = new JButton("Cancel");
        l.add((Component)btnClose, (GridBagConstraints)GridBagManager.RIGHT);
        l.pop();
        this.updateUI();
        UIUtil.enableEscCloseDefaultMinSize((JDialog)((Object)this), (AbstractButton)btnClose, (JButton)btnOk);
        this.pack();
        this.setMinimumSize(this.getPreferredSize());
        UIUtil.center((Component)((Object)this));
    }

    protected void loadSettings() {
        Settings userPrefs = Settings.getSettings((String)"UserPreferences");
        Boolean showInstanceNames = (Boolean)userPrefs.getSetting("ColView.showInstanceNames", (Object)false);
        this.mShowInstanceNames.setSelected(showInstanceNames);
        Boolean showTemplateNames = (Boolean)userPrefs.getSetting("ColView.showTemplateNames", (Object)false);
        this.mShowTemplateNames.setSelected(showTemplateNames);
        Boolean showGapValues = (Boolean)userPrefs.getSetting("ColView.showGapValues", (Object)false);
        this.mShowGapValues.setSelected(showGapValues);
        Boolean showDimensions = (Boolean)userPrefs.getSetting("ColView.showDimensions", (Object)false);
        this.mShowDimensions.setSelected(showDimensions);
    }

    protected void writeSettings() {
        Settings userPrefs = Settings.getSettings((String)"UserPreferences");
        userPrefs.putSetting("ColView.showTemplateNames", (Object)this.mShowTemplateNames.isSelected());
        userPrefs.putSetting("ColView.showInstanceNames", (Object)this.mShowInstanceNames.isSelected());
        userPrefs.putSetting("ColView.showGapValues", (Object)this.mShowGapValues.isSelected());
        userPrefs.putSetting("ColView.showDimensions", (Object)this.mShowDimensions.isSelected());
        Settings.save((String)"UserPreferences");
    }

    protected void updateUI() {
        this.loadSettings();
    }
}

