/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.colView;

import com.sigrity.acl.ALog;
import com.sigrity.acl.Unit;
import com.sigrity.acl.app.AAppView;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.ui.DbDialog;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.orbit.OrbitIO;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.HeadlessException;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class ColViewSetGapDlg
extends DbDialog {
    protected AAppView mView;
    protected JTextField mGapField;
    protected GapInfo mAccepted = null;
    protected ActionListener mOk = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            ColViewSetGapDlg.this.mAccepted = new GapInfo();
            ColViewSetGapDlg.this.mAccepted.make();
            UIUtil.closeWindow((Window)((Object)ColViewSetGapDlg.this));
        }
    };

    public static ColViewSetGapDlg createDialog(Window owner, Db db, int row, double gap) {
        ColViewSetGapDlg dlg = null;
        dlg = new ColViewSetGapDlg(db, owner);
        dlg.init(row, gap);
        return dlg;
    }

    public ColViewSetGapDlg(Db db, Window owner) throws HeadlessException {
        super(db, (Component)owner);
    }

    public GapInfo getAccepted() {
        return this.mAccepted;
    }

    protected void init(int row, double gap) {
        this.mView = OrbitIO.getCurView();
        this.setTitle("Edit Gap");
        this.setModal(true);
        GridBagManager l = new GridBagManager(this.getContentPane());
        l.pushFillX();
        l.add("Gap:");
        this.mGapField = new JTextField(10);
        this.mGapField.setText(Double.toString(gap));
        l.add((Component)this.mGapField, (GridBagConstraints)GridBagManager.FILLX_REMAINX);
        l.pop();
        l.newline();
        l.push((Container)new JPanel(), (GridBagConstraints)GridBagManager.RIGHT_REMAINX);
        JButton btnOk = new JButton("OK");
        l.add((Component)btnOk, (GridBagConstraints)GridBagManager.RIGHT);
        btnOk.addActionListener(this.mOk);
        JButton btnClose = new JButton("Cancel");
        l.add((Component)btnClose, (GridBagConstraints)GridBagManager.RIGHT);
        l.pop();
        this.updateUI();
        UIUtil.enableEscCloseDefaultMinSize((JDialog)((Object)this), (AbstractButton)btnClose, (JButton)btnOk);
        this.pack();
        this.setMinimumSize(this.getPreferredSize());
        UIUtil.center((Component)((Object)this));
    }

    public void addNotify() {
        super.addNotify();
        this.updateUI();
    }

    protected void updateUI() {
    }

    public class GapInfo {
        long mGap;

        protected void make() {
            Unit unit = Design.getUnit((Db)OrbitIO.getCurDb());
            String text = ColViewSetGapDlg.this.mGapField.getText();
            this.mGap = 0L;
            if (!text.isEmpty()) {
                try {
                    this.mGap = unit.fromUserString(text);
                }
                catch (NumberFormatException nfe) {
                    ALog.logWarn((String)"%s is not a number", (Object[])new Object[]{text});
                    this.mGap = 0L;
                }
            }
        }
    }
}

