/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.diff_merge;

import com.sigrity.acl.AIterableItr;
import com.sigrity.acl.ALog;
import com.sigrity.acl.IterableIterator;
import com.sigrity.acl.db.DbObject;
import com.sigrity.orbit.diff_merge.CompareContext;
import java.util.Iterator;
import java.util.List;
import javax.swing.Action;

public abstract class Compare<T extends DbObject> {
    protected abstract Iterator<Diff<? extends DbObject>> findDiffs(CompareContext var1, T var2, T var3);

    public IterableIterator<Diff<? extends DbObject>> getDiffs(CompareContext context, T orig, T updated) {
        return AIterableItr.itr(this.findDiffs(context, orig, updated));
    }

    public static abstract class Mergeable<T extends DbObject>
    extends Diff<T> {
        protected State mState = State.Unattempted;
        protected String mMergeMessage = null;

        public Mergeable(T owner, Diff.Type type) {
            super(owner, type);
        }

        public boolean canMerge() {
            return this.mState != State.Complete;
        }

        protected abstract boolean _merge();

        public boolean merge() {
            if (!this.canMerge()) {
                return false;
            }
            try {
                if (this._merge()) {
                    this.mState = State.Complete;
                    return true;
                }
                this.mState = State.Failed;
                return false;
            }
            catch (Throwable t) {
                String msg = ALog.appendThrowableToMessage((Throwable)t, (String)"Unexpected error during merge.");
                this.setMergeMessage(msg, new Object[0]);
                this.mState = State.Failed;
                return false;
            }
        }

        public String getMergeMessage() {
            return this.mMergeMessage;
        }

        protected void setMergeMessage(String fmt, Object ... args) {
            this.mMergeMessage = String.format(fmt, args);
        }

        public static enum State {
            Unattempted,
            Failed,
            Complete;

        }
    }

    public static abstract class Diff<T extends DbObject>
    implements Comparable<Diff<?>> {
        protected T mOwner;
        protected Type mType;

        public Diff(T owner, Type type) {
            this.mOwner = owner;
            this.mType = type;
        }

        public Type getType() {
            return this.mType;
        }

        public T getOwner() {
            return this.mOwner;
        }

        public Class<? extends DbObject> getModifiedType() {
            return this.mOwner.getClass();
        }

        public abstract String getDesc();

        public abstract String getItemDesc();

        public abstract String getOldDesc();

        public abstract String getNewDesc();

        public abstract String getUserName();

        public String toString() {
            return this.getDesc();
        }

        public abstract List<Action> getActions();

        @Override
        public int compareTo(Diff<?> other) {
            return this.getDesc().compareTo(other.getDesc());
        }

        public String getDbClass() {
            if (this.mOwner == null) {
                return "[Unknown]";
            }
            return this.mOwner.getClass().getSimpleName();
        }

        public static enum Type {
            ADD,
            DELETE,
            MODIFY;

        }
    }
}

