/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.diff_merge;

import com.google.common.collect.Maps;
import com.sigrity.acl.Indenter;
import com.sigrity.acl.Unit;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.std.Design;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Optional;

public class CompareContext {
    protected HashMap<Class<?>, ItemFactory<?>> mItemFactories = Maps.newHashMap();
    protected HashMap<Class<?>, Object> mItems = Maps.newHashMap();
    protected Integer mDistanceDecimalPlace = null;

    public void setDistanceDecimalPlace(int d) {
        if (d < 0 || d > 20) {
            throw new IllegalArgumentException("decimal places can not be negative or more than 20");
        }
        this.mDistanceDecimalPlace = d;
    }

    public Unit getDistanceUnit(Db db) {
        Design design = Design.getDesign((Db)db);
        if (this.mDistanceDecimalPlace == null) {
            return design.getUnit();
        }
        return new Unit.Distance(design.getUnitDistName(), (double)design.getUnitDistDbuCount(), this.mDistanceDecimalPlace.intValue(), design.getUnitDistDbuPerMicron());
    }

    public <T> void register(Class<T> type, ItemFactory<T> factory) {
        if (!this.mItemFactories.containsKey(type)) {
            this.mItemFactories.put(type, factory);
        }
    }

    public <T> T getItem(Class<T> type) {
        ItemFactory<?> factory;
        Object item = this.mItems.get(type);
        if (item == null && (factory = this.mItemFactories.get(type)) != null && (item = factory.create(this)) != null) {
            this.mItems.put(type, item);
        }
        return (T)item;
    }

    public <T> T getItem(Class<T> type, ItemFactory<T> factory) {
        if (!this.mItemFactories.containsKey(type)) {
            this.mItemFactories.put(type, factory);
        }
        return this.getItem(type);
    }

    public void dump(PrintStream to) {
        HashSet classesOutput = new HashSet();
        try (Indenter out = new Indenter((OutputStream)to);){
            this.mItemFactories.forEach((cls, factory) -> {
                out.formatln("Class: %s; Factory: %s", new Object[]{cls.getName(), factory.getClass().getName()});
                out.indent();
                Optional.ofNullable(this.mItems.get(cls)).ifPresent(obj -> out.formatln("Object: %s", new Object[]{obj}));
                out.unindent();
                classesOutput.add(cls);
            });
            this.mItems.forEach((cls, obj) -> {
                if (!classesOutput.contains(cls)) {
                    out.formatln("Object: %s", new Object[]{obj});
                    classesOutput.add(cls);
                }
            });
        }
    }

    public static interface ItemFactory<T> {
        public T create(CompareContext var1);
    }
}

