/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.diff_merge;

import com.google.common.collect.BiMap;
import com.google.common.collect.Lists;
import com.sigrity.acl.ATransformUtil;
import com.sigrity.acl.AUtil;
import com.sigrity.acl.Unit;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.Selection;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.NetMap;
import com.sigrity.acl.db.std.Personality;
import com.sigrity.acl.db.std.PersonalityMap;
import com.sigrity.acl.db.std.PinInstance;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.HierPin;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.ShowMeTheWay;
import com.sigrity.orbit.diff_merge.Compare;
import com.sigrity.orbit.diff_merge.CompareContext;
import com.sigrity.orbit.diff_merge.CompareDeviceTemplate;
import com.sigrity.orbit.diff_merge.CompareRegistry;
import java.awt.event.ActionEvent;
import java.awt.geom.AffineTransform;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.swing.AbstractAction;
import javax.swing.Action;

public class CompareDevice
extends Compare<Device> {
    @Override
    public Iterator<Compare.Diff<?>> findDiffs(CompareContext context, Device a, Device b) {
        Comparator dc = new Comparator(context, a, b);
        return dc.getDiffs().iterator();
    }

    public static class PinPersonalityChanged
    extends Compare.Mergeable<PinInstance>
    implements Comparable<Compare.Diff<?>> {
        protected PinInstance mPinUpdated;
        protected String mPersonalityName;
        protected boolean mAdded;

        public PinPersonalityChanged(PinInstance pinOrig, PinInstance pinUpdated, String persName, boolean add) {
            super(pinOrig, Compare.Diff.Type.MODIFY);
            this.mPinUpdated = pinUpdated;
            this.mPersonalityName = persName;
            this.mAdded = add;
        }

        @Override
        protected boolean _merge() {
            DeviceTemplate devTempOrig = ((PinInstance)this.mOwner).getDeviceTemplate();
            if (this.mAdded) {
                Personality personality;
                Optional persOrig = Personality.getPersonality((DeviceTemplate)devTempOrig, (Personality.Type)Personality.Type.PORT, (String)this.mPersonalityName);
                if (!persOrig.isPresent()) {
                    Optional persUpdt = Personality.getPersonality((DeviceTemplate)this.mPinUpdated.getDeviceTemplate(), (Personality.Type)Personality.Type.PORT, (String)this.mPersonalityName);
                    if (persUpdt.isPresent()) {
                        personality = ((Personality)persUpdt.get()).copy(devTempOrig);
                    } else {
                        persOrig = Personality.create((DeviceTemplate)devTempOrig, (Personality.Type)Personality.Type.PORT, (String)this.mPersonalityName);
                        Objects.requireNonNull(persOrig);
                        if (!persOrig.isPresent()) {
                            throw new IllegalStateException();
                        }
                        personality = (Personality)persOrig.get();
                    }
                } else {
                    personality = (Personality)persOrig.get();
                }
                for (DevicePath devPath : devTempOrig.getDescendantDevices()) {
                    if (devPath.getLast() != ((PinInstance)this.mOwner).getDevice()) continue;
                    PersonalityMap.create((Personality)personality, (DevicePath)devPath, (DbObject)this.mOwner);
                }
                return true;
            }
            Optional persOrig = Personality.getPersonality((DeviceTemplate)devTempOrig, (Personality.Type)Personality.Type.PORT, (String)this.mPersonalityName);
            if (!persOrig.isPresent()) {
                this.setMergeMessage("Unable to remove Personality '%s' from new pin '%s' as the specified Personality does not exist on Substrate '%s'.", this.mPersonalityName, ((PinInstance)this.mOwner).getName(), devTempOrig.getName());
                return false;
            }
            boolean ans = PersonalityMap.removePersonalityMaps((DbObject)this.mOwner, (Personality)((Personality)persOrig.get()));
            if (!ans) {
                this.setMergeMessage("Unable to remove Personality '%s' from new pin '%s' as the specified Personality is not associated with the pin.", this.mPersonalityName, ((PinInstance)this.mOwner).getName());
            }
            return ans;
        }

        @Override
        public String getDesc() {
            return String.format("Device '%s' pin '%s' had Personality '%s' %s.", ((PinInstance)this.mOwner).getDevice().getName(), ((PinInstance)this.mOwner).getName(), this.mPersonalityName, this.mAdded ? "added" : "removed");
        }

        @Override
        public List<Action> getActions() {
            return List.of(this.getActionSelect(), this.getActionShow());
        }

        protected Action getActionSelect() {
            return new AbstractAction("Select"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Selection s = Selection.getCurrentSelectionForDb((Db)((PinInstance)mOwner).getDb());
                    s.add(mOwner);
                    OrbitIO.getOrbitIO().refreshCurrentView();
                }
            };
        }

        protected Action getActionShow() {
            return new AbstractAction("Show"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    for (DevicePath path : ((PinInstance)mOwner).getDevice().getHierarchicalInstances()) {
                        ShowMeTheWay.addHierPin(new HierPin(path, (PinInstance)mOwner));
                    }
                    for (DevicePath path : mPinUpdated.getDevice().getHierarchicalInstances()) {
                        String msg = String.format("'%s' %s", mPersonalityName, mAdded ? "added" : "removed");
                        ShowMeTheWay.showMeAPt(new HierPin(path, mPinUpdated).getWorldLoc(), msg, ShowMeTheWay.LineStyle.Straight, null);
                    }
                }
            };
        }

        @Override
        public int compareTo(Compare.Diff<?> other) {
            if (!(other instanceof PinPersonalityChanged)) {
                return super.compareTo(other);
            }
            PinPersonalityChanged o = (PinPersonalityChanged)other;
            int r = ((PinInstance)this.mOwner).getDevice().getName().compareTo(((PinInstance)o.mOwner).getName());
            if (r == 0) {
                r = ((PinInstance)this.mOwner).getName().compareTo(((PinInstance)o.mOwner).getName());
            }
            if (r == 0) {
                r = Boolean.compare(this.mAdded, o.mAdded);
            }
            if (r == 0) {
                r = this.mPersonalityName.compareTo(o.mPersonalityName);
            }
            return r;
        }

        @Override
        public String getDbClass() {
            return "Pin";
        }

        @Override
        public String getItemDesc() {
            return "personality";
        }

        @Override
        public String getOldDesc() {
            if (this.mAdded) {
                return "";
            }
            return this.mPersonalityName;
        }

        @Override
        public String getNewDesc() {
            if (!this.mAdded) {
                return "";
            }
            return this.mPersonalityName;
        }

        @Override
        public String getUserName() {
            return "Personality Changed";
        }
    }

    public static class NetMapChanged
    extends NetMapMergeable {
        protected Net mNetParentOrig;
        protected String mNetNameUpdated;

        public NetMapChanged(Device child, Net netOrig, String netNameUpdated) {
            super(child, netOrig, Compare.Diff.Type.MODIFY);
            this.mNetChildOrig = netOrig;
            this.mNetParentOrig = NetMap.getParentNet((Device)((Device)this.mOwner), (Net)this.mNetChildOrig);
            this.mNetNameUpdated = netNameUpdated;
        }

        @Override
        public boolean canMerge() {
            return ((Device)this.mOwner).getParent().getNet(this.mNetNameUpdated) != null && super.canMerge();
        }

        @Override
        protected boolean _merge() {
            Net newParentNet = ((Device)this.mOwner).getParent().getNet(this.mNetNameUpdated);
            if (newParentNet == null) {
                this.setMergeMessage("Unable to get parent net for Device '%s' net '%s', merge failed.", ((Device)this.mOwner).getName(), this.mNetChildOrig.getName());
                return false;
            }
            return NetMap.mapChildNet((Device)((Device)this.mOwner), (Net)this.mNetChildOrig, (Net)newParentNet);
        }

        @Override
        public String getDesc() {
            return String.format("The net '%s' on device '%s' was remapped from parent net '%s' to parent net '%s'.", this.mNetChildOrig.getName(), ((Device)this.mOwner).getName(), this.mNetParentOrig.getName(), this.mNetNameUpdated);
        }

        @Override
        public Class<NetMap> getModifiedType() {
            return NetMap.class;
        }

        @Override
        public String getItemDesc() {
            return "map";
        }

        @Override
        public String getOldDesc() {
            DeviceTemplate dtParent = this.mOwner == null ? null : ((Device)this.mOwner).getParent();
            Object parent = dtParent == null ? "" + dtParent : dtParent.getName();
            return String.format("%s -> %s, %s", this.mNetChildOrig == null ? "<none>" : this.mNetChildOrig.getName(), parent, this.mNetParentOrig == null ? "<none>" : this.mNetParentOrig.getName());
        }

        @Override
        public String getNewDesc() {
            DeviceTemplate dtParent = this.mOwner == null ? null : ((Device)this.mOwner).getParent();
            Object parent = dtParent == null ? "" + dtParent : dtParent.getName();
            return String.format("%s, %s -> %s, %s", this.mNetChildOrig == null ? "<none>" : this.mNetChildOrig.getName(), this.mOwner == null ? "<none>" : ((Device)this.mOwner).getName(), parent, this.mNetNameUpdated);
        }

        @Override
        public String getUserName() {
            return "Changed";
        }
    }

    public static class NetMapRemoved
    extends NetMapMergeable {
        protected Net mNetParentOrig;

        public NetMapRemoved(Device childDevice, Net netOrig) {
            super(childDevice, netOrig, Compare.Diff.Type.DELETE);
            this.mNetChildOrig = netOrig;
            this.mNetParentOrig = NetMap.getParentNet((Device)((Device)this.mOwner), (Net)this.mNetChildOrig);
        }

        @Override
        protected boolean _merge() {
            boolean result;
            Net newChildNet = ((Device)this.mOwner).getTemplate().getNet(this.mNetChildOrig.getName());
            if (((Device)this.mOwner).getTemplate() != this.mNetChildOrig.getDeviceTemplate()) {
                Net parentNet;
                Net net = parentNet = newChildNet == null ? null : NetMap.getParentNet((Device)((Device)this.mOwner), (Net)newChildNet);
                if (parentNet == null) {
                    this.setMergeMessage("The parent mapping is no longer valid, perhaps due to a previously merged change.", new Object[0]);
                    return true;
                }
            }
            if (!(result = NetMap.unmap((Device)((Device)this.mOwner), (Net)newChildNet, (Net)this.mNetParentOrig))) {
                this.setMergeMessage("Unmapping %s failed.", NetMap.getUserDesc((Net)this.mNetParentOrig, (Device)((Device)this.mOwner), (Net)this.mNetChildOrig));
            }
            return result;
        }

        @Override
        public String getDesc() {
            DeviceTemplate dtParent = this.mOwner == null ? null : ((Device)this.mOwner).getParent();
            Object parent = dtParent == null ? "" + dtParent : dtParent.getName();
            return String.format("The net '%s' on device '%s' (parent: '%s') had its mapping to parent net '%s' removed.", this.mNetChildOrig == null ? "<none>" : this.mNetChildOrig.getName(), this.mOwner == null ? "<none>" : ((Device)this.mOwner).getName(), parent, this.mNetParentOrig == null ? "<none>" : this.mNetParentOrig.getName());
        }

        @Override
        public Class<NetMap> getModifiedType() {
            return NetMap.class;
        }

        @Override
        public String getItemDesc() {
            return "map";
        }

        @Override
        public String getOldDesc() {
            DeviceTemplate dtParent = this.mOwner == null ? null : ((Device)this.mOwner).getParent();
            Object parent = dtParent == null ? "" + dtParent : dtParent.getName();
            return String.format("%s -> %s, %s", this.mNetChildOrig == null ? "<none>" : this.mNetChildOrig.getName(), parent, this.mNetParentOrig == null ? "<none>" : this.mNetParentOrig.getName());
        }

        @Override
        public String getNewDesc() {
            return "";
        }

        @Override
        public String getUserName() {
            return "Removed";
        }
    }

    public static class NetMapAdded
    extends NetMapMergeable {
        protected String mNetNameParentUpdated;

        public NetMapAdded(Device child, Net netChild, String netNameParentUpdated) {
            super(child, netChild, Compare.Diff.Type.ADD);
            this.mNetChildOrig = netChild;
            this.mNetNameParentUpdated = netNameParentUpdated;
        }

        @Override
        public boolean canMerge() {
            return ((Device)this.mOwner).getParent().getNet(this.mNetNameParentUpdated) != null;
        }

        @Override
        protected boolean _merge() {
            Net newParentNet = ((Device)this.mOwner).getParent().getNet(this.mNetNameParentUpdated);
            if (newParentNet == null) {
                this.setMergeMessage("Unable to merge, parent Net '%s' does not exist.", this.mNetNameParentUpdated);
                return false;
            }
            return NetMap.mapChildNet((Device)((Device)this.mOwner), (Net)this.mNetChildOrig, (Net)newParentNet);
        }

        @Override
        public String getDesc() {
            return String.format("The net '%s' on device '%s' was mapped to parent net '%s'.", this.mNetChildOrig.getName(), ((Device)this.mOwner).getName(), this.mNetNameParentUpdated);
        }

        @Override
        public Class<NetMap> getModifiedType() {
            return NetMap.class;
        }

        @Override
        public String getItemDesc() {
            return "map";
        }

        @Override
        public String getOldDesc() {
            return "";
        }

        @Override
        public String getNewDesc() {
            DeviceTemplate dtParent = this.mOwner == null ? null : ((Device)this.mOwner).getParent();
            Object parent = dtParent == null ? "" + dtParent : dtParent.getName();
            return String.format("%s -> %s, %s", this.mNetChildOrig.getName(), this.mNetNameParentUpdated, parent);
        }

        @Override
        public String getUserName() {
            return "Added";
        }
    }

    public static abstract class NetMapMergeable
    extends Compare.Mergeable<Device> {
        protected Net mNetChildOrig;

        public NetMapMergeable(Device child, Net netChildOrig, Compare.Diff.Type type) {
            super(child, type);
            this.mNetChildOrig = netChildOrig;
        }

        @Override
        public List<Action> getActions() {
            return Collections.emptyList();
        }

        @Override
        public String getDbClass() {
            return "Net Mapping";
        }
    }

    public static class PinAdded
    extends Compare.Mergeable<Device> {
        protected PinInstance mPinUpdated;
        protected Unit mUnit = null;
        protected AffineTransform mXform = null;

        public PinAdded(Device devOrig, PinInstance pinUpdated) {
            super(devOrig, Compare.Diff.Type.ADD);
            this.mPinUpdated = pinUpdated;
        }

        public void setUnit(Unit unit) {
            this.mUnit = unit;
        }

        public void setXform(AffineTransform xform) {
            this.mXform = xform;
        }

        @Override
        protected boolean _merge() {
            String netName;
            DeviceTemplate dtOrig = ((Device)this.mOwner).getTemplate();
            Net netOrig = dtOrig.getNet(netName = this.mPinUpdated.getNet().getName());
            if (netOrig != null) {
                this.setMergeMessage("Unable to create new pin at this time, Net '%s' does not exist on DeviceTemplate '%s'.", netName, ((Device)this.mOwner).getName());
                return false;
            }
            PinTemplate dtpUpdated = this.mPinUpdated.getPinTemplate();
            PinTemplate dtpOrig = dtOrig.getPinByName(dtpUpdated.getName());
            if (dtpOrig == null && (dtpOrig = dtpUpdated.copyTo(dtOrig)) == null) {
                this.setMergeMessage("Unable to create new template pin '%s' on Net '%s' on DeviceTemplate '%s'.", dtpUpdated.getName(), netName, ((Device)this.mOwner).getName());
                return false;
            }
            PinInstance pinOrig = PinInstance.create((Db)((Device)this.mOwner).getDb(), (String)this.mPinUpdated.getName(), (Device)((Device)this.mOwner), (PinTemplate)dtpOrig);
            if (pinOrig == null) {
                this.setMergeMessage("Unable to create new pin '%s' on Net '%s' on DeviceTemplate '%s'.", this.mPinUpdated.getName(), netName, ((Device)this.mOwner).getName());
                return false;
            }
            pinOrig.setPinNum(this.mPinUpdated.getPinNum());
            return true;
        }

        @Override
        public String getDesc() {
            APoint2D loc = this.mPinUpdated.getLoc();
            if (this.mXform != null) {
                loc = loc.transform(this.mXform);
            }
            String strLoc = loc.toString(this.mUnit);
            return String.format("Pin '%s' on net '%s' was added to Device '%s' at %s.", this.mPinUpdated.getName(), this.mPinUpdated.getNet().getName(), ((Device)this.mOwner).getName(), strLoc);
        }

        public PinInstance getUpdatedPin() {
            return this.mPinUpdated;
        }

        @Override
        public List<Action> getActions() {
            return List.of(this.getActionSelect(), this.getActionShow());
        }

        protected Action getActionSelect() {
            return new AbstractAction("Select"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Selection s = Selection.getCurrentSelectionForDb((Db)((Device)mOwner).getDb());
                    s.add(mOwner);
                    s.add((DbObject)mPinUpdated);
                    OrbitIO.getOrbitIO().refreshCurrentView();
                }
            };
        }

        protected Action getActionShow() {
            return new AbstractAction("Show"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    for (DevicePath path : ((Device)mOwner).getHierarchicalInstances()) {
                        ShowMeTheWay.addDevicePath(path);
                    }
                    for (DevicePath path : mPinUpdated.getDeviceTemplate().getHierarchicalInstances()) {
                        ShowMeTheWay.addHierPin(new HierPin(path, mPinUpdated));
                    }
                }
            };
        }

        @Override
        public String getItemDesc() {
            return "pin";
        }

        @Override
        public String getOldDesc() {
            return "";
        }

        @Override
        public String getNewDesc() {
            APoint2D loc = this.mPinUpdated.getLoc();
            if (this.mXform != null) {
                loc = loc.transform(this.mXform);
            }
            String strLoc = loc.toString(this.mUnit);
            return String.format("%s, %s, %s", this.mPinUpdated.getName(), strLoc, this.mPinUpdated.getNet().getName());
        }

        @Override
        public String getUserName() {
            return "Added";
        }
    }

    public static class DevicePlaced
    extends DeviceMergeable {
        public DevicePlaced(Device orig, Device updated) {
            super(orig, updated, Compare.Diff.Type.MODIFY);
        }

        @Override
        protected boolean _merge() {
            ((Device)this.mOwner).setIsPlaced(this.mUpdated.getIsPlaced());
            return true;
        }

        @Override
        public String getDesc() {
            return String.format("Device '%s' changed from %s to %s.", ((Device)this.mOwner).getName(), this.getOldDesc(), this.getOldDesc());
        }

        protected String getPlacedDesc(boolean placed) {
            return placed ? "placed" : "unplaced";
        }

        @Override
        public String getItemDesc() {
            return "placed";
        }

        @Override
        public String getOldDesc() {
            return this.getPlacedDesc(((Device)this.mOwner).getIsPlaced());
        }

        @Override
        public String getNewDesc() {
            return this.getPlacedDesc(this.mUpdated.getIsPlaced());
        }

        @Override
        public String getUserName() {
            return "Placed";
        }
    }

    public static class DeviceFixed
    extends DeviceMergeable {
        public DeviceFixed(Device orig, Device updated) {
            super(orig, updated, Compare.Diff.Type.MODIFY);
        }

        @Override
        protected boolean _merge() {
            ((Device)this.mOwner).setIsFixed(this.mUpdated.getIsFixed());
            return true;
        }

        @Override
        public String getDesc() {
            return String.format("Device '%s' changed from %s to %s.", ((Device)this.mOwner).getName(), this.getOldDesc(), this.getOldDesc());
        }

        protected String getFixedDesc(boolean fixed) {
            return fixed ? "fixed" : "not fixed";
        }

        @Override
        public String getItemDesc() {
            return "fixed";
        }

        @Override
        public String getOldDesc() {
            return this.getFixedDesc(((Device)this.mOwner).getIsFixed());
        }

        @Override
        public String getNewDesc() {
            return this.getFixedDesc(this.mUpdated.getIsFixed());
        }

        @Override
        public String getUserName() {
            return "Fix";
        }
    }

    public static class DeviceMirrored
    extends DeviceMergeable {
        protected boolean mOrigAddMirror = false;

        public DeviceMirrored(Device orig, Device updated) {
            super(orig, updated, Compare.Diff.Type.MODIFY);
        }

        public DeviceMirrored(Device orig, Device updated, boolean origAddMirror) {
            this(orig, updated);
            this.mOrigAddMirror = origAddMirror;
        }

        @Override
        protected boolean _merge() {
            ((Device)this.mOwner).setMirror(this.mOrigAddMirror ? !this.mUpdated.getMirror() : this.mUpdated.getMirror());
            return true;
        }

        @Override
        public String getDesc() {
            return String.format("Device '%s' changed from %s to %s.", ((Device)this.mOwner).getName(), this.getOldDesc(), this.getNewDesc());
        }

        protected String getMirrorDesc(boolean mirror) {
            return mirror ? "mirrored" : "not mirrored";
        }

        public boolean getNewMirror() {
            return this.mOrigAddMirror ? !this.mUpdated.getMirror() : this.mUpdated.getMirror();
        }

        @Override
        public String getItemDesc() {
            return "mirror";
        }

        @Override
        public String getOldDesc() {
            return this.getMirrorDesc(((Device)this.mOwner).getMirror());
        }

        @Override
        public String getNewDesc() {
            return this.getMirrorDesc(this.getNewMirror());
        }

        @Override
        public String getUserName() {
            return "Mirror";
        }
    }

    public static class DeviceRotated
    extends DeviceMergeable {
        protected float mOrigAddRot = 0.0f;

        public DeviceRotated(Device orig, Device updated) {
            super(orig, updated, Compare.Diff.Type.MODIFY);
        }

        public DeviceRotated(Device orig, Device updated, float origAddRot) {
            this(orig, updated);
            this.mOrigAddRot = origAddRot;
        }

        @Override
        protected boolean _merge() {
            ((Device)this.mOwner).setRotate(this.getNewRot());
            return true;
        }

        @Override
        public String getDesc() {
            return String.format("Device '%s' rotation was changed from %s to %s.", ((Device)this.mOwner).getName(), Float.valueOf(((Device)this.mOwner).getRotate()), Float.valueOf(this.getNewRot()));
        }

        public float getNewRot() {
            return ATransformUtil.normRot((float)(this.mUpdated.getRotate() - this.mOrigAddRot));
        }

        @Override
        public String getItemDesc() {
            return "Rotate";
        }

        @Override
        public String getOldDesc() {
            return "" + ((Device)this.mOwner).getRotate();
        }

        @Override
        public String getNewDesc() {
            return "" + this.getNewRot();
        }

        @Override
        public String getUserName() {
            return "Rotate";
        }
    }

    public static class DeviceMoved
    extends DeviceMergeable {
        protected AffineTransform mOrigAddXform = null;
        protected Unit mUnit = null;
        protected AffineTransform mXform = null;

        public DeviceMoved(Device orig, Device updated) {
            super(orig, updated, Compare.Diff.Type.MODIFY);
        }

        @Override
        protected Action getActionShow() {
            return new AbstractAction("Show"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    for (DevicePath path : ((Device)mOwner).getHierarchicalInstances()) {
                        ShowMeTheWay.addDevicePath(path, path.getLast().getName() + " original");
                    }
                    for (DevicePath path : mUpdated.getHierarchicalInstances()) {
                        ShowMeTheWay.addDevicePath(path, path.getLast().getName() + " moved");
                    }
                }
            };
        }

        public DeviceMoved(Device orig, Device updated, AffineTransform origAddXform) {
            this(orig, updated);
            this.mOrigAddXform = origAddXform;
        }

        public void setUnit(Unit unit) {
            this.mUnit = unit;
        }

        public void setXform(AffineTransform xform) {
            this.mXform = xform;
        }

        @Override
        protected boolean _merge() {
            ((Device)this.mOwner).setLoc(this.getNewLoc());
            return true;
        }

        @Override
        public String getDesc() {
            return String.format("Device '%s' was moved from %s to %s.", ((Device)this.mOwner).getName(), this.getOldDesc(), this.getNewDesc());
        }

        public APoint2D getNewLoc() {
            APoint2D newLoc = this.mUpdated.getLoc().copy();
            if (this.mOrigAddXform != null) {
                newLoc = newLoc.transform(ATransformUtil.inverse((AffineTransform)this.mOrigAddXform));
            }
            return newLoc;
        }

        @Override
        public String getItemDesc() {
            return "location";
        }

        @Override
        public String getOldDesc() {
            APoint2D oldLoc = ((Device)this.mOwner).getLoc();
            if (oldLoc != null && this.mXform != null) {
                oldLoc = oldLoc.transform(this.mXform);
            }
            return oldLoc == null ? "null" : oldLoc.toString(this.mUnit);
        }

        @Override
        public String getNewDesc() {
            APoint2D newLoc = this.getNewLoc();
            if (this.mXform != null) {
                newLoc = newLoc.transform(this.mXform);
            }
            return newLoc.toString(this.mUnit);
        }

        @Override
        public String getUserName() {
            return "Location";
        }
    }

    public static class DeviceTemplateChanged
    extends DeviceMergeable {
        public DeviceTemplateChanged(Device orig, Device updated) {
            super(orig, updated, Compare.Diff.Type.MODIFY);
            this.mUpdated = updated;
        }

        @Override
        public String getDesc() {
            return String.format("Device '%s' template was changed from '%s' to '%s'.", ((Device)this.mOwner).getName(), ((Device)this.mOwner).getTemplate().getName(), this.mUpdated.getTemplate().getName());
        }

        @Override
        protected boolean _merge() {
            DeviceTemplate newDevT = this.mUpdated.getTemplate();
            if (((Device)this.mOwner).getSubstrate() != newDevT.getSubstrate()) {
                DeviceTemplate t = ((Device)this.mOwner).getSubstrate().getDeviceTemplate(newDevT.getName());
                newDevT = t != null ? t : newDevT.copyToSubstrate(((Device)this.mOwner).getSubstrate());
            }
            ((Device)this.mOwner).replaceTemplate(newDevT);
            return true;
        }

        @Override
        public String getItemDesc() {
            return "template";
        }

        @Override
        public String getOldDesc() {
            return ((Device)this.mOwner).getTemplate().getName();
        }

        @Override
        public String getNewDesc() {
            return this.mUpdated.getTemplate().getName();
        }

        @Override
        public String getUserName() {
            return "Changed";
        }
    }

    public static abstract class DeviceMergeable
    extends Compare.Mergeable<Device> {
        protected Device mUpdated;

        public DeviceMergeable(Device orig, Device updated, Compare.Diff.Type type) {
            super(orig, type);
            this.mUpdated = updated;
        }

        @Override
        public List<Action> getActions() {
            return List.of(this.getActionSelect(), this.getActionShow());
        }

        protected Action getActionSelect() {
            return new AbstractAction("Select"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Selection s = Selection.getCurrentSelectionForDb((Db)((Device)mOwner).getDb());
                    s.add(mOwner);
                    OrbitIO.getOrbitIO().refreshCurrentView();
                }
            };
        }

        protected Action getActionShow() {
            return new AbstractAction("Show"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    for (DevicePath path : ((Device)mOwner).getHierarchicalInstances()) {
                        ShowMeTheWay.addDevicePath(path, path.getLast().getName() + " updated");
                    }
                }
            };
        }
    }

    public static class Comparator {
        protected CompareContext mCompareContext;
        protected Device mDeviceOrig;
        protected Device mDeviceUpdated;
        protected LinkedList<Compare.Diff<?>> mDiffs = Lists.newLinkedList();
        protected Consumer<Compare.Diff<?>> mDiffConsumer = d -> this.mDiffs.add((Compare.Diff<?>)d);

        public Comparator(CompareContext context, Device a, Device b) {
            this.mCompareContext = context;
            this.mDeviceOrig = a;
            this.mDeviceUpdated = b;
            context.register(CompareDeviceTemplate.EquivNets.class, CompareDeviceTemplate.EquivNets.Factory);
            context.register(CompareDeviceTemplate.EquivPinTemplates.class, CompareDeviceTemplate.EquivPinTemplates.Factory);
        }

        public Collection<Compare.Diff<?>> getDiffs() {
            this.compare();
            return this.mDiffs;
        }

        protected void compare() {
            DeviceTemplate dtUpdated;
            boolean deviceTemplateSame;
            DeviceTemplate dtOrig = this.mDeviceOrig.getTemplate();
            boolean bl = deviceTemplateSame = dtOrig == (dtUpdated = this.mDeviceUpdated.getTemplate());
            if (!(deviceTemplateSame || dtOrig.getSubstrate() != dtUpdated.getSubstrate() && AUtil.equals((Object)dtOrig.getName(), (Object)dtUpdated.getName()))) {
                this.mDiffs.add(new DeviceTemplateChanged(this.mDeviceOrig, this.mDeviceUpdated));
            }
            Unit unit = this.mCompareContext.getDistanceUnit(this.mDeviceOrig.getDb());
            if (!this.mDeviceOrig.getLoc().equals(this.mDeviceUpdated.getLoc(), unit)) {
                this.mDiffs.add(new DeviceMoved(this.mDeviceOrig, this.mDeviceUpdated));
            }
            if (this.mDeviceOrig.getRotate() != this.mDeviceUpdated.getRotate()) {
                this.mDiffs.add(new DeviceRotated(this.mDeviceOrig, this.mDeviceUpdated));
            }
            if (this.mDeviceOrig.getMirror() != this.mDeviceUpdated.getMirror()) {
                this.mDiffs.add(new DeviceMirrored(this.mDeviceOrig, this.mDeviceUpdated));
            }
            if (this.mDeviceOrig.getIsFixed() != this.mDeviceUpdated.getIsFixed()) {
                this.mDiffs.add(new DeviceFixed(this.mDeviceOrig, this.mDeviceUpdated));
            }
            if (this.mDeviceOrig.getIsPlaced() != this.mDeviceUpdated.getIsPlaced()) {
                this.mDiffs.add(new DevicePlaced(this.mDeviceOrig, this.mDeviceUpdated));
            }
            if (deviceTemplateSame) {
                for (Net net : dtOrig.getNets()) {
                    Comparator.compareNetMaps(this.mDeviceOrig, net, this.mDeviceUpdated, net, this.mDiffConsumer);
                }
            } else {
                CompareRegistry cr = CompareRegistry.getCompareRegistry();
                for (Compare compare : cr.getCompares(DeviceTemplate.class)) {
                    for (Compare.Diff change : compare.getDiffs(this.mCompareContext, dtOrig, dtUpdated)) {
                        this.mDiffs.add(change);
                    }
                }
                Map<Net, Net> equivNets = this.mCompareContext.getItem(CompareDeviceTemplate.EquivNets.class).getEquivNets(dtOrig, dtUpdated);
                for (Map.Entry<Net, Net> equivNet : equivNets.entrySet()) {
                    if (equivNet.getValue() == null) continue;
                    Comparator.compareNetMaps(this.mDeviceOrig, equivNet.getKey(), this.mDeviceUpdated, equivNet.getValue(), this.mDiffConsumer);
                }
            }
            this.comparePins();
        }

        public static void compareNetMaps(Device deviceChild, Net netOrig, Device deviceUpdated, Net netUpdated, Consumer<Compare.Diff<?>> diffConsumer) {
            Net netParentOrig = NetMap.getParentNet((Device)deviceChild, (Net)netOrig);
            Net netParentUpdated = NetMap.getParentNet((Device)deviceUpdated, (Net)netUpdated);
            if (netParentOrig != null && netParentUpdated != null) {
                if (!netParentOrig.getName().equals(netParentUpdated.getName())) {
                    diffConsumer.accept(new NetMapChanged(deviceChild, netOrig, netParentUpdated.getName()));
                }
            } else if (netParentOrig == null && netParentUpdated != null) {
                diffConsumer.accept(new NetMapAdded(deviceChild, netOrig, netParentUpdated.getName()));
            } else if (netParentOrig != null && netParentUpdated == null) {
                diffConsumer.accept(new NetMapRemoved(deviceChild, netOrig));
            }
        }

        protected void comparePins() {
            CompareDeviceTemplate.EquivPinTemplates ept = this.mCompareContext.getItem(CompareDeviceTemplate.EquivPinTemplates.class);
            BiMap<PinTemplate, PinTemplate> o2uPinT = ept.getEquivPinTemplates(this.mDeviceOrig.getTemplate(), this.mDeviceUpdated.getTemplate());
            for (PinInstance pinOrig : this.mDeviceOrig.getPins()) {
                PinTemplate pinTUpdated = (PinTemplate)o2uPinT.get((Object)pinOrig.getPinTemplate());
                if (pinTUpdated == null) continue;
                PinInstance pinUpdt = PinInstance.getPinInstance((Device)this.mDeviceUpdated, (PinTemplate)pinTUpdated);
                HashSet origPs = AUtil.hashSet((Iterator)PersonalityMap.getPersonalityNames((DbObject)pinOrig));
                HashSet updtPs = AUtil.hashSet((Iterator)PersonalityMap.getPersonalityNames((DbObject)pinUpdt));
                PersonalityMap.getPersonalityMaps((DbObject)pinUpdt).forEach(pm -> {
                    if (!origPs.contains(pm.getPersonality().getName())) {
                        this.mDiffs.add(new PinPersonalityChanged(pinOrig, pinUpdt, pm.getPersonality().getName(), true));
                    }
                });
                PersonalityMap.getPersonalityMaps((DbObject)pinOrig).forEach(pm -> {
                    if (!updtPs.contains(pm.getPersonality().getName())) {
                        this.mDiffs.add(new PinPersonalityChanged(pinOrig, pinUpdt, pm.getPersonality().getName(), false));
                    }
                });
            }
        }
    }
}

