/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.diff_merge;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.sigrity.acl.AEmptyItr;
import com.sigrity.acl.APair;
import com.sigrity.acl.AUtil;
import com.sigrity.acl.Unit;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.Selection;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Layer;
import com.sigrity.acl.db.std.LayerShape;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.Obstacle;
import com.sigrity.acl.db.std.PinInstance;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.acl.db.std.Wire;
import com.sigrity.acl.geom.AGeom;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.HierPin;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.ShowMeTheWay;
import com.sigrity.orbit.diff_merge.Compare;
import com.sigrity.orbit.diff_merge.CompareContext;
import com.sigrity.orbit.diff_merge.CompareObstacle;
import com.sigrity.orbit.diff_merge.CompareRegistry;
import com.sigrity.orbit.diff_merge.CompareSubstrate;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.geom.AffineTransform;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.swing.AbstractAction;
import javax.swing.Action;

public class CompareDeviceTemplate
extends Compare<DeviceTemplate> {
    private boolean mIsCompareChildern = true;

    public void setIsCompareChildern(boolean b) {
        this.mIsCompareChildern = b;
    }

    @Override
    public Iterator<Compare.Diff<?>> findDiffs(CompareContext context, DeviceTemplate orig, DeviceTemplate updated) {
        context.register(EquivDeviceTemplates.class, EquivDeviceTemplates.Factory);
        context.register(EquivNets.class, EquivNets.Factory);
        context.register(EquivPinTemplates.class, EquivPinTemplates.Factory);
        EquivDeviceTemplates alreadyCompared = context.getItem(EquivDeviceTemplates.class);
        if (alreadyCompared.containsOrig(orig)) {
            return AEmptyItr.create();
        }
        alreadyCompared.put(orig, updated);
        Comparator dtc = new Comparator(context, orig, updated, this.mIsCompareChildern);
        return dtc.getDiffs().iterator();
    }

    public static class NetRenamed
    extends NetMergeable {
        protected Net mNetOrig;
        protected Net mNetUpdated;

        public NetRenamed(Net netOrig, Net netUpdated) {
            super(netOrig.getDeviceTemplate(), Compare.Diff.Type.MODIFY);
            this.mNetOrig = netOrig;
            this.mNetUpdated = netUpdated;
        }

        @Override
        protected boolean _merge() {
            this.mNetOrig.setName(this.mNetUpdated.getName());
            return true;
        }

        @Override
        public String getDesc() {
            return String.format("Net '%s' on device template '%s' was renamed to '%s'.", this.mNetOrig.getName(), ((DeviceTemplate)this.mOwner).getName(), this.mNetUpdated.getName());
        }

        @Override
        public Class<Net> getModifiedType() {
            return Net.class;
        }

        @Override
        public List<Action> getActions() {
            return List.of(this.getActionSelect());
        }

        protected Action getActionSelect() {
            return new AbstractAction("Select"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Selection s = Selection.getCurrentSelectionForDb((Db)((DeviceTemplate)mOwner).getDb());
                    s.add((DbObject)mNetUpdated);
                    OrbitIO.getOrbitIO().refreshCurrentView();
                }
            };
        }

        @Override
        public String getItemDesc() {
            return "net";
        }

        @Override
        public String getOldDesc() {
            return this.mNetOrig.getName();
        }

        @Override
        public String getNewDesc() {
            return this.mNetUpdated.getName();
        }

        @Override
        public String getUserName() {
            return "Net Name Changed";
        }
    }

    public static class NetRemoved
    extends NetMergeable {
        protected Net mNet;

        public NetRemoved(Net net) {
            super(net.getDeviceTemplate(), Compare.Diff.Type.DELETE);
            this.mNet = net;
        }

        @Override
        protected boolean _merge() {
            if (!this.mNet.moveContents(((DeviceTemplate)this.getOwner()).getNetUnused())) {
                return false;
            }
            return this.mNet.deleteFromDb();
        }

        @Override
        public String getDesc() {
            return String.format("Net '%s' was removed from device template '%s'.", this.mNet.getName(), ((DeviceTemplate)this.mOwner).getName());
        }

        @Override
        public Class<Net> getModifiedType() {
            return Net.class;
        }

        @Override
        public List<Action> getActions() {
            return List.of(this.getActionSelect());
        }

        protected Action getActionSelect() {
            return new AbstractAction("Select"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Selection s = Selection.getCurrentSelectionForDb((Db)((DeviceTemplate)mOwner).getDb());
                    s.add((DbObject)mNet);
                    OrbitIO.getOrbitIO().refreshCurrentView();
                }
            };
        }

        @Override
        public String getItemDesc() {
            return "net";
        }

        @Override
        public String getOldDesc() {
            return this.mNet.getName();
        }

        @Override
        public String getNewDesc() {
            return "";
        }

        @Override
        public String getUserName() {
            return "Removed";
        }
    }

    public static class NetAdded
    extends NetMergeable {
        protected Net mNetUpdated;

        public NetAdded(DeviceTemplate template, Net netUpdated) {
            super(template, Compare.Diff.Type.ADD);
            this.mNetUpdated = netUpdated;
        }

        @Override
        protected boolean _merge() {
            ((DeviceTemplate)this.mOwner).createNet(this.mNetUpdated.getName());
            return true;
        }

        @Override
        public String getDesc() {
            return String.format("Net '%s' was added to the device template '%s'.", this.mNetUpdated.getName(), ((DeviceTemplate)this.mOwner).getName());
        }

        @Override
        public Class<Net> getModifiedType() {
            return Net.class;
        }

        @Override
        public List<Action> getActions() {
            return List.of(this.getActionSelect());
        }

        protected Action getActionSelect() {
            return new AbstractAction("Select"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Selection s = Selection.getCurrentSelectionForDb((Db)((DeviceTemplate)mOwner).getDb());
                    s.add((DbObject)mNetUpdated);
                    OrbitIO.getOrbitIO().refreshCurrentView();
                }
            };
        }

        @Override
        public String getItemDesc() {
            return "net";
        }

        @Override
        public String getOldDesc() {
            return "";
        }

        @Override
        public String getNewDesc() {
            return this.mNetUpdated.getName();
        }

        @Override
        public String getUserName() {
            return "Added";
        }
    }

    public static abstract class NetMergeable
    extends Compare.Mergeable<DeviceTemplate> {
        public NetMergeable(DeviceTemplate dtOrig, Compare.Diff.Type type) {
            super(dtOrig, type);
        }

        @Override
        public String getDbClass() {
            return "Net";
        }
    }

    public static class WireRemoved
    extends DeviceTemplateMergeable {
        protected Wire mWireOrig;
        protected Unit mUnit = null;

        public WireRemoved(Wire obs) {
            super(obs.getDeviceTemplate(), Compare.Diff.Type.DELETE);
            this.mWireOrig = obs;
        }

        public void setUnit(Unit unit) {
            this.mUnit = unit;
        }

        @Override
        protected boolean _merge() {
            this.mWireOrig.deleteFromDb();
            return true;
        }

        @Override
        public Class<Wire> getModifiedType() {
            return Wire.class;
        }

        @Override
        public String getDesc() {
            return String.format("Wire %s removed from DeviceTemplate '%s'.", this.mWireOrig.getDbObjId(), ((DeviceTemplate)this.mOwner).getName());
        }

        @Override
        public List<Action> getActions() {
            if (this.mWireOrig.getDb() == null) {
                return Collections.emptyList();
            }
            return List.of(this.getActionSelect());
        }

        @Override
        protected Action getActionSelect() {
            return new AbstractAction("Select"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Selection s = Selection.getCurrentSelectionForDb((Db)((DeviceTemplate)mOwner).getDb());
                    s.add((DbObject)mWireOrig);
                    OrbitIO.getOrbitIO().refreshCurrentView();
                }
            };
        }

        @Override
        public void _select(Selection s) {
            s.add((DbObject)this.mWireOrig);
        }

        @Override
        public String getItemDesc() {
            return "wire";
        }

        @Override
        public String getOldDesc() {
            return "" + this.mWireOrig.getDbObjId();
        }

        @Override
        public String getNewDesc() {
            return "";
        }

        @Override
        public String getUserName() {
            return "Wire Removed";
        }
    }

    public static class WireAdded
    extends DeviceTemplateMergeable {
        protected Wire mWireUpdated;

        public WireAdded(DeviceTemplate dtOrig, Wire wireUpdated) {
            super(dtOrig, Compare.Diff.Type.ADD);
            this.mWireUpdated = wireUpdated;
        }

        @Override
        protected boolean _merge() {
            Wire obstacleCreate = this.mWireUpdated.copyTo((DeviceTemplate)this.mOwner);
            if (obstacleCreate == null) {
                this.setMergeMessage("Unable to create new %s on DeviceTemplate '%s'.", this.mWireUpdated, ((DeviceTemplate)this.mOwner).getName());
                return false;
            }
            return true;
        }

        @Override
        public String getDesc() {
            return String.format("Wire %s added to DeviceTemplate '%s'.", this.mWireUpdated.getDbObjId(), ((DeviceTemplate)this.mOwner).getName());
        }

        public Wire getUpdatedObstacle() {
            return this.mWireUpdated;
        }

        @Override
        public void _select(Selection s) {
            s.add((DbObject)this.mWireUpdated);
        }

        @Override
        public String getItemDesc() {
            return "wire";
        }

        @Override
        public String getOldDesc() {
            return "";
        }

        @Override
        public String getNewDesc() {
            return "" + this.mWireUpdated.getDbObjId();
        }

        @Override
        public String getUserName() {
            return "Wire Added";
        }
    }

    public static class ObstacleRemoved
    extends DeviceTemplateMergeable {
        protected Obstacle mObstacleOrig;
        protected Unit mUnit = null;

        public ObstacleRemoved(Obstacle obs) {
            super(obs.getDeviceTemplate(), Compare.Diff.Type.DELETE);
            this.mObstacleOrig = obs;
        }

        public void setUnit(Unit unit) {
            this.mUnit = unit;
        }

        @Override
        protected boolean _merge() {
            this.mObstacleOrig.deleteFromDb();
            return true;
        }

        @Override
        public Class<Obstacle> getModifiedType() {
            return Obstacle.class;
        }

        @Override
        public String getDesc() {
            return String.format("%s removed from DeviceTemplate '%s'.", this.mObstacleOrig.getDesc(this.mUnit), ((DeviceTemplate)this.mOwner).getName());
        }

        @Override
        public List<Action> getActions() {
            if (this.mObstacleOrig.getDb() == null) {
                return Collections.emptyList();
            }
            return List.of(this.getActionSelect(), this.getActionShow());
        }

        @Override
        protected Action getActionSelect() {
            return new AbstractAction("Select"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Selection s = Selection.getCurrentSelectionForDb((Db)((DeviceTemplate)mOwner).getDb());
                    s.add((DbObject)mObstacleOrig);
                    OrbitIO.getOrbitIO().refreshCurrentView();
                }
            };
        }

        @Override
        public void show() {
            CompareObstacle.show(this.mObstacleOrig);
        }

        @Override
        public void _select(Selection s) {
            s.add((DbObject)this.mObstacleOrig);
        }

        @Override
        public String getItemDesc() {
            return "obstacle";
        }

        @Override
        public String getOldDesc() {
            return this.mObstacleOrig.getDesc(this.mUnit);
        }

        @Override
        public String getNewDesc() {
            return "";
        }

        @Override
        public String getUserName() {
            return "Obstacle Removed";
        }
    }

    public static class ObstacleAdded
    extends DeviceTemplateMergeable {
        protected Obstacle mObstacleUpdated;
        protected Unit mUnit = null;

        public ObstacleAdded(DeviceTemplate dtOrig, Obstacle obstacleUpdated) {
            super(dtOrig, Compare.Diff.Type.ADD);
            this.mObstacleUpdated = obstacleUpdated;
        }

        public void setUnit(Unit unit) {
            this.mUnit = unit;
        }

        @Override
        protected boolean _merge() {
            Obstacle obstacleCreate = this.mObstacleUpdated.copyTo((DeviceTemplate)this.mOwner);
            if (obstacleCreate == null) {
                this.setMergeMessage("Unable to create new %s on DeviceTemplate '%s'.", this.mObstacleUpdated, ((DeviceTemplate)this.mOwner).getName());
                return false;
            }
            return true;
        }

        @Override
        public String getDesc() {
            return String.format("%s added to DeviceTemplate '%s'.", this.mObstacleUpdated.getDesc(this.mUnit), ((DeviceTemplate)this.mOwner).getName());
        }

        public Obstacle getUpdatedObstacle() {
            return this.mObstacleUpdated;
        }

        @Override
        public void show() {
            CompareObstacle.show(this.mObstacleUpdated);
        }

        @Override
        public void _select(Selection s) {
            s.add((DbObject)this.mObstacleUpdated);
        }

        @Override
        public String getItemDesc() {
            return "obstacle";
        }

        @Override
        public String getOldDesc() {
            return "";
        }

        @Override
        public String getNewDesc() {
            return this.mObstacleUpdated.getDesc(this.mUnit);
        }

        @Override
        public String getUserName() {
            return "Obstacle Added";
        }
    }

    public static class PinTemplateRemoved
    extends Compare.Mergeable<DeviceTemplate> {
        protected PinTemplate mPinOrig;
        protected final Action mSelect = new AbstractAction("Select"){

            @Override
            public void actionPerformed(ActionEvent e) {
                Selection s = Selection.getCurrentSelectionForDb((Db)((DeviceTemplate)mOwner).getDb());
                s.add((DbObject)mPinOrig);
                OrbitIO.getOrbitIO().refreshCurrentView();
            }
        };
        protected final Action mShow = new AbstractAction("Show"){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (DevicePath path : ((DeviceTemplate)mOwner).getHierarchicalInstances()) {
                    ShowMeTheWay.addHierPin(new HierPin(path, PinInstance.getPinInstance((Device)path.getLast(), (PinTemplate)mPinOrig)));
                }
            }
        };

        public PinTemplateRemoved(PinTemplate pinT) {
            super(pinT.getDeviceTemplate(), Compare.Diff.Type.DELETE);
            this.mPinOrig = pinT;
        }

        public PinTemplate getOrigPinT() {
            return this.mPinOrig;
        }

        @Override
        protected boolean _merge() {
            this.mPinOrig.deleteFromDb();
            return true;
        }

        @Override
        public Class<PinTemplate> getModifiedType() {
            return PinTemplate.class;
        }

        @Override
        public String getDesc() {
            return String.format("Pin '%s' on net '%s' was removed from device template '%s'.", this.mPinOrig.getName(), this.mPinOrig.getNet() == null ? null : this.mPinOrig.getNet().getName(), ((DeviceTemplate)this.mOwner).getName());
        }

        @Override
        public List<Action> getActions() {
            if (this.mPinOrig.getDb() == null) {
                return Collections.emptyList();
            }
            return AUtil.arrayList((Object[])new Action[]{this.mSelect, this.mShow});
        }

        @Override
        public String getDbClass() {
            return "Pin";
        }

        @Override
        public String getItemDesc() {
            return "pin template";
        }

        @Override
        public String getOldDesc() {
            return String.format("%s, %s", this.mPinOrig.getName(), this.mPinOrig.getNet() == null ? null : this.mPinOrig.getNet().getName());
        }

        @Override
        public String getNewDesc() {
            return "";
        }

        @Override
        public String getUserName() {
            return "Pin Removed";
        }
    }

    public static class PinTemplateAdded
    extends DeviceTemplateMergeable {
        protected PinTemplate mPortUpdated;
        protected Unit mUnit = null;
        protected AffineTransform mXform = null;

        public PinTemplateAdded(DeviceTemplate dtOrig, PinTemplate portUpdated) {
            super(dtOrig, Compare.Diff.Type.ADD);
            this.mPortUpdated = portUpdated;
        }

        public void setUnit(Unit unit) {
            this.mUnit = unit;
        }

        public void setXform(AffineTransform xform) {
            this.mXform = xform;
        }

        @Override
        protected boolean _merge() {
            String netName = this.mPortUpdated.getNet().getName();
            Net netOrig = ((DeviceTemplate)this.mOwner).getNet(netName);
            if (netOrig == null) {
                this.setMergeMessage("Unable to create new pin at this time, Net '%s' does not exist on DeviceTemplate '%s'.", netName, ((DeviceTemplate)this.mOwner).getName());
                return false;
            }
            PinTemplate portCreate = this.mPortUpdated.copyTo((DeviceTemplate)this.mOwner);
            if (portCreate == null) {
                this.setMergeMessage("Unable to create new pin '%s' on Net '%s' on DeviceTemplate '%s'.", this.mPortUpdated.getName(), netName, ((DeviceTemplate)this.mOwner).getName());
                return false;
            }
            return true;
        }

        @Override
        public String getDesc() {
            APoint2D loc = this.mPortUpdated.getLoc();
            if (this.mXform != null) {
                loc = loc.transform(this.mXform);
            }
            String strLoc = loc == null ? "" + loc : loc.toString(this.mUnit);
            return String.format("Pin '%s' on net '%s' was added to DeviceTemplate '%s' at %s.", this.mPortUpdated.getName(), this.mPortUpdated.getNet().getName(), ((DeviceTemplate)this.mOwner).getName(), strLoc);
        }

        @Override
        public List<Action> getActions() {
            if (this.mPortUpdated.getDb() == null) {
                return Collections.emptyList();
            }
            return List.of(this.getActionSelect(), this.getActionShow());
        }

        @Override
        protected final Action getActionSelect() {
            return new AbstractAction("Select"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DeviceTemplate dt = mPortUpdated.getDeviceTemplate();
                    Selection s = Selection.getCurrentSelectionForDb((Db)dt.getDb());
                    s.add((DbObject)mPortUpdated);
                    OrbitIO.getOrbitIO().refreshCurrentView();
                }
            };
        }

        @Override
        protected final Action getActionShow() {
            return new AbstractAction("Show"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DeviceTemplate dt = mPortUpdated.getDeviceTemplate();
                    for (DevicePath path : dt.getHierarchicalInstances()) {
                        ShowMeTheWay.addHierPin(new HierPin(path, PinInstance.getPinInstance((Device)path.getLast(), (PinTemplate)mPortUpdated)));
                    }
                }
            };
        }

        public PinTemplate getUpdatedPort() {
            return this.mPortUpdated;
        }

        @Override
        public String getDbClass() {
            return "Pin";
        }

        @Override
        public String getItemDesc() {
            return "pin template";
        }

        @Override
        public String getOldDesc() {
            return "";
        }

        @Override
        public String getNewDesc() {
            return String.format("%s, %s", this.mPortUpdated.getName(), this.mPortUpdated.getNet().getName());
        }

        @Override
        public String getUserName() {
            return "Pin Added";
        }
    }

    public static class DeviceRemoved
    extends DeviceTemplateMergeable {
        protected Device mRemovedChild;
        protected DeviceTemplate mUpdatedParent;

        public DeviceRemoved(DeviceTemplate origParent, Device removedChild, DeviceTemplate updatedParent) {
            super(origParent, Compare.Diff.Type.DELETE);
            this.mRemovedChild = removedChild;
            this.mUpdatedParent = updatedParent;
        }

        @Override
        protected boolean _merge() {
            this.mRemovedChild.deleteFromDb();
            return true;
        }

        @Override
        public String getDesc() {
            return String.format("Device '%s' was removed from template '%s'.", this.mRemovedChild.getName(), ((DeviceTemplate)this.mOwner).getName());
        }

        @Override
        public void show() {
            for (DevicePath path : this.mRemovedChild.getHierarchicalInstances()) {
                ShowMeTheWay.addDevicePath(path, path.getLast().getName() + " removed");
            }
        }

        @Override
        public void _select(Selection s) {
            s.add((DbObject)this.mRemovedChild);
        }

        public DeviceTemplate getOrigParent() {
            return (DeviceTemplate)this.mOwner;
        }

        public Device getDeletedChild() {
            return this.mRemovedChild;
        }

        public DeviceTemplate getUpdatedParent() {
            return this.mUpdatedParent;
        }

        @Override
        public String getItemDesc() {
            return "child";
        }

        @Override
        public String getOldDesc() {
            return this.mRemovedChild.getName();
        }

        @Override
        public String getNewDesc() {
            return "";
        }

        @Override
        public String getUserName() {
            return "Removed";
        }
    }

    public static class DeviceAdded
    extends DeviceTemplateMergeable {
        protected CompareContext mContext;
        protected Device mUpdated;
        protected Device mAddedByMerge = null;
        protected Unit mUnit = null;
        protected AffineTransform mXform = null;

        public DeviceAdded(CompareContext ctx, DeviceTemplate dtOrig, Device deviceUpdated) {
            super(dtOrig, Compare.Diff.Type.ADD);
            this.mContext = ctx;
            this.mUpdated = deviceUpdated;
        }

        public Device getAddedByMerge() {
            return this.mAddedByMerge;
        }

        public void setUnit(Unit unit) {
            this.mUnit = unit;
        }

        public void setXform(AffineTransform xform) {
            this.mXform = xform;
        }

        @Override
        protected boolean _merge() {
            this.mAddedByMerge = this.mUpdated.copyTo((DeviceTemplate)this.getOwner(), false);
            if (this.mAddedByMerge == null || this.mAddedByMerge.getDb() == null) {
                this.setMergeMessage("Unable to create new device '%s' from template '%s' as a child ofDeviceTemplate '%s'.", this.mUpdated.getName(), this.mUpdated.getTemplate().getName(), ((DeviceTemplate)this.mOwner).getName());
                return false;
            }
            DeviceTemplate updatedTemplate = this.mAddedByMerge.getTemplate();
            if (updatedTemplate.getSubstrate() != ((DeviceTemplate)this.getOwner()).getSubstrate()) {
                EquivDeviceTemplates equivTs = this.mContext.getItem(EquivDeviceTemplates.class);
                DeviceTemplate origT = equivTs.getOrig(updatedTemplate);
                if (origT == null) {
                    origT = updatedTemplate.copyToSubstrate(((DeviceTemplate)this.mOwner).getSubstrate());
                    equivTs.put(origT, updatedTemplate);
                }
                this.mAddedByMerge.replaceTemplate(origT);
            }
            return true;
        }

        @Override
        public String getDesc() {
            APoint2D loc = this.mUpdated.getLoc();
            String strLoc = "";
            if (loc != null) {
                if (this.mXform != null) {
                    loc = loc.transform(this.mXform);
                }
                strLoc = loc.toString(this.mUnit);
            }
            return String.format("A new Device '%s' was created  from template '%s' as a child of '%s' at %s.", this.mUpdated.getName(), this.mUpdated.getTemplate().getName(), ((DeviceTemplate)this.mOwner).getName(), strLoc);
        }

        @Override
        public void show() {
            Set shownAddPts = this.mUpdated.getHierarchicalInstances().stream().map(DevicePath::getLoc).peek(pt -> ShowMeTheWay.showMeAPt(pt, "Added", ShowMeTheWay.LineStyle.Straight, Color.ORANGE)).collect(Collectors.toSet());
            ((DeviceTemplate)this.mOwner).getHierarchicalInstances().stream().map(path -> this.mUpdated.getLoc().transform(path.getTransform())).filter(pt -> !shownAddPts.contains(pt)).forEach(pt -> ShowMeTheWay.showMeAPt(pt, "Target Location", ShowMeTheWay.LineStyle.Dashed, Color.GREEN));
        }

        @Override
        public List<Action> getActions() {
            return List.of(this.getActionShow());
        }

        @Override
        public String getItemDesc() {
            return "child";
        }

        @Override
        public String getOldDesc() {
            return "";
        }

        @Override
        public String getNewDesc() {
            return this.mUpdated.getName();
        }

        @Override
        public String getUserName() {
            return "Added";
        }
    }

    public static class DeviceTemplateIsSynthesizedChanged
    extends DeviceTemplateMergeable {
        DeviceTemplate mUpdated;

        public DeviceTemplateIsSynthesizedChanged(DeviceTemplate owner, DeviceTemplate updated) {
            super(owner, Compare.Diff.Type.MODIFY);
            this.mUpdated = updated;
        }

        @Override
        public String getDesc() {
            return String.format("IsSynthesized changed from %s to %s for device template '%s'.", ((DeviceTemplate)this.mOwner).getIsSynthesized(), this.mUpdated.getIsSynthesized(), ((DeviceTemplate)this.mOwner).getName());
        }

        @Override
        protected boolean _merge() {
            ((DeviceTemplate)this.mOwner).setIsSynthesized(this.mUpdated.getIsSynthesized());
            return true;
        }

        @Override
        public String getItemDesc() {
            return "synthesized";
        }

        @Override
        public String getOldDesc() {
            return "" + ((DeviceTemplate)this.mOwner).getIsSynthesized();
        }

        @Override
        public String getNewDesc() {
            return "" + this.mUpdated.getIsSynthesized();
        }

        @Override
        public String getUserName() {
            return "Synthesized Changed";
        }
    }

    public static class DeviceTemplateSourceChanged
    extends DeviceTemplateMergeable {
        DeviceTemplate mUpdated;

        public DeviceTemplateSourceChanged(DeviceTemplate owner, DeviceTemplate updated) {
            super(owner, Compare.Diff.Type.MODIFY);
            this.mUpdated = updated;
        }

        @Override
        public String getDesc() {
            return String.format("Source changed from '%s' to '%s' for device template '%s'.", this.getSrcDesc((DeviceTemplate)this.mOwner), this.getSrcDesc(this.mUpdated), ((DeviceTemplate)this.mOwner).getName());
        }

        protected String getSrcDesc(DeviceTemplate dt) {
            DeviceTemplate.SourceType dtType = dt.getSourceType();
            if (dtType == null) {
                return "null";
            }
            StringBuilder res = new StringBuilder(dtType.toString());
            String sf = dt.getSourceFile();
            if (sf != null) {
                res.append(String.format("(%s)", sf));
            }
            return res.toString();
        }

        @Override
        protected boolean _merge() {
            if (this.mOwner == null || this.mUpdated == null) {
                return false;
            }
            if (((DeviceTemplate)this.mOwner).getSourceType() != this.mUpdated.getSourceType()) {
                ((DeviceTemplate)this.mOwner).setSourceType(this.mUpdated.getSourceType());
            }
            if (!AUtil.equals((Object)((DeviceTemplate)this.mOwner).getSourceFile(), (Object)this.mUpdated.getSourceFile())) {
                ((DeviceTemplate)this.mOwner).setSourceFile(this.mUpdated.getSourceFile());
            }
            return true;
        }

        @Override
        public String getItemDesc() {
            return "source";
        }

        @Override
        public String getOldDesc() {
            return this.getSrcDesc((DeviceTemplate)this.mOwner);
        }

        @Override
        public String getNewDesc() {
            return this.getSrcDesc(this.mUpdated);
        }

        @Override
        public String getUserName() {
            return "Source Changed";
        }
    }

    public static class DeviceTemplateTypeChanged
    extends DeviceTemplateMergeable {
        DeviceTemplate mUpdated;

        public DeviceTemplateTypeChanged(DeviceTemplate owner, DeviceTemplate updated) {
            super(owner, Compare.Diff.Type.MODIFY);
            this.mUpdated = updated;
        }

        @Override
        public String getDesc() {
            return String.format("Type changed from '%s' to '%s' for device template '%s'.", ((DeviceTemplate)this.mOwner).getType(), this.mUpdated.getType(), ((DeviceTemplate)this.mOwner).getName());
        }

        @Override
        protected boolean _merge() {
            ((DeviceTemplate)this.mOwner).setType(this.mUpdated.getType());
            return true;
        }

        @Override
        public String getItemDesc() {
            return "type";
        }

        @Override
        public String getOldDesc() {
            return ((DeviceTemplate)this.mOwner).getType().toString();
        }

        @Override
        public String getNewDesc() {
            return this.mUpdated.getType().toString();
        }

        @Override
        public String getUserName() {
            return "Type Changed";
        }
    }

    public static class BoundsChanged
    extends DeviceTemplateMergeable {
        DeviceTemplate mUpdated;

        public BoundsChanged(DeviceTemplate owner, DeviceTemplate updated) {
            super(owner, Compare.Diff.Type.MODIFY);
            this.mUpdated = updated;
        }

        @Override
        public String getDesc() {
            return String.format("Bounds changed from %s to %s for device template '%s'.", ((DeviceTemplate)this.mOwner).getBounds(), this.mUpdated.getBounds(), ((DeviceTemplate)this.mOwner).getName());
        }

        @Override
        protected boolean _merge() {
            ((DeviceTemplate)this.mOwner).setBounds(this.mUpdated.getBounds().copy());
            return true;
        }

        @Override
        public String getItemDesc() {
            return "bound";
        }

        @Override
        public String getOldDesc() {
            return ((DeviceTemplate)this.mOwner).getBounds().toString();
        }

        @Override
        public String getNewDesc() {
            return this.mUpdated.getBounds().toString();
        }

        @Override
        public String getUserName() {
            return "Bound Changed";
        }
    }

    public static abstract class DeviceTemplateMergeable
    extends Compare.Mergeable<DeviceTemplate> {
        public DeviceTemplateMergeable(DeviceTemplate orig, Compare.Diff.Type type) {
            super(orig, type);
        }

        @Override
        public List<Action> getActions() {
            return List.of(this.getActionSelect(), this.getActionShow());
        }

        protected Action getActionSelect() {
            return new AbstractAction("Select"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.select();
                }
            };
        }

        protected Action getActionShow() {
            return new AbstractAction("Show"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.show();
                }
            };
        }

        public void show() {
            for (DevicePath path : ((DeviceTemplate)this.mOwner).getHierarchicalInstances()) {
                ShowMeTheWay.addDevicePath(path);
            }
        }

        public void select() {
            Selection s = Selection.getCurrentSelectionForDb((Db)((DeviceTemplate)this.mOwner).getDb());
            this._select(s);
            OrbitIO.getOrbitIO().refreshCurrentView();
        }

        public void _select(Selection s) {
            s.add(this.mOwner);
        }
    }

    public static class EquivPinTemplates {
        public static final CompareContext.ItemFactory<EquivPinTemplates> Factory = context -> new EquivPinTemplates();
        protected Map<APair<DeviceTemplate, DeviceTemplate>, BiMap<PinTemplate, PinTemplate>> mEqPinTemplates = Maps.newHashMap();

        public BiMap<PinTemplate, PinTemplate> getEquivPinTemplates(DeviceTemplate orig, DeviceTemplate updated) {
            APair mapKey = APair.create((Object)orig, (Object)updated);
            return this.mEqPinTemplates.computeIfAbsent((APair<DeviceTemplate, DeviceTemplate>)mapKey, __ -> HashBiMap.create());
        }
    }

    public static class EquivNets {
        public static final CompareContext.ItemFactory<EquivNets> Factory = context -> new EquivNets();
        protected HashMap<APair<DeviceTemplate, DeviceTemplate>, HashMap<Net, Net>> mEqNets = Maps.newHashMap();

        public Map<Net, Net> getEquivNets(DeviceTemplate orig, DeviceTemplate updated) {
            APair mapKey = APair.create((Object)orig, (Object)updated);
            LinkedHashMap map = this.mEqNets.get(mapKey);
            if (map == null) {
                map = Maps.newLinkedHashMap();
                this.mEqNets.put((APair<DeviceTemplate, DeviceTemplate>)mapKey, map);
                if (orig != null && updated != null) {
                    for (Net netOrig : orig.getNets()) {
                        Net netUpdated = updated.getNet(netOrig.getName());
                        map.put(netOrig, netUpdated);
                    }
                }
            }
            return map;
        }
    }

    public static class EquivDeviceTemplates {
        public static final CompareContext.ItemFactory<EquivDeviceTemplates> Factory = context -> new EquivDeviceTemplates();
        protected HashBiMap<DeviceTemplate, DeviceTemplate> mOrig2Updated = HashBiMap.create();
        protected HashSet<DeviceTemplate> mOrigRemoved = new HashSet();
        protected HashSet<DeviceTemplate> mUpdatedAdded = new HashSet();

        public void put(DeviceTemplate orig, DeviceTemplate updated) {
            if (orig == null) {
                this.mUpdatedAdded.add(orig);
            } else if (updated == null) {
                this.mOrigRemoved.add(orig);
            } else {
                this.mOrig2Updated.put((Object)orig, (Object)updated);
            }
        }

        public DeviceTemplate getUpdated(DeviceTemplate orig) {
            return (DeviceTemplate)this.mOrig2Updated.get((Object)orig);
        }

        public DeviceTemplate getOrig(DeviceTemplate updated) {
            return (DeviceTemplate)this.mOrig2Updated.inverse().get((Object)updated);
        }

        public boolean containsOrig(DeviceTemplate orig) {
            return this.mOrigRemoved.contains(orig) || this.mOrig2Updated.containsKey((Object)orig);
        }

        public boolean containsUpdated(DeviceTemplate updated) {
            return this.mUpdatedAdded.contains(updated) || this.mOrig2Updated.containsValue((Object)updated);
        }
    }

    public static class Comparator {
        protected CompareContext mCompareContext;
        protected DeviceTemplate mDtOrig;
        protected DeviceTemplate mDtUpdated;
        private boolean mIsCompareChildern = true;
        protected LinkedList<Compare.Diff<?>> diffs = new LinkedList();

        public Comparator(CompareContext context, DeviceTemplate origDevT, DeviceTemplate updatedDevT) {
            this(context, origDevT, updatedDevT, true);
        }

        public Comparator(CompareContext context, DeviceTemplate origDevT, DeviceTemplate updatedDevT, boolean isCompareChildern) {
            this.mCompareContext = context;
            this.mDtOrig = origDevT;
            this.mDtUpdated = updatedDevT;
            this.mIsCompareChildern = isCompareChildern;
            this.compare();
        }

        public void setIsCompareChildern(boolean b) {
            this.mIsCompareChildern = b;
        }

        public Collection<Compare.Diff<?>> getDiffs() {
            return this.diffs;
        }

        protected void compare() {
            this.mCompareContext.register(CompareSubstrate.EquivSubstrates.class, CompareSubstrate.EquivSubstrates.Factory);
            CompareSubstrate.EquivSubstrates eqSubstrates = this.mCompareContext.getItem(CompareSubstrate.EquivSubstrates.class);
            this.diffs.addAll(eqSubstrates.compare(this.mCompareContext, this.mDtOrig.getSubstrate(), this.mDtUpdated.getSubstrate()));
            AGeom origBounds = this.mDtOrig.getBounds();
            AGeom updatedBounds = this.mDtUpdated.getBounds();
            if (!AUtil.equals((Object)origBounds, (Object)updatedBounds)) {
                this.diffs.add(new BoundsChanged(this.mDtOrig, this.mDtUpdated));
            }
            if (this.mDtOrig.getType() != this.mDtUpdated.getType()) {
                this.diffs.add(new DeviceTemplateTypeChanged(this.mDtOrig, this.mDtUpdated));
            }
            if (!this.isSourceEqual()) {
                this.diffs.add(new DeviceTemplateSourceChanged(this.mDtOrig, this.mDtUpdated));
            }
            if (this.mDtOrig.getIsSynthesized() != this.mDtUpdated.getIsSynthesized()) {
                this.diffs.add(new DeviceTemplateIsSynthesizedChanged(this.mDtOrig, this.mDtUpdated));
            }
            Comparator.compareNets(this.mCompareContext, this.mDtOrig, this.mDtUpdated, this.diffs::add);
            Comparator.comparePins(this.mCompareContext, this.mDtOrig, this.mDtUpdated, this.diffs::add);
            this.compareObstacles();
            this.compareChildDevices();
        }

        public boolean isSourceEqual() {
            if (this.mDtOrig.getSourceType() != this.mDtUpdated.getSourceType()) {
                return false;
            }
            String origSrcFile = this.mDtOrig.getSourceFile();
            String updatedSrcFile = this.mDtUpdated.getSourceFile();
            return AUtil.equals((Object)origSrcFile, (Object)updatedSrcFile);
        }

        public static void compareNets(CompareContext compareContext, DeviceTemplate dtOrig, DeviceTemplate dtUpdated, Consumer<Compare.Diff<?>> diffConsumer) {
            Map<Net, Net> equivNets = compareContext.getItem(EquivNets.class, EquivNets.Factory).getEquivNets(dtOrig, dtUpdated);
            for (Net netOrig : dtOrig.getNets()) {
                if (netOrig.isUnused() || equivNets.get(netOrig) != null) continue;
                diffConsumer.accept(new NetRemoved(netOrig));
            }
            for (Net netUpdated : dtUpdated.getNets()) {
                if (netUpdated.isUnused() || dtOrig.getNet(netUpdated.getName()) != null) continue;
                diffConsumer.accept(new NetAdded(dtOrig, netUpdated));
            }
        }

        public static void comparePins(CompareContext compareContext, DeviceTemplate dtOrig, DeviceTemplate dtUpdated, Consumer<Compare.Diff<?>> diffConsumer) {
            List<PinTemplate> updatedPins;
            EquivPinTemplates equivPinTs = compareContext.getItem(EquivPinTemplates.class, EquivPinTemplates.Factory);
            BiMap<PinTemplate, PinTemplate> orig2New = equivPinTs.getEquivPinTemplates(dtOrig, dtUpdated);
            LinkedHashSet removed = Sets.newLinkedHashSet();
            LinkedHashSet added = Sets.newLinkedHashSet();
            Map<Net, Net> equivNets = compareContext.getItem(EquivNets.class).getEquivNets(dtOrig, dtUpdated);
            LinkedList origPins = AUtil.linkedList((Iterator)dtOrig.getPins());
            Collections.sort(origPins, DbObject.CompareKeyStr);
            for (Object pinOrig : origPins) {
                Object pinUpdated;
                Net netNew;
                Net netOrig = pinOrig.getNet();
                if (netOrig.isUnused()) {
                    netOrig = dtOrig.getNetUnused();
                }
                if ((netNew = equivNets.get(netOrig)) != null && (pinUpdated = netNew.getPinTemplate(pinOrig.getName())) != null) {
                    orig2New.put(pinOrig, pinUpdated);
                    continue;
                }
                removed.add(pinOrig);
            }
            Map<String, List<PinTemplate>> updatedPinMap = dtUpdated.getPins().stream().collect(Collectors.groupingBy(PinTemplate::getName));
            for (PinTemplate origPin : AUtil.linkedList((Collection)removed)) {
                updatedPins = updatedPinMap.get(origPin.getName());
                if (updatedPins == null) continue;
                for (PinTemplate p : updatedPins) {
                    if (orig2New.containsValue((Object)p) || !p.getLocalTransform().equals(origPin.getLocalTransform())) continue;
                    orig2New.put((Object)origPin, (Object)p);
                    removed.remove(origPin);
                }
            }
            for (PinTemplate origPin : AUtil.linkedList((Collection)removed)) {
                updatedPins = updatedPinMap.get(origPin.getName());
                if (updatedPins == null) continue;
                for (PinTemplate p : updatedPins) {
                    if (orig2New.containsValue((Object)p)) continue;
                    orig2New.put((Object)origPin, (Object)p);
                    removed.remove(origPin);
                }
            }
            for (PinTemplate pinUpdated : dtUpdated.getPins()) {
                if (orig2New.containsValue((Object)pinUpdated)) continue;
                added.add(pinUpdated);
            }
            for (PinTemplate p : added) {
                diffConsumer.accept(new PinTemplateAdded(dtOrig, p));
            }
            for (PinTemplate p : removed) {
                diffConsumer.accept(new PinTemplateRemoved(p));
            }
            CompareRegistry cr = CompareRegistry.getCompareRegistry();
            LinkedList origPinsSorted = new LinkedList(orig2New.keySet());
            Collections.sort(origPinsSorted, DbObject.CompareKeyStr);
            for (PinTemplate orig : origPinsSorted) {
                PinTemplate updated = (PinTemplate)orig2New.get((Object)orig);
                for (Compare compare : cr.getCompares(PinTemplate.class)) {
                    for (Compare.Diff diff : compare.getDiffs(compareContext, orig, updated)) {
                        diffConsumer.accept(diff);
                    }
                }
            }
        }

        protected void compareObstacles() {
            HashedObstacle h;
            HashBiMap orig2Updated = HashBiMap.create();
            LinkedHashSet removed = Sets.newLinkedHashSet();
            LinkedHashSet added = Sets.newLinkedHashSet();
            for (Obstacle oNew : this.mDtUpdated.getObstacles()) {
                Obstacle oOrig = this.mDtOrig.getObstacleById(oNew.getId());
                if (oOrig == null) {
                    added.add(oNew);
                    continue;
                }
                orig2Updated.put((Object)oOrig, (Object)oNew);
            }
            for (Object oOrig : this.mDtOrig.getObstacles()) {
                if (orig2Updated.containsKey(oOrig)) continue;
                removed.add(oOrig);
            }
            HashMap origHash = Maps.newHashMap();
            for (Obstacle o : removed) {
                h = new HashedObstacle(o);
                origHash.put(h, o);
            }
            for (Obstacle u : AUtil.linkedList((Collection)added)) {
                h = new HashedObstacle(u);
                Obstacle o = (Obstacle)origHash.get(h);
                if (o == null) continue;
                orig2Updated.put((Object)o, (Object)u);
                origHash.remove(h);
                removed.remove(o);
                added.remove(u);
            }
            for (Obstacle o : added) {
                this.diffs.add(new ObstacleAdded(this.mDtOrig, o));
            }
            for (Obstacle o : removed) {
                this.diffs.add(new ObstacleRemoved(o));
            }
            CompareRegistry cr = CompareRegistry.getCompareRegistry();
            LinkedList origSorted = new LinkedList(orig2Updated.keySet());
            Collections.sort(origSorted, DbObject.CompareKeyStr);
            for (Obstacle orig : origSorted) {
                Obstacle updated = (Obstacle)orig2Updated.get((Object)orig);
                for (Compare compare : cr.getCompares(Obstacle.class)) {
                    for (Compare.Diff diff : compare.getDiffs(this.mCompareContext, orig, updated)) {
                        this.diffs.add(diff);
                    }
                }
            }
        }

        public static void compareWires(CompareContext compareContext, DeviceTemplate dtOrig, DeviceTemplate dtUpdated, Consumer<Compare.Diff<?>> diffConsumer) {
            for (Wire p : dtUpdated.getWires()) {
                diffConsumer.accept(new WireAdded(dtOrig, p));
            }
            for (Wire p : dtOrig.getWires()) {
                diffConsumer.accept(new WireRemoved(p));
            }
        }

        protected void compareChildDevices() {
            for (Device devChildUpdated : this.mDtUpdated.getChildren()) {
                Device devChildOrig;
                if (!this.mIsCompareChildern && !devChildUpdated.isPin() || (devChildOrig = this.mDtOrig.getChild(devChildUpdated.getName())) != null) continue;
                this.diffs.add(new DeviceAdded(this.mCompareContext, this.mDtOrig, devChildUpdated));
            }
            CompareRegistry compareRegistry = CompareRegistry.getCompareRegistry();
            for (Device devChildOrig : this.mDtOrig.getChildren()) {
                if (!this.mIsCompareChildern && !devChildOrig.isPin()) continue;
                Device devChildUpdated = this.mDtUpdated.getChild(devChildOrig.getName());
                if (devChildUpdated == null) {
                    DeviceRemoved diff = new DeviceRemoved(this.mDtOrig, devChildOrig, this.mDtUpdated);
                    this.diffs.add(diff);
                    continue;
                }
                for (Compare compare : compareRegistry.getCompares(Device.class)) {
                    for (Compare.Diff change : compare.getDiffs(this.mCompareContext, devChildOrig, devChildUpdated)) {
                        this.diffs.add(change);
                    }
                }
            }
        }

        static class HashedObstacle {
            Obstacle obs;

            public HashedObstacle(Obstacle o) {
                this.obs = o;
            }

            public int hashCode() {
                return this.obs.getType().hashCode() ^ this.hashLayerShapes((Iterable<LayerShape>)this.obs.getLayerShapes());
            }

            public boolean equals(Object o) {
                if (!(o instanceof HashedObstacle)) {
                    return false;
                }
                HashedObstacle other = (HashedObstacle)o;
                return this.obs.getType() == other.obs.getType() && this.sameLayerShapes(other);
            }

            boolean sameLayerShapes(HashedObstacle other) {
                LinkedList myShapes = AUtil.linkedList((Iterator)this.obs.getLayerShapes());
                Collections.sort(myShapes, CompareObstacle.ShapeSorter);
                LinkedList otherShapes = AUtil.linkedList((Iterator)other.obs.getLayerShapes());
                Collections.sort(otherShapes, CompareObstacle.ShapeSorter);
                Iterator otherShapeItr = otherShapes.iterator();
                for (LayerShape ls : myShapes) {
                    if (otherShapeItr.hasNext() && this.equalShape(ls, (LayerShape)otherShapeItr.next())) continue;
                    return false;
                }
                return true;
            }

            boolean equalShape(LayerShape a, LayerShape b) {
                return AUtil.equals((Object)this.getLayerName(a.getLayer()), (Object)this.getLayerName(b.getLayer())) && a.getGeom().equals((Object)b.getGeom());
            }

            String getLayerName(Layer l) {
                return l == null ? null : l.getName();
            }

            int hashLayerShapes(Iterable<LayerShape> lss) {
                int hash = 0;
                for (LayerShape ls : lss) {
                    hash ^= ls.getLayer() == null ? 0 : ls.getLayer().getName().hashCode() ^ AUtil.hash((Object)ls.getGeom());
                }
                return hash;
            }
        }
    }
}

