/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.diff_merge;

import com.google.common.collect.Lists;
import com.sigrity.acl.AUtil;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.std.Layer;
import com.sigrity.orbit.diff_merge.Compare;
import com.sigrity.orbit.diff_merge.CompareContext;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Action;

public class CompareLayer
extends Compare<Layer> {
    private static final String[] CompareFields = new String[]{"material", "name", "order", "resistance", "thickness", "type", "width"};

    @Override
    public Iterator<Compare.Diff<? extends DbObject>> findDiffs(CompareContext context, Layer orig, Layer updated) {
        LinkedList diffs = Lists.newLinkedList();
        for (String fn : CompareFields) {
            if (AUtil.equals((Object)orig.getValue(fn), (Object)updated.getValue(fn))) continue;
            diffs.add(new LayerChange(orig, fn, updated));
        }
        return diffs.iterator();
    }

    public static class LayerChange
    extends Compare.Mergeable<Layer> {
        protected String mFieldName;
        protected Layer mUpdatedLayer;

        public LayerChange(Layer origLayer, String fieldName, Layer updatedLayer) {
            super(origLayer, Compare.Diff.Type.MODIFY);
            this.mFieldName = fieldName;
            this.mUpdatedLayer = updatedLayer;
        }

        @Override
        public String getDesc() {
            return String.format("Layer '%s' in substrate '%s' %s changed from %s to %s.", ((Layer)this.getOwner()).getName(), ((Layer)this.getOwner()).getSubstrate().getName(), this.mFieldName, ((Layer)this.getOwner()).getStringValue(this.mFieldName), this.mUpdatedLayer.getStringValue(this.mFieldName));
        }

        @Override
        protected boolean _merge() {
            return ((Layer)this.mOwner).setValue(this.mFieldName, this.mUpdatedLayer.getValue(this.mFieldName));
        }

        @Override
        public List<Action> getActions() {
            return Collections.emptyList();
        }

        @Override
        public String getDbClass() {
            return "Layer";
        }

        @Override
        public String getItemDesc() {
            return this.mFieldName;
        }

        @Override
        public String getOldDesc() {
            return ((Layer)this.getOwner()).getStringValue(this.mFieldName);
        }

        @Override
        public String getNewDesc() {
            return this.mUpdatedLayer.getStringValue(this.mFieldName);
        }

        @Override
        public String getUserName() {
            return "Changed";
        }
    }
}

