/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.diff_merge;

import com.google.common.collect.Lists;
import com.sigrity.acl.ALog;
import com.sigrity.acl.AUtil;
import com.sigrity.acl.IterableIterator;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.Selection;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Layer;
import com.sigrity.acl.db.std.LayerShape;
import com.sigrity.acl.db.std.Obstacle;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.ShowMeTheWay;
import com.sigrity.orbit.diff_merge.Compare;
import com.sigrity.orbit.diff_merge.CompareContext;
import com.sigrity.orbit.diff_merge.CompareSubstrate;
import java.awt.event.ActionEvent;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;

public class CompareObstacle
extends Compare<Obstacle> {
    protected static boolean VerboseLayerShapeChanges = false;
    public static final Comparator<LayerShape> ShapeSorter = (a, b) -> {
        int i = AUtil.compare((Comparable)((Object)a.getLayer().getName()), (Object)b.getLayer().getName());
        if (i != 0) {
            return i;
        }
        i = AUtil.compare((Comparable)a.getGeom(), (Object)b.getGeom());
        if (i != 0) {
            return i;
        }
        return 0;
    };

    public static void show(Obstacle o) {
        APoint2D pt = o.getCenter();
        if (pt == null) {
            ALog.logWarn((String)"Unable to show obstacle, it has no associated geometries.");
        } else {
            for (DevicePath path : o.getDeviceTemplate().getHierarchicalInstances()) {
                APoint2D wp = pt.transform(path.getTransform());
                ShowMeTheWay.showMeAPt(wp, o.getDesc(), ShowMeTheWay.LineStyle.Straight, null);
            }
        }
    }

    @Override
    public Iterator<Compare.Diff<?>> findDiffs(CompareContext context, Obstacle a, Obstacle b) {
        LinkedList diffs = Lists.newLinkedList();
        if (!AUtil.equals((Object)a.getType(), (Object)b.getType())) {
            diffs.add(new ObstacleTypeChanged(a, b));
        }
        if (!AUtil.equals((Object)a.getId(), (Object)b.getId())) {
            diffs.add(new ObstacleIdChanged(a, b));
        }
        LinkedList aShapes = AUtil.linkedList((Iterator)a.getLayerShapes());
        Collections.sort(aShapes, ShapeSorter);
        LinkedList bShapes = AUtil.linkedList((Iterator)b.getLayerShapes());
        Collections.sort(bShapes, ShapeSorter);
        Iterator bShapeItr = bShapes.iterator();
        int shapeNum = -1;
        boolean layerShapesChanged = false;
        for (LayerShape lsA : aShapes) {
            ++shapeNum;
            if (!bShapeItr.hasNext()) {
                if (VerboseLayerShapeChanges) {
                    diffs.add(new ObstacleShapesRemoved(a, b));
                } else {
                    layerShapesChanged = true;
                    break;
                }
            }
            LayerShape lsB = (LayerShape)bShapeItr.next();
            if (!AUtil.equals((Object)CompareObstacle.getLayerName(lsA.getLayer()), (Object)CompareObstacle.getLayerName(lsB.getLayer()))) {
                if (VerboseLayerShapeChanges) {
                    diffs.add(new ObstacleLayerChanged(a, b, shapeNum));
                } else {
                    layerShapesChanged = true;
                    break;
                }
            }
            if (AUtil.equals((Object)lsA.getGeom(), (Object)lsB.getGeom())) continue;
            if (VerboseLayerShapeChanges) {
                diffs.add(new ObstacleGeomChanged(a, b, shapeNum));
                continue;
            }
            layerShapesChanged = true;
            break;
        }
        if (bShapeItr.hasNext()) {
            if (VerboseLayerShapeChanges) {
                diffs.add(new ObstacleShapesAdded(a, b));
            } else {
                layerShapesChanged = true;
            }
        }
        if (!VerboseLayerShapeChanges && layerShapesChanged) {
            diffs.add(new ObstacleShapesChanged(context, a, b));
        }
        return diffs.iterator();
    }

    private static String getLayerName(Layer l) {
        return l == null ? null : l.getName();
    }

    public static class ObstacleShapesRemoved
    extends ObstacleMergable {
        protected Obstacle mOrig;
        protected Obstacle mUpdated;

        public ObstacleShapesRemoved(Obstacle orig, Obstacle updated) {
            super(orig, Compare.Diff.Type.MODIFY);
            this.mOrig = orig;
            this.mUpdated = updated;
        }

        @Override
        public String getDesc() {
            return String.format("%s had %d shape(s) removed.", this.mOrig.getDesc(), this.mOrig.getShapeCount() - this.mUpdated.getShapeCount());
        }

        @Override
        protected boolean _merge() {
            LinkedList shapes = AUtil.linkedList((Iterator)this.mOrig.getLayerShapes());
            for (LayerShape ls : shapes.subList(this.mUpdated.getShapeCount(), this.mOrig.getShapeCount())) {
                ls.deleteFromDb();
            }
            return true;
        }

        @Override
        public String getItemDesc() {
            return "shape";
        }

        @Override
        public String getOldDesc() {
            return "...";
        }

        @Override
        public String getNewDesc() {
            return String.format("... %d", this.mUpdated.getShapeCount() - this.mOrig.getShapeCount());
        }

        @Override
        public String getUserName() {
            return "Shape Removed";
        }
    }

    public static class ObstacleShapesAdded
    extends ObstacleMergable {
        protected Obstacle mOrig;
        protected Obstacle mUpdated;

        public ObstacleShapesAdded(Obstacle orig, Obstacle updated) {
            super(orig, Compare.Diff.Type.MODIFY);
            this.mOrig = orig;
            this.mUpdated = updated;
        }

        @Override
        public String getDesc() {
            return String.format("%s had %d shape(s) added.", this.mOrig.getDesc(), this.mUpdated.getShapeCount() - this.mOrig.getShapeCount());
        }

        @Override
        protected boolean _merge() {
            int origShapeCount = this.mOrig.getShapeCount();
            IterableIterator updatedShapes = this.mUpdated.getLayerShapes();
            for (int i = 0; i < origShapeCount; ++i) {
                updatedShapes.next();
            }
            while (updatedShapes.hasNext()) {
                LayerShape updatedShape = (LayerShape)updatedShapes.next();
                this.mOrig.addLayerShape(updatedShape.getLayer(), updatedShape.getGeom().copy());
            }
            return true;
        }

        @Override
        public String getItemDesc() {
            return "shape";
        }

        @Override
        public String getOldDesc() {
            return "...";
        }

        @Override
        public String getNewDesc() {
            return String.format("... +%d", this.mUpdated.getShapeCount() - this.mOrig.getShapeCount());
        }

        @Override
        public String getUserName() {
            return "Shape Added";
        }
    }

    public static class ObstacleGeomChanged
    extends ObstacleMergable {
        protected Obstacle mOrig;
        protected Obstacle mUpdated;
        protected int mShapeNum;

        public ObstacleGeomChanged(Obstacle orig, Obstacle updated, int shapeNum) {
            super(orig, Compare.Diff.Type.MODIFY);
            this.mOrig = orig;
            this.mUpdated = updated;
            this.mShapeNum = shapeNum;
        }

        @Override
        protected boolean _merge() {
            this.mOrig.getShape(this.mShapeNum).setGeom(this.mUpdated.getShape(this.mShapeNum).getGeom().copy());
            return true;
        }

        @Override
        public String getDesc() {
            return String.format("%s shape %d geometry was changed from %s to %s.", this.mOrig.getDesc(), this.mShapeNum, this.mOrig.getShape(this.mShapeNum).getGeom(), this.mUpdated.getShape(this.mShapeNum).getGeom());
        }

        @Override
        public String getItemDesc() {
            return "shape";
        }

        @Override
        public String getOldDesc() {
            return this.mOrig.getShape(this.mShapeNum).getGeom().toString();
        }

        @Override
        public String getNewDesc() {
            return this.mUpdated.getShape(this.mShapeNum).getGeom().toString();
        }

        @Override
        public String getUserName() {
            return "Shape Changed";
        }
    }

    public static class ObstacleLayerChanged
    extends ObstacleMergable {
        protected Obstacle mOrig;
        protected Obstacle mUpdated;
        protected int mShapeNum;

        public ObstacleLayerChanged(Obstacle orig, Obstacle updated, int shapeNum) {
            super(orig, Compare.Diff.Type.MODIFY);
            this.mOrig = orig;
            this.mUpdated = updated;
            this.mShapeNum = shapeNum;
        }

        @Override
        protected boolean _merge() {
            this.mOrig.getShape(this.mShapeNum).setLayer(this.mUpdated.getShape(this.mShapeNum).getLayer());
            return true;
        }

        @Override
        public String getDesc() {
            return String.format("%s shape %d layer was changed from %s to %s.", this.mOrig.getDesc(), this.mShapeNum, this.mOrig.getShape(this.mShapeNum).getLayer().getName(), this.mUpdated.getShape(this.mShapeNum).getLayer().getName());
        }

        @Override
        public String getItemDesc() {
            return String.format("shape %d - layer", this.mShapeNum);
        }

        @Override
        public String getOldDesc() {
            return this.mOrig.getShape(this.mShapeNum).getLayer().getName();
        }

        @Override
        public String getNewDesc() {
            return this.mUpdated.getShape(this.mShapeNum).getLayer().getName();
        }

        @Override
        public String getUserName() {
            return "Layer Changed";
        }
    }

    public static class ObstacleShapesChanged
    extends ObstacleMergable {
        protected CompareContext mContext;
        protected Obstacle mOrig;
        protected Obstacle mUpdated;

        public ObstacleShapesChanged(CompareContext context, Obstacle orig, Obstacle updated) {
            super(orig, Compare.Diff.Type.MODIFY);
            this.mContext = context;
            this.mOrig = orig;
            this.mUpdated = updated;
        }

        @Override
        protected boolean _merge() {
            CompareSubstrate.EquivSubstrates.EquivSubstrate es = this.mContext.getItem(CompareSubstrate.EquivSubstrates.class).getEquivInfo(this.mOrig.getSubstrate(), this.mUpdated.getSubstrate());
            for (LayerShape lsOrig : AUtil.linkedList((Iterator)this.mOrig.getLayerShapes())) {
                lsOrig.deleteFromDb();
            }
            for (LayerShape lsUpdt : AUtil.linkedList((Iterator)this.mUpdated.getLayerShapes())) {
                Layer l = es.getEquivOfUpdated(lsUpdt.getLayer());
                this.mOrig.addLayerShape(l, lsUpdt.getGeom().copy());
            }
            return true;
        }

        @Override
        public String getDesc() {
            return String.format("Layer shapes changed for %s.", this.mOrig.getDesc());
        }

        @Override
        public String getItemDesc() {
            return "shape";
        }

        @Override
        public String getOldDesc() {
            return "...";
        }

        @Override
        public String getNewDesc() {
            return "...";
        }

        @Override
        public String getUserName() {
            return "Shape Changed";
        }
    }

    public static class ObstacleTypeChanged
    extends ObstacleMergable {
        protected Obstacle mOrig;
        protected Obstacle mUpdated;

        public ObstacleTypeChanged(Obstacle orig, Obstacle updated) {
            super(orig, Compare.Diff.Type.MODIFY);
            this.mOrig = orig;
            this.mUpdated = updated;
        }

        @Override
        protected boolean _merge() {
            this.mOrig.setType(this.mUpdated.getType());
            return true;
        }

        @Override
        public String getDesc() {
            return String.format("%s type was changed to %s.", this.mOrig.getDesc(), this.mUpdated.getType());
        }

        @Override
        public String getItemDesc() {
            return "type";
        }

        @Override
        public String getOldDesc() {
            return this.mOrig.getTypeName();
        }

        @Override
        public String getNewDesc() {
            return this.mUpdated.getTypeName();
        }

        @Override
        public String getUserName() {
            return "Type Changed";
        }
    }

    public static class ObstacleIdChanged
    extends ObstacleMergable {
        protected Obstacle mOrig;
        protected Obstacle mUpdated;

        public ObstacleIdChanged(Obstacle orig, Obstacle updated) {
            super(orig, Compare.Diff.Type.MODIFY);
            this.mOrig = orig;
            this.mUpdated = updated;
        }

        @Override
        protected boolean _merge() {
            Obstacle exist = this.mOrig.getDeviceTemplate().getObstacleById(this.mUpdated.getId());
            if (exist != null) {
                ALog.logError((String)"Id '%s' is already in use by %s.", (Object[])new Object[]{this.mUpdated.getId(), exist.getDesc()});
                return false;
            }
            this.mOrig.setId(this.mUpdated.getId());
            return true;
        }

        @Override
        public String getDesc() {
            return String.format("%s id was changed to %d.", this.mOrig.getDesc(), this.mUpdated.getId());
        }

        @Override
        public String getItemDesc() {
            return "";
        }

        @Override
        public String getOldDesc() {
            return this.mOrig.getDesc();
        }

        @Override
        public String getNewDesc() {
            return "" + this.mUpdated.getId();
        }

        @Override
        public String getUserName() {
            return "Obstacle ID Changed";
        }
    }

    public static abstract class ObstacleMergable
    extends Compare.Mergeable<DeviceTemplate> {
        Obstacle mObstacle;

        public ObstacleMergable(Obstacle obs, Compare.Diff.Type type) {
            super(obs.getDeviceTemplate(), type);
            this.mObstacle = obs;
        }

        @Override
        public Class<Obstacle> getModifiedType() {
            return Obstacle.class;
        }

        @Override
        public List<Action> getActions() {
            return List.of(this.getActionSelect(), this.getActionShow());
        }

        protected Action getActionSelect() {
            return new AbstractAction("Select"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Selection s = Selection.getCurrentSelectionForDb((Db)((DeviceTemplate)mOwner).getDb());
                    s.add((DbObject)mObstacle);
                    OrbitIO.getOrbitIO().refreshCurrentView();
                }
            };
        }

        protected Action getActionShow() {
            return new AbstractAction("Show"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CompareObstacle.show(mObstacle);
                }
            };
        }
    }
}

