/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.diff_merge;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.sigrity.acl.ALog;
import com.sigrity.acl.APair;
import com.sigrity.acl.AUtil;
import com.sigrity.acl.IterableIterator;
import com.sigrity.acl.Unit;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.Selection;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Layer;
import com.sigrity.acl.db.std.LayerShape;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.PadTemplate;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.acl.db.std.PortTemplate;
import com.sigrity.acl.db.std.Substrate;
import com.sigrity.acl.geom.AGeom;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.HierPin;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.ShowMeTheWay;
import com.sigrity.orbit.diff_merge.Compare;
import com.sigrity.orbit.diff_merge.CompareContext;
import com.sigrity.orbit.diff_merge.CompareSubstrate;
import java.awt.event.ActionEvent;
import java.awt.geom.AffineTransform;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;

public class ComparePinTemplate
extends Compare<PinTemplate> {
    @Override
    public Iterator<Compare.Diff<?>> findDiffs(CompareContext context, PinTemplate pinTA, PinTemplate pinTB) {
        context.register(EquivPadTemplates.class, EquivPadTemplates.Factory);
        EquivPadTemplates equivPadTs = context.getItem(EquivPadTemplates.class);
        LinkedList diffs = Lists.newLinkedList();
        if (!pinTA.getNet().getName().equals(pinTB.getNet().getName())) {
            diffs.add(new PinNetChanged(pinTA, pinTB));
        }
        if (pinTA.getDirection() != pinTB.getDirection()) {
            diffs.add(new PinDirectionChanged(pinTA, pinTB));
        }
        if (pinTA.getUse() != pinTB.getUse()) {
            diffs.add(new PinUseChanged(pinTA, pinTB));
        }
        if (pinTA.getType() != pinTB.getType()) {
            diffs.add(new PinTypeChanged(pinTA, pinTB));
        }
        diffs.addAll(AUtil.linkedList(ComparePinTemplate.comparePorts(context, pinTA, pinTB, equivPadTs)));
        return diffs.iterator();
    }

    public static Iterator<Compare.Diff<?>> comparePorts(PinTemplate pinTA, PinTemplate pinTB, EquivPadTemplates equivPadTs) {
        return ComparePinTemplate.comparePorts(null, pinTA, pinTB, equivPadTs);
    }

    public static Iterator<Compare.Diff<?>> comparePorts(CompareContext context, PinTemplate pinTA, PinTemplate pinTB, EquivPadTemplates equivPadTs) {
        Unit unit = context != null ? context.getDistanceUnit(pinTA.getDb()) : Design.getUnit((Db)pinTA.getDb());
        LinkedList diffs = Lists.newLinkedList();
        Iterator portsB = AUtil.sort((IterableIterator)pinTB.getPortTemplates()).iterator();
        for (PortTemplate portTA : AUtil.sort((IterableIterator)pinTA.getPortTemplates())) {
            PadTemplate ptB;
            PadTemplate ptA;
            if (!portsB.hasNext()) {
                diffs.add(new PortRemoved(portTA));
                continue;
            }
            PortTemplate portTB = (PortTemplate)portsB.next();
            if (!portTA.getLoc().equals(portTB.getLoc(), unit)) {
                diffs.add(new PortMoved(portTA, portTB));
            }
            if (portTA.getRotate() != portTB.getRotate()) {
                diffs.add(new PortRotateChanged(portTA, portTB));
            }
            if (portTA.getMirror() != portTB.getMirror()) {
                diffs.add(new PortMirrorChanged(portTA, portTB));
            }
            if ((ptA = portTA.getPadTemplate()) == (ptB = portTB.getPadTemplate()) || (equivPadTs == null || equivPadTs.equivalent(ptA, ptB)) && (equivPadTs != null || ptA.equivalent(ptB))) continue;
            diffs.add(new PortPadTemplateChanged(portTA, portTB));
        }
        while (portsB.hasNext()) {
            PortTemplate bPort = (PortTemplate)portsB.next();
            diffs.add(new PortAdded(pinTA, bPort));
        }
        return diffs.iterator();
    }

    protected static String getPadTName(PadTemplate pt) {
        return pt == null ? "" + pt : pt.getName();
    }

    public static boolean sameSubstrate(PinTemplate a, PinTemplate b) {
        return AUtil.equals((Object)a.getSubstrate(), (Object)b.getSubstrate());
    }

    public static class PortRemoved
    extends PinTemplateMergeable {
        protected PortTemplate mPortOrig;

        public PortRemoved(PortTemplate portT) {
            super(portT.getPinTemplate(), Compare.Diff.Type.DELETE);
            this.mPortOrig = portT;
        }

        @Override
        protected boolean _merge() {
            this.mPortOrig.deleteFromDb();
            return true;
        }

        @Override
        public Class<PinTemplate> getModifiedType() {
            return PinTemplate.class;
        }

        @Override
        public String getDesc() {
            return String.format("Port %d on pin '%s' on net '%s' was removed from device template '%s'.", this.mPortOrig.getPortNum(), this.mPinT.getName(), this.mPinT.getNet() == null ? null : this.mPinT.getNet().getName(), ((DeviceTemplate)this.mOwner).getName());
        }

        @Override
        public List<Action> getActions() {
            if (this.mPinT.getDb() == null) {
                return Collections.emptyList();
            }
            return List.of(this.getActionSelect(), this.getActionShow());
        }

        @Override
        protected Action getActionSelect() {
            return new AbstractAction("Select"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Selection s = Selection.getCurrentSelectionForDb((Db)((DeviceTemplate)mOwner).getDb());
                    s.add((DbObject)mPortOrig);
                    OrbitIO.getOrbitIO().refreshCurrentView();
                }
            };
        }

        @Override
        protected Action getActionShow() {
            return new AbstractAction("Show"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    for (DevicePath path : ((DeviceTemplate)mOwner).getHierarchicalInstances()) {
                        ShowMeTheWay.addHierPort(path, mPortOrig);
                    }
                }
            };
        }

        @Override
        public String getItemDesc() {
            return String.format("%s port", this.mPinT.getName());
        }

        @Override
        public String getOldDesc() {
            return "...";
        }

        @Override
        public String getNewDesc() {
            return "";
        }

        @Override
        public String getUserName() {
            return "Port Removed";
        }
    }

    public static class PortAdded
    extends PinTemplateMergeable {
        protected PortTemplate mPortUpdated;
        protected Unit mUnit = null;
        protected AffineTransform mXform = null;

        public PortAdded(PinTemplate pinTOrig, PortTemplate portUpdated) {
            super(pinTOrig, Compare.Diff.Type.ADD);
            this.mPortUpdated = portUpdated;
        }

        public void setUnit(Unit unit) {
            this.mUnit = unit;
        }

        public void setXform(AffineTransform xform) {
            this.mXform = xform;
        }

        @Override
        protected boolean _merge() {
            PortTemplate portCreate = this.mPortUpdated.copyTo(this.mPinT);
            if (portCreate == null) {
                this.setMergeMessage("Unable to create new port on PinTemplate '%s' on DeviceTemplate '%s'.", this.mPinT.getName(), ((DeviceTemplate)this.mOwner).getName());
                return false;
            }
            return true;
        }

        @Override
        public String getDesc() {
            APoint2D loc = this.mPortUpdated.getLoc();
            if (this.mXform != null) {
                loc = loc.transform(this.mXform);
            }
            String strLoc = loc == null ? "" + loc : loc.toString(this.mUnit);
            return String.format("A port was added to PinTemplate '%s' on Net '%s' on DeviceTemplate '%s' at %s.", this.mPinT.getName(), this.mPinT.getNet().getName(), ((DeviceTemplate)this.mOwner).getName(), strLoc);
        }

        public PortTemplate getUpdatedPort() {
            return this.mPortUpdated;
        }

        @Override
        public String getItemDesc() {
            return String.format("%s port", this.mPinT.getName());
        }

        @Override
        public String getOldDesc() {
            return "";
        }

        @Override
        public String getNewDesc() {
            return "...";
        }

        @Override
        public String getUserName() {
            return "Port Added";
        }
    }

    public static class PortPadTemplateChanged
    extends PinTemplateMergeable {
        protected static boolean VerboseDescription = true;
        protected PortTemplate mOrig;
        protected PortTemplate mUpdated;
        protected String mEquivPadTemplateAdoptContext = null;

        public PortPadTemplateChanged(PortTemplate orig, PortTemplate updated) {
            super(orig.getPinTemplate(), Compare.Diff.Type.MODIFY);
            this.mOrig = orig;
            this.mUpdated = updated;
        }

        protected String getPadTemplateShapesDesc(PadTemplate padT) {
            List shapes = AUtil.sort((IterableIterator)padT.getLayerShapes());
            StringBuilder s = new StringBuilder();
            for (LayerShape shape : shapes) {
                s.append((s.length() == 0 ? "" : ", ") + shape.toString());
            }
            return s.toString();
        }

        public void setEquivPadTemplateAdoptContext(String contextKey) {
            this.mEquivPadTemplateAdoptContext = contextKey;
        }

        @Override
        protected boolean _merge() {
            if (AUtil.equals((Object)this.mOrig.getPinTemplate().getSubstrate(), (Object)this.mUpdated.getPinTemplate().getSubstrate())) {
                this.mOrig.setPadTemplate(this.mUpdated.getPadTemplate());
            } else {
                LinkedList<LayerShape> newShapes = new LinkedList<LayerShape>();
                for (LayerShape updatedShape : this.mUpdated.getPadTemplate().getLayerShapes()) {
                    Layer l = this.mOrig.getPinTemplate().getSubstrate().getLayer(updatedShape.getLayer().getName());
                    if (l == null) continue;
                    newShapes.add(LayerShape.create(null, (Layer)l, null, (AGeom)updatedShape.getGeom().copy()));
                }
                PadTemplate pt = PadTemplate.getEquiv((Db)this.mOrig.getDb(), (String)this.mEquivPadTemplateAdoptContext, (Substrate)this.mOrig.getPinTemplate().getSubstrate(), newShapes, (String)"PT", null);
                this.mOrig.setPadTemplate(pt);
            }
            return true;
        }

        @Override
        public String getDesc() {
            String details = "";
            if (VerboseDescription) {
                details = String.format("\nOriginal shapes:\n\t%s\nUpdated shapes:\n\t%s", this.getPadTemplateShapesDesc(this.mOrig.getPadTemplate()), this.getPadTemplateShapesDesc(this.mUpdated.getPadTemplate()));
            }
            return String.format("Port %d pin '%s' pad template was changed from '%s' to non-equivalent '%s' for DeviceTemplate '%s'.%s", this.mOrig.getPortNum(), this.mOrig.getPadTemplate().getName(), ComparePinTemplate.getPadTName(this.mOrig.getPadTemplate()), ComparePinTemplate.getPadTName(this.mUpdated.getPadTemplate()), ((DeviceTemplate)this.mOwner).getName(), details);
        }

        @Override
        public String getItemDesc() {
            return String.format("%s - %d template", this.mOrig.getPinTemplate().getName(), this.mOrig.getPortNum());
        }

        @Override
        public String getOldDesc() {
            return ComparePinTemplate.getPadTName(this.mOrig.getPadTemplate());
        }

        @Override
        public String getNewDesc() {
            return ComparePinTemplate.getPadTName(this.mUpdated.getPadTemplate());
        }

        @Override
        public String getUserName() {
            return "Port Changed";
        }
    }

    public static class PortMirrorChanged
    extends PinTemplateMergeable {
        protected PortTemplate mOrig;
        protected PortTemplate mUpdated;

        public PortMirrorChanged(PortTemplate orig, PortTemplate updated) {
            super(orig.getPinTemplate(), Compare.Diff.Type.MODIFY);
            this.mOrig = orig;
            this.mUpdated = updated;
        }

        @Override
        protected boolean _merge() {
            this.mOrig.setMirror(this.mUpdated.getMirror());
            return true;
        }

        @Override
        public String getDesc() {
            return String.format("Port %d of pin '%s' mirror was changed from '%s' to '%s' for device template '%s'.", this.mOrig.getPortNum(), this.mOrig.getPinTemplate().getName(), this.getMirrorDesc(this.mOrig), this.getMirrorDesc(this.mUpdated), ((DeviceTemplate)this.mOwner).getName());
        }

        protected String getMirrorDesc(PortTemplate p) {
            return p.getMirror() ? "mirrored" : "not mirrored";
        }

        @Override
        public String getItemDesc() {
            return String.format("%s - %d mirror", this.mOrig.getPinTemplate().getName(), this.mOrig.getPortNum());
        }

        @Override
        public String getOldDesc() {
            return this.getMirrorDesc(this.mOrig);
        }

        @Override
        public String getNewDesc() {
            return this.getMirrorDesc(this.mUpdated);
        }

        @Override
        public String getUserName() {
            return "Port Mirror Changed";
        }
    }

    public static class PortRotateChanged
    extends PinTemplateMergeable {
        protected PortTemplate mOrig;
        protected PortTemplate mUpdated;

        public PortRotateChanged(PortTemplate orig, PortTemplate updated) {
            super(orig.getPinTemplate(), Compare.Diff.Type.MODIFY);
            this.mOrig = orig;
            this.mUpdated = updated;
        }

        @Override
        protected boolean _merge() {
            this.mOrig.setRotate(this.mUpdated.getRotate());
            return true;
        }

        @Override
        public String getDesc() {
            return String.format("Port %d of pin '%s' rotate was changed from '%s' to '%s' for DeviceTemplate '%s'.", this.mOrig.getPortNum(), this.mOrig.getPinTemplate().getName(), Float.valueOf(this.mOrig.getRotate()), Float.valueOf(this.mUpdated.getRotate()), ((DeviceTemplate)this.mOwner).getName());
        }

        @Override
        public String getItemDesc() {
            return String.format("%s - %d rotate", this.mOrig.getPinTemplate().getName(), this.mOrig.getPortNum());
        }

        @Override
        public String getOldDesc() {
            return "" + this.mOrig.getRotate();
        }

        @Override
        public String getNewDesc() {
            return "" + this.mUpdated.getRotate();
        }

        @Override
        public String getUserName() {
            return "Port Rotate Changed";
        }
    }

    public static class PortMoved
    extends PinTemplateMergeable {
        protected PortTemplate mOrig;
        protected PortTemplate mUpdated;
        protected Unit mUnit = null;
        protected AffineTransform mXform = null;

        public PortMoved(PortTemplate orig, PortTemplate updated) {
            super(orig.getPinTemplate(), Compare.Diff.Type.MODIFY);
            this.mOrig = orig;
            this.mUpdated = updated;
        }

        public void setUnit(Unit unit) {
            this.mUnit = unit;
        }

        public void setXform(AffineTransform xform) {
            this.mXform = xform;
        }

        @Override
        protected boolean _merge() {
            APoint2D loc = this.mUpdated.getLoc();
            if (loc != null) {
                loc = loc.copy();
            }
            this.mOrig.setLoc(loc);
            return true;
        }

        @Override
        public String getDesc() {
            return String.format("Port %d of pin '%s' on net '%s' was moved from %s to %s for DeviceTemplate '%s'.", this.mOrig.getPortNum(), this.mOrig.getPinTemplate().getName(), this.mOrig.getPinTemplate().getNet().getName(), this.getOldDesc(), this.getNewDesc(), ((DeviceTemplate)this.mOwner).getName());
        }

        @Override
        public void show() {
            super.show();
            for (DevicePath path : this.mUpdated.getDeviceTemplate().getHierarchicalInstances()) {
                ShowMeTheWay.addHierPort(path, this.mUpdated);
            }
        }

        @Override
        public String getItemDesc() {
            return "location";
        }

        @Override
        public String getOldDesc() {
            APoint2D oldLoc = this.mOrig.getLoc();
            if (this.mXform != null) {
                oldLoc = oldLoc.transform(this.mXform);
            }
            return oldLoc.toString(this.mUnit);
        }

        @Override
        public String getNewDesc() {
            APoint2D newLoc = this.mUpdated.getLoc();
            if (this.mXform != null && newLoc != null) {
                newLoc = newLoc.transform(this.mXform);
            }
            return newLoc == null ? "" + newLoc : newLoc.toString(this.mUnit);
        }

        @Override
        public String getUserName() {
            return "Port Location Changed";
        }
    }

    public static class PinTypeChanged
    extends PinTemplateMergeable {
        protected PinTemplate mOrig;
        protected PinTemplate mUpdated;

        public PinTypeChanged(PinTemplate orig, PinTemplate updated) {
            super(orig, Compare.Diff.Type.MODIFY);
            this.mOrig = orig;
            this.mUpdated = updated;
        }

        @Override
        protected boolean _merge() {
            this.mOrig.setType(this.mUpdated.getType());
            return true;
        }

        @Override
        public String getDesc() {
            return String.format("Pin '%s' type was changed from %s to %s for device template '%s'.", this.mOrig.getName(), this.mOrig.getType(), this.mUpdated.getType(), ((DeviceTemplate)this.mOwner).getName());
        }

        @Override
        public String getItemDesc() {
            return String.format("%s - type", this.mOrig.getName());
        }

        @Override
        public String getOldDesc() {
            return "" + this.mOrig.getType();
        }

        @Override
        public String getNewDesc() {
            return "" + this.mUpdated.getType();
        }

        @Override
        public String getUserName() {
            return "Type Changed";
        }
    }

    public static class PinUseChanged
    extends PinTemplateMergeable {
        protected PinTemplate mOrig;
        protected PinTemplate mUpdated;

        public PinUseChanged(PinTemplate orig, PinTemplate updated) {
            super(orig, Compare.Diff.Type.MODIFY);
            this.mOrig = orig;
            this.mUpdated = updated;
        }

        @Override
        protected boolean _merge() {
            this.mOrig.setUse(this.mUpdated.getUse());
            return true;
        }

        @Override
        public String getDesc() {
            return String.format("Pin '%s' use was changed from '%s' to '%s' for DeviceTemplate '%s'.", this.mOrig.getName(), this.mOrig.getUse(), this.mUpdated.getUse(), ((DeviceTemplate)this.mOwner).getName());
        }

        @Override
        public String getItemDesc() {
            return String.format("%s - use", this.mOrig.getName());
        }

        @Override
        public String getOldDesc() {
            return "" + this.mOrig.getUse();
        }

        @Override
        public String getNewDesc() {
            return "" + this.mUpdated.getUse();
        }

        @Override
        public String getUserName() {
            return "Use Changed";
        }
    }

    public static class PinDirectionChanged
    extends PinTemplateMergeable {
        protected PinTemplate mOrig;
        protected PinTemplate mUpdated;

        public PinDirectionChanged(PinTemplate orig, PinTemplate updated) {
            super(orig, Compare.Diff.Type.MODIFY);
            this.mOrig = orig;
            this.mUpdated = updated;
        }

        @Override
        protected boolean _merge() {
            this.mOrig.setDirection(this.mUpdated.getDirection());
            return true;
        }

        @Override
        public String getDesc() {
            return String.format("Pin '%s' direction was changed from %s to %s for device template '%s'.", this.mOrig.getName(), this.mOrig.getDirection(), this.mUpdated.getDirection(), ((DeviceTemplate)this.mOwner).getName());
        }

        @Override
        public String getItemDesc() {
            return String.format("%s direction", this.mOrig.getName());
        }

        @Override
        public String getOldDesc() {
            return "" + this.mOrig.getDirection();
        }

        @Override
        public String getNewDesc() {
            return "" + this.mUpdated.getDirection();
        }

        @Override
        public String getUserName() {
            return "Direction Changed";
        }
    }

    public static class PinNetChanged
    extends PinTemplateMergeable {
        protected PinTemplate mOrig;
        protected PinTemplate mUpdated;

        public PinNetChanged(PinTemplate orig, PinTemplate updated) {
            super(orig, Compare.Diff.Type.MODIFY);
            this.mOrig = orig;
            this.mUpdated = updated;
        }

        @Override
        protected boolean _merge() {
            Net newNet = this.mOrig.getDeviceTemplate().getNet(this.mUpdated.getNet().getName());
            if (newNet == null) {
                return false;
            }
            this.mOrig.setNet(newNet);
            return true;
        }

        @Override
        public String getDesc() {
            return String.format("Pin '%s' net was changed from '%s' to '%s' for DeviceTemplate '%s'.", this.mOrig.getName(), this.mOrig.getNet().getName(), this.mUpdated.getNet().getName(), ((DeviceTemplate)this.mOwner).getName());
        }

        @Override
        public String getItemDesc() {
            return String.format("%s net", this.mOrig.getName());
        }

        @Override
        public String getOldDesc() {
            return this.mOrig.getNet().getName();
        }

        @Override
        public String getNewDesc() {
            return this.mUpdated.getNet().getName();
        }

        @Override
        public String getUserName() {
            return "Net Changed";
        }
    }

    public static class PinRenamed
    extends PinTemplateMergeable {
        protected PinTemplate mOrig;
        protected PinTemplate mUpdated;

        public PinRenamed(PinTemplate orig, PinTemplate updated) {
            super(orig, Compare.Diff.Type.MODIFY);
            this.mOrig = orig;
            this.mUpdated = updated;
        }

        @Override
        protected boolean _merge() {
            this.mOrig.setName(this.mUpdated.getName());
            return true;
        }

        @Override
        public String getDesc() {
            return String.format("Pin '%s' on net '%s' was renamed from %s to %s for device template '%s'.", this.mOrig.getName(), this.mOrig.getNet().getName(), this.mOrig.getName(), this.mUpdated.getName(), ((DeviceTemplate)this.mOwner).getName());
        }

        @Override
        public String getItemDesc() {
            return "name";
        }

        @Override
        public String getOldDesc() {
            return this.mOrig.getName();
        }

        @Override
        public String getNewDesc() {
            return this.mUpdated.getName();
        }

        @Override
        public String getUserName() {
            return "Pin Name Changed";
        }
    }

    public static abstract class PinTemplateMergeable
    extends Compare.Mergeable<DeviceTemplate> {
        PinTemplate mPinT;

        public PinTemplateMergeable(PinTemplate port, Compare.Diff.Type type) {
            super(port.getDeviceTemplate(), type);
            this.mPinT = port;
        }

        public PinTemplate getOrigPinT() {
            return this.mPinT;
        }

        @Override
        public Class<PinTemplate> getModifiedType() {
            return PinTemplate.class;
        }

        @Override
        public List<Action> getActions() {
            return List.of(this.getActionSelect(), this.getActionShow());
        }

        protected Action getActionSelect() {
            return new AbstractAction("Select"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Selection s = Selection.getCurrentSelectionForDb((Db)((DeviceTemplate)mOwner).getDb());
                    s.add((DbObject)mPinT);
                    OrbitIO.getOrbitIO().refreshCurrentView();
                }
            };
        }

        protected Action getActionShow() {
            return new AbstractAction("Show"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.show();
                }
            };
        }

        public void show() {
            for (DevicePath path : ((DeviceTemplate)this.mOwner).getHierarchicalInstances()) {
                ShowMeTheWay.addHierPin(HierPin.forPinT((DevicePath)path, (PinTemplate)this.mPinT));
            }
        }

        @Override
        public String getDbClass() {
            return "Pin";
        }
    }

    public static class EquivPadTemplates {
        public static final CompareContext.ItemFactory<EquivPadTemplates> Factory = EquivPadTemplates::new;
        protected CompareContext mContext;
        protected Comparator<AGeom> mGeomComparator = null;
        protected HashMap<APair<PadTemplate, PadTemplate>, Boolean> mEquivPadTemplates = Maps.newHashMap();

        public EquivPadTemplates(CompareContext context) {
            this.mContext = context;
        }

        public void setGeomComparator(Comparator<AGeom> geomComarator) {
            this.mGeomComparator = geomComarator;
        }

        public boolean equivalent(PadTemplate orig, PadTemplate updated) {
            APair key = APair.create((Object)orig, (Object)updated);
            Boolean val = this.mEquivPadTemplates.get(key);
            if (val == null) {
                val = this.equiv(orig, updated);
                this.mEquivPadTemplates.put((APair<PadTemplate, PadTemplate>)key, val);
            }
            return val;
        }

        protected boolean equiv(PadTemplate a, PadTemplate b) {
            if (a == null && b == null) {
                return true;
            }
            if (a == null || b == null) {
                return false;
            }
            if (a == b) {
                return true;
            }
            PadTemplate.EquivalentLayer layerCompare = new PadTemplate.EquivalentLayer(){

                public boolean equivalent(Layer a, Layer b) {
                    if (a == null && b == null) {
                        return true;
                    }
                    if (a == null || b == null) {
                        return false;
                    }
                    if (a == b) {
                        return true;
                    }
                    CompareSubstrate.EquivSubstrates ess = mContext.getItem(CompareSubstrate.EquivSubstrates.class);
                    if (ess == null) {
                        ALog.logWarn((String)"Attempt to compare PadTemplates of different substrates without a registered EquivSubstrates class in the compare context.");
                        return false;
                    }
                    CompareSubstrate.EquivSubstrates.EquivSubstrate es = ess.getEquivInfo(a.getSubstrate(), b.getSubstrate());
                    if (es == null) {
                        ALog.logWarn((String)"Attempt to compare PadTemplates of different substrates without substrate equivalency information in the compare context.");
                        return false;
                    }
                    return es.isEquiv(a, b);
                }
            };
            return PadTemplate.isEquivLayerShapes((List)AUtil.linkedList((Iterator)a.getLayerShapes()), (List)AUtil.linkedList((Iterator)b.getLayerShapes()), (PadTemplate.EquivalentLayer)layerCompare, this.mGeomComparator);
        }
    }
}

