/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.diff_merge;

import com.sigrity.acl.AIterableItr;
import com.sigrity.acl.APair;
import com.sigrity.acl.IterableIterator;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Layer;
import com.sigrity.acl.db.std.Obstacle;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.acl.db.std.Substrate;
import com.sigrity.orbit.diff_merge.Compare;
import com.sigrity.orbit.diff_merge.CompareDevice;
import com.sigrity.orbit.diff_merge.CompareDeviceTemplate;
import com.sigrity.orbit.diff_merge.CompareLayer;
import com.sigrity.orbit.diff_merge.CompareObstacle;
import com.sigrity.orbit.diff_merge.ComparePinTemplate;
import com.sigrity.orbit.diff_merge.CompareSubstrate;
import java.util.Collection;
import java.util.LinkedList;
import org.apache.commons.collections15.multimap.MultiHashMap;

public class CompareRegistry {
    protected static CompareRegistry sCompareRegistry = new CompareRegistry();
    protected MultiHashMap<Class<?>, Compare<?>> mClass2Compares = new MultiHashMap();

    public static CompareRegistry getCompareRegistry() {
        return sCompareRegistry;
    }

    public <T extends DbObject> void addCompare(Class<T> type, Compare<T> compare) {
        this.mClass2Compares.put(type, compare);
    }

    public <T extends DbObject> IterableIterator<Compare<T>> getCompares(Class<T> type) {
        Collection c = this.mClass2Compares.get(type);
        return AIterableItr.itr((Collection)c);
    }

    public int remove(Compare<?> compare) {
        LinkedList<APair> toRemove = new LinkedList<APair>();
        for (Class key : this.mClass2Compares.keySet()) {
            for (Compare val : this.mClass2Compares.get((Object)key)) {
                if (val != compare) continue;
                toRemove.add(new APair((Object)key, (Object)val));
            }
        }
        int res = 0;
        for (APair remove : toRemove) {
            this.mClass2Compares.remove(remove.first, remove.second);
            ++res;
        }
        return res;
    }

    static {
        sCompareRegistry.addCompare(Substrate.class, new CompareSubstrate());
        sCompareRegistry.addCompare(Layer.class, new CompareLayer());
        sCompareRegistry.addCompare(DeviceTemplate.class, new CompareDeviceTemplate());
        sCompareRegistry.addCompare(Device.class, new CompareDevice());
        sCompareRegistry.addCompare(PinTemplate.class, new ComparePinTemplate());
        sCompareRegistry.addCompare(Obstacle.class, new CompareObstacle());
    }
}

