/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.diff_merge;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.sigrity.acl.APair;
import com.sigrity.acl.AUtil;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.std.Layer;
import com.sigrity.acl.db.std.Substrate;
import com.sigrity.orbit.diff_merge.Compare;
import com.sigrity.orbit.diff_merge.CompareContext;
import com.sigrity.orbit.diff_merge.CompareRegistry;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.Action;

public class CompareSubstrate
extends Compare<Substrate> {
    @Override
    public Iterator<Compare.Diff<? extends DbObject>> findDiffs(CompareContext context, Substrate orig, Substrate updated) {
        context.register(EquivSubstrates.class, EquivSubstrates.Factory);
        EquivSubstrates eqSubstrate = context.getItem(EquivSubstrates.class);
        return eqSubstrate.compare(context, orig, updated).iterator();
    }

    public static class LayerRemoved
    extends Compare.Diff<Substrate> {
        protected Layer mRemovedLayer;

        public LayerRemoved(Substrate substOrig, Layer l) {
            super(substOrig, Compare.Diff.Type.DELETE);
            this.mRemovedLayer = l;
        }

        @Override
        public String getDesc() {
            return String.format("Layer removed from substrate '%s', layer name '%s' of type %s.", ((Substrate)this.getOwner()).getName(), this.mRemovedLayer.getName(), this.mRemovedLayer.getType());
        }

        @Override
        public List<Action> getActions() {
            return Collections.emptyList();
        }

        @Override
        public int compareTo(Compare.Diff<?> o) {
            if (o instanceof LayerRemoved) {
                LayerRemoved other = (LayerRemoved)o;
                return Layer.TopFirstSort.compare(this.mRemovedLayer, other.mRemovedLayer);
            }
            return this.getDesc().compareTo(o.getDesc());
        }

        @Override
        public String getDbClass() {
            return "Layer";
        }

        @Override
        public String getItemDesc() {
            return "layer";
        }

        @Override
        public String getOldDesc() {
            return this.mRemovedLayer.getName();
        }

        @Override
        public String getNewDesc() {
            return "";
        }

        @Override
        public String getUserName() {
            return "Removed";
        }
    }

    public static class LayerAdded
    extends Compare.Mergeable<Substrate> {
        protected Layer mAddedLayer;
        protected CompareContext mCtx = null;

        public LayerAdded(Substrate substOrig, Layer l, CompareContext ctx) {
            super(substOrig, Compare.Diff.Type.ADD);
            this.mAddedLayer = l;
            this.mCtx = ctx;
        }

        @Override
        public String getDesc() {
            return String.format("New layer added to substrate '%s', layer name '%s' of type %s.", ((Substrate)this.getOwner()).getName(), this.mAddedLayer.getName(), this.mAddedLayer.getType());
        }

        @Override
        public List<Action> getActions() {
            return Collections.emptyList();
        }

        @Override
        protected boolean _merge() {
            EquivSubstrates ess;
            String name = this.mAddedLayer.getName();
            int i = 1;
            while (((Substrate)this.getOwner()).getLayer(name) != null) {
                name = String.format("%s%d", this.mAddedLayer.getName(), i);
                ++i;
            }
            Layer l = Layer.create((Substrate)((Substrate)this.getOwner()), (String)name);
            if (this.mCtx != null && (ess = this.mCtx.getItem(EquivSubstrates.class)) != null) {
                EquivSubstrates.EquivSubstrate es = ess.getEquivInfo((Substrate)this.getOwner(), this.mAddedLayer.getSubstrate());
                assert (es != null) : "Substrates are net set as equivalent";
                if (es != null) {
                    es.putEquiv(l, this.mAddedLayer);
                }
            }
            return true;
        }

        @Override
        public int compareTo(Compare.Diff<?> o) {
            if (o instanceof LayerAdded) {
                LayerAdded other = (LayerAdded)o;
                return Layer.TopFirstSort.compare(this.mAddedLayer, other.mAddedLayer);
            }
            return this.getDesc().compareTo(o.getDesc());
        }

        @Override
        public String getDbClass() {
            return "Layer";
        }

        @Override
        public String getItemDesc() {
            return "layer";
        }

        @Override
        public String getOldDesc() {
            return "";
        }

        @Override
        public String getNewDesc() {
            return this.mAddedLayer.getName();
        }

        @Override
        public String getUserName() {
            return "Added";
        }
    }

    public static class EquivSubstrates {
        public static final CompareContext.ItemFactory<EquivSubstrates> Factory = context -> new EquivSubstrates();
        protected HashMap<APair<Substrate, Substrate>, EquivSubstrate> mEquivs = Maps.newHashMap();

        public boolean containsOrig(Substrate orig) {
            return this.getUpdated(orig).isPresent();
        }

        public boolean containsUpdated(Substrate updated) {
            return this.getOrig(updated).isPresent();
        }

        public Optional<Substrate> getUpdated(Substrate orig) {
            return this.mEquivs.keySet().stream().filter(p -> p.first == orig).findAny().map(p -> (Substrate)p.second);
        }

        public Optional<Substrate> getOrig(Substrate updated) {
            return this.mEquivs.keySet().stream().filter(p -> p.second == updated).findAny().map(p -> (Substrate)p.first);
        }

        public Stream<Map.Entry<APair<Substrate, Substrate>, EquivSubstrate>> getEquivSubstrates() {
            return this.mEquivs.entrySet().stream();
        }

        public Collection<Compare.Diff<?>> compare(CompareContext context, Substrate substOrig, Substrate substUpdt) {
            LinkedList result = Lists.newLinkedList();
            APair key = APair.create((Object)substOrig, (Object)substUpdt);
            if (this.mEquivs.containsKey(key)) {
                return result;
            }
            EquivSubstrate eq = new EquivSubstrate(context, substOrig, substUpdt);
            this.mEquivs.put((APair<Substrate, Substrate>)key, eq);
            result.addAll(eq.getAndClearDiffs());
            CompareRegistry cr = CompareRegistry.getCompareRegistry();
            for (Compare compare : cr.getCompares(Substrate.class)) {
                for (Compare.Diff change : compare.getDiffs(context, substOrig, substUpdt)) {
                    result.add(change);
                }
            }
            return result;
        }

        public EquivSubstrate getEquivInfo(Substrate substOrig, Substrate substUpdt) {
            APair key = APair.create((Object)substOrig, (Object)substUpdt);
            return this.mEquivs.get(key);
        }

        public class EquivSubstrate {
            protected boolean mLayersPrematched = false;
            protected LayerMatcher mLayerMatcher;
            protected LinkedList<Compare.Diff<?>> diffs = Lists.newLinkedList();

            public EquivSubstrate(CompareContext context, Substrate substOrig, Substrate substUpdt) {
                this.mLayerMatcher = context.getItem(LayerMatcher.class);
                if (this.mLayerMatcher != null) {
                    this.mLayersPrematched = true;
                } else {
                    this.mLayerMatcher = new LayerMatcher(substUpdt, substOrig);
                }
                if (!this.mLayersPrematched) {
                    this.mLayerMatcher.getLeftOnly().forEach(l -> this.diffs.add(new LayerAdded(substOrig, (Layer)l, context)));
                    this.mLayerMatcher.getRightOnly().forEach(l -> this.diffs.add(new LayerRemoved(substOrig, (Layer)l)));
                    CompareRegistry cr = CompareRegistry.getCompareRegistry();
                    for (Map.Entry layers : this.mLayerMatcher.getMatched().entrySet()) {
                        for (Compare compare : cr.getCompares(Layer.class)) {
                            compare.findDiffs(context, (Layer)layers.getValue(), (Layer)layers.getKey()).forEachRemaining(diff -> this.diffs.add((Compare.Diff<?>)diff));
                        }
                    }
                }
            }

            public Collection<Layer> getEquivOfOrig(Layer orig) {
                return this.mLayerMatcher.getMatchedInverse().get((Object)orig);
            }

            public Layer getEquivOfUpdated(Layer updated) {
                return (Layer)this.mLayerMatcher.getMatched().get((Object)updated);
            }

            public void putEquiv(Layer orig, Layer updated) {
                assert (this.getEquivOfUpdated(updated) == null);
                this.mLayerMatcher.addMatch(orig, updated);
            }

            public boolean isEquiv(Layer orig, Layer updt) {
                return this.getEquivOfUpdated(updt) == orig;
            }

            protected LinkedList<Compare.Diff<?>> getAndClearDiffs() {
                LinkedList<Compare.Diff<?>> res = this.diffs;
                this.diffs = null;
                return res;
            }
        }
    }

    public static class LayerMatcher {
        List<Layer> mLeft;
        List<Layer> mRight;
        HashMap<Layer, Layer> mL2R = new HashMap();
        HashMultimap<Layer, Layer> mR2L = HashMultimap.create();

        public LayerMatcher(Substrate left, Substrate right) {
            this.mLeft = left == null ? Collections.emptyList() : left.getLayers().stream().sorted(Layer.TopFirstSort).collect(Collectors.toList());
            this.mRight = left == right ? this.mLeft : (right == null ? Collections.emptyList() : right.getLayers().stream().sorted(Layer.TopFirstSort).collect(Collectors.toList()));
            this.detectMatches();
        }

        public LayerMatcher(Stream<Layer> leftLayers, Stream<Layer> rightLayers) {
            this.mLeft = leftLayers.collect(Collectors.toList());
            this.mRight = rightLayers.collect(Collectors.toList());
        }

        public void clearMatches() {
            this.mL2R.clear();
            this.mR2L.clear();
        }

        public void addMatch(Layer left, Layer right) {
            Layer oldRight = this.mL2R.get(left);
            if (oldRight == right) {
                return;
            }
            this.mL2R.remove(left);
            if (oldRight != null) {
                this.mR2L.remove((Object)right, (Object)left);
            }
            this.mL2R.put(left, right);
            if (right != null) {
                this.mR2L.put((Object)right, (Object)left);
            }
        }

        public void detectMatches() {
            this.clearMatches();
            if (this.mLeft == this.mRight) {
                this.mLeft.forEach(l -> this.addMatch((Layer)l, (Layer)l));
                return;
            }
            LinkedHashMap<String, Layer> rightLayersByName = new LinkedHashMap<String, Layer>();
            for (Layer rl : this.mRight) {
                rightLayersByName.put(rl.getName(), rl);
            }
            for (Layer ll : this.mLeft) {
                Layer rl = (Layer)rightLayersByName.get(ll.getName());
                if (rl == null) continue;
                this.addMatch(ll, rl);
            }
            block2: for (Layer rl : AUtil.linkedList(this.getRightOnly())) {
                for (Layer ll : AUtil.linkedList(this.getLeftOnly())) {
                    if (!this.isARenameOf(ll, rl)) continue;
                    this.addMatch(ll, rl);
                    continue block2;
                }
            }
        }

        private boolean isARenameOf(Layer l1, Layer l2) {
            return l2.getName().equalsIgnoreCase(l1.getName()) || l2.getOrder() == l1.getOrder() && l2.getType() == l1.getType();
        }

        public ImmutableMap<Layer, Layer> getMatched() {
            return ImmutableMap.copyOf(this.mL2R);
        }

        ImmutableMultimap<Layer, Layer> getMatchedInverse() {
            return ImmutableMultimap.copyOf(this.mR2L);
        }

        public Stream<Layer> getLeftOnly() {
            return this.mLeft.stream().filter(l -> !this.mL2R.containsKey(l));
        }

        public Stream<Layer> getRightOnly() {
            return this.mRight.stream().filter(r -> !this.mR2L.containsKey(r));
        }
    }
}

