/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.diff_merge;

import com.google.common.collect.ArrayListMultimap;
import com.sigrity.acl.ALog;
import com.sigrity.acl.APair;
import com.sigrity.acl.AUtil;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.PinInstance;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.orbit.diff_merge.Compare;
import com.sigrity.orbit.diff_merge.CompareContext;
import com.sigrity.orbit.diff_merge.CompareDevice;
import com.sigrity.orbit.diff_merge.CompareDeviceTemplate;
import com.sigrity.orbit.diff_merge.CompareRegistry;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Stream;

public class DTDiffMerge {
    protected Device mOrigDevice = null;
    protected DeviceTemplate mOrigTemplate;
    protected Device mUpdatedDevice = null;
    protected DeviceTemplate mUpdatedTemplate;
    protected Diffs mDiffs = new Diffs();
    protected Consumer<Compare.Diff<?>> mDiffConsumer = d -> this.mDiffs.add((Compare.Diff<? extends DbObject>)d);
    protected boolean mDiffRun = false;

    public DTDiffMerge(DeviceTemplate original) {
        this.mOrigTemplate = original;
    }

    public DTDiffMerge(DeviceTemplate original, DeviceTemplate updated) {
        this(original);
        this.mUpdatedTemplate = updated;
    }

    public DTDiffMerge(Device original, Device updated) {
        this(original.getTemplate(), updated.getTemplate());
        this.mOrigDevice = original;
        this.mUpdatedDevice = updated;
    }

    public boolean compare() {
        ALog.logInfo((String)"Comparing...");
        this.mDiffs.clear();
        CompareRegistry cr = CompareRegistry.getCompareRegistry();
        CompareContext context = new CompareContext();
        if (this.mOrigDevice != null && this.mUpdatedDevice != null) {
            for (Compare compare : cr.getCompares(Device.class)) {
                for (Compare.Diff change : compare.getDiffs(context, this.mOrigDevice, this.mUpdatedDevice)) {
                    this.addDiff(change);
                }
            }
        } else if (this.mOrigTemplate != null && this.mUpdatedTemplate != null) {
            for (Compare compare : cr.getCompares(DeviceTemplate.class)) {
                for (Compare.Diff change : compare.getDiffs(context, this.mOrigTemplate, this.mUpdatedTemplate)) {
                    this.addDiff(change);
                }
            }
        } else {
            ALog.logError((String)"A pair of DeviceTemplateS or DeviceS must be supplied to compare.");
        }
        this.mDiffRun = true;
        ALog.logInfo((String)"Comparision complete.");
        return true;
    }

    public void log() {
        ALog.logInfo((String)"======== Differences from '%s' to '%s' ========", (Object[])new Object[]{this.mOrigTemplate.getName(), this.mUpdatedTemplate.getName()});
        for (Compare.Diff<? extends DbObject> diff : this.mDiffs.getDiffs()) {
            ALog.logInfo((String)("%s " + diff.getDesc()), (Object[])new Object[]{diff instanceof Compare.Mergeable ? "+" : "o"});
        }
        ALog.logInfo((String)"=============================");
    }

    public boolean getDiffRun() {
        return this.mDiffRun;
    }

    protected void addDiff(Compare.Diff<? extends DbObject> diff) {
        this.mDiffs.add(diff);
    }

    protected void addAll(Stream<Compare.Diff<? extends DbObject>> diffs) {
        this.mDiffs.addAll(diffs);
    }

    public Collection<Compare.Diff<? extends DbObject>> getDiffs() {
        return this.mDiffs.getDiffs();
    }

    public Db getOrigDb() {
        return this.mOrigTemplate == null ? null : this.mOrigTemplate.getDb();
    }

    public Design getOrigDesign() {
        return Design.getDesign((Db)this.getOrigDb(), (boolean)false);
    }

    public Device getOriginalDevice() {
        return this.mOrigDevice;
    }

    public DeviceTemplate getOriginalTemplate() {
        return this.mOrigTemplate;
    }

    public Device getUpdatedDevice() {
        return this.mUpdatedDevice;
    }

    public DeviceTemplate getUpdatedTemplate() {
        return this.mUpdatedTemplate;
    }

    public void setUpdatedTemplate(DeviceTemplate updatedTemplate) {
        this.mUpdatedTemplate = updatedTemplate;
    }

    public String getCompareTypeDesc() {
        return this.mOrigDevice != null ? "Device" : "DeviceTemplate";
    }

    public String getOriginalDesc() {
        return this.mOrigDevice != null ? this.mOrigDevice.getName() : this.mOrigTemplate.getName();
    }

    public String getUpdatedDesc() {
        return this.mUpdatedDevice != null ? this.mUpdatedDevice.getName() : this.mUpdatedTemplate.getName();
    }

    public String getCompareDesc() {
        return String.format("Compare %s '%s' to '%s'", this.getCompareTypeDesc(), this.getOriginalDesc(), this.getUpdatedDesc());
    }

    public void processHierarchyCompression() {
        ALog.logInfo((String)"Evaluating hierarchy compression...");
        for (Compare.Diff d : AUtil.arrayList(this.mDiffs.getDiffs())) {
            if (!(d instanceof CompareDeviceTemplate.DeviceRemoved)) continue;
            CompareDeviceTemplate.DeviceRemoved diffDevRemoved = (CompareDeviceTemplate.DeviceRemoved)d;
            DeviceTemplate dtParentOrig = diffDevRemoved.getOrigParent();
            Device devRemoved = diffDevRemoved.getDeletedChild();
            DeviceTemplate dtParentUpdated = diffDevRemoved.getUpdatedParent();
            LinkedList<PinInstance> pins = new LinkedList<PinInstance>();
            for (PinInstance port : devRemoved.getPins()) {
                pins.add(port);
            }
            for (Device devDescended : devRemoved.getDescendants()) {
                for (PinInstance port : devDescended.getPins()) {
                    pins.add(port);
                }
            }
            boolean foundAll = true;
            LinkedList<APair> equivPorts = new LinkedList<APair>();
            for (PinInstance port : pins) {
                PinTemplate parentPort = dtParentUpdated.getPinByName(port.getName());
                if (parentPort == null) {
                    foundAll = false;
                    break;
                }
                equivPorts.add(new APair((Object)port, (Object)parentPort));
            }
            if (!foundAll) continue;
            this.mDiffs.remove(diffDevRemoved);
            for (APair equiv : equivPorts) {
                for (Compare.Diff diff : AUtil.arrayList(this.mDiffs.getDiffs(dtParentOrig))) {
                    CompareDevice.PinAdded pinAdded;
                    PinInstance updatedPin;
                    if (!(diff instanceof CompareDevice.PinAdded) || (updatedPin = (pinAdded = (CompareDevice.PinAdded)diff).getUpdatedPin()).getPinTemplate() != equiv.second) continue;
                    this.mDiffs.remove(diff);
                }
            }
        }
        ALog.logInfo((String)"Hierarchy compression evaluation complete.");
    }

    public static class Diffs {
        protected ArrayListMultimap<Object, Compare.Diff<? extends DbObject>> mObject2Diffs = ArrayListMultimap.create();

        public void clear() {
            this.mObject2Diffs.clear();
        }

        public boolean add(Compare.Diff<? extends DbObject> diff) {
            this.mObject2Diffs.put((Object)diff.getOwner(), diff);
            return true;
        }

        public void addAll(Stream<Compare.Diff<? extends DbObject>> diffs) {
            diffs.forEach(this::add);
        }

        public void remove(Compare.Diff<? extends DbObject> diff) {
            this.mObject2Diffs.remove((Object)diff.getOwner(), diff);
        }

        public Collection<Compare.Diff<? extends DbObject>> getDiffs() {
            return this.mObject2Diffs.values();
        }

        public List<Compare.Diff<? extends DbObject>> getDiffs(Object owner) {
            return this.mObject2Diffs.get(owner);
        }

        public boolean isEmpty() {
            return this.mObject2Diffs.isEmpty();
        }

        public long size() {
            return this.mObject2Diffs.size();
        }
    }
}

