/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.diff_merge;

import com.sigrity.acl.ALog;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.std.Connection;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Substrate;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.diff_merge.DTDiffMerge;
import java.util.Set;
import java.util.stream.Collectors;

public abstract class FileDiffMerger
extends DTDiffMerge {
    private final String mFilePath;
    private boolean mIsCompareRootDeviceTemplate = true;
    private boolean mIsDbPreOpen = false;
    private Set<Device> mTargetDevices;

    public FileDiffMerger(DeviceTemplate origRootDevT, String filePath) {
        super(origRootDevT);
        this.mFilePath = filePath;
    }

    public void setIsCompareRootDeviceTemplate(boolean b) {
        this.mIsCompareRootDeviceTemplate = b;
    }

    public boolean getIsCompareRootDeviceTemplate() {
        return this.mIsCompareRootDeviceTemplate;
    }

    public void setTargetDevices(Set<Device> targetDevs) {
        this.mTargetDevices = targetDevs;
    }

    public void setIsDbPrOpen(boolean b) {
        this.mIsDbPreOpen = b;
    }

    public Set<Device> getTargetDevices() {
        return this.mTargetDevices;
    }

    public String getFilePath() {
        return this.mFilePath;
    }

    public void importFile() {
        DeviceTemplate updatedDevT = this.createUpdatedDeviceTemplate();
        this.setUpdatedTemplate(updatedDevT);
    }

    protected abstract DeviceTemplate createUpdatedDeviceTemplate();

    public void cleanupPostMerge() {
        DeviceTemplate updatedTemplate = this.getUpdatedTemplate();
        if (updatedTemplate == null) {
            ALog.logWarn((String)"No updated template, ignore cleanup request ignored.");
            return;
        }
        Db updatedDb = updatedTemplate.getDb();
        if (updatedDb != null && updatedDb == this.getOrigDb() && this.getOriginalTemplate() != updatedTemplate) {
            this.clearTempDeviceTemplate(updatedTemplate);
        } else if (updatedDb != null && !this.mIsDbPreOpen) {
            this.clearTempDb(updatedDb);
        }
        this.mDiffs.clear();
        this.mDiffRun = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearTempDeviceTemplate(DeviceTemplate updatedTemplate) {
        Db db = this.getOrigDb();
        boolean oldHistEnabled = db.getHistoryEnabled();
        db.setHistoryEnabled(false);
        try {
            Connection.removeAll((Db)db);
            updatedTemplate.getChildren().stream().filter(d -> d.getSubstrate() != updatedTemplate.getSubstrate()).map(Device::getSubstrate).collect(Collectors.toSet()).forEach(Substrate::forceDeleteFromDb);
            updatedTemplate.getSubstrate().forceDeleteFromDb();
        }
        finally {
            if (oldHistEnabled) {
                db.setHistoryEnabled(true);
            }
        }
    }

    private void clearTempDb(Db tempDb) {
        OrbitIO.getApp().closeDesign(tempDb);
    }
}

