/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.diff_merge;

import com.sigrity.acl.ALog;
import com.sigrity.acl.APair;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.diff_merge.Compare;
import com.sigrity.orbit.diff_merge.CompareContext;
import com.sigrity.orbit.diff_merge.CompareDeviceTemplate;
import com.sigrity.orbit.diff_merge.CompareRegistry;
import com.sigrity.orbit.diff_merge.FileDiffMerger;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;

public class OioDiffMerger
extends FileDiffMerger {
    private CompareContext mCompareContext;

    public OioDiffMerger(Db origDb, String filePath) {
        super((DeviceTemplate)Design.getDesign((Db)origDb), filePath);
    }

    public OioDiffMerger(DeviceTemplate origRootDevT, String filePath) {
        super(origRootDevT, filePath);
    }

    @Override
    protected DeviceTemplate createUpdatedDeviceTemplate() {
        Db updatedDb = OrbitIO.getApp().getDesign(this.getFilePath());
        if (updatedDb != null) {
            this.setIsDbPrOpen(true);
            return Design.getDesign((Db)updatedDb);
        }
        boolean isOpen = OrbitIO.getApp().openDesign(this.getFilePath());
        if (isOpen) {
            updatedDb = OrbitIO.getCurDb();
            OrbitIO.getApp().setCurDb(this.getOrigDb());
            return Design.getDesign((Db)updatedDb);
        }
        return null;
    }

    @Override
    public boolean compare() {
        this.mCompareContext = new CompareContext();
        List<CompareDeviceTemplate> devTComparetors = CompareRegistry.getCompareRegistry().getCompares(DeviceTemplate.class).stream().filter(c -> c instanceof CompareDeviceTemplate).map(c -> (CompareDeviceTemplate)c).collect(Collectors.toList());
        devTComparetors.forEach(c -> c.setIsCompareChildern(false));
        ALog.logInfo((String)"Comparing...");
        this.mDiffs.clear();
        this.compareFromRootTemplate(this.mOrigTemplate, this.mUpdatedTemplate);
        this.mDiffRun = true;
        ALog.logInfo((String)"Comparision complete.");
        devTComparetors.forEach(c -> c.setIsCompareChildern(true));
        return true;
    }

    private void compareFromRootTemplate(DeviceTemplate origRootDevT, DeviceTemplate updatedRootDevT) {
        if (this.getIsCompareRootDeviceTemplate()) {
            this.compareTemplate(origRootDevT, updatedRootDevT);
        }
        this.compareChildren(origRootDevT, updatedRootDevT);
    }

    private void compareTemplate(DeviceTemplate origRootDevT, DeviceTemplate updatedRootDevT) {
        for (Compare compare : CompareRegistry.getCompareRegistry().getCompares(DeviceTemplate.class)) {
            for (Compare.Diff change : compare.getDiffs(this.mCompareContext, origRootDevT, updatedRootDevT)) {
                this.addDiff(change);
            }
        }
    }

    private void compareChildren(DeviceTemplate dtOrig, DeviceTemplate dtUpdated) {
        if (dtOrig != this.getOriginalTemplate() && this.hasCompared(dtOrig)) {
            return;
        }
        LinkedList devTPairs = new LinkedList();
        dtOrig.getChildren().forEach(origChild -> {
            if (origChild.isPin()) {
                return;
            }
            Device updatedChild = dtUpdated.getChild(origChild.getName());
            if (updatedChild != null && this.isTergetPath((Device)origChild)) {
                this.compareDevice((Device)origChild, updatedChild);
            } else if (updatedChild != null) {
                DeviceTemplate origDevT = origChild.getTemplate();
                DeviceTemplate updateDevT = updatedChild.getTemplate();
                devTPairs.add(APair.create((Object)origDevT, (Object)updateDevT));
            } else if (updatedChild == null) {
                this.addDiff(new CompareDeviceTemplate.DeviceRemoved(dtOrig, (Device)origChild, dtUpdated));
            }
        });
        devTPairs.forEach(devPair -> {
            DeviceTemplate origDevT = (DeviceTemplate)devPair.getFirst();
            if (this.hasCompared(origDevT)) {
                return;
            }
            DeviceTemplate updateDevT = (DeviceTemplate)devPair.getSecond();
            this.compareChildren(origDevT, updateDevT);
            this.setEqiuv(origDevT, updateDevT);
        });
        dtUpdated.getChildren().stream().filter(updatedChild -> dtOrig.getChild(updatedChild.getName()) == null && !updatedChild.isPin()).forEach(addedChild -> this.addDiff(new CompareDeviceTemplate.DeviceAdded(this.mCompareContext, dtOrig, (Device)addedChild)));
    }

    private void compareDevice(Device origDev, Device updatedDev) {
        DeviceTemplate origDevT = origDev.getTemplate();
        DeviceTemplate updatedDevT = updatedDev.getTemplate();
        if (origDevT.getName().equals(updatedDevT.getName()) && !this.hasCompared(origDevT)) {
            this.compareChildren(origDevT, updatedDevT);
        }
        for (Compare compare : CompareRegistry.getCompareRegistry().getCompares(Device.class)) {
            for (Compare.Diff change : compare.getDiffs(this.mCompareContext, origDev, updatedDev)) {
                this.addDiff(change);
            }
        }
    }

    private boolean hasCompared(DeviceTemplate origDevT) {
        return this.eqiuvDevTs() != null && this.eqiuvDevTs().containsOrig(origDevT);
    }

    private void setEqiuv(DeviceTemplate origDevT, DeviceTemplate updateDevT) {
        this.eqiuvDevTs().put(origDevT, updateDevT);
    }

    private boolean isTergetPath(Device origChild) {
        return this.getTargetDevices() == null || this.getTargetDevices().contains(origChild);
    }

    private CompareDeviceTemplate.EquivDeviceTemplates eqiuvDevTs() {
        CompareDeviceTemplate.EquivDeviceTemplates equivDevT = this.mCompareContext.getItem(CompareDeviceTemplate.EquivDeviceTemplates.class);
        if (equivDevT != null) {
            return equivDevT;
        }
        this.mCompareContext.register(CompareDeviceTemplate.EquivDeviceTemplates.class, CompareDeviceTemplate.EquivDeviceTemplates.Factory);
        return this.mCompareContext.getItem(CompareDeviceTemplate.EquivDeviceTemplates.class);
    }
}

