/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.diff_merge.ui;

import com.sigrity.acl.AFileFilter;
import com.sigrity.acl.ALog;
import com.sigrity.acl.APair;
import com.sigrity.acl.AUtil;
import com.sigrity.acl.FileLineCounter;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.ui.AButtonGroup;
import com.sigrity.acl.ui.ADialog;
import com.sigrity.acl.ui.AFileChooser;
import com.sigrity.acl.ui.AList;
import com.sigrity.acl.ui.AListModel;
import com.sigrity.acl.ui.APatternHelpButton;
import com.sigrity.acl.ui.DbDialog;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.diff_merge.Compare;
import com.sigrity.orbit.diff_merge.DTDiffMerge;
import com.sigrity.orbit.diff_merge.ui.InteractiveMergeUI;
import com.sigrity.orbit.ui.DeviceChooser;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileReader;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.filechooser.FileFilter;

public class DTDiffMergeUI {
    public static final AFileFilter FF_TEXTFILE = AFileFilter.TXT;
    private static DiffSetupDlg sPrevDiffSetupDlg = null;
    public static final Comparator<Class<?>> DiffTypeCompare = (a, b) -> a.getSimpleName().compareTo(b.getSimpleName());
    public static final Comparator<Compare.Diff<?>> DiffCompare = (a, b) -> {
        Object ownerB;
        int r = DiffTypeCompare.compare(a.getClass(), b.getClass());
        if (r != 0) {
            return r;
        }
        Object ownerA = a.getOwner();
        r = ownerA.compareTo(ownerB = b.getOwner());
        if (r != 0) {
            return r;
        }
        Class<DbObject> modifiedA = a.getModifiedType();
        Class<DbObject> modifiedB = a.getModifiedType();
        r = modifiedA.getName().compareTo(modifiedB.getName());
        if (r != 0) {
            return r;
        }
        return a.getDesc().compareTo(b.getDesc());
    };

    private DTDiffMergeUI() {
    }

    public static Action getAction() {
        return new AbstractAction("Compare/Merge Devices..."){

            @Override
            public void actionPerformed(ActionEvent e) {
                DTDiffMergeUI.diff(OrbitIO.getCurDb());
            }

            @Override
            public boolean isEnabled() {
                return super.isEnabled() && OrbitIO.getCurDb() != null;
            }
        };
    }

    public static void diff(Db db) {
        DTDiffMergeUI.diff(db, (Device)null, (Device)null);
    }

    public static void diff(Db db, String origPath, String updatedPath) {
        Device u;
        Device o;
        if (db == null) {
            ALog.logError((String)"No Db specified.");
            return;
        }
        Device device = o = origPath == null ? null : Device.fromPath((Db)db, (String)origPath);
        if (o == null) {
            ALog.logError((String)"Original device path '%s' is invalid.", (Object[])new Object[]{origPath});
            return;
        }
        Device device2 = u = updatedPath == null ? null : Device.fromPath((Db)db, (String)updatedPath);
        if (u == null) {
            ALog.logError((String)"Updated device path '%s' is invalid.", (Object[])new Object[]{updatedPath});
            return;
        }
        DTDiffMergeUI.diff(db, o, u);
    }

    public static void diff(Db db, Device orig, Device updated) {
        DiffSetupDlg dlg;
        Window appWin = OrbitIO.getMainWindow();
        if (sPrevDiffSetupDlg != null && sPrevDiffSetupDlg.getDb() == db && (orig == null && updated == null && sPrevDiffSetupDlg.getOrigDevice() != null && sPrevDiffSetupDlg.getOrigDevice().getDb() == db && sPrevDiffSetupDlg.getUpdatedDevice() != null && sPrevDiffSetupDlg.getUpdatedDevice().getDb() == db || sPrevDiffSetupDlg.getOrigDevice() == orig && sPrevDiffSetupDlg.getUpdatedDevice() == updated)) {
            dlg = sPrevDiffSetupDlg;
        } else {
            dlg = new DiffSetupDlg(db, appWin);
            dlg.setOrigDevice(orig);
            dlg.setUpdatedDevice(updated);
            sPrevDiffSetupDlg = dlg;
        }
        if (!dlg.doModal()) {
            return;
        }
        orig = dlg.getOrigDevice();
        updated = dlg.getUpdatedDevice();
        DTDiffMerge merger = dlg.getIsCompareTemplate() ? new DTDiffMerge(orig.getTemplate(), updated.getTemplate()) : new DTDiffMerge(orig, updated);
        if (!merger.compare()) {
            return;
        }
        if (dlg.getIgnoreCompressedHierarchy()) {
            merger.processHierarchyCompression();
        }
        DTDiffMergeUI.showUi(appWin, merger);
    }

    public static void showUi(Component owner, DTDiffMerge merger) {
        if (!merger.getDiffRun()) {
            merger.compare();
        }
        ALog.logInfo((String)"Preparing Diff UI...");
        InteractiveMergeUI dlg = new InteractiveMergeUI(owner, merger);
        dlg.setVisible(true);
        ALog.logInfo((String)"Diff UI is ready.");
    }

    public static void applyFilters(Collection<Compare.Diff<?>> all, Collection<Pattern> exclude, List<Compare.Diff<?>> filtered) {
        DTDiffMergeUI.applyFilters(all.iterator(), exclude, filtered);
    }

    public static void applyFilters(Iterator<Compare.Diff<?>> all, Collection<Pattern> exclude, List<Compare.Diff<?>> filtered) {
        filtered.clear();
        for (Compare.Diff d : AUtil.getIterable(all)) {
            if (DTDiffMergeUI.anyMatches(d.getDesc(), exclude)) continue;
            filtered.add(d);
        }
    }

    public static boolean anyMatches(String s, Collection<Pattern> patterns) {
        for (Pattern p : patterns) {
            if (!p.matcher(s).matches()) continue;
            return true;
        }
        return false;
    }

    public static class PatternEditDlg
    extends ADialog {
        protected JTextField mTxtPattern;
        protected boolean mUserOked = false;
        protected Pattern mPattern = null;

        public PatternEditDlg(Window owner, Pattern pattern) {
            super(owner);
            this.setTitle(pattern == null ? "Add Pattern" : "Edit Pattern");
            this.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
            this.mPattern = pattern;
            GridBagManager l = GridBagManager.layout((Container)this.getContentPane());
            JLabel lblPattern = l.add("Pattern:");
            this.mTxtPattern = (JTextField)l.add((Component)new JTextField(20), (GridBagConstraints)GridBagManager.FILLX);
            lblPattern.setLabelFor(this.mTxtPattern);
            l.add((Component)new APatternHelpButton(), (GridBagConstraints)GridBagManager.RIGHT);
            l.newline();
            l.pushFillXRemainX();
            l.addFillX();
            JButton btnOk = (JButton)l.add((Component)new JButton("OK"), (GridBagConstraints)GridBagManager.RIGHT);
            btnOk.addActionListener(e -> {
                try {
                    if (this.mTxtPattern.getText().trim().length() == 0) {
                        JOptionPane.showMessageDialog((Component)((Object)this), "No pattern specified.", "Invalid Entry", 0);
                        return;
                    }
                    this.mPattern = Pattern.compile(this.mTxtPattern.getText());
                }
                catch (PatternSyntaxException pse) {
                    String s = pse.getMessage();
                    JTextArea m = new JTextArea(s);
                    ((JComponent)m).setFont(new Font("Monospaced", 0, m.getFont().getSize()));
                    m.setFocusable(false);
                    m.setOpaque(false);
                    m.setBackground(new Color(0, 0, 0, 0));
                    JOptionPane.showMessageDialog((Component)((Object)this), m, "Invalid Entry", 0);
                    return;
                }
                this.mUserOked = true;
                UIUtil.closeWindow((Window)((Object)this));
            });
            JButton btnCancel = (JButton)l.add((Component)new JButton("Cancel"), (GridBagConstraints)GridBagManager.RIGHT);
            l.pop();
            UIUtil.enableEscCloseDefaultMinSize((JDialog)((Object)this), (AbstractButton)btnCancel, (JButton)btnOk);
            this.pack();
            this.setMinimumSize(this.getPreferredSize());
            UIUtil.center((Component)((Object)this));
            if (this.mPattern != null) {
                this.mTxtPattern.setText(this.mPattern.pattern());
            }
        }

        public boolean doModal() {
            this.setVisible(true);
            return this.mUserOked;
        }

        public Pattern getPattern() {
            return this.mPattern;
        }
    }

    public static class FilterSetupDlg
    extends ADialog {
        protected FilterSet mInitialFilters;
        protected AList<Pattern> mLstPatterns;
        protected JButton mBtnOk;
        protected JButton mBtnCancel;
        protected AListModel<Pattern> mPatterns;
        protected boolean mUserOked = false;
        protected ActionListener mOK = e -> {
            this.mUserOked = true;
            UIUtil.closeWindow((Window)((Object)this));
        };
        protected Action mAdd = new AbstractAction("Add..."){

            @Override
            public void actionPerformed(ActionEvent e) {
                PatternEditDlg d = new PatternEditDlg((Window)((Object)this), null);
                if (d.doModal()) {
                    mPatterns.addItem(d.getPattern());
                    this.enableControls();
                }
            }
        };
        protected Action mEdit = new AbstractAction("Edit..."){

            @Override
            public void actionPerformed(ActionEvent e) {
                int idx = mLstPatterns.getSelectedIndex();
                if (idx < 0) {
                    return;
                }
                Pattern p = mPatterns.getElementAt(idx);
                PatternEditDlg d = new PatternEditDlg((Window)((Object)this), p);
                if (d.doModal()) {
                    mPatterns.setItemAt(idx, d.getPattern());
                    this.enableControls();
                }
            }
        };
        protected Action mDelete = new AbstractAction("Delete"){

            @Override
            public void actionPerformed(ActionEvent e) {
                int i = mLstPatterns.getSelectedIndex();
                if (i < 0) {
                    return;
                }
                mPatterns.removeItem(i);
                this.enableControls();
            }
        };
        protected Action mClear = new AbstractAction("Clear"){

            @Override
            public void actionPerformed(ActionEvent e) {
                String msg = "Do you want to delete all filter patterns?";
                if (0 != JOptionPane.showConfirmDialog((Component)((Object)this), msg, "Confirm Clear", 0)) {
                    return;
                }
                mPatterns.clear();
            }
        };
        protected Action mSave = new AbstractAction("Save..."){

            @Override
            public void actionPerformed(ActionEvent e) {
                AFileChooser fc = new AFileChooser();
                fc.setFileFilter((FileFilter)FF_TEXTFILE);
                if (0 != fc.showSaveDialog((Component)((Object)this))) {
                    return;
                }
                File file = fc.getSelectedFile();
                try (PrintWriter out = new PrintWriter(file);){
                    for (Pattern p : mPatterns.getList()) {
                        out.println(p.pattern());
                    }
                }
                catch (Exception ex) {
                    ALog.logError((Throwable)ex, (String)"Error writing file '%s'.", (Object[])new Object[]{file.toString()});
                    JOptionPane.showMessageDialog((Component)((Object)this), ex.getMessage(), "Error Writing File", 0);
                }
            }
        };
        protected Action mLoad = new AbstractAction("Load..."){

            @Override
            public void actionPerformed(ActionEvent e) {
                String msg;
                AFileChooser fc = new AFileChooser();
                fc.setFileFilter((FileFilter)FF_TEXTFILE);
                if (0 != fc.showOpenDialog((Component)((Object)this))) {
                    return;
                }
                File file = fc.getSelectedFile();
                long lines = FileLineCounter.countLines((File)file);
                if (lines > 10L && 0 != JOptionPane.showConfirmDialog((Component)((Object)this), msg = String.format("The file '%s' contains %d lines, are you sure you want to read each line as an exclusion pattern?", file.getPath(), lines), "Confirm Read", 0)) {
                    return;
                }
                try (LineNumberReader reader = new LineNumberReader(new FileReader(file));){
                    String s = reader.readLine();
                    while (s != null) {
                        if (!s.isEmpty() && s.trim().length() != 0) {
                            this.addPattern(file, reader, s);
                        }
                        s = reader.readLine();
                    }
                }
                catch (Exception ex) {
                    ALog.logError((Throwable)ex, (String)"Error reading file '%s'.", (Object[])new Object[]{file.toString()});
                    JOptionPane.showMessageDialog((Component)((Object)this), ex.getMessage(), "Error Reading File", 0);
                }
            }

            private void addPattern(File file, LineNumberReader reader, String s) {
                try {
                    mPatterns.addItem(Pattern.compile(s));
                }
                catch (PatternSyntaxException pse) {
                    ALog.logError((String)"Pattern syntax error on line %d of file '%s'.\n%s", (Object[])new Object[]{reader.getLineNumber(), file.getPath(), pse.getMessage()});
                }
            }
        };

        public FilterSetupDlg(Component owner, FilterSet initialFilters) {
            super(owner);
            this.setTitle("Exclude Filters");
            this.mInitialFilters = initialFilters;
            GridBagManager l = GridBagManager.layout((Container)this.getContentPane());
            l.add("Exclude differences matching:");
            l.newline();
            this.mPatterns = new AListModel();
            this.mLstPatterns = new AList<Pattern>((ListModel<Pattern>)this.mPatterns);
            this.mLstPatterns.setSelectionMode(0);
            this.mLstPatterns.addListSelectionListener(e -> this.enableControls());
            JScrollPane spPatterns = new JScrollPane(this.mLstPatterns);
            spPatterns.setPreferredSize(new Dimension(100, 200));
            l.add((Component)spPatterns, (GridBagConstraints)GridBagManager.FILLALL);
            l.newline();
            l.pushFillX();
            Insets noMargins = new Insets(0, 0, 0, 0);
            ((JButton)l.add((Component)new JButton(this.mAdd))).setMargin(noMargins);
            ((JButton)l.add((Component)new JButton(this.mEdit))).setMargin(noMargins);
            ((JButton)l.add((Component)new JButton(this.mDelete))).setMargin(noMargins);
            l.addFillX(12);
            ((JButton)l.add((Component)new JButton(this.mClear))).setMargin(noMargins);
            l.addFillX(12);
            JButton btnSave = (JButton)l.add((Component)new JButton(this.mSave));
            btnSave.setMargin(noMargins);
            Font btnFont = btnSave.getFont();
            float littleSize = (float)btnFont.getSize() - 2.0f;
            Font littleBtnFont = btnFont.deriveFont(littleSize);
            btnSave.setFont(littleBtnFont);
            JButton btnLoad = (JButton)l.add((Component)new JButton(this.mLoad));
            btnLoad.setMargin(noMargins);
            btnLoad.setFont(littleBtnFont);
            l.popNl();
            l.pushFillXRemainX();
            l.addFillX();
            this.mBtnOk = (JButton)l.add((Component)new JButton("OK"), (GridBagConstraints)GridBagManager.RIGHT);
            this.mBtnOk.addActionListener(this.mOK);
            JButton btnCancel = (JButton)l.add((Component)new JButton("Cancel"), (GridBagConstraints)GridBagManager.RIGHT);
            l.pop();
            UIUtil.enableEscCloseDefaultMinSize((JDialog)((Object)this), (AbstractButton)btnCancel, (JButton)this.mBtnOk);
            this.pack();
            this.setMinimumSize(this.getPreferredSize());
            UIUtil.center((Component)((Object)this));
            this.mPatterns.setContents(this.mInitialFilters.getAll());
            this.enableControls();
        }

        public boolean doModal() {
            this.setModal(true);
            this.setVisible(true);
            return this.mUserOked;
        }

        public List<Pattern> getFilters() {
            return this.mPatterns.getList();
        }

        protected void enableControls() {
            this.mBtnOk.setEnabled(true);
            boolean patternSelected = this.mLstPatterns.getSelectedIndex() >= 0;
            this.mEdit.setEnabled(patternSelected);
            this.mDelete.setEnabled(patternSelected);
        }
    }

    public static class DiffSetupDlg
    extends DbDialog {
        protected DeviceChooser.DCComponent mDTOrig;
        protected DeviceChooser.DCComponent mDTUpdated;
        private CompareLevelPanel mCompareLevelPanel;
        private OptionsPanel mOptionsPanel;
        protected JButton mBtnOk;
        protected JLabel mStatus;
        protected APair<String, String> mUserTemplateFilter = null;
        protected boolean mUserOked = false;
        protected ActionListener mOK = e -> {
            this.mUserOked = true;
            UIUtil.closeWindow((Window)((Object)this));
        };
        protected DeviceChooser.DCComponent.UpdateListener mChooserUpdateListener = new DeviceChooser.DCComponent.UpdateListener(){

            @Override
            public void initBrowse(DeviceChooser.DCComponent dtc) {
                if (mUserTemplateFilter != null) {
                    dtc.setUserFilter(mUserTemplateFilter);
                }
            }

            @Override
            public void deviceUpdated(DeviceChooser.DCComponent dtc) {
                mUserTemplateFilter = dtc.getUserFilter();
                this.enableControls();
            }
        };

        public DiffSetupDlg(Db db, Component owner) {
            super(db, owner);
            this.setTitle("Compare and Merge Devices");
            GridBagManager l = GridBagManager.layout((Container)this.getContentPane());
            l.add("Original:");
            this.mDTOrig = (DeviceChooser.DCComponent)l.add((Component)new DeviceChooser.DCComponent(db), (GridBagConstraints)GridBagManager.FILLX);
            this.mDTOrig.addUpdateListener(this.mChooserUpdateListener);
            l.newline();
            l.add("Updated:");
            this.mDTUpdated = (DeviceChooser.DCComponent)l.add((Component)new DeviceChooser.DCComponent(db), (GridBagConstraints)GridBagManager.FILLX);
            this.mDTUpdated.addUpdateListener(this.mChooserUpdateListener);
            l.newline();
            l.push("Compare", (GridBagConstraints)GridBagManager.FILLALL);
            this.mCompareLevelPanel = (CompareLevelPanel)l.add((Component)new CompareLevelPanel(), (GridBagConstraints)GridBagManager.FILLALL);
            this.mCompareLevelPanel.setToolTipText("Compare the device templates.  Ignore differences in instance level.");
            l.pop();
            l.push("Options", (GridBagConstraints)GridBagManager.FILLALL_REMAINX);
            this.mOptionsPanel = (OptionsPanel)l.add((Component)new OptionsPanel(), (GridBagConstraints)GridBagManager.FILLALL);
            this.mOptionsPanel.setToolTipText("Ignore differences where device hierarchy has been replaced by pins");
            l.pop();
            l.newline();
            l.pushFillXRemainX();
            this.mStatus = (JLabel)l.add((Component)new JLabel(), (GridBagConstraints)GridBagManager.FILLX);
            this.mBtnOk = (JButton)l.add((Component)new JButton("Compare"), (GridBagConstraints)GridBagManager.RIGHT);
            this.mBtnOk.addActionListener(this.mOK);
            JButton btnCancel = (JButton)l.add((Component)new JButton("Cancel"), (GridBagConstraints)GridBagManager.RIGHT);
            l.pop();
            UIUtil.enableEscCloseDefaultMinSize((JDialog)((Object)this), (AbstractButton)btnCancel, (JButton)this.mBtnOk);
            this.pack();
            UIUtil.center((Component)((Object)this));
            this.enableControls();
        }

        public void setOrigDevice(Device t) {
            this.mDTOrig.setDevice(t);
        }

        public Device getOrigDevice() {
            return this.mDTOrig.getDevice();
        }

        public void setUpdatedDevice(Device t) {
            this.mDTUpdated.setDevice(t);
        }

        public Device getUpdatedDevice() {
            return this.mDTUpdated.getDevice();
        }

        protected boolean getIsCompareTemplate() {
            return this.mCompareLevelPanel.isCompareTemplate();
        }

        public boolean getIgnoreCompressedHierarchy() {
            return this.mOptionsPanel.isIgnorecompressedhieararchy();
        }

        public boolean doModal() {
            this.setModal(true);
            this.setVisible(true);
            return this.mUserOked;
        }

        public void addNotify() {
            super.addNotify();
            this.mUserOked = false;
        }

        protected void enableControls() {
            boolean enable = this.mDTOrig.getDevice() != null && this.mDTUpdated.getDevice() != null;
            this.mBtnOk.setEnabled(enable);
        }

        protected static class OptionsPanel
        extends JPanel {
            protected JCheckBox mCbIgnoreCompressedHierarchy;

            public OptionsPanel() {
                GridBagManager l = new GridBagManager((Container)this);
                this.mCbIgnoreCompressedHierarchy = (JCheckBox)l.add((Component)new JCheckBox("Ignore compressed hieararchy"), (GridBagConstraints)GridBagManager.LEFT_REMAINX);
                this.mCbIgnoreCompressedHierarchy.setToolTipText("Ignore differences where device hierarchy has been replaced by pins");
                l.newline();
                l.addFillX();
                l.addFillY();
                this.setMinimumSize(this.getPreferredSize());
            }

            public boolean isIgnorecompressedhieararchy() {
                return this.mCbIgnoreCompressedHierarchy.isSelected();
            }
        }

        protected static class CompareLevelPanel
        extends JPanel {
            protected AButtonGroup mBgCompareLevel = new AButtonGroup();
            protected JRadioButton devTButton;
            protected JRadioButton devInstButton;

            public CompareLevelPanel() {
                GridBagManager l = new GridBagManager((Container)this);
                this.devInstButton = new JRadioButton("Instance");
                this.devInstButton.setToolTipText("Compate the device instances");
                this.devInstButton.setSelected(true);
                l.add((Component)this.devInstButton, (GridBagConstraints)GridBagManager.LEFT.insets(0));
                l.newline();
                this.devTButton = new JRadioButton("Template");
                this.devTButton.setToolTipText("Compare the device templates");
                this.devTButton.setSelected(true);
                l.add((Component)this.devTButton, (GridBagConstraints)GridBagManager.LEFT.insets(0));
                l.newline();
                this.mBgCompareLevel.add(this.devInstButton);
                this.mBgCompareLevel.add(this.devTButton);
                l.addFillX();
                l.addFillY();
                this.setMinimumSize(this.getPreferredSize());
            }

            public boolean isCompareTemplate() {
                return this.devTButton.isSelected();
            }
        }
    }

    protected static class FilterSet {
        protected LinkedList<Pattern> mPatterns = new LinkedList();
        protected long mLastModified = 0L;

        protected FilterSet() {
        }

        public long getLastModified() {
            return this.mLastModified;
        }

        public void clear() {
            this.mPatterns.clear();
            this.updated();
        }

        public void addAll(Collection<? extends Pattern> patterns) {
            this.mPatterns.addAll(patterns);
            this.updated();
        }

        public int size() {
            return this.mPatterns.size();
        }

        public Collection<Pattern> getAll() {
            return this.mPatterns;
        }

        protected void updated() {
            this.mLastModified = new Date().getTime();
        }
    }
}

