/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.diff_merge.ui;

import com.sigrity.acl.ALog;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.jfxui.AJFXDesignDialog;
import com.sigrity.acl.jfxui.AJFXPanel;
import com.sigrity.acl.jfxui.OkCancelHBox;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.orbit.DeviceFilters;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.diff_merge.FileDiffMerger;
import com.sigrity.orbit.diff_merge.ui.FileInteractiveMergeUI;
import com.sigrity.orbit.jfxui.DevicePathCheckBoxTreeChooser;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Set;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Label;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javax.swing.SwingUtilities;

public class FileDiffMergeOptionUI
extends AJFXDesignDialog {
    private static final String TITLE = "Compare/Merge";
    private boolean mIsCloseNormal = false;
    private final FileDiffMerger mMerger;
    private FileDiffMergeOptionPanel mDiffMergeOptionPanel;

    public static FileDiffMergeOptionUI createDialog(Window owner, FileDiffMerger merger) {
        if (merger == null) {
            assert (false);
            return null;
        }
        FileDiffMergeOptionUI dlg = new FileDiffMergeOptionUI(owner, merger);
        dlg.setVisible(true);
        return dlg;
    }

    protected FileDiffMergeOptionUI(Window owner, final FileDiffMerger merger) {
        super(merger.getOrigDb(), (Component)owner, TITLE, Dialog.ModalityType.APPLICATION_MODAL);
        this.mMerger = merger;
        this.init();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                if (FileDiffMergeOptionUI.this.mIsCloseNormal) {
                    return;
                }
                FileDiffMergeOptionUI.this.mMerger.cleanupPostMerge();
                OrbitIO.refreshViewsOf(merger.getOrigDb());
            }
        });
    }

    protected FileDiffMerger getMerger() {
        return this.mMerger;
    }

    protected Set<Device> getSelectedDevices() {
        return this.mDiffMergeOptionPanel.getSelectedDevices();
    }

    protected boolean isRootSelected() {
        return this.mDiffMergeOptionPanel.isRootSelected();
    }

    protected AJFXPanel createJfxPanel() {
        this.mDiffMergeOptionPanel = new FileDiffMergeOptionPanel();
        return this.mDiffMergeOptionPanel;
    }

    private class FileDiffMergeOptionPanel
    extends AJFXPanel {
        private static final int PANEL_WIDTH = 300;
        private static final int PANEL_HEIGHT = 400;
        private DevicePathCheckBoxTreeChooser mDevicePathCheckBoxTreeView;
        EventHandler<ActionEvent> mOkHandler = e -> SwingUtilities.invokeLater(() -> {
            FileDiffMergeOptionUI.this.mIsCloseNormal = true;
            UIUtil.closeWindow((Window)((Object)FileDiffMergeOptionUI.this));
            FileDiffMergeOptionUI.this.mMerger.setIsCompareRootDeviceTemplate(this.mDevicePathCheckBoxTreeView.isRootSelected());
            FileDiffMergeOptionUI.this.mMerger.setTargetDevices(this.mDevicePathCheckBoxTreeView.getSelectedDevices());
            if (FileDiffMergeOptionUI.this.mMerger.compare()) {
                ALog.flogInfo((String)"Compare complete.", (Object[])new Object[0]);
                FileInteractiveMergeUI.showUI(FileDiffMergeOptionUI.this.getOwner(), FileDiffMergeOptionUI.this.mMerger);
            } else {
                ALog.flogError((String)"Compare failed.", (Object[])new Object[0]);
            }
        });

        public FileDiffMergeOptionPanel() {
            this.setPreferredSize(new Dimension(300, 400));
        }

        protected Parent initSceneGraph() {
            VBox pane = new VBox(5.0);
            Label targetLabel = new Label("Target:");
            VBox.setVgrow((Node)targetLabel, (Priority)Priority.NEVER);
            pane.getChildren().add((Object)targetLabel);
            this.mDevicePathCheckBoxTreeView = new DevicePathCheckBoxTreeChooser(new DevicePath(FileDiffMergeOptionUI.this.mMerger.getOriginalTemplate()), DeviceFilters.FILTER_NONPIN);
            this.mDevicePathCheckBoxTreeView.setExpanded(false);
            VBox.setVgrow((Node)this.mDevicePathCheckBoxTreeView, (Priority)Priority.ALWAYS);
            pane.getChildren().add((Object)this.mDevicePathCheckBoxTreeView);
            OkCancelHBox okCancelHBox = new OkCancelHBox((Window)((Object)FileDiffMergeOptionUI.this), this.mOkHandler);
            pane.getChildren().add((Object)okCancelHBox);
            return pane;
        }

        private Set<Device> getSelectedDevices() {
            return this.mDevicePathCheckBoxTreeView.getSelectedDevices();
        }

        private boolean isRootSelected() {
            return this.mDevicePathCheckBoxTreeView.isRootSelected();
        }
    }
}

