/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.diff_merge.ui;

import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.diff_merge.FileDiffMerger;
import com.sigrity.orbit.diff_merge.ui.InteractiveMergeUI;
import java.awt.Component;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JOptionPane;

public class FileInteractiveMergeUI
extends InteractiveMergeUI {
    public static void showUI(Component owner, FileDiffMerger merger) {
        if (merger.getDiffs().isEmpty()) {
            JOptionPane.showMessageDialog(owner, "No differences found.", "Compare", 1);
            merger.cleanupPostMerge();
            OrbitIO.refreshViewsOf(merger.getOrigDb());
        } else {
            new FileInteractiveMergeUI(owner, merger).setVisible(true);
        }
    }

    public FileInteractiveMergeUI(Component owner, final FileDiffMerger merger) {
        super(owner, merger);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                merger.cleanupPostMerge();
                OrbitIO.refreshViewsOf(merger.getOrigDb());
            }
        });
    }

    @Override
    protected void verifyCloseUI() {
        int resp = JOptionPane.showConfirmDialog((Component)((Object)this), "Complete merge?\nAny remaining changes will be discarded.", "Confirm Close", 2, 3);
        if (resp == 0) {
            this.setDefaultCloseOperation(2);
        } else {
            this.setDefaultCloseOperation(0);
        }
    }
}

