/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.diff_merge.ui;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.sigrity.acl.AColor;
import com.sigrity.acl.AEmptyItr;
import com.sigrity.acl.ALog;
import com.sigrity.acl.AUtil;
import com.sigrity.acl.IterableIterator;
import com.sigrity.acl.MutableBoolean;
import com.sigrity.acl.ProcessingIterator;
import com.sigrity.acl.StreamIterableIterator;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbCompare;
import com.sigrity.acl.db.DbHistory;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.ui.AButton;
import com.sigrity.acl.ui.AColorIcon;
import com.sigrity.acl.ui.AComponentTitledBorder;
import com.sigrity.acl.ui.ADecoratedIcon;
import com.sigrity.acl.ui.AFileChooser;
import com.sigrity.acl.ui.ASplitPane;
import com.sigrity.acl.ui.ATwoIcon;
import com.sigrity.acl.ui.DbDialog;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.acl.ui.atree.ALazyTreeNode;
import com.sigrity.acl.ui.atree.ATree;
import com.sigrity.acl.ui.atree.ATreeModel;
import com.sigrity.acl.ui.atree.ATreeNode;
import com.sigrity.orbit.OrbitApp;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.automation.contact_sync.ContactNetSyncEngine;
import com.sigrity.orbit.automation.contact_sync.ContactObjectSyncEngine;
import com.sigrity.orbit.diff_merge.Compare;
import com.sigrity.orbit.diff_merge.CompareDevice;
import com.sigrity.orbit.diff_merge.CompareDeviceTemplate;
import com.sigrity.orbit.diff_merge.ComparePinTemplate;
import com.sigrity.orbit.diff_merge.DTDiffMerge;
import com.sigrity.orbit.diff_merge.ui.DTDiffMergeUI;
import com.sigrity.orbit.ui.OrbitIcons;
import com.sigrity.tools.dbexplorer.DBEResources;
import com.sigrity.tools.dbexplorer.DbExplorerPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableModel;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class InteractiveMergeUI
extends DbDialog {
    protected static final String CURDIFF_TITLE = "Current Difference";
    private static final Icon ICON_NEXT = OrbitIcons.DOWN;
    private static final Icon ICON_ACCEPT = OrbitIcons.CHECK;
    public static final Icon ICON_BASE = new AColorIcon(16, 16, (Color)AColor.withAlpha((Color)Color.WHITE, (int)0), null);
    public static final Icon ICON_BELOW = OrbitIcons.ICON_BELOW;
    public static final Icon DECOR_NORMAL = new AColorIcon(9, 9, (Color)AColor.withAlpha((Color)Color.GRAY, (int)0), null);
    public static final Icon DECOR_ADDED = OrbitIcons.DECOR_ADDED;
    public static final Icon DECOR_MODIFIED = OrbitIcons.DECOR_MODIFIED;
    public static final Icon DECOR_DELETED = OrbitIcons.DECOR_DELETED;
    public static final Icon ICON_DIFF = UIUtil.ICON_INFO;
    public static final Icon ICON_MERGABLE = UIUtil.ICON_WARN;
    private ContactNetSyncEngine mContactNetSyncEngine;
    private ContactObjectSyncEngine mContactObjectSyncEngine;
    protected DTDiffMerge mMerger;
    protected DiffTree mDiffTree;
    protected DiffTreeModel mDiffTreeModel;
    protected ASplitPane mSplitListAndTree;
    protected DiffTable mDiffTable;
    protected ASplitPane mSplitCurDiff;
    protected JTextPane mCurDiffDisplay;
    protected DTDiffMergeUI.FilterSet mExcludeFilters = new DTDiffMergeUI.FilterSet();
    protected JButton mBtnNext;
    protected JButton mBtnAccept;
    protected JButton mBtnAcceptSel;
    protected JButton mBtnAcceptAll;
    protected JButton mBtnFilter;
    protected JLabel mLblFilterStatus;
    protected AbstractAction mNext = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            InteractiveMergeUI.this.gotoNextDiff(true);
        }
    };
    protected AbstractAction mAccept = new AbstractAction("Accpet"){

        @Override
        public void actionPerformed(ActionEvent e) {
            InteractiveMergeUI.this.acceptCurDiff(true);
            InteractiveMergeUI.this.removeDiffComplete();
        }
    };
    protected AbstractAction mAcceptSel = new AbstractAction("Accpet selected"){

        @Override
        public void actionPerformed(ActionEvent e) {
            try (OrbitApp.ChangeWarningSilencer cm = OrbitApp.suppressDbChangeMonitorWarnings();
                 DbHistory.DbTransaction trans = DbHistory.newDbTransaction((Db)InteractiveMergeUI.this.getDb(), (String)"Merge selected diffs");){
                int idx = InteractiveMergeUI.this.mDiffTable.getSelectedRow();
                while (idx >= 0) {
                    Compare.Diff<?> diff = InteractiveMergeUI.this.mDiffTable.getDiffTableModel().getElementAt(idx);
                    if (diff instanceof Compare.Mergeable) {
                        Compare.Mergeable m = (Compare.Mergeable)diff;
                        InteractiveMergeUI.this.addContactSyncObject(m);
                        boolean merged = m.merge();
                        if (!merged) {
                            InteractiveMergeUI.this.emitMergeError(m);
                            break;
                        }
                    }
                    InteractiveMergeUI.this.mDiffTable.getDiffTableModel().removeElement(idx);
                    idx = InteractiveMergeUI.this.mDiffTable.getSelectedRow();
                }
            }
            InteractiveMergeUI.this.removeDiffComplete();
            InteractiveMergeUI.this.refreshDesignView();
            InteractiveMergeUI.this.mNext.actionPerformed(e);
        }
    };
    protected AbstractAction mAcceptAll = new AbstractAction("Accpet all"){

        @Override
        public void actionPerformed(ActionEvent e) {
            List<Compare.Diff<?>> diffs = InteractiveMergeUI.this.mDiffTreeModel.getDiffs();
            long count = diffs.size();
            String qry = String.format("Are you sure you want to accept and merge all %d changes?", count);
            int resp = JOptionPane.showConfirmDialog((Component)((Object)InteractiveMergeUI.this), qry, "Confirm Accept All", 0, 3);
            if (resp != 0) {
                return;
            }
            String txnName = String.format("[Compare/Merge Device] Accept %d changes", count);
            int actualCount = 0;
            try (DbHistory.DbTransaction trans = DbHistory.newDbTransaction((Db)InteractiveMergeUI.this.getDb(), (String)txnName);){
                for (Compare.Diff<?> diffToAccept : diffs) {
                    boolean isAccept = InteractiveMergeUI.this.acceptDiff(diffToAccept, false);
                    if (!isAccept) {
                        String msg = String.format("<html><p>Unable to merge difference, aborting merge of all differences. Some changes may have been merged and the data may be in a partially updated state.</p><p>The failed merge was:</p><p style='padding-left:8px;font-style:italic'>%s</p>", diffToAccept);
                        OrbitIO.logAndDisplayWarningDialog((String)msg, (String)"Merge Problem");
                        break;
                    }
                    ++actualCount;
                }
            }
            ALog.logInfo((String)"Accept %d of %d changes. DONE ...", (Object[])new Object[]{actualCount, count});
            InteractiveMergeUI.this.removeDiffComplete();
        }
    };
    protected AbstractAction mSetupFilterAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            DTDiffMergeUI.FilterSetupDlg dlg = new DTDiffMergeUI.FilterSetupDlg((Component)((Object)InteractiveMergeUI.this), InteractiveMergeUI.this.mExcludeFilters);
            if (dlg.doModal()) {
                InteractiveMergeUI.this.mExcludeFilters.clear();
                InteractiveMergeUI.this.mExcludeFilters.addAll(dlg.getFilters());
                InteractiveMergeUI.this.mLblFilterStatus.setText(InteractiveMergeUI.this.mExcludeFilters.size() == 0 ? "" : "Filtered");
                InteractiveMergeUI.this.updateFilteredData();
            }
        }
    };
    protected Action mWrite = new AbstractAction("Write..."){
        {
            this.putValue("ShortDescription", "Save differences to a file; filters are applied if active");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AFileChooser fc = new AFileChooser();
            fc.setFileFilter((FileFilter)DTDiffMergeUI.FF_TEXTFILE);
            if (0 == fc.showSaveDialog((Component)((Object)InteractiveMergeUI.this))) {
                File file = fc.getSelectedFile();
                try (PrintWriter out = new PrintWriter(file);){
                    LinkedList filtered = new LinkedList();
                    DTDiffMergeUI.applyFilters(InteractiveMergeUI.this.mMerger.getDiffs().iterator(), InteractiveMergeUI.this.mExcludeFilters.getAll(), filtered);
                    for (Compare.Diff diff : filtered) {
                        out.println(diff.getDesc());
                    }
                }
                catch (Exception ex) {
                    ALog.logError((Throwable)ex, (String)"Error writing file '%s'.", (Object[])new Object[]{file.toString()});
                    JOptionPane.showMessageDialog((Component)((Object)InteractiveMergeUI.this), ex.getMessage(), "Error Writing File", 0);
                }
            }
        }
    };

    public InteractiveMergeUI(Component owner, DTDiffMerge merger) {
        super(merger.getOrigDb(), owner);
        this.mMerger = merger;
        this.mContactNetSyncEngine = new ContactNetSyncEngine(this.mDb);
        this.mContactNetSyncEngine.setIsVerifySync(true);
        this.mContactObjectSyncEngine = new ContactObjectSyncEngine(this.mDb);
        String title = this.mMerger.getCompareDesc();
        this.setTitle(title);
        this.setIconImage(UIUtil.getAwtImage((Icon)OrbitIcons.DIFF));
        GridBagManager l = GridBagManager.layout((Container)this.getContentPane());
        this.mSplitCurDiff = (ASplitPane)l.add((Component)new ASplitPane(0, true), (GridBagConstraints)GridBagManager.FILLALL_REMAINX);
        this.mSplitListAndTree = new ASplitPane(1, true);
        this.mSplitCurDiff.setTopComponent(this.mSplitListAndTree);
        this.mDiffTreeModel = new DiffTypeTreeModel();
        this.mDiffTree = new DiffTree(this.mDiffTreeModel);
        this.mDiffTreeModel.initTree(this.mDiffTree);
        this.mDiffTree.getSelectionModel().setSelectionMode(1);
        this.mSplitListAndTree.setLeftComponent(new JScrollPane((Component)((Object)this.mDiffTree)));
        this.setDiffTable(new DiffTable(null));
        this.mCurDiffDisplay = new JTextPane();
        this.mCurDiffDisplay.setBorder(BorderFactory.createTitledBorder(CURDIFF_TITLE));
        HTMLEditorKit ek = new HTMLEditorKit();
        URL uSS = ((Object)((Object)this)).getClass().getResource("./res/DTDiffMergeUI.css");
        if (uSS != null) {
            try (InputStreamReader reader = new InputStreamReader(uSS.openStream());){
                StyleSheet ss = new StyleSheet();
                ss.loadRules(reader, uSS);
                ek.setStyleSheet(ss);
            }
            catch (IOException e) {
                ALog.logDebug((Throwable)e, (String)"Reading CSS failed.", (Object[])new Object[0]);
            }
        }
        this.mCurDiffDisplay.setEditorKit(ek);
        this.mCurDiffDisplay.setEditable(false);
        this.mCurDiffDisplay.setOpaque(false);
        this.mCurDiffDisplay.setBackground(new Color(0, 0, 0, 0));
        this.mSplitCurDiff.setBottomComponent(this.mCurDiffDisplay);
        l.newline();
        l.push((GridBagConstraints)GridBagManager.FILLX.noInsets());
        this.mBtnNext = (JButton)l.add((Component)new AButton("Next", ICON_NEXT, "Next Difference"), (GridBagConstraints)GridBagManager.LEFT);
        this.mBtnNext.addActionListener(this.mNext);
        this.mBtnNext.getInputMap(2).put(KeyStroke.getKeyStroke("alt N"), "nextDiff");
        this.mBtnNext.getActionMap().put("nextDiff", this.mNext);
        this.mBtnAccept = (JButton)l.add((Component)new AButton("Accept", ICON_ACCEPT), (GridBagConstraints)GridBagManager.LEFT);
        this.mBtnAccept.addActionListener(this.mAccept);
        this.mBtnAccept.getInputMap(2).put(KeyStroke.getKeyStroke("alt A"), "acceptDiff");
        this.mBtnAccept.getActionMap().put("acceptDiff", this.mAccept);
        this.mBtnAcceptSel = (JButton)l.add((Component)new AButton(), (GridBagConstraints)GridBagManager.LEFT);
        this.mBtnAcceptSel.addActionListener(this.mAcceptSel);
        this.updateAcceptSelButton(0);
        this.mBtnAcceptAll = (JButton)l.add((Component)new AButton("Accept All"), (GridBagConstraints)GridBagManager.LEFT);
        this.mBtnAcceptAll.addActionListener(this.mAcceptAll);
        this.mBtnFilter = new JButton("Filter...");
        this.mBtnFilter.setToolTipText("Apply filters to limit the displayed differences");
        this.mBtnFilter.addActionListener(this.mSetupFilterAction);
        l.add((Component)this.mBtnFilter, (GridBagConstraints)GridBagManager.LEFT);
        this.mLblFilterStatus = (JLabel)l.add((Component)new JLabel(), (GridBagConstraints)GridBagManager.FILLX);
        l.addFillX();
        l.add((Component)new JButton(this.mWrite));
        JButton btnClose = (JButton)l.add((Component)new JButton("Done"));
        l.pop();
        UIUtil.enableEscCloseMinSize((Window)((Object)this), (AbstractButton)btnClose);
        UIUtil.expandTreeLevels((JTree)((Object)this.mDiffTree), (int)1);
        this.updateSelectedDiffs();
        this.pack();
        UIUtil.center((Component)((Object)this));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (InteractiveMergeUI.this.dialogDbClosed()) {
                    InteractiveMergeUI.this.setDefaultCloseOperation(2);
                } else {
                    InteractiveMergeUI.this.verifyCloseUI();
                }
            }

            @Override
            public void windowClosed(WindowEvent e) {
                try (OrbitApp.ChangeWarningSilencer cm = OrbitApp.suppressDbChangeMonitorWarnings();
                     DbHistory.DbTransaction trans = DbHistory.newDbTransaction((Db)InteractiveMergeUI.this.getDb(), (String)"Sync contact nets");){
                    InteractiveMergeUI.this.mContactObjectSyncEngine.execute();
                    InteractiveMergeUI.this.mContactNetSyncEngine.execute();
                }
                InteractiveMergeUI.this.refreshDesignView();
            }
        });
    }

    public Db getDb() {
        return this.mMerger.getOriginalTemplate().getDb();
    }

    public DiffTable getDiffList() {
        return this.mDiffTable;
    }

    public void setDiffTable(DiffTable dl) {
        JScrollPane sp = new JScrollPane(dl);
        int oldLoc = this.mSplitListAndTree.getDividerLocation();
        this.mSplitListAndTree.setRightComponent(sp);
        this.mSplitListAndTree.setDividerLocation(oldLoc);
        this.mDiffTable = dl;
        this.updateSelectedDiffs();
    }

    public void updateSelectedDiffs() {
        if (this.mCurDiffDisplay == null) {
            return;
        }
        List<Compare.Diff<?>> diffs = this.getSelectedDiffs();
        if (diffs.size() == 1) {
            Compare.Diff<?> d = diffs.get(0);
            String s = this.getDiffHTML(d);
            this.mCurDiffDisplay.setText(s);
            JLabel lbl = new JLabel(CURDIFF_TITLE);
            lbl.setOpaque(true);
            lbl.setIcon(this.getDiffIcon(d));
            AComponentTitledBorder b = new AComponentTitledBorder(lbl, this.mCurDiffDisplay);
            this.mCurDiffDisplay.setBorder(b);
            for (HyperlinkListener hl : this.mCurDiffDisplay.getHyperlinkListeners()) {
                this.mCurDiffDisplay.removeHyperlinkListener(hl);
            }
            this.mCurDiffDisplay.addHyperlinkListener(e -> {
                if (e.getEventType() != HyperlinkEvent.EventType.ACTIVATED) {
                    return;
                }
                URL url = e.getURL();
                if (url.getHost().equals("action")) {
                    String actionName = url.getPath().substring(1);
                    this.doDiffAction(d, actionName, e.getDescription());
                }
            });
            if (d instanceof Compare.Mergeable) {
                this.updateAcceptButton(true, "Merge", "Merge the change");
            } else {
                this.updateAcceptButton(true, "Acknowledge", "MergeAcknowledge the change");
            }
        } else {
            this.updateAcceptButton(false, "Accept", null);
            this.mCurDiffDisplay.setText("<br><br><br>");
            this.mCurDiffDisplay.setBorder(BorderFactory.createTitledBorder(CURDIFF_TITLE));
        }
        this.updateAcceptSelButton(diffs.size());
        this.mBtnAcceptAll.setEnabled(this.mDiffTreeModel.hasDiff());
    }

    protected void updateAcceptSelButton(int selCount) {
        this.mBtnAcceptSel.setEnabled(selCount > 1);
        this.mBtnAcceptSel.setText(String.format("Accept%s Selected", selCount > 1 ? " " + selCount : ""));
    }

    protected void updateAcceptButton(boolean enabled, String text, String tip) {
        this.mBtnAccept.setEnabled(enabled);
        if (this.mBtnAccept.getText() != null && !this.mBtnAccept.getText().isEmpty()) {
            this.mBtnAccept.setText(text);
        }
        this.mBtnAccept.setToolTipText(tip);
    }

    protected String getDiffHTML(Compare.Diff<?> d) {
        Color c = UIManager.getColor("Label.foreground");
        StringBuilder html = new StringBuilder(String.format("<font color='%s'>%s</font>", AColor.formatColor((Color)c), d.getDesc()));
        html.append("<div id='actions'>");
        for (Action a : d.getActions()) {
            html.append(String.format("<a class='ActionLink' href='http://action/%s'>%s</a> ", a.getValue("Name"), a.getValue("Name")));
        }
        html.append("</div>");
        return html.toString();
    }

    protected boolean doDiffAction(Compare.Diff<?> d, String actionName, String actionCmd) {
        for (Action a : d.getActions()) {
            if (!a.getValue("Name").equals(actionName)) continue;
            ActionEvent event = new ActionEvent((Object)this, 1001, actionCmd);
            a.actionPerformed(event);
            return true;
        }
        return false;
    }

    public List<Compare.Diff<?>> getSelectedDiffs() {
        return new ArrayList(this.mDiffTable.getSelectedValues());
    }

    public Optional<Compare.Diff<?>> getCurDiff() {
        int[] indxs = this.mDiffTable.getSelectedRows();
        if (indxs.length == 1) {
            return Optional.of(this.mDiffTable.getDiffTableModel().getElementAt(indxs[0]));
        }
        return Optional.empty();
    }

    public void removeCurDiff() {
        int[] indxs = this.mDiffTable.getSelectedRows();
        if (indxs.length != 1) {
            return;
        }
        this.mDiffTable.getDiffTableModel().removeElement(indxs[0]);
    }

    public Optional<Icon> getCurDiffIcon() {
        return this.getCurDiff().map(this::getDiffIcon);
    }

    public Icon getDiffIcon(Compare.Diff<?> diff) {
        Object owner = diff.getOwner();
        Class<DbObject> modifiedType = diff.getModifiedType();
        Icon icon = diff.getDbClass().equals("Layer") ? UIUtil.getScaledIcon((Icon)OrbitIcons.LAYERS, (int)16, (int)16) : (owner.getClass().isAssignableFrom(modifiedType) && owner instanceof DbObject ? OrbitIcons.getSmallIcon((DbObject)owner) : OrbitIcons.getSmallIcon(modifiedType));
        Icon decorator = this.getDiffTypeDecorator(diff.getType());
        return new ADecoratedIcon(icon, decorator);
    }

    public Icon getDiffMergeIcon(Compare.Diff<?> d) {
        if (d instanceof Compare.Mergeable) {
            return ICON_MERGABLE;
        }
        return ICON_DIFF;
    }

    public Icon getDiffTypeDecorator(Compare.Diff.Type type) {
        switch (type) {
            case ADD: {
                return DECOR_ADDED;
            }
            case MODIFY: {
                return DECOR_MODIFIED;
            }
            case DELETE: {
                return DECOR_DELETED;
            }
        }
        return DECOR_NORMAL;
    }

    private void addContactSyncObject(Compare.Diff<?> diff) {
        Object mergedObj = null;
        if (diff instanceof ComparePinTemplate.PinNetChanged) {
            mergedObj = ((ComparePinTemplate.PinNetChanged)diff).getOrigPinT();
        } else if (diff instanceof CompareDevice.NetMapMergeable && ((Device)diff.getOwner()).isPin()) {
            mergedObj = diff.getOwner();
        }
        if (mergedObj != null) {
            this.mContactNetSyncEngine.addToSyncNetObject((DbObject)mergedObj);
        }
        if (diff instanceof CompareDeviceTemplate.PinTemplateRemoved) {
            this.mContactObjectSyncEngine.addToSyncDelete((DbObject)((CompareDeviceTemplate.PinTemplateRemoved)diff).getOrigPinT());
        } else if (diff instanceof ComparePinTemplate.PortMoved) {
            this.mContactObjectSyncEngine.addToSyncLoc((DbObject)((ComparePinTemplate.PortMoved)diff).getOrigPinT());
        }
    }

    public void refreshDesignView() {
        OrbitIO.refreshViewsOf(this.mMerger.getOrigDb());
    }

    private void removeDiffComplete() {
        this.mDiffTable.removeDiffComplete();
        this.mDiffTable.repaint();
        this.mDiffTreeModel.removeDiffComplete();
        this.mDiffTree.repaint();
    }

    protected void emitMergeError(Compare.Mergeable<?> m) {
        JOptionPane.showMessageDialog((Component)((Object)this), m.getMergeMessage(), "Merge Error", 0);
    }

    protected void updateFilteredData() {
        this.mDiffTree.getModel().reload((TreeNode)this.mDiffTree.getModel().getRoot());
    }

    protected void verifyCloseUI() {
        int resp = JOptionPane.showConfirmDialog((Component)((Object)this), "Close dialog?", "Confirm Close", 2, 3);
        if (resp == 0) {
            this.setDefaultCloseOperation(2);
        } else {
            this.setDefaultCloseOperation(0);
        }
    }

    private DbHistory.DbTransaction getAcceptTransaction(boolean interactive, Compare.Mergeable<?> m) {
        if (interactive) {
            return DbHistory.newDbTransaction((Db)this.mDb, (String)("Merge " + m.getClass().getSimpleName()));
        }
        return null;
    }

    protected void acceptCurDiff(boolean interactive) {
        this.getCurDiff().ifPresent(diff -> {
            this.acceptDiff((Compare.Diff<?>)diff, interactive);
            this.gotoNextDiff(interactive);
        });
    }

    private boolean acceptDiff(Compare.Diff<?> diff, boolean interactive) {
        if (diff instanceof Compare.Mergeable) {
            Compare.Mergeable m = (Compare.Mergeable)diff;
            try (OrbitApp.ChangeWarningSilencer cm = OrbitApp.suppressDbChangeMonitorWarnings();
                 DbHistory.DbTransaction trans = this.getAcceptTransaction(interactive, m);){
                this.addContactSyncObject(m);
                boolean merged = m.merge();
                this.refreshDesignView();
                if (!merged) {
                    this.emitMergeError(m);
                    boolean bl = false;
                    return bl;
                }
            }
        }
        return true;
    }

    protected boolean gotoNextDiff(boolean interactive) {
        int idx = this.mDiffTable.getSelectedRow();
        if (idx + 1 < this.mDiffTable.getDiffTableModel().getRowCount()) {
            this.mDiffTable.setRowSelectionInterval(idx + 1, idx + 1);
            return true;
        }
        final TreePath selPath = this.mDiffTree.getSelectionPath();
        final MutableBoolean selected = new MutableBoolean(false);
        TreeTraverser.CallBack cb = new TreeTraverser.CallBack(){
            boolean mSkipping;
            {
                this.mSkipping = selPath != null;
            }

            @Override
            public boolean processTreeNode(TreePath path) {
                if (this.mSkipping) {
                    if (path.equals(selPath)) {
                        this.mSkipping = false;
                    }
                    return true;
                }
                DiffTreeNode n = (DiffTreeNode)((Object)path.getLastPathComponent());
                if (n.getDiffCount() > 0) {
                    InteractiveMergeUI.this.mDiffTree.setSelectionPath(path);
                    selected.setValue(true);
                    return false;
                }
                return true;
            }
        };
        new TreeTraverser((TreeModel)((Object)this.mDiffTreeModel), cb).start();
        if (selected.getValue()) {
            return true;
        }
        boolean startAtOrBeforeFirstDiff = selPath == null;
        TreePath rootPath = new TreePath(this.mDiffTreeModel.getRoot());
        int rootDiffCount = ((DiffTreeNode)((Object)this.mDiffTreeModel.getRoot())).getDiffCount();
        if (selPath == null || selPath.equals(rootPath) && rootDiffCount < 2) {
            startAtOrBeforeFirstDiff = true;
        }
        if (!startAtOrBeforeFirstDiff) {
            int result;
            if (interactive && (result = JOptionPane.showConfirmDialog((Component)((Object)this), "End of list, would you like to continue from the beginning?", "End of list", 0)) != 0) {
                return false;
            }
            cb = new TreeTraverser.CallBack(){

                @Override
                public boolean processTreeNode(TreePath path) {
                    if (path.equals(selPath)) {
                        int selPathDiffCount = ((DiffTreeNode)((Object)path.getLastPathComponent())).getDiffCount();
                        if (selPathDiffCount < 2) {
                            return false;
                        }
                        InteractiveMergeUI.this.mDiffTable.setRowSelectionInterval(0, 0);
                        selected.setValue(true);
                        return false;
                    }
                    DiffTreeNode n = (DiffTreeNode)((Object)path.getLastPathComponent());
                    if (n.getDiffCount() > 0) {
                        InteractiveMergeUI.this.mDiffTree.setSelectionPath(path);
                        selected.setValue(true);
                        return false;
                    }
                    return true;
                }
            };
            new TreeTraverser((TreeModel)((Object)this.mDiffTreeModel), cb).start();
        }
        if (interactive && !selected.getValue()) {
            JOptionPane.showMessageDialog((Component)((Object)this), "No more differences", "End of List", 1);
        }
        return selected.getValue();
    }

    protected class DHTreeModel
    extends DiffTreeModel {
        DTDiffMerge.Diffs mTemplateDiffs;
        DTDiffMerge.Diffs mDeviceDiffs;

        public DHTreeModel() {
            this.mTemplateDiffs = new DTDiffMerge.Diffs();
            this.mDeviceDiffs = new DTDiffMerge.Diffs();
            for (Compare.Diff<? extends DbObject> diff : InteractiveMergeUI.this.mMerger.getDiffs()) {
                DbObject owner = diff.getOwner();
                if (owner instanceof DeviceTemplate) {
                    this.mTemplateDiffs.add(diff);
                    continue;
                }
                if (owner instanceof Device) {
                    this.mDeviceDiffs.add(diff);
                    continue;
                }
                assert (false) : "Unexpected diff owner.";
            }
            if (InteractiveMergeUI.this.mMerger.getOriginalDevice() != null) {
                this.setRoot((TreeNode)((Object)new DHDeviceNode(this, InteractiveMergeUI.this.mMerger.getOriginalDevice())));
            } else {
                this.setRoot((TreeNode)((Object)new DHTemplateNode(this, InteractiveMergeUI.this.mMerger.getOriginalTemplate())));
            }
        }

        protected class DHDeviceNode
        extends DHTreeNode {
            protected Device mDevice;
            protected List<Compare.Diff<?>> mDiffs;
            protected int mLastTemplateDiffCount;
            protected int mLastDeviceDiffCount;
            protected long mLastFilterUpdate;
            protected List<Compare.Diff<?>> mDiffCache;

            public DHDeviceNode(DHTreeModel model, Device device) {
                super((DiffTreeModel)model);
                this.mLastTemplateDiffCount = -1;
                this.mLastDeviceDiffCount = -1;
                this.mLastFilterUpdate = -1L;
                this.mDiffCache = new ArrayList();
                this.mDevice = device;
                this.mDiffs = DHTreeModel.this.mDeviceDiffs.getDiffs(this.mDevice);
            }

            public DHDeviceNode(DiffTreeNode owner, Device device) {
                super(owner);
                this.mLastTemplateDiffCount = -1;
                this.mLastDeviceDiffCount = -1;
                this.mLastFilterUpdate = -1L;
                this.mDiffCache = new ArrayList();
                this.mDevice = device;
                this.mDiffs = DHTreeModel.this.mDeviceDiffs.getDiffs(this.mDevice);
            }

            public String getText() {
                return this.mDevice.getName();
            }

            public ArrayList<? extends ATreeNode> populateChildren() {
                ArrayList<DHDeviceNode> children = new ArrayList<DHDeviceNode>();
                for (Device d : this.mDevice.getTemplate().getChildren()) {
                    children.add(new DHDeviceNode(this, d));
                }
                return children;
            }

            public Icon getIcon() {
                Icon icon = DbExplorerPanel.getIconForDevice(this.mDevice);
                Icon decorator = this.getModifiedStatusIcon();
                if (decorator == null) {
                    decorator = DECOR_NORMAL;
                }
                return new ATwoIcon(decorator, icon);
            }

            @Override
            public Icon getModifiedStatusIcon() {
                List<Compare.Diff<?>> diffs;
                Icon icon = ICON_BASE;
                for (DHTreeNode c : this.getDHChildren()) {
                    if (c.getModifiedStatusIcon() == ICON_BASE) continue;
                    icon = ICON_BELOW;
                    break;
                }
                if ((diffs = this.getDiffs()) != null && !diffs.isEmpty()) {
                    icon = new ADecoratedIcon(icon, DECOR_MODIFIED, ADecoratedIcon.POSX.RIGHT, ADecoratedIcon.POSY.TOP);
                }
                return icon;
            }

            @Override
            public DbObject getDiffsOwner() {
                return this.mDevice;
            }

            @Override
            public List<Compare.Diff<?>> getDiffs() {
                int ddiffs;
                List<Compare.Diff<? extends DbObject>> templateDiffs = DHTreeModel.this.mTemplateDiffs.getDiffs(this.mDevice.getTemplate());
                int tdiffs = templateDiffs == null ? 0 : templateDiffs.size();
                int n = ddiffs = this.mDiffs == null ? 0 : this.mDiffs.size();
                if (tdiffs == this.mLastTemplateDiffCount && ddiffs == this.mLastDeviceDiffCount && InteractiveMergeUI.this.mExcludeFilters.getLastModified() == this.mLastFilterUpdate) {
                    return this.mDiffCache;
                }
                this.mDiffCache.clear();
                if (this.mDiffs != null) {
                    this.mDiffCache.addAll(this.mDiffs);
                }
                if (templateDiffs != null) {
                    this.mDiffCache.addAll(templateDiffs);
                }
                if (!this.mDiffCache.isEmpty() && InteractiveMergeUI.this.mExcludeFilters.size() > 0) {
                    ArrayList all = AUtil.arrayList(this.mDiffCache);
                    DTDiffMergeUI.applyFilters(all, InteractiveMergeUI.this.mExcludeFilters.getAll(), this.mDiffCache);
                }
                this.mLastTemplateDiffCount = tdiffs;
                this.mLastDeviceDiffCount = ddiffs;
                this.mLastFilterUpdate = InteractiveMergeUI.this.mExcludeFilters.getLastModified();
                return this.mDiffCache;
            }

            public String toString() {
                return String.format("Device '%s' (%d)", this.mDevice.getName(), this.getDiffCount());
            }

            public boolean isLeaf() {
                return this.getChildCount() == 0;
            }
        }

        protected class DHTemplateNode
        extends DHTreeNode {
            protected DeviceTemplate mTemplate;
            protected List<Compare.Diff<?>> mDiffs;
            protected ArrayList<Compare.Diff<?>> mFilteredDiffs;
            protected long mFilterUpdate;

            public DHTemplateNode(DHTreeModel model, DeviceTemplate dt) {
                super((DiffTreeModel)model);
                this.mFilteredDiffs = new ArrayList();
                this.mFilterUpdate = 0L;
                this.mTemplate = dt;
                this.mDiffs = DHTreeModel.this.mTemplateDiffs.getDiffs(this.mTemplate);
            }

            public String getText() {
                return this.mTemplate.getName();
            }

            public ArrayList<? extends ATreeNode> populateChildren() {
                ArrayList<DHDeviceNode> children = new ArrayList<DHDeviceNode>();
                for (Device d : this.mTemplate.getChildren()) {
                    children.add(new DHDeviceNode(this, d));
                }
                return children;
            }

            public Icon getIcon() {
                Icon icon = DbExplorerPanel.getIconForTemplate(this.mTemplate);
                Icon decorator = this.getModifiedStatusIcon();
                if (decorator == null) {
                    decorator = DECOR_NORMAL;
                }
                return new ATwoIcon(decorator, icon);
            }

            @Override
            public Icon getModifiedStatusIcon() {
                Icon icon = ICON_BASE;
                for (DHTreeNode c : this.getDHChildren()) {
                    if (c.getModifiedStatusIcon() == ICON_BASE) continue;
                    icon = ICON_BELOW;
                    break;
                }
                if (this.getDiffs() != null && !this.getDiffs().isEmpty()) {
                    icon = new ADecoratedIcon(icon, DECOR_MODIFIED, ADecoratedIcon.POSX.RIGHT, ADecoratedIcon.POSY.TOP);
                }
                return icon;
            }

            @Override
            public DbObject getDiffsOwner() {
                return this.mTemplate;
            }

            @Override
            public List<Compare.Diff<?>> getDiffs() {
                if (InteractiveMergeUI.this.mExcludeFilters.size() == 0 || this.mDiffs == null || this.mDiffs.isEmpty()) {
                    return this.mDiffs;
                }
                if (InteractiveMergeUI.this.mExcludeFilters.getLastModified() <= this.mFilterUpdate) {
                    return this.mFilteredDiffs;
                }
                DTDiffMergeUI.applyFilters(this.mDiffs, InteractiveMergeUI.this.mExcludeFilters.getAll(), this.mFilteredDiffs);
                this.mFilterUpdate = InteractiveMergeUI.this.mExcludeFilters.getLastModified();
                return this.mFilteredDiffs;
            }

            public String toString() {
                return String.format("DeviceTemplate '%s' (%d)", this.mTemplate.getName(), this.getDiffCount());
            }
        }

        protected abstract class DHTreeNode
        extends DiffTreeNode {
            public DHTreeNode(DiffTreeModel model) {
                super(model);
            }

            public DHTreeNode(DiffTreeNode parent) {
                super(parent);
            }

            public abstract Icon getModifiedStatusIcon();

            public abstract DbObject getDiffsOwner();

            public IterableIterator<DHTreeNode> getDHChildren() {
                return new ProcessingIterator<DiffTreeNode, DHTreeNode>(super.getChildren()){

                    protected DHTreeNode process(DiffTreeNode o) {
                        return o instanceof DHTreeNode ? (DHTreeNode)o : null;
                    }
                };
            }
        }
    }

    protected class DiffTypeTreeModel
    extends DiffTreeModel {
        public DiffTypeTreeModel() {
            HashMap mTypeNodes = Maps.newHashMap();
            HashMap mClassNodes = Maps.newHashMap();
            for (Compare.Diff<? extends DbObject> diff : InteractiveMergeUI.this.mMerger.getDiffs()) {
                Class<?> diffType = diff.getClass();
                TypeNode tn = mTypeNodes.computeIfAbsent(diffType, k -> new TypeNode(diffType));
                tn.setDbClassName(diff.getDbClass());
                tn.addDiff(diff);
            }
            for (TypeNode tn : mTypeNodes.values()) {
                ClassNode cn = mClassNodes.computeIfAbsent(tn.getDbClassName(), k -> new ClassNode(tn.getDbClassName()));
                cn.mTypeChildren.add(tn);
            }
            ArrayList classNodes = Lists.newArrayList(mClassNodes.values());
            this.setRoot((TreeNode)((Object)new RootNode(classNodes)));
        }

        @Override
        public void initTree(DiffTree tree) {
            super.initTree(tree);
            tree.setShowsRootHandles(false);
        }

        protected class TypeNode
        extends DiffTreeNode {
            protected String mText;
            protected Class<? extends Compare.Diff<? extends DbObject>> mDiffType;
            protected List<Compare.Diff<?>> mDiffs;
            protected boolean mSorted;
            protected String mDbClassName;
            protected ArrayList<Compare.Diff<?>> mFilteredDiffs;
            protected long mFilterUpdate;
            protected Icon mIcon;

            public TypeNode(Class<? extends Compare.Diff<? extends DbObject>> diffType) {
                super(DiffTypeTreeModel.this);
                this.mDiffs = Lists.newLinkedList();
                this.mSorted = false;
                this.mFilteredDiffs = new ArrayList();
                this.mFilterUpdate = 0L;
                this.mIcon = null;
                this.mDiffType = diffType;
                this.mText = this.mDiffType.getSimpleName();
            }

            public void setDbClassName(String dbClass) {
                this.mDbClassName = dbClass;
            }

            public String getDbClassName() {
                return this.mDbClassName;
            }

            public void addDiff(Compare.Diff<?> diff) {
                this.mDiffs.add(diff);
                if (this.mIcon == null) {
                    Class<DbObject> modifiedType = diff.getModifiedType();
                    Icon icon = OrbitIcons.BLANK16x16;
                    if (this.mDbClassName.equals("Layer")) {
                        icon = UIUtil.getScaledIcon((Icon)OrbitIcons.LAYERS, (int)16, (int)16);
                    } else if (modifiedType.isAssignableFrom(DeviceTemplate.class)) {
                        icon = DBEResources.ICON_TEMPLATE;
                    } else if (modifiedType.isAssignableFrom(Device.class)) {
                        icon = DBEResources.ICON_DEVICE;
                    } else if (DbObject.class.isAssignableFrom(modifiedType)) {
                        icon = OrbitIcons.getSmallIcon(modifiedType);
                    }
                    this.mText = diff.getUserName();
                    Icon decorator = InteractiveMergeUI.this.getDiffTypeDecorator(diff.getType());
                    this.mIcon = new ADecoratedIcon(icon, decorator);
                }
            }

            public String getText() {
                return String.format("%s (%s)", this.mText, this.mDiffs.size());
            }

            public List<? extends ATreeNode> populateChildren() {
                return Collections.emptyList();
            }

            public Icon getIcon() {
                return this.mIcon;
            }

            @Override
            public boolean hasDiff() {
                return this.mDiffs != null && !this.mDiffs.isEmpty();
            }

            @Override
            public List<Compare.Diff<?>> getDiffs() {
                if (!this.mSorted) {
                    Collections.sort(this.mDiffs);
                }
                if (InteractiveMergeUI.this.mExcludeFilters.size() == 0 || this.mDiffs == null || this.mDiffs.isEmpty()) {
                    return this.mDiffs;
                }
                if (InteractiveMergeUI.this.mExcludeFilters.getLastModified() <= this.mFilterUpdate) {
                    return this.mFilteredDiffs;
                }
                DTDiffMergeUI.applyFilters(this.mDiffs, InteractiveMergeUI.this.mExcludeFilters.getAll(), this.mFilteredDiffs);
                this.mFilterUpdate = InteractiveMergeUI.this.mExcludeFilters.getLastModified();
                return this.mFilteredDiffs;
            }

            @Override
            public void removeDiffComplete() {
                this.mDiffs = this.mDiffs.stream().filter(d -> d instanceof Compare.Mergeable).filter(m -> ((Compare.Mergeable)m).canMerge()).collect(Collectors.toList());
            }

            public String toString() {
                return String.format(this.mDiffType.getSimpleName(), new Object[0]);
            }

            public boolean isLeaf() {
                return true;
            }
        }

        protected final class ClassNode
        extends DiffTreeNode {
            private String mClassName;
            private List<TypeNode> mTypeChildren;

            public ClassNode(String className) {
                super(DiffTypeTreeModel.this);
                this.mClassName = className;
                this.mChildren = this.mTypeChildren = new ArrayList<TypeNode>();
            }

            public List<? extends ATreeNode> populateChildren() {
                return this.mChildren;
            }

            public String getText() {
                return this.mClassName + " (" + this.getDiffCount() + ")";
            }

            @Override
            public int getDiffCount() {
                int count = 0;
                for (ATreeNode node : this.mChildren) {
                    TypeNode c = (TypeNode)node;
                    count += c.getDiffCount();
                }
                return count;
            }

            public Icon getIcon() {
                if (this.mClassName.equals("Device")) {
                    return DbExplorerPanel.getIconForDevice(InteractiveMergeUI.this.mMerger.getOriginalDevice());
                }
                if (this.mClassName.equals("DeviceTemplate")) {
                    return DbExplorerPanel.getIconForDbObject((DbObject)InteractiveMergeUI.this.mMerger.getOriginalTemplate());
                }
                if (this.mClassName.equals("Net Mapping")) {
                    return OrbitIcons.NETMAP;
                }
                if (this.mClassName.equals("Net")) {
                    return DBEResources.ICON_NETS;
                }
                if (this.mClassName.equals("Pin")) {
                    return DBEResources.ICON_PINS;
                }
                if (this.mClassName.equals("Layer")) {
                    return UIUtil.getScaledIcon((Icon)OrbitIcons.LAYERS, (int)16, (int)16);
                }
                return super.getIcon();
            }
        }

        protected class RootNode
        extends DiffTreeNode {
            public RootNode(List<ClassNode> children) {
                super(DiffTypeTreeModel.this);
                this.mChildren = children;
            }

            public String getText() {
                return String.format("%s vs. %s", InteractiveMergeUI.this.mMerger.getOriginalDesc(), InteractiveMergeUI.this.mMerger.getUpdatedDesc());
            }

            public Icon getIcon() {
                return UIUtil.getScaledIcon((Icon)OrbitIcons.DIFF, (int)14, (int)14);
            }

            public List<? extends ATreeNode> populateChildren() {
                return this.mChildren;
            }

            @Override
            public int getDiffCount() {
                int count = 0;
                for (ATreeNode node : this.mChildren) {
                    ClassNode c = (ClassNode)node;
                    count += c.getDiffCount();
                }
                return count;
            }
        }
    }

    protected abstract class DiffTreeNode
    extends ALazyTreeNode {
        public DiffTreeNode(DiffTreeModel model) {
            super((ATreeModel)model);
        }

        public DiffTreeNode(DiffTreeNode parent) {
            super((ATreeNode)parent);
        }

        public boolean hasDiff() {
            return this.mChildren.stream().filter(c -> c instanceof DiffTreeNode).map(c -> (DiffTreeNode)((Object)c)).map(DiffTreeNode::hasDiff).reduce(false, (n1, n2) -> n1 != false || n2 != false);
        }

        public List<Compare.Diff<?>> getDiffs() {
            return this.mChildren.stream().filter(c -> c instanceof DiffTreeNode).flatMap(c -> ((DiffTreeNode)((Object)c)).getDiffs().stream()).collect(Collectors.toList());
        }

        public void removeDiffComplete() {
            this.mChildren.stream().filter(c -> c instanceof DiffTreeNode).map(c -> (DiffTreeNode)((Object)c)).forEach(DiffTreeNode::removeDiffComplete);
        }

        public DiffTreeModel getDiffTreeModel() {
            return (DiffTreeModel)this.getTreeModel();
        }

        public IterableIterator<DiffTreeNode> getChildren() {
            this.populateChildrenAsNeeded();
            if (this.mChildren == null) {
                return AEmptyItr.create();
            }
            return new StreamIterableIterator(this.mChildren.stream().filter(DiffTreeNode.class::isInstance).map(DiffTreeNode.class::cast));
        }

        public int getDiffCount() {
            List<Compare.Diff<?>> diffs = this.getDiffs();
            if (diffs == null) {
                return 0;
            }
            return diffs.size();
        }
    }

    protected abstract class DiffTreeModel
    extends ATreeModel {
        protected DiffTreeModel() {
        }

        public void initTree(DiffTree tree) {
        }

        public boolean hasDiff() {
            Object rootNode = this.getRoot();
            if (rootNode instanceof DiffTreeNode) {
                return ((DiffTreeNode)((Object)rootNode)).hasDiff();
            }
            return false;
        }

        public List<Compare.Diff<?>> getDiffs() {
            Object rootNode = this.getRoot();
            if (rootNode instanceof DiffTreeNode) {
                return ((DiffTreeNode)((Object)rootNode)).getDiffs();
            }
            return Collections.emptyList();
        }

        public void removeDiffComplete() {
            Object rootNode = this.getRoot();
            if (rootNode instanceof DiffTreeNode) {
                ((DiffTreeNode)((Object)rootNode)).removeDiffComplete();
            }
        }
    }

    protected class DiffTree
    extends ATree {
        protected TreeSelectionListener mTreeSelectionListener;

        public DiffTree(DiffTreeModel model) {
            super((ATreeModel)model);
            this.mTreeSelectionListener = new TreeSelectionListener(){
                DiffTreeNode mPrevNode = null;

                @Override
                public void valueChanged(TreeSelectionEvent e) {
                    DiffTreeNode selNode = (DiffTreeNode)((Object)DiffTree.this.getLastSelectedPathComponent());
                    if (selNode == this.mPrevNode) {
                        return;
                    }
                    InteractiveMergeUI.this.setDiffTable(new DiffTable(selNode));
                    this.mPrevNode = selNode;
                }
            };
            this.addTreeSelectionListener(this.mTreeSelectionListener);
            this.setShowsRootHandles(true);
        }

        public void setSelectionPath(TreePath path) {
            super.setSelectionPath(path);
            this.scrollPathToVisible(path);
        }
    }

    protected static class DiffTableModel
    extends AbstractTableModel {
        private final String[] columnNames;
        private List<Compare.Diff<?>> mDiffList;

        public DiffTableModel(DTDiffMerge merger, List<Compare.Diff<?>> list) {
            this.columnNames = new String[]{"", merger.getOriginalDesc(), merger.getUpdatedDesc()};
            this.mDiffList = new ArrayList(list);
        }

        public void removeDiffComplete() {
            this.mDiffList = this.mDiffList.stream().filter(d -> d instanceof Compare.Mergeable).filter(m -> ((Compare.Mergeable)m).canMerge()).collect(Collectors.toList());
        }

        public void removeElement(int row) {
            this.mDiffList.remove(row);
            this.fireTableRowsDeleted(row, row);
        }

        public Compare.Diff<?> getElementAt(int row) {
            if (row >= 0 && row < this.mDiffList.size()) {
                return this.mDiffList.get(row);
            }
            return null;
        }

        @Override
        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public int getRowCount() {
            return this.mDiffList.size();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            return null;
        }
    }

    protected class DiffTable
    extends JTable {
        protected MouseListener mMouseListener = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                this.maybeShowPopup(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.maybeShowPopup(e);
            }

            protected void maybeShowPopup(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    e.getSource();
                    int row = DiffTable.this.locationToIndex(e.getPoint());
                    DiffTable.this.setRowSelectionInterval(row, row);
                    DiffTable.this.showContextMenu(row, e.getPoint());
                }
            }
        };
        protected ListSelectionListener mChangeSelListener = e -> {
            int[] selIdxs = this.getSelectedRows();
            if (selIdxs.length == 1 && selIdxs[0] >= 0) {
                Rectangle r = this.getCellRect(selIdxs[0], 0, true);
                this.scrollRectToVisible(r);
            }
            InteractiveMergeUI.this.updateSelectedDiffs();
        };

        public DiffTable(DiffTreeNode treeNode) {
            if (treeNode != null) {
                this.setModel(new DiffTableModel(InteractiveMergeUI.this.mMerger, treeNode.getDiffs()));
            }
            this.setSelectionMode(2);
            this.getSelectionModel().addListSelectionListener(this.mChangeSelListener);
            this.addMouseListener(this.mMouseListener);
            this.setDefaultRenderer(Object.class, new DiffTableRenderer());
        }

        public void removeDiffComplete() {
            TableModel model = this.getModel();
            if (model instanceof DiffTableModel) {
                DiffTableModel diffTableModel = (DiffTableModel)model;
                diffTableModel.removeDiffComplete();
            }
        }

        public List<Compare.Diff<?>> getSelectedValues() {
            ArrayList result = new ArrayList();
            for (int selIdx : this.getSelectedRows()) {
                result.add(this.getDiffTableModel().getElementAt(selIdx));
            }
            return result;
        }

        public DiffTableModel getDiffTableModel() {
            TableModel m = this.getModel();
            if (m instanceof DiffTableModel) {
                return (DiffTableModel)this.getModel();
            }
            return null;
        }

        protected void showContextMenu(int row, Point location) {
            JPopupMenu m = new JPopupMenu();
            Compare.Diff<?> item = this.getDiffTableModel().getElementAt(row);
            if (item instanceof Compare.Mergeable) {
                JMenuItem acceptItem = new JMenuItem(InteractiveMergeUI.this.mAccept);
                m.add(acceptItem);
            } else if (item instanceof Compare.Diff) {
                m.add(new AckAction());
            } else {
                return;
            }
            m.show(this, location.x, location.y);
        }

        protected int locationToIndex(Point p) {
            int row = (int)(p.getY() / (double)this.getRowHeight());
            if (row >= this.getRowCount()) {
                return 0;
            }
            return row;
        }

        public Compare.Diff<?> getSelectedValue() {
            int row = this.getSelectedRow();
            return this.getDiffTableModel().getElementAt(row);
        }

        public class DiffTableRenderer
        extends DefaultTableCellRenderer {
            @Override
            public Component getTableCellRendererComponent(JTable table, Object o, boolean isSelected, boolean hasFocus, int row, int column) {
                super.getTableCellRendererComponent(table, o, isSelected, hasFocus, row, column);
                this.setIcon(null);
                this.setText(null);
                this.setHorizontalAlignment(2);
                this.setForeground(Color.BLACK);
                this.setBackground(Color.WHITE);
                Compare.Diff<?> diff = DiffTable.this.getDiffTableModel().getElementAt(row);
                this.setToolTipText(diff.getDesc());
                if (diff.getType() == Compare.Diff.Type.ADD) {
                    if (column == 2) {
                        this.setBackground(DbCompare.COLOR_ADD);
                    }
                } else if (diff.getType() == Compare.Diff.Type.DELETE) {
                    if (column == 1) {
                        this.setBackground(DbCompare.COLOR_REMOVE);
                    }
                } else if (diff.getType() == Compare.Diff.Type.MODIFY) {
                    this.setBackground(DbCompare.COLOR_CHANGE);
                }
                if (isSelected) {
                    Color sc = AColor.mix((Color)this.getBackground(), (Color)Color.BLUE, (float)0.5f);
                    this.setBackground(sc);
                }
                if (column == 0) {
                    this.setIcon(InteractiveMergeUI.this.getDiffIcon(diff));
                    this.setText(diff.getItemDesc());
                } else if (column == 1) {
                    this.setText(diff.getOldDesc());
                } else if (column == 2) {
                    this.setText(diff.getNewDesc());
                }
                return this;
            }
        }

        protected class AckAction
        extends AbstractAction {
            protected Compare.Diff<?> mDiff;

            public AckAction() {
                super("Acknowledge");
                this.mDiff = DiffTable.this.getSelectedValue();
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                DiffTable.this.getDiffTableModel().removeElement(DiffTable.this.getSelectedRow());
            }
        }
    }

    public static class TreeTraverser {
        protected TreeModel mModel;
        protected CallBack mCallBack;

        public TreeTraverser(TreeModel model, CallBack cb) {
            this.mModel = model;
            this.mCallBack = cb;
        }

        public void start() {
            this.next(new TreePath(this.mModel.getRoot()));
        }

        protected boolean next(TreePath p) {
            if (!this.mCallBack.processTreeNode(p)) {
                return false;
            }
            Object node = p.getLastPathComponent();
            int childCount = this.mModel.getChildCount(node);
            for (int idx = 0; idx < childCount; ++idx) {
                Object child = this.mModel.getChild(node, idx);
                if (this.next(p.pathByAddingChild(child))) continue;
                return false;
            }
            return true;
        }

        public static interface CallBack {
            public boolean processTreeNode(TreePath var1);
        }
    }
}

