/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.diff_merge.ui;

import com.sigrity.acl.db.Db;
import com.sigrity.acl.jfxui.AJFXDesignDialog;
import com.sigrity.acl.jfxui.AJFXFileChooser;
import com.sigrity.acl.jfxui.AJFXFileChooserControl;
import com.sigrity.acl.jfxui.AJFXPanel;
import com.sigrity.acl.jfxui.OkCancelHBox;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.diff_merge.OioDiffMerger;
import com.sigrity.orbit.diff_merge.ui.FileDiffMergeOptionUI;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Label;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.SwingUtilities;

public class OioDiffMergeUI
extends AJFXDesignDialog {
    private static final String TITLE = "Compare/Merge OIO";

    public static Action getAction() {
        return new AbstractAction(TITLE){

            @Override
            public void actionPerformed(ActionEvent e) {
                OioDiffMergeUI.createDialog(OrbitIO.getMainWindow(), OrbitIO.getCurDb());
            }

            @Override
            public boolean isEnabled() {
                return super.isEnabled() && OrbitIO.getCurDb() != null;
            }
        };
    }

    public static OioDiffMergeUI createDialog(Window owner, Db db) {
        if (db == null) {
            return null;
        }
        OioDiffMergeUI dlg = new OioDiffMergeUI(owner, db);
        dlg.setVisible(true);
        return dlg;
    }

    private OioDiffMergeUI(Window owner, Db db) {
        super(db, (Component)owner, TITLE, Dialog.ModalityType.APPLICATION_MODAL);
        this.init();
    }

    protected AJFXPanel createJfxPanel() {
        return new OioDiffMergePanel();
    }

    private class OioDiffMergePanel
    extends AJFXPanel {
        private static final int PANEL_WIDTH = 500;
        private static final int PANEL_HEIGHT = 75;
        private AJFXFileChooserControl mFileChooser;
        EventHandler<javafx.event.ActionEvent> mOkHandler = e -> SwingUtilities.invokeLater(() -> {
            UIUtil.closeWindow((Window)((Object)OioDiffMergeUI.this));
            this.mergeCompareOIO(OioDiffMergeUI.this.getDb(), this.mFileChooser.getPath());
        });

        public OioDiffMergePanel() {
            this.setPreferredSize(new Dimension(500, 75));
        }

        protected Parent initSceneGraph() {
            VBox pane = new VBox(10.0);
            HBox updatedFileBox = new HBox(10.0);
            updatedFileBox.setAlignment(Pos.CENTER);
            Label updatedFileLabel = new Label("Updated File");
            updatedFileLabel.setTooltip(new Tooltip("Specify an oio file for compare/merge."));
            HBox.setHgrow((Node)updatedFileLabel, (Priority)Priority.NEVER);
            updatedFileBox.getChildren().add((Object)updatedFileLabel);
            this.mFileChooser = new AJFXFileChooserControl((Window)((Object)OioDiffMergeUI.this));
            this.mFileChooser.addChoosableFileFilter(AJFXFileChooser.OIO_FILE_FILTER);
            this.mFileChooser.setUseSaveChooser(false);
            HBox.setHgrow((Node)this.mFileChooser, (Priority)Priority.ALWAYS);
            updatedFileBox.getChildren().add((Object)this.mFileChooser);
            pane.getChildren().add((Object)updatedFileBox);
            OkCancelHBox okCancelHBox = new OkCancelHBox((Window)((Object)OioDiffMergeUI.this), this.mOkHandler);
            pane.getChildren().add((Object)okCancelHBox);
            return pane;
        }

        private void mergeCompareOIO(Db db, String filePath) {
            OioDiffMerger merger = new OioDiffMerger(db, filePath);
            merger.importFile();
            if (merger.getUpdatedTemplate() != null) {
                FileDiffMergeOptionUI.createDialog(OrbitIO.getMainWindow(), merger);
            }
        }
    }
}

