/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.drc;

import com.sigrity.acl.AColor;
import com.sigrity.acl.ALog;
import com.sigrity.acl.APatternColor;
import com.sigrity.acl.Unit;
import com.sigrity.acl.app.AAppView;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.acl.geom.ARect;
import com.sigrity.acl.ui.AFieldValidator;
import com.sigrity.acl.ui.ASplitPane;
import com.sigrity.acl.ui.DbDialog;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.acl.ui.atree.ALazyTreeNode;
import com.sigrity.acl.ui.atree.ATreeCellRenderer;
import com.sigrity.acl.ui.atree.ATreeModel;
import com.sigrity.acl.ui.atree.ATreeNode;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.ShowMeTheWay;
import com.sigrity.orbit.drc.DRCRecord;
import com.sigrity.orbit.drc.Pin2PinSep;
import com.sigrity.orbit.ui.OrbitIcons;
import com.sigrity.orbit.ui.core.DesignCanvas2D;
import com.sigrity.orbit.ui.core.DesignView2D;
import com.sigrity.orbit.ui.core.ViewColorizer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.dnd.Autoscroll;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DropMode;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.plaf.ColorUIResource;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class BumpDRCDlg
extends DbDialog {
    protected AAppView mView;
    protected Design mDesign;
    protected ASplitPane mSplitTreeAndExplanation;
    protected JTextField mMinSep;
    protected JTextField mMaxSep;
    protected JRadioButton mZoomTo;
    protected JRadioButton mShowMe;
    protected JButton mFindDRCErrors;
    protected BumpDRCDlg mP2PSD;
    protected DRCRecordTree drcRecordTree;
    protected JTextPane mExplanation;
    ArrayList<DRCRecord> records;
    JProgressBar mProgressMeter;
    protected Pin2PinSep.LoadListener mListener;
    protected DevicePath mPath;
    JScrollPane sp;
    protected TreeSelectionListener mSelectionChanged = new TreeSelectionListener(){

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            TreePath tp = e.getPath();
            BumpDRCDlg.this.drcRecordTree.showRecord(tp);
        }
    };
    protected ActionListener mFindErrors = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            Unit unit = Design.getUnit((Db)OrbitIO.getCurDb());
            try {
                AFieldValidator.validateDouble((JTextField)BumpDRCDlg.this.mMinSep);
                if (!BumpDRCDlg.this.mMaxSep.getText().isEmpty()) {
                    AFieldValidator.validateDouble((JTextField)BumpDRCDlg.this.mMaxSep);
                } else {
                    BumpDRCDlg.this.mMaxSep.setText("0");
                }
            }
            catch (AFieldValidator.AFieldValidationException ve) {
                return;
            }
            long maxSep = unit.fromUser(Double.parseDouble(BumpDRCDlg.this.mMaxSep.getText().replace(",", "")));
            long minDist = unit.fromUser(Double.parseDouble(BumpDRCDlg.this.mMinSep.getText().replace(",", "")));
            ArrayList<DRCRecord> records = Pin2PinSep.drcBumps(minDist, maxSep, BumpDRCDlg.this.mPath);
            BumpDRCDlg.this.setRecords(records);
        }
    };

    public static BumpDRCDlg create(Window owner, AAppView view, DevicePath path) {
        BumpDRCDlg p2psd = new BumpDRCDlg(view, owner, path);
        p2psd.setVisible(true);
        return p2psd;
    }

    public BumpDRCDlg(AAppView view, Component owner, DevicePath path) {
        super(view.getDb(), owner);
        this.mPath = path;
        this.init(owner);
    }

    protected void init(Component owner) {
        this.setTitle("DRC Bump Review");
        this.mDb = OrbitIO.getCurDb();
        GridBagManager l = new GridBagManager(this.getContentPane());
        JPanel pnl = new JPanel();
        l.push((Container)pnl, (GridBagConstraints)GridBagManager.FILLALL);
        this.mZoomTo = new JRadioButton("Zoom To");
        l.add((Component)this.mZoomTo);
        this.mShowMe = new JRadioButton("Show Me");
        l.add((Component)this.mShowMe);
        l.newline();
        l.add((Component)new JLabel("Minimum Bump Pitch (microns):"));
        this.mMinSep = new JTextField(4);
        l.add((Component)this.mMinSep);
        l.newline();
        l.add((Component)new JLabel("Maximum Bump Pitch (microns):"));
        this.mMaxSep = new JTextField(4);
        l.add((Component)this.mMaxSep);
        this.mFindDRCErrors = new JButton("Find Errors");
        this.mFindDRCErrors.addActionListener(this.mFindErrors);
        l.add((Component)this.mFindDRCErrors);
        l.pop();
        l.newline();
        ATreeModel tm = new ATreeModel();
        this.drcRecordTree = new DRCRecordTree(tm, this);
        RootNode rn = new RootNode(tm, this.mDb);
        tm.setRoot((TreeNode)((Object)rn));
        this.drcRecordTree.setDragEnabled(true);
        this.drcRecordTree.setDropMode(DropMode.INSERT);
        this.drcRecordTree.setCellRenderer((TreeCellRenderer)((Object)new DRCRecordTreeRenderer()));
        this.drcRecordTree.setRootVisible(true);
        this.drcRecordTree.setShowsRootHandles(true);
        this.drcRecordTree.setOpaque(false);
        this.drcRecordTree.addTreeSelectionListener(this.mSelectionChanged);
        this.sp = new JScrollPane(this.drcRecordTree);
        this.mSplitTreeAndExplanation = new ASplitPane(1, true);
        this.mSplitTreeAndExplanation.setLeftComponent(this.sp);
        l.add((Component)this.mSplitTreeAndExplanation, (GridBagConstraints)GridBagManager.FILLALL);
        this.mExplanation = new JTextPane();
        this.mExplanation.setBorder(BorderFactory.createTitledBorder("Explanation"));
        this.mSplitTreeAndExplanation.setRightComponent(this.mExplanation);
        HTMLEditorKit ek = new HTMLEditorKit();
        URL uSS = ((Object)((Object)this)).getClass().getResource(String.format("./res/%s.css", ((Object)((Object)this)).getClass().getSimpleName()));
        if (uSS != null) {
            try (InputStreamReader reader = new InputStreamReader(uSS.openStream());){
                StyleSheet ss = new StyleSheet();
                ss.loadRules(reader, uSS);
                ek.setStyleSheet(ss);
            }
            catch (IOException e) {
                ALog.logDebug((Throwable)e, (String)"Reading CSS failed.", (Object[])new Object[0]);
            }
        }
        this.mExplanation.setEditorKit(ek);
        this.mExplanation.setEditable(false);
        this.mExplanation.setOpaque(false);
        this.mExplanation.setBackground(new Color(0, 0, 0, 0));
        l.newline();
        if (this.drcRecordTree.getPreferredSize().width < 100) {
            this.drcRecordTree.setPreferredSize(new Dimension(200, 200));
        }
        if (this.mExplanation.getPreferredSize().width < 100) {
            this.mExplanation.setPreferredSize(new Dimension(300, 100));
        }
        l.newline();
        this.mProgressMeter = new JProgressBar(0, 100);
        this.mProgressMeter.setStringPainted(true);
        l.add((Component)this.mProgressMeter, (GridBagConstraints)GridBagManager.FILLX);
        this.mListener = new Pin2PinSep.LoadListener(){

            @Override
            public void stats(int percent, boolean done, String data) {
                if (done) {
                    percent = 100;
                }
                BumpDRCDlg.this.mProgressMeter.setValue(percent);
                Object s = done ? data : percent + "% " + data;
                BumpDRCDlg.this.mProgressMeter.setString((String)s);
                Dimension d = BumpDRCDlg.this.mProgressMeter.getSize();
                BumpDRCDlg.this.mProgressMeter.paintImmediately(0, 0, d.width, d.height);
                if (done) {
                    // empty if block
                }
            }
        };
        Pin2PinSep.addLoadListener(this.mListener);
        JButton btnClose = new JButton("Close");
        l.add((Component)btnClose, (GridBagConstraints)GridBagManager.RIGHT_REMAINX);
        this.expandAll(this.drcRecordTree, true, 5);
        UIUtil.enableEscCloseDefaultMinSize((JDialog)((Object)this), (AbstractButton)btnClose, null);
        this.pack();
        this.setMinimumSize(this.getPreferredSize());
        UIUtil.center((Component)((Object)this));
    }

    protected void setRecords(ArrayList<DRCRecord> records) {
        this.records = records;
        ATreeModel tm = (ATreeModel)this.drcRecordTree.getModel();
        RootNode rn = (RootNode)((Object)tm.getRoot());
        rn.invalidateChildren();
    }

    public void expandAll(JTree tree, boolean expand, int stopDepth) {
        TreeNode root = (TreeNode)tree.getModel().getRoot();
        this.expandAll(tree, new TreePath(root), expand, 0, stopDepth);
    }

    private void expandAll(JTree tree, TreePath parent, boolean expand, int depth, int stopDepth) {
        if (depth >= stopDepth) {
            return;
        }
        TreeNode node = (TreeNode)parent.getLastPathComponent();
        if (node.getChildCount() >= 0) {
            Enumeration<? extends TreeNode> e = node.children();
            while (e != null && e.hasMoreElements()) {
                TreeNode n = e.nextElement();
                TreePath path = parent.pathByAddingChild(n);
                this.expandAll(tree, path, expand, depth + 1, stopDepth);
            }
        }
        if (expand) {
            tree.expandPath(parent);
        } else {
            tree.collapsePath(parent);
        }
    }

    public class DRCRecordTreeRenderer
    extends ATreeCellRenderer {
        Unit unit = Design.getUnit((Db)OrbitIO.getCurDb());

        public void setBackground(Color color) {
            if (color instanceof ColorUIResource) {
                color = null;
            }
            super.setBackground(color);
        }

        public Color getBackgroundNonSelectionColor() {
            return null;
        }

        public Color getBackground() {
            return null;
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Component c = super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
            this.setOpaque(false);
            if (value instanceof DRCRecordNode) {
                DRCRecordNode node = (DRCRecordNode)((Object)value);
                DRCRecord r = node.r;
                String dist = this.unit.toUserStr(r.dist);
                if (r.type == DRCRecord.Type.BumpMin) {
                    this.setText("Min Distance Violation " + dist);
                } else {
                    this.setText("Max Distance Violation " + dist);
                }
                this.setIcon(OrbitIcons.DRC_ERROR);
            }
            return c;
        }
    }

    protected class RootNode
    extends ALazyTreeNode {
        protected ArrayList<DRCRecordNode> mRecordNodes;

        public RootNode(ATreeModel m, Db db) {
            super(m);
        }

        public ArrayList<DRCRecordNode> populateChildren() {
            if (BumpDRCDlg.this.records == null) {
                return null;
            }
            Collections.sort(BumpDRCDlg.this.records);
            this.mRecordNodes = new ArrayList();
            for (DRCRecord r : BumpDRCDlg.this.records) {
                this.mRecordNodes.add(new DRCRecordNode((ATreeNode)this, r));
            }
            return this.mRecordNodes;
        }

        public String getText() {
            return "Bump to Bump Violations";
        }
    }

    protected class DRCRecordNode
    extends ALazyTreeNode {
        DRCRecord r;

        public DRCRecordNode(ATreeNode m, DRCRecord r) {
            super(m);
            this.r = r;
        }

        public ArrayList<DRCRecordNode> populateChildren() {
            return null;
        }

        public String getText() {
            return "Sides";
        }
    }

    protected static class DRCRecordTree
    extends JTree
    implements Autoscroll {
        protected ATreeModel mDbTreeModel;
        protected PopupMenuHandler mPopupMenuHandler = null;
        protected BumpDRCDlg owner = null;
        protected Insets m_autoscrollInsets = new Insets(20, 20, 20, 20);
        protected MouseListener mMouseListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    this.popupMenu(e);
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    this.popupMenu(e);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    this.popupMenu(e);
                } else if (e.getButton() == 1) {
                    this.showRecord(e);
                }
            }
        };

        public DRCRecordTree(ATreeModel tm, BumpDRCDlg owner) {
            super((TreeModel)tm);
            this.owner = owner;
            this.mDbTreeModel = tm;
            this.addMouseListener(this.mMouseListener);
        }

        public void setPopupMenuHandler(PopupMenuHandler h) {
            this.mPopupMenuHandler = h;
        }

        public void showRecord(MouseEvent e) {
            int row = this.getRowForLocation(e.getX(), e.getY());
            this.setSelectionRow(row);
            if (this.getSelectionPath() == null) {
                return;
            }
            TreePath tp = this.getSelectionPath();
            if (tp == null) {
                return;
            }
            this.showRecord(tp);
        }

        public void showRecord(TreePath tp) {
            Unit unit = Design.getUnit((Db)OrbitIO.getCurDb());
            if (tp.getLastPathComponent() instanceof DRCRecordNode) {
                DRCRecordNode rn = (DRCRecordNode)((Object)tp.getLastPathComponent());
                DRCRecord r = rn.r;
                String dist = unit.toUserStr(r.dist);
                DesignCanvas2D dv2d = ((DesignView2D)OrbitIO.getCurView()).getCanvas();
                ViewColorizer colorizer = dv2d.getColorizer();
                Object html = "<html>";
                if (r.type == DRCRecord.Type.BumpMin) {
                    DevicePath path = r.dpp1.getPath();
                    APatternColor color = colorizer.getColor(path, r.layer);
                    html = (String)html + "Minimum Pitch Violation ";
                    if (r.layer != null) {
                        html = (String)html + "Layer <font color=" + AColor.formatColor((Color)color.getColor()) + ">" + r.layer.getName() + "</font>";
                        html = (String)html + "<br>";
                    }
                    html = (String)html + "Separation " + dist + " microns";
                    html = (String)html + "<br>";
                    html = (String)html + r.dpp1.toString() + " & " + r.dpp2.toString();
                    html = (String)html + "</html>";
                } else {
                    html = (String)html + "Maximum Pitch Violation ";
                }
                this.owner.mExplanation.setText((String)html);
                if (this.owner.mZoomTo.isSelected()) {
                    ARect rect;
                    if (r.type == DRCRecord.Type.BumpMin) {
                        rect = r.dist > 0L ? ARect.create((APoint2D)r.dpp1.getWorldLoc(), (APoint2D)r.dpp2.getWorldLoc()) : new ARect(r.dpp1.getWorldBounds());
                        rect.expand(1.3);
                        dv2d.zoomTo(rect);
                    } else if (r.type == DRCRecord.Type.BumpMax) {
                        rect = new ARect(r.r1);
                        rect = rect.normalize();
                        rect.expand(1.3);
                        dv2d.zoomTo(rect);
                    }
                }
                if (this.owner.mShowMe.isSelected()) {
                    if (r.type == DRCRecord.Type.BumpMin) {
                        ShowMeTheWay.clear();
                        ShowMeTheWay.showMeTwoPts(r.dpp1.getWorldLoc(), r.dpp2.getWorldLoc(), "", ShowMeTheWay.LineStyle.Resistor, Color.ORANGE);
                    } else if (r.type == DRCRecord.Type.BumpMax) {
                        ShowMeTheWay.clear();
                        ShowMeTheWay.showMeTwoPts(r.r1.center(), r.r2.center(), "", ShowMeTheWay.LineStyle.Circles, Color.RED);
                    }
                }
            }
        }

        protected void popupMenu(MouseEvent e) {
            int row = this.getRowForLocation(e.getX(), e.getY());
            this.setSelectionRow(row);
            if (this.mPopupMenuHandler != null) {
                this.mPopupMenuHandler.handlePopup(e.getX(), e.getY());
            }
        }

        @Override
        public Insets getAutoscrollInsets() {
            return this.m_autoscrollInsets;
        }

        @Override
        public void autoscroll(Point cursorLocation) {
            Insets insets = this.getAutoscrollInsets();
            Rectangle outer = this.getVisibleRect();
            Rectangle inner = new Rectangle(outer.x + insets.left, outer.y + insets.top, outer.width - (insets.left + insets.right), outer.height - (insets.top + insets.bottom));
            if (!inner.contains(cursorLocation)) {
                Rectangle scrollRect = new Rectangle(cursorLocation.x - insets.left, cursorLocation.y - insets.top, insets.left + insets.right, insets.top + insets.bottom);
                this.scrollRectToVisible(scrollRect);
            }
        }

        static interface PopupMenuHandler {
            public void handlePopup(int var1, int var2);
        }
    }
}

