/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.drc;

import com.sigrity.acl.AIterableItr;
import com.sigrity.acl.ALog;
import com.sigrity.acl.AMultiMap;
import com.sigrity.acl.AUtil;
import com.sigrity.acl.IterableIterator;
import com.sigrity.acl.app.AApp;
import com.sigrity.acl.app.Settings;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.Selection;
import com.sigrity.acl.db.std.Constraint;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.Substrate;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.acl.geom.ARect;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.drc.ExportChecksToXml;
import com.sigrity.orbit.drc.checks.BumpToBumpCheck;
import com.sigrity.orbit.drc.checks.DeviceGridCheck;
import com.sigrity.orbit.drc.checks.IOPadCheck;
import com.sigrity.orbit.drc.checks.LayerInterconnectCheck;
import com.sigrity.orbit.drc.checks.WireGridCheck;
import com.sigrity.orbit.drc.ui.DRCDialog;
import com.sigrity.orbit.drc.ui.DRCOptions;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Action;
import javax.swing.JOptionPane;

public class DRC {
    protected static CheckRegistry gRegistry = new CheckRegistry();

    public static CheckRegistry getCheckRegistry() {
        return gRegistry;
    }

    public static void main(String[] cmdArgs) {
        Db db = OrbitIO.getCurDb();
        AMultiMap args = AApp.parseCmdLineArgsEx((String[])cmdArgs);
        Collection checks = args.get((Object)"ui");
        if (checks != null && !checks.isEmpty()) {
            DRCDialog drcDialog = new DRCDialog(OrbitIO.getMainWindow(), db);
            drcDialog.setVisible(true);
        } else {
            Engine drcEngine = new Engine(db);
            Substrate s = Substrate.getSubstrate((Db)db, (String)"SynthePHY_Substrate_1");
            Constraint.setConstraintValue((DbObject)s, (Constraint.Descriptor)Constraint.BUMP_TO_BUMP_CLEAR, (Object)Design.micronToInternal((Db)db, (double)120.0));
            LayerInterconnectCheck layerInterconnectCheck = new LayerInterconnectCheck();
            layerInterconnectCheck.OptCheckClearToNetUnused.set(true);
            layerInterconnectCheck.setOptScope(LayerInterconnectCheck.Scope.ALL);
            layerInterconnectCheck.setOptTraceToTrace(true);
            drcEngine.addCheck(layerInterconnectCheck);
            DeviceGridCheck deviceGridCheck = new DeviceGridCheck();
            drcEngine.addCheck(deviceGridCheck);
            WireGridCheck wireGridCheck = new WireGridCheck();
            drcEngine.addCheck(wireGridCheck);
            IOPadCheck ioPadCheck = new IOPadCheck();
            drcEngine.addCheck(ioPadCheck);
            BumpToBumpCheck bumpCheck = new BumpToBumpCheck();
            bumpCheck.setOptMinPitch(190.0);
            drcEngine.addCheck(bumpCheck);
            long violations = drcEngine.execute();
            if (violations == 0L) {
                JOptionPane.showMessageDialog(OrbitIO.getMainWindow(), "Yay " + System.getProperty("user.name") + "! No violations were found in the specified checks.", "Checks Complete", 1);
            } else {
                DRCDialog drcDialog = new DRCDialog(OrbitIO.getMainWindow(), db, drcEngine.getChecks());
                drcDialog.setVisible(true);
            }
        }
    }

    public static long testPinClearances(String filePath, double pinToDieEdge, double pinToCellEdge) {
        Db db = OrbitIO.getCurDb();
        Engine drcEngine = new Engine(db);
        BumpToBumpCheck bumpCheck = new BumpToBumpCheck();
        bumpCheck.setOptMinPinEdgeToDieEdge(pinToDieEdge);
        bumpCheck.setOptMinPinEdgeToCellEdge(pinToCellEdge);
        drcEngine.addCheck(bumpCheck);
        long violations = drcEngine.execute();
        if (violations == 0L) {
            ALog.logInfo((String)"No violations found.");
        } else {
            ExportChecksToXml.export(drcEngine.mChecks, filePath, Design.getUnit((Db)db));
        }
        return violations;
    }

    public static interface EngineListener {
        public void notifyCheckStart(Check var1);

        public void notifyCheckEnd(Check var1);
    }

    public static class Engine {
        protected Db mDb;
        protected Selection mSelection;
        protected boolean mJustSelected = false;
        protected Checks mChecks = new Checks();
        protected LinkedHashSet<EngineListener> mListeners = new LinkedHashSet();

        public boolean isJustSelected() {
            return this.mJustSelected;
        }

        public void isJustSelected(boolean state) {
            this.mJustSelected = state;
        }

        public Engine(Db db) {
            this.mDb = db;
            this.mSelection = new Selection(db);
        }

        public Db getDb() {
            return this.mDb;
        }

        public void addCheck(Check check) {
            this.mChecks.add(check);
        }

        public void addChecks(Iterator<Check> checks) {
            AUtil.addAll((Collection)this.mChecks, checks);
        }

        public Checks getChecks() {
            return this.mChecks;
        }

        public void setSelection(Selection sel) {
            this.mSelection = sel == null ? new Selection(this.mDb) : sel;
        }

        public Selection getSelection() {
            return this.mSelection;
        }

        public long execute() {
            long total = 0L;
            for (Check check : this.mChecks) {
                this.fireNotifyStart(check);
                total += check.execute(this);
                this.fireNotifyEnd(check);
            }
            return total;
        }

        public boolean addListener(EngineListener l) {
            return this.mListeners.add(l);
        }

        public boolean removeListener(EngineListener l) {
            return this.mListeners.remove(l);
        }

        protected void fireNotifyStart(Check c) {
            for (EngineListener l : this.mListeners) {
                l.notifyCheckStart(c);
            }
        }

        protected void fireNotifyEnd(Check c) {
            for (EngineListener l : this.mListeners) {
                l.notifyCheckEnd(c);
            }
        }
    }

    public static class CheckRegistry {
        protected LinkedList<Class<? extends Check>> mChecks = new LinkedList();

        public CheckRegistry() {
            this.loadChecks();
        }

        public IterableIterator<Class<? extends Check>> getChecks() {
            return new AIterableItr(this.mChecks);
        }

        public void registerCheck(Class<? extends Check> c) {
            this.mChecks.add(c);
        }

        protected void loadChecks() {
            String c;
            Settings piSettings = Settings.getSettings((String)"DRC");
            int i = 0;
            while ((c = (String)piSettings.getSettingOfClass("CheckClass" + i, String.class)) != null) {
                Class<? extends Check> check = this.loadCheck(c);
                if (check != null) {
                    this.registerCheck(check);
                }
                ++i;
            }
        }

        protected Class<? extends Check> loadCheck(String className) {
            try {
                Class<?> cls = Class.forName(className);
                return cls.asSubclass(Check.class);
            }
            catch (ClassNotFoundException e) {
                ALog.logWarn((Throwable)e, (String)"The DRC check '%s' could not be found on the application's classpath.", (Object[])new Object[]{className});
            }
            catch (ClassCastException e) {
                ALog.logWarn((Throwable)e, (String)"The DRC check '%s' is not derived from '%s', it can not be used.", (Object[])new Object[]{className, Check.class.getName()});
            }
            return null;
        }
    }

    public static class OptionDouble
    extends Option<Double> {
        protected DRCOptions.OptionUIDouble mUi = null;

        public OptionDouble(String desc) {
            super(desc, Double.class);
        }

        public OptionDouble(String desc, double val) {
            super(desc, Double.class, val);
        }

        public boolean doCheck() {
            return this.mUi == null || this.mUi.doCheck();
        }

        @Override
        public DRCOptions.OptionUI getUI() {
            this.mUi = new DRCOptions.OptionUIDouble(this);
            return this.mUi;
        }
    }

    public static class OptionEnum<T extends Enum<?>>
    extends Option<T> {
        public OptionEnum(String desc, Class<T> type) {
            super(desc, type);
        }

        public OptionEnum(String desc, Class<T> type, T val) {
            super(desc, type, val);
        }

        @Override
        public DRCOptions.OptionUI getUI() {
            DRCOptions.OptionUIEnum ui = new DRCOptions.OptionUIEnum(this);
            return ui;
        }
    }

    public static class OptionBoolean
    extends Option<Boolean> {
        public OptionBoolean(String desc) {
            super(desc, Boolean.class);
        }

        public OptionBoolean(String desc, boolean val) {
            super(desc, Boolean.class, val);
        }

        @Override
        public DRCOptions.OptionUI getUI() {
            return new DRCOptions.OptionUIBoolean(this);
        }
    }

    public static abstract class Option<T> {
        protected String mDesc = "";
        protected Class<T> mType;
        protected T mVal = null;

        protected Option(String desc, Class<T> type) {
            this.mType = type;
            this.mDesc = desc;
        }

        protected Option(String desc, Class<T> type, T val) {
            this(desc, type);
            this.mVal = val;
        }

        public Class<T> getType() {
            return this.mType;
        }

        public void set(T val) {
            this.mVal = val;
        }

        public T get() {
            return this.mVal;
        }

        public String getDesc() {
            return this.mDesc;
        }

        public abstract DRCOptions.OptionUI getUI();
    }

    public static interface Violation {
        public Check getCheck();

        public String getName();

        public String getDescription();

        public APoint2D getLocation();

        public ARect getBounds();

        public List<Action> getActions();
    }

    public static interface Check {
        public String getName();

        public Options getOptions();

        public long execute(Engine var1);

        public Violations getViolations();

        default public Integer getTestCaseCount() {
            return null;
        }
    }

    public static class Violations
    extends LinkedList<Violation> {
    }

    public static class Options
    extends LinkedList<Option<?>> {
        public Options() {
        }

        public Options(Option<?> ... options) {
            super(Arrays.asList(options));
        }
    }

    public static class Checks
    extends LinkedList<Check> {
    }
}

