/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.drc;

import com.sigrity.acl.ALog;
import com.sigrity.acl.Unit;
import com.sigrity.acl.xml.AXDomUtil;
import com.sigrity.orbit.drc.DRC;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ExportChecksToXml {
    protected DRC.Checks mChecks = null;
    protected Unit mUnit = null;
    protected boolean mHtmlInCdata = false;

    public static void export(DRC.Checks checks, String filePath, Unit userUnit) {
        ExportChecksToXml exporter = new ExportChecksToXml(checks);
        exporter.setUserUnit(userUnit);
        exporter.export(filePath);
    }

    public static String findFieldContaining(Object srch, Object find) {
        if (srch == null) {
            return null;
        }
        Class<?> cls = srch.getClass();
        for (Field fld : cls.getFields()) {
            try {
                if (fld.get(srch) != find) continue;
                return fld.getName();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public ExportChecksToXml(DRC.Checks checks) {
        this.mChecks = checks;
    }

    public void setUserUnit(Unit userUnit) {
        this.mUnit = userUnit;
    }

    public void setHtmlInCData(boolean b) {
        this.mHtmlInCdata = b;
    }

    public void export(String filePath) {
        Element elChecks = AXDomUtil.createXmlDoc((String)"Checks");
        Document doc = elChecks.getOwnerDocument();
        for (DRC.Check check : this.mChecks) {
            Element elCheck = AXDomUtil.addElement((Element)elChecks, (String)"Check");
            elCheck.setAttribute("class", check.getClass().getName());
            elCheck.setAttribute("name", check.getName());
            for (DRC.Option option : check.getOptions()) {
                Element elOption = AXDomUtil.addElement((Element)elCheck, (String)"Option");
                String checkFieldName = ExportChecksToXml.findFieldContaining(check, option);
                if (checkFieldName != null) {
                    elOption.setAttribute("name", checkFieldName);
                }
                elOption.setAttribute("class", option.getClass().getName());
                elOption.setAttribute("desc", option.getDesc());
                elOption.setAttribute("type", option.getType().getName());
                elOption.setAttribute("value", "" + option.get());
            }
            for (DRC.Violation violation : check.getViolations()) {
                Element elViolation = AXDomUtil.addElement((Element)elCheck, (String)"Violation");
                elViolation.setAttribute("class", violation.getClass().getName());
                elViolation.setAttribute("loc", violation.getLocation().toString(this.mUnit));
                elViolation.setAttribute("bounds", violation.getBounds().toString(this.mUnit));
                String desc = violation.getDescription();
                if (desc == null || desc.length() <= 0) continue;
                if (this.mHtmlInCdata) {
                    Element elDesc = AXDomUtil.addElement((Element)elViolation, (String)"desc");
                    CDATASection cd = elViolation.getOwnerDocument().createCDATASection(desc);
                    elDesc.appendChild(cd);
                    continue;
                }
                String strDoc = String.format("<desc>%s</desc>", desc);
                Element el = AXDomUtil.elementFromString((String)strDoc);
                elViolation.appendChild(doc.importNode(el, true));
            }
        }
        if (filePath != null) {
            try (FileOutputStream os = new FileOutputStream(filePath);){
                AXDomUtil.serialize((Node)elChecks, (OutputStream)os);
            }
            catch (IOException ioe) {
                ALog.logError((Throwable)ioe, (String)"Error writing to '%s'.", (Object[])new Object[]{filePath});
            }
        }
    }
}

