/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.drc;

import com.sigrity.acl.APair;
import com.sigrity.acl.IslandSeparation;
import com.sigrity.acl.Unit;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Layer;
import com.sigrity.acl.db.std.PinInstance;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.acl.geom.ALine;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.acl.geom.ARect;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.HierPin;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.drc.DRCRecord;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;

public class Pin2PinSep {
    ArrayList<HierPin> dpps;
    ArrayList<Layer> layers;
    protected static LinkedList<LoadListener> sLoadListener = new LinkedList();

    public void loadCandidates(ArrayList<HierPin> dpps) {
        this.dpps = dpps;
    }

    public ArrayList<DRCRecord> lessThan(long dist) {
        Pin2PinSep.updateProgress(false, 0.0, "Min Clearance Check");
        ArrayList<DRCRecord> records = new ArrayList<DRCRecord>();
        Db db = OrbitIO.getCurDb();
        Unit unit = Design.getUnit((Db)db);
        this.deriveUsedLayers();
        int numPorts = this.dpps.size();
        int errors = 0;
        for (int i = 0; i < numPorts; ++i) {
            double percent = (double)i / (double)numPorts;
            Pin2PinSep.updateProgress(false, percent, "Errors: " + errors);
            for (int j = i + 1; j < numPorts; ++j) {
                for (Layer l : this.layers) {
                    APoint2D p2;
                    APoint2D p1 = this.dpps.get(i).getWorldLoc();
                    long thisDist = p1.distance(p2 = this.dpps.get(j).getWorldLoc());
                    if (thisDist > dist) continue;
                    DRCRecord r = new DRCRecord();
                    r.dist = thisDist;
                    r.dpp1 = new HierPin(this.dpps.get(i));
                    r.dpp2 = new HierPin(this.dpps.get(j));
                    r.layer = l;
                    r.type = DRCRecord.Type.BumpMin;
                    String thisUserDist = unit.toUserStr(thisDist);
                    r.explanation = "Bumps Closer Than Minimum Distance " + r.dpp1.toString() + " and " + r.dpp2.toString() + " are " + thisUserDist + " apart on layer " + l.getName();
                    records.add(r);
                    ++errors;
                }
            }
        }
        Pin2PinSep.updateProgress(true, 1.0, "Done");
        return records;
    }

    public ArrayList<DRCRecord> moreThan(long dist) {
        ArrayList<DRCRecord> records = new ArrayList<DRCRecord>();
        IslandSeparation islandSeparation = new IslandSeparation();
        for (HierPin dpp : this.dpps) {
            islandSeparation.addObject((Object)dpp, dpp.getWorldBounds());
        }
        islandSeparation.group(dist);
        int count = islandSeparation.getIslandCount();
        if (count < 2) {
            return records;
        }
        for (int i = 0; i < count; ++i) {
            ArrayList ris = islandSeparation.getRsOfIsland(i);
            int next = i + 1;
            if (i == count - 1) {
                next = 0;
                if (count == 2) break;
            }
            ArrayList rjs = islandSeparation.getRsOfIsland(next);
            APair<ARect, ARect> rij = this.getClosestPair(ris, rjs);
            ARect ri = (ARect)rij.first;
            ARect rj = (ARect)rij.second;
            DRCRecord r = new DRCRecord();
            ALine l = ri.distanceToRect(rj);
            r.dist = l == null ? 0L : l.getLength();
            r.dpp1 = null;
            r.dpp2 = null;
            r.layer = null;
            r.r1 = ri;
            r.r2 = rj;
            r.type = DRCRecord.Type.BumpMax;
            records.add(r);
        }
        return records;
    }

    APair<ARect, ARect> getClosestPair(ArrayList<ARect> ris, ArrayList<ARect> rjs) {
        APair best = null;
        long bestDist = 0L;
        for (ARect ri : ris) {
            for (ARect rj : rjs) {
                long thisDist = 0L;
                ALine v = ri.distanceToRect(rj);
                thisDist = v == null ? 0L : ri.distanceToRect(rj).getLength();
                if (best != null && thisDist >= bestDist) continue;
                best = new APair((Object)ri, (Object)rj);
                bestDist = thisDist;
            }
        }
        return best;
    }

    protected void deriveUsedLayers() {
        HashSet layerSet = new HashSet();
        for (HierPin dpp : this.dpps) {
            dpp.getPinTemplate().getLayersInUse().forEach(layerSet::add);
        }
        this.layers = new ArrayList(layerSet);
    }

    protected void findCandidates(DevicePath path) {
        ArrayList<HierPin> dpp = new ArrayList<HierPin>();
        for (DevicePath dp : path.getDescendants()) {
            for (PinInstance dPort : dp.getLast().getPins()) {
                if (dPort.getType() != PinTemplate.Type.BUMPPAD && dp.getDeviceTemplate().getType() != DeviceTemplate.Type.BUMP) continue;
                dpp.add(new HierPin(dp, dPort));
            }
        }
        this.loadCandidates(dpp);
    }

    public static ArrayList<DRCRecord> drcBumps(long minDist, long maxDist, DevicePath path) {
        Pin2PinSep p2ps = new Pin2PinSep();
        p2ps.findCandidates(path);
        ArrayList<DRCRecord> rtn = new ArrayList();
        if (minDist > 0L) {
            rtn = p2ps.lessThan(minDist);
        }
        if (maxDist > 0L) {
            rtn.addAll(p2ps.moreThan(maxDist));
        }
        return rtn;
    }

    public static boolean addLoadListener(LoadListener l) {
        return sLoadListener.add(l);
    }

    public static boolean removeLoadListener(LoadListener l) {
        return sLoadListener.remove(l);
    }

    protected static void firePercentUpdate(int percent, boolean done, String data) {
        for (LoadListener l : sLoadListener) {
            l.stats(percent, done, data);
        }
    }

    public static void updateProgress(boolean done, double percent, String data) {
        int iPercent = (int)(percent * 100.0);
        Pin2PinSep.firePercentUpdate(iPercent, done, data);
    }

    public static interface LoadListener {
        public void stats(int var1, boolean var2, String var3);
    }
}

