/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.drc.checks;

import com.sigrity.acl.ALog;
import com.sigrity.acl.AUtil;
import com.sigrity.acl.IterableIterator;
import com.sigrity.acl.NestedIterator;
import com.sigrity.acl.ProcessingIterator;
import com.sigrity.acl.Unit;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.Selection;
import com.sigrity.acl.db.std.Constraint;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.PinInstance;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.acl.db.std.Substrate;
import com.sigrity.acl.geom.ALine;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.acl.geom.ARect;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.HierPin;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.ShowMeTheWay;
import com.sigrity.orbit.drc.DRC;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;

@Deprecated
public class BumpCheck
implements DRC.Check {
    public DRC.Option<Scope> OptScope = new DRC.OptionEnum<Scope>("Scope of items to check", Scope.class, Scope.ALL);
    protected DRC.Option<?>[] OPTIONS = new DRC.Option[]{this.OptScope};
    protected DRC.Options mOptions = new DRC.Options(this.OPTIONS);
    DRC.Violations mViolations = new DRC.Violations();

    @Override
    public String getName() {
        return "Bump";
    }

    @Override
    public DRC.Options getOptions() {
        return this.mOptions;
    }

    @Override
    public long execute(DRC.Engine context) {
        Db db = context.getDb();
        Selection selection = context.getSelection();
        this.mViolations.clear();
        for (DevicePath substratePath : Substrate.getSubstrateInstances((Db)db)) {
            NestedIterator<DevicePath, HierPin> bumps;
            Device substrateDevice = substratePath.getLast();
            if (this.OptScope.get() == Scope.SELECTED_SUBSTRATE_DEVICES && !selection.contains((DbObject)substrateDevice) || !(bumps = new NestedIterator<DevicePath, HierPin>((Iterator)substratePath.getDescendants()){

                public Iterator<HierPin> getLowerIterator(final DevicePath path) {
                    IterableIterator ports = path.getLast().getPins();
                    return new ProcessingIterator<PinInstance, HierPin>((Iterator)ports){

                        protected HierPin process(PinInstance port) {
                            if (port.getType() != PinTemplate.Type.BUMPPAD && path.getDeviceTemplate().getType() != DeviceTemplate.Type.BUMP) {
                                return null;
                            }
                            return new HierPin(path, port);
                        }
                    };
                }
            }).hasNext()) continue;
            ArrayList bumpList = AUtil.arrayList((Iterator)bumps);
            Substrate substrate = substrateDevice.getSubstrate();
            Long min = (Long)Constraint.getValue((Db)db, (DbObject)substrate, (Constraint.Descriptor)Constraint.BUMP_TO_BUMP_CLEAR);
            if (min == null) {
                ALog.logWarn((String)"Unable to determine '%s' constraint value for substrate '%s', the constraint is not being checked for %d bumps on device '%s'.", (Object[])new Object[]{Constraint.BUMP_TO_BUMP_CLEAR.getName(), substrate.getName(), bumpList.size(), substrateDevice.getName()});
                continue;
            }
            for (int i = 0; i < bumpList.size(); ++i) {
                for (int j = 0; j < bumpList.size(); ++j) {
                    APoint2D pt2;
                    APoint2D pt1;
                    long actual;
                    HierPin port1 = (HierPin)bumpList.get(i);
                    if (this.OptScope.get() == Scope.SELECTED_BUMPS && !selection.contains((DbObject)port1.getDbObject())) continue;
                    HierPin port2 = (HierPin)bumpList.get(j);
                    if (j <= i && (this.OptScope.get() != Scope.SELECTED_BUMPS || selection.contains((DbObject)port2.getDbObject())) || port1 == port2 || (actual = (pt1 = port1.getWorldLoc()).distance(pt2 = port2.getWorldLoc())) >= min) continue;
                    this.mViolations.add(new BCVClearance(port1, port2, min, actual));
                }
            }
        }
        return this.mViolations.size();
    }

    @Override
    public DRC.Violations getViolations() {
        return this.mViolations;
    }

    public class BCVClearance
    implements DRC.Violation {
        protected HierPin mPort1;
        protected HierPin mPort2;
        protected long mMin;
        protected long mActual;
        protected APoint2D mLocation;
        public Action mSelect = new AbstractAction("Select"){

            @Override
            public void actionPerformed(ActionEvent e) {
                Selection s = Selection.getCurrentSelectionForDb((Db)BCVClearance.this.mPort1.getDbObject().getDb());
                s.add(BCVClearance.this.mPort1.getPath(), (DbObject)BCVClearance.this.mPort1.getDbObject());
                s.add(BCVClearance.this.mPort2.getPath(), (DbObject)BCVClearance.this.mPort2.getDbObject());
                OrbitIO.getOrbitIO().refreshCurrentView();
            }
        };
        public Action mShow = new AbstractAction("Show"){

            @Override
            public void actionPerformed(ActionEvent e) {
                ShowMeTheWay.addHierPin(BCVClearance.this.mPort1);
                ShowMeTheWay.addHierPin(BCVClearance.this.mPort2);
            }
        };

        public BCVClearance(HierPin port1, HierPin port2, long min, long actual) {
            this.mPort1 = port1;
            this.mPort2 = port2;
            this.mMin = min;
            this.mActual = actual;
            this.mLocation = new ALine(this.mPort1.getWorldLoc(), this.mPort2.getWorldLoc()).center();
        }

        @Override
        public String getDescription() {
            Unit unit = Design.getUnit((Db)this.mPort1.getDbObject().getDb());
            return String.format("<h1>Bump seperation violation</h1><div><span class='label'>Bump A:</span><span class='value'> %s</span></div><div><span class='label'>Bump B:</span><span class='value'> %s</span></div><div><span class='label'>Required seperation:</span><span class='value'> %ss</span></div><div><span class='label'>Actual seperation:</span><span class='value'> %ss</span></div>", this.mPort1.toString(), this.mPort2.toString(), unit.toUserStr(this.mMin, true), unit.toUserStr(this.mActual, true));
        }

        @Override
        public APoint2D getLocation() {
            return this.mLocation;
        }

        @Override
        public String getName() {
            return String.format("%s to %s", this.mPort1.getDbObject().getName(), this.mPort2.getDbObject().getName());
        }

        @Override
        public List<Action> getActions() {
            return List.of(this.mSelect, this.mShow);
        }

        @Override
        public ARect getBounds() {
            return ARect.create((APoint2D)this.mPort1.getWorldLoc(), (APoint2D)this.mPort2.getWorldLoc());
        }

        @Override
        public DRC.Check getCheck() {
            return BumpCheck.this;
        }
    }

    public static enum Scope {
        ALL,
        SELECTED_SUBSTRATE_DEVICES,
        SELECTED_BUMPS;

    }
}

