/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.drc.checks;

import com.sigrity.acl.ALog;
import com.sigrity.acl.APair;
import com.sigrity.acl.AProgress;
import com.sigrity.acl.AUtil;
import com.sigrity.acl.FilteringIterator;
import com.sigrity.acl.IslandSeparation;
import com.sigrity.acl.Unit;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.Selection;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.LayerShape;
import com.sigrity.acl.db.std.PadTemplate;
import com.sigrity.acl.db.std.PinInstance;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.acl.db.std.PortTemplate;
import com.sigrity.acl.geom.AGeom;
import com.sigrity.acl.geom.ALine;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.acl.geom.ARect;
import com.sigrity.acl.topology.Binner;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.HierPort;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.ShowMeTheWay;
import com.sigrity.orbit.drc.DRC;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;

public class BumpToBumpCheck
implements DRC.Check,
AProgress.Provider {
    public final DRC.OptionDouble OptMinPitch = new DRC.OptionDouble("Minimum Pin Pitch", 0.0);
    public final DRC.OptionDouble OptMaxPitch = new DRC.OptionDouble("Maximum Pin Pitch", 1000000.0);
    public final DRC.OptionDouble OptMinPinEdgeToDieEdge = new DRC.OptionDouble("Pin Edge to Die Edge", 0.0);
    public final DRC.OptionDouble OptMinPinEdgeToCellEdge = new DRC.OptionDouble("Pin Edge to Cell Edge", 0.0);
    protected DRC.Options mOptions = new DRC.Options(this.OptMinPitch, this.OptMaxPitch, this.OptMinPinEdgeToDieEdge, this.OptMinPinEdgeToCellEdge);
    protected AProgress.ProviderImpl mTotalProgress = new AProgress.ProviderImpl(){

        public void fireProgressUpdate(AProgress.Provider src, int percent, String msg) {
            super.fireProgressUpdate(src, percent, msg);
        }
    };
    protected DRC.Violations mViolations = new DRC.Violations();
    protected AProgress.Adapter mMinProgress;
    protected AProgress.Adapter mMaxProgress;
    protected AProgress.Adapter mMinPinDieProgress;
    protected AProgress.Adapter mMaxPinCellProgress;
    protected Unit mUnit;
    protected int mTestCases = 0;

    public void setOptMinPitch(double minPitch) {
        this.OptMinPitch.set(minPitch);
    }

    public void setOptMaxPitch(double maxPitch) {
        this.OptMaxPitch.set(maxPitch);
    }

    public void setOptMinPinEdgeToDieEdge(double optMinPinEdgeToDieEdge) {
        this.OptMinPinEdgeToDieEdge.set(optMinPinEdgeToDieEdge);
    }

    public void setOptMinPinEdgeToCellEdge(double optMinPinEdgeToCellEdge) {
        this.OptMinPinEdgeToCellEdge.set(optMinPinEdgeToCellEdge);
    }

    public double getOptMinPitch() {
        return (Double)this.OptMinPitch.get();
    }

    public double getOptMaxPitch() {
        return (Double)this.OptMaxPitch.get();
    }

    public double getOptMinPinEdgeToDieEdge() {
        return (Double)this.OptMinPinEdgeToDieEdge.get();
    }

    public double getOptMinPinEdgeToCellEdge() {
        return (Double)this.OptMinPinEdgeToCellEdge.get();
    }

    public void addProgressListener(AProgress.Listener l) {
        this.mTotalProgress.addProgressListener(l);
    }

    public boolean removeProgressListener(AProgress.Listener l) {
        return this.mTotalProgress.removeProgressListener(l);
    }

    @Override
    public String getName() {
        return "Pin Pitch";
    }

    @Override
    public DRC.Options getOptions() {
        return this.mOptions;
    }

    @Override
    public DRC.Violations getViolations() {
        return this.mViolations;
    }

    @Override
    public long execute(final DRC.Engine context) {
        this.mTestCases = 0;
        this.mViolations.clear();
        Db db = context.getDb();
        Design design = Design.getDesign((Db)db);
        this.mUnit = design.getUnit();
        final Selection s2 = Selection.getCurrentSelectionForDb((Db)db);
        ArrayList bumps = AUtil.arrayList((Iterator)new FilteringIterator<DeviceTemplate.DescendantPin>((Iterator)design.getDescendantPins()){

            protected boolean include(DeviceTemplate.DescendantPin dp) {
                if (context.isJustSelected()) {
                    PinInstance pi = dp.getPinInstance();
                    return s2.contains((DbObject)pi);
                }
                PinTemplate.Type type = dp.getPinTemplate().getType();
                return type == PinTemplate.Type.BUMPPAD || type == PinTemplate.Type.BALLPAD;
            }
        });
        this.mMinProgress = this.checkMin() ? new AProgress.Adapter() : null;
        this.mMaxProgress = this.checkMax() ? new AProgress.Adapter() : null;
        this.mMinPinDieProgress = this.checkMinPinEdgeToDieEdge() ? new AProgress.Adapter() : null;
        this.mMaxPinCellProgress = this.checkMinPinEdgeToCellEdge() ? new AProgress.Adapter() : null;
        AProgress.aggregateProgress((AProgress.Provider[])new AProgress.Provider[]{this.mMinProgress, this.mMaxProgress}).addProgressListener(new AProgress.Listener(){

            public void progressUpdate(AProgress.Provider src, int percent, String message) {
                BumpToBumpCheck.this.mTotalProgress.fireProgressUpdate((AProgress.Provider)BumpToBumpCheck.this, percent, message);
            }
        });
        if (this.checkMin()) {
            this.findMinViolations(this.mUnit.fromUser(((Double)this.OptMinPitch.get()).doubleValue()), bumps);
        }
        if (this.checkMax()) {
            this.findMaxViolations(this.mUnit.fromUser(((Double)this.OptMaxPitch.get()).doubleValue()), bumps);
        }
        if (this.checkMinPinEdgeToDieEdge()) {
            this.findMinPinEdgeToDeviceEdgeViolations(this.mUnit.fromUser(((Double)this.OptMinPinEdgeToDieEdge.get()).doubleValue()), bumps, true);
        }
        if (this.checkMinPinEdgeToCellEdge()) {
            this.findMinPinEdgeToDeviceEdgeViolations(this.mUnit.fromUser(((Double)this.OptMinPinEdgeToCellEdge.get()).doubleValue()), bumps, false);
        }
        if (!this.anyCheck()) {
            ALog.logInfo((String)"No checks selected, nothing to do.");
        }
        return this.mViolations.size();
    }

    @Override
    public Integer getTestCaseCount() {
        return this.mTestCases;
    }

    public boolean checkMin() {
        return this.OptMinPitch.doCheck();
    }

    public boolean checkMax() {
        return this.OptMaxPitch.doCheck();
    }

    public boolean checkMinPinEdgeToDieEdge() {
        return this.OptMinPinEdgeToDieEdge.doCheck();
    }

    public boolean checkMinPinEdgeToCellEdge() {
        return this.OptMinPinEdgeToCellEdge.doCheck();
    }

    public boolean anyCheck() {
        return this.checkMin() || this.checkMax() || this.checkMinPinEdgeToDieEdge() || this.checkMinPinEdgeToCellEdge();
    }

    protected void findMinViolations(long min, List<DeviceTemplate.DescendantPin> bumps) {
        APoint2D checkLoc;
        DevicePath path;
        this.mMinProgress.fireProgressUpdate((AProgress.Provider)this, 0, "Minimum pitch check");
        int bumpCount = bumps.size();
        int errors = 0;
        int lastPercent = -1;
        HashMap<HierPort, DeviceTemplate.DescendantPin> map = new HashMap<HierPort, DeviceTemplate.DescendantPin>();
        Binner binner = new Binner();
        ARect worldBound = null;
        for (DeviceTemplate.DescendantPin checkBump : bumps) {
            path = checkBump.getDevicePath();
            for (PortTemplate checkPort : checkBump.getPinTemplate().getPortTemplates()) {
                APoint2D worldLoc = checkPort.getWorldLoc(path);
                if (worldBound == null) {
                    worldBound = new ARect(worldLoc, worldLoc);
                    continue;
                }
                worldBound.expand(worldLoc);
            }
        }
        binner.setWorld(worldBound);
        for (DeviceTemplate.DescendantPin checkBump : bumps) {
            path = checkBump.getDevicePath();
            for (PortTemplate checkPort : checkBump.getPinTemplate().getPortTemplates()) {
                HierPort hierPort = new HierPort(path, checkPort);
                checkLoc = checkPort.getWorldLoc(checkBump.getDevicePath());
                binner.insert((Object)hierPort, new ARect(checkLoc, checkLoc));
                map.put(hierPort, checkBump);
            }
        }
        for (int i = 0; i < bumpCount; ++i) {
            DeviceTemplate.DescendantPin checkBump;
            checkBump = bumps.get(i);
            int percent = (int)Math.round((double)i / (double)bumpCount * 100.0);
            if (percent != lastPercent) {
                lastPercent = percent;
                this.mMinProgress.fireProgressUpdate((AProgress.Provider)this, percent, "Errors: " + errors);
            }
            DevicePath path2 = checkBump.getDevicePath();
            for (PortTemplate checkPort : checkBump.getPinTemplate().getPortTemplates()) {
                checkLoc = checkPort.getWorldLoc(checkBump.getDevicePath());
                HierPort hierPort = new HierPort(path2, checkPort);
                for (HierPort otherHierPort : binner.intersects(new ARect(checkLoc, checkLoc).expandBy(min))) {
                    if (hierPort.equals((Object)otherHierPort)) continue;
                    APoint2D curLoc = otherHierPort.getWorldLoc();
                    long actual = checkLoc.distance(curLoc);
                    ++this.mTestCases;
                    if (actual >= min) continue;
                    this.mViolations.add(new MinPitchViolation(new HierPort(checkBump.getPath(), checkPort), otherHierPort, min, actual));
                    ++errors;
                }
            }
        }
        this.mMinProgress.fireProgressUpdate((AProgress.Provider)this, 100, "Minimum pitch check complete");
    }

    private static APair<Device, DevicePath> getDevInfoToCheck(Device device, DevicePath path, boolean toDieEdge) {
        if (!toDieEdge && device.getDeviceType() == DeviceTemplate.Type.COVER) {
            return APair.create((Object)device, (Object)path);
        }
        if (toDieEdge && device.getDeviceType() == DeviceTemplate.Type.DIE) {
            return APair.create((Object)device, (Object)path);
        }
        Device curDevice = null;
        DevicePath curPath = null;
        curPath = path.getParent();
        Device device2 = curDevice = curPath == null ? null : curPath.getLast();
        if (curDevice == null) {
            return null;
        }
        return BumpToBumpCheck.getDevInfoToCheck(curDevice, curPath, toDieEdge);
    }

    protected boolean checkPinInstanceToEdgeIsOk(PinInstance ioPin, DevicePath path, long minDist, boolean toDieEdge) {
        Device device;
        AffineTransform pinTransform = path.getTransform();
        Device device2 = device = path == null ? null : path.getLast();
        if (device == null) {
            return true;
        }
        APair<Device, DevicePath> thePair = BumpToBumpCheck.getDevInfoToCheck(device, path, toDieEdge);
        if (thePair == null) {
            return true;
        }
        AGeom deviceShape = ((Device)thePair.first).getUntransformedShape();
        AGeom devGeom = deviceShape.transform(((DevicePath)thePair.second).getTransform());
        ARect devBB = devGeom.getBounds();
        ARect devAdjBB = null;
        devAdjBB = minDist <= 0L ? devBB.expandBy(-minDist + 1L) : devBB;
        PinTemplate pinTemplate = ioPin.getPinTemplate();
        for (PortTemplate portTmplt : pinTemplate.getPortTemplates()) {
            AffineTransform xform = portTmplt.getTransform();
            if (xform != null) {
                xform.preConcatenate(pinTransform);
            } else {
                xform = pinTransform;
            }
            PadTemplate pt = portTmplt.getPadTemplate();
            if (pt == null) continue;
            for (LayerShape ls : pt.getLayerShapes()) {
                AGeom pinGeom = ls.getGeom().transform(xform);
                ARect pinBB = pinGeom.getBounds();
                long actual = devAdjBB.minEdgeDist(pinBB);
                if (!devAdjBB.contains((AGeom)pinBB)) {
                    actual = -actual;
                }
                if (minDist <= 0L) {
                    actual += minDist - 1L;
                }
                ++this.mTestCases;
                if (actual >= minDist) continue;
                ALine conflictLine = devAdjBB.minEdgeLine(pinBB, false);
                this.mViolations.add(new MinPinEdgeToDeviceEdgeViolation(new HierPort(path, portTmplt), (DevicePath)thePair.second, minDist, actual, toDieEdge, conflictLine));
                return false;
            }
        }
        return true;
    }

    protected void findMinPinEdgeToDeviceEdgeViolations(long min, List<DeviceTemplate.DescendantPin> bumps, boolean toDieEdge) {
        if (toDieEdge) {
            this.mMinPinDieProgress.fireProgressUpdate((AProgress.Provider)this, 0, "Minimum pin edge to die edge check");
        } else {
            this.mMaxPinCellProgress.fireProgressUpdate((AProgress.Provider)this, 0, "Minimum pin edge to cover cell edge check");
        }
        int bumpCount = bumps.size();
        int errors = 0;
        for (int i = 0; i < bumpCount; ++i) {
            DeviceTemplate.DescendantPin checkBump = bumps.get(i);
            double percent = (double)i / (double)bumpCount;
            if (toDieEdge) {
                this.mMinPinDieProgress.fireProgressUpdate((AProgress.Provider)this, (int)Math.round(percent * 100.0), "Errors: " + errors);
            } else {
                this.mMaxPinCellProgress.fireProgressUpdate((AProgress.Provider)this, (int)Math.round(percent * 100.0), "Errors: " + errors);
            }
            DevicePath path = checkBump.getDevicePath();
            if (this.checkPinInstanceToEdgeIsOk(checkBump.getPinInstance(), path, min, toDieEdge)) continue;
            ++errors;
        }
        if (toDieEdge) {
            this.mMinPinDieProgress.fireProgressUpdate((AProgress.Provider)this, 100, "Minimum pin edge to die edge check complete");
        } else {
            this.mMaxPinCellProgress.fireProgressUpdate((AProgress.Provider)this, 100, "Minimum pin edge to cover cell edge check complete");
        }
    }

    protected void findMaxViolations(long max, List<DeviceTemplate.DescendantPin> bumps) {
        this.mMaxProgress.fireProgressUpdate((AProgress.Provider)this, 0, "Maximum pitch check");
        IslandSeparation islandSeparation = new IslandSeparation();
        islandSeparation.addProgressListener((AProgress.Listener)this.mMaxProgress);
        ARect worldRect = null;
        for (DeviceTemplate.DescendantPin bump : bumps) {
            for (PortTemplate portTemplate : ((PinTemplate)bump.second).getPortTemplates()) {
                HierPort hport = new HierPort(bump.getDevicePath(), portTemplate);
                worldRect = hport.getSubstrateWorldBounds();
                islandSeparation.addObject((Object)hport, hport.getWorldBounds());
            }
        }
        LinkedList empty = islandSeparation.reduce(max, worldRect);
        IslandSeparation islandGroup = new IslandSeparation();
        for (ARect r : empty) {
            islandGroup.addObject(null, r);
        }
        islandGroup.group(0L);
        LinkedList violations = new LinkedList();
        Collections.sort(violations, (o1, o2) -> Integer.compare(o1.rs.size(), o2.rs.size()));
        this.mViolations.addAll(violations);
        this.mMaxProgress.fireProgressUpdate((AProgress.Provider)this, 100, "Maximum pitch check complete");
    }

    protected APinPair getClosestPair(ArrayList<ARect> ris, ArrayList<ARect> rjs) {
        APinPair best = null;
        long bestDist = 0L;
        for (int i = 0; i < ris.size(); ++i) {
            ARect ri = ris.get(i);
            for (int j = 0; j < rjs.size(); ++j) {
                ARect rj = rjs.get(j);
                Long thisDist = ri.distanceTo(rj);
                if (thisDist == null || best != null && thisDist >= bestDist) continue;
                best = new APinPair(ri, rj, i, j);
                bestDist = thisDist;
            }
        }
        return best;
    }

    public class MinPinEdgeToDeviceEdgeViolation
    implements DRC.Violation {
        protected HierPort mPA;
        protected DevicePath mDevicePath;
        protected long mMin;
        protected long mActual;
        protected APoint2D mLocation = null;
        protected ARect mBounds = null;
        protected String mName;
        protected boolean mToDieEdge = false;
        protected ALine mConflictLine = null;

        public MinPinEdgeToDeviceEdgeViolation(HierPort pa, DevicePath pb, long min, long actual, boolean toDieEdge, ALine conflictLine) {
            this.mPA = pa;
            this.mDevicePath = pb;
            this.mMin = min;
            this.mActual = actual;
            this.mToDieEdge = toDieEdge;
            this.mName = this.mToDieEdge ? String.format("Minimum pin edge to die edge (%s)", BumpToBumpCheck.this.mUnit.toUserStr(this.mActual, true)) : String.format("Minimum pin edge to cover cell edge (%s)", BumpToBumpCheck.this.mUnit.toUserStr(this.mActual, true));
            this.mConflictLine = conflictLine;
        }

        @Override
        public DRC.Check getCheck() {
            return BumpToBumpCheck.this;
        }

        @Override
        public String getName() {
            return this.mName;
        }

        @Override
        public String getDescription() {
            String line1 = this.mToDieEdge ? "Minimum pin edge to die edge violation" : "Minimum pin edge to cover cell edge violation";
            return String.format("<h1>%s</h1><div><span class='label'>Bump:</span><span class='value'> %s</span></div><div><span class='label'>Die:</span><span class='value'> %s</span></div><div><span class='label'>Required distance:</span><span class='value'> %ss</span></div><div><span class='label'>Actual distance:</span><span class='value'> %ss</span></div>", line1, this.getDesc(this.mPA), this.mDevicePath.getString(), BumpToBumpCheck.this.mUnit.toUserStr(this.mMin, true), BumpToBumpCheck.this.mUnit.toUserStr(this.mActual, true));
        }

        protected String getDesc(HierPort bump) {
            return String.format("%s Pin %s (port %d)", bump.getPath().toString(), ((PortTemplate)bump.getDbObject()).getPinTemplate().getName(), ((PortTemplate)bump.getDbObject()).getPortNum());
        }

        @Override
        public APoint2D getLocation() {
            if (this.mLocation == null) {
                ALine l = new ALine(this.mPA.getWorldLoc(), this.mDevicePath.getLoc());
                this.mLocation = l.center();
            }
            return this.mLocation;
        }

        @Override
        public ARect getBounds() {
            if (this.mBounds == null) {
                this.mBounds = ((PortTemplate)this.mPA.getDbObject()).getBounds().transform(this.mPA.getPath().getTransform()).getBounds();
                AffineTransform t = this.mDevicePath.getTransform();
                Device device = this.mDevicePath.getLast();
                if (device == null) {
                    return this.mBounds;
                }
                AGeom deviceShape = device.getUntransformedShape();
                AGeom pathGeom = deviceShape.transform(t);
                ARect pathBB = pathGeom.getBounds();
                this.mBounds.expand(pathBB);
            }
            return this.mBounds;
        }

        @Override
        public List<Action> getActions() {
            AbstractAction mSelect = new AbstractAction("Select"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Db db = ((PortTemplate)MinPinEdgeToDeviceEdgeViolation.this.mPA.getDbObject()).getDb();
                    Selection s = Selection.getCurrentSelectionForDb((Db)db);
                    s.add((DbObject)PinInstance.getPinInstance((Device)MinPinEdgeToDeviceEdgeViolation.this.mPA.getPath().getDevice(), (PinTemplate)((PortTemplate)MinPinEdgeToDeviceEdgeViolation.this.mPA.getDbObject()).getPinTemplate()));
                    s.add((DbObject)MinPinEdgeToDeviceEdgeViolation.this.mDevicePath.getFirst());
                    OrbitIO.getOrbitIO().refreshCurrentView();
                }
            };
            AbstractAction mShow = new AbstractAction("Show"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ShowMeTheWay.showMeTwoPts(MinPinEdgeToDeviceEdgeViolation.this.mConflictLine.getP0(), MinPinEdgeToDeviceEdgeViolation.this.mConflictLine.getP1(), "", ShowMeTheWay.LineStyle.Resistor, Color.ORANGE);
                }
            };
            return List.of(mSelect, mShow);
        }
    }

    public class MaxPitchViolation
    implements DRC.Violation {
        protected long mMax;
        protected long mActual;
        protected LinkedList<ARect> rs = new LinkedList();
        protected String mName;

        public MaxPitchViolation(long max, List<ARect> rs) {
            this.mMax = max;
            this.rs.addAll(rs);
            this.mName = String.format("Maximum bump pitch (%ss)", BumpToBumpCheck.this.mUnit.toUserStr(this.mMax, true));
        }

        @Override
        public DRC.Check getCheck() {
            return BumpToBumpCheck.this;
        }

        @Override
        public String getName() {
            return this.mName;
        }

        @Override
        public String getDescription() {
            return String.format("<h1>Maximum bump pitch violation</h1><div><span class='label'>Required maximum pitch:</span><span class='value'> %ss</span></div><div><span class='label'>Actual pitch:</span><span class='value'> %ss</span></div>", BumpToBumpCheck.this.mUnit.toUserStr(this.mMax, true), BumpToBumpCheck.this.mUnit.toUserStr(this.mMax, true));
        }

        @Override
        public APoint2D getLocation() {
            ARect bounds = null;
            for (ARect r : this.rs) {
                if (bounds == null) {
                    bounds = new ARect(r);
                    continue;
                }
                bounds.expand(r);
            }
            return bounds.center();
        }

        @Override
        public ARect getBounds() {
            ARect bounds = null;
            for (ARect r : this.rs) {
                if (bounds == null) {
                    bounds = new ARect(r);
                    continue;
                }
                bounds.expand(r);
            }
            bounds.expand(8.0);
            return bounds;
        }

        @Override
        public List<Action> getActions() {
            AbstractAction mShow = new AbstractAction("Show"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ShowMeTheWay.showMeArea(MaxPitchViolation.this.getLocation(), MaxPitchViolation.this.rs, "", ShowMeTheWay.LineStyle.Circles, Color.RED);
                }
            };
            return List.of(mShow);
        }

        public String toString() {
            return String.format("%s (%s)", this.getName(), super.toString());
        }
    }

    public class MinPitchViolation
    implements DRC.Violation {
        protected HierPort mPA;
        protected HierPort mPB;
        protected long mMin;
        protected long mActual;
        protected APoint2D mLocation = null;
        protected ARect mBounds = null;
        protected String mName;

        public MinPitchViolation(HierPort pa, HierPort pb, long min, long actual) {
            if (this.getDesc(pa).compareTo(this.getDesc(pb)) <= 0) {
                this.mPA = pa;
                this.mPB = pb;
            } else {
                this.mPA = pb;
                this.mPB = pa;
            }
            this.mMin = min;
            this.mActual = actual;
            this.mName = String.format("Minimum bump pitch (%s)", BumpToBumpCheck.this.mUnit.toUserStr(this.mActual, true));
        }

        @Override
        public DRC.Check getCheck() {
            return BumpToBumpCheck.this;
        }

        @Override
        public String getName() {
            return this.mName;
        }

        @Override
        public String getDescription() {
            return String.format("<h1>Minimum bump pitch violation</h1><div><span class='label'>Bump A:</span><span class='value'> %s</span></div><div><span class='label'>Bump B:</span><span class='value'> %s</span></div><div><span class='label'>Required pitch:</span><span class='value'> %ss</span></div><div><span class='label'>Actual pitch:</span><span class='value'> %ss</span></div>", this.getDesc(this.mPA), this.getDesc(this.mPB), BumpToBumpCheck.this.mUnit.toUserStr(this.mMin, true), BumpToBumpCheck.this.mUnit.toUserStr(this.mActual, true));
        }

        protected String getDesc(HierPort bump) {
            return String.format("%s Pin %s (port %d)", bump.getPath().toString(), ((PortTemplate)bump.getDbObject()).getPinTemplate().getName(), ((PortTemplate)bump.getDbObject()).getPortNum());
        }

        @Override
        public APoint2D getLocation() {
            if (this.mLocation == null) {
                ALine l = new ALine(this.mPA.getWorldLoc(), this.mPB.getWorldLoc());
                this.mLocation = l.center();
            }
            return this.mLocation;
        }

        @Override
        public ARect getBounds() {
            if (this.mBounds == null) {
                this.mBounds = ((PortTemplate)this.mPA.getDbObject()).getBounds().transform(this.mPA.getPath().getTransform()).getBounds();
                this.mBounds.expand(((PortTemplate)this.mPB.getDbObject()).getBounds().transform(this.mPB.getPath().getTransform()).getBounds());
            }
            return this.mBounds;
        }

        @Override
        public List<Action> getActions() {
            AbstractAction select = new AbstractAction("Select"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Db db = ((PortTemplate)MinPitchViolation.this.mPA.getDbObject()).getDb();
                    Selection s = Selection.getCurrentSelectionForDb((Db)db);
                    s.add((DbObject)PinInstance.getPinInstance((Device)MinPitchViolation.this.mPA.getPath().getDevice(), (PinTemplate)((PortTemplate)MinPitchViolation.this.mPA.getDbObject()).getPinTemplate()));
                    s.add((DbObject)PinInstance.getPinInstance((Device)MinPitchViolation.this.mPB.getPath().getDevice(), (PinTemplate)((PortTemplate)MinPitchViolation.this.mPB.getDbObject()).getPinTemplate()));
                    OrbitIO.getOrbitIO().refreshCurrentView();
                }
            };
            AbstractAction show = new AbstractAction("Show"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ShowMeTheWay.showMeTwoPts(MinPitchViolation.this.mPA.getWorldLoc(), MinPitchViolation.this.mPB.getWorldLoc(), "", ShowMeTheWay.LineStyle.Resistor, Color.ORANGE);
                }
            };
            return List.of(select, show);
        }
    }

    class APinPair {
        ARect fromR;
        ARect toR;
        int fromIndex;
        int toIndex;

        public APinPair(ARect fr, ARect tr, int fi, int ti) {
            this.fromR = fr;
            this.toR = tr;
            this.fromIndex = fi;
            this.toIndex = ti;
        }
    }
}

